// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/feature_registry_service.proto

#include "google/cloud/aiplatform/v1/feature_registry_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

FeatureRegistryServiceConnectionIdempotencyPolicy::
    ~FeatureRegistryServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<FeatureRegistryServiceConnectionIdempotencyPolicy>
FeatureRegistryServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<FeatureRegistryServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency
FeatureRegistryServiceConnectionIdempotencyPolicy::CreateFeatureGroup(
    google::cloud::aiplatform::v1::CreateFeatureGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::GetFeatureGroup(
    google::cloud::aiplatform::v1::GetFeatureGroupRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
FeatureRegistryServiceConnectionIdempotencyPolicy::ListFeatureGroups(
    google::cloud::aiplatform::v1::ListFeatureGroupsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency
FeatureRegistryServiceConnectionIdempotencyPolicy::UpdateFeatureGroup(
    google::cloud::aiplatform::v1::UpdateFeatureGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
FeatureRegistryServiceConnectionIdempotencyPolicy::DeleteFeatureGroup(
    google::cloud::aiplatform::v1::DeleteFeatureGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::CreateFeature(
    google::cloud::aiplatform::v1::CreateFeatureRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::GetFeature(
    google::cloud::aiplatform::v1::GetFeatureRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::ListFeatures(
    google::cloud::aiplatform::v1::ListFeaturesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::UpdateFeature(
    google::cloud::aiplatform::v1::UpdateFeatureRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::DeleteFeature(
    google::cloud::aiplatform::v1::DeleteFeatureRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::ListLocations(
    google::cloud::location::ListLocationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency
FeatureRegistryServiceConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency FeatureRegistryServiceConnectionIdempotencyPolicy::WaitOperation(
    google::longrunning::WaitOperationRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<FeatureRegistryServiceConnectionIdempotencyPolicy>
MakeDefaultFeatureRegistryServiceConnectionIdempotencyPolicy() {
  return std::make_unique<FeatureRegistryServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
