// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/feature_registry_service.proto

#include "google/cloud/aiplatform/v1/feature_registry_connection.h"
#include "google/cloud/aiplatform/v1/feature_registry_options.h"
#include "google/cloud/aiplatform/v1/internal/feature_registry_connection_impl.h"
#include "google/cloud/aiplatform/v1/internal/feature_registry_option_defaults.h"
#include "google/cloud/aiplatform/v1/internal/feature_registry_stub_factory.h"
#include "google/cloud/aiplatform/v1/internal/feature_registry_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FeatureRegistryServiceConnection::~FeatureRegistryServiceConnection() = default;

future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
FeatureRegistryServiceConnection::CreateFeatureGroup(
    google::cloud::aiplatform::v1::CreateFeatureGroupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceConnection::CreateFeatureGroup(
    NoAwaitTag,
    google::cloud::aiplatform::v1::CreateFeatureGroupRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
FeatureRegistryServiceConnection::CreateFeatureGroup(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::FeatureGroup>
FeatureRegistryServiceConnection::GetFeatureGroup(
    google::cloud::aiplatform::v1::GetFeatureGroupRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::FeatureGroup>
FeatureRegistryServiceConnection::ListFeatureGroups(
    google::cloud::aiplatform::v1::
        ListFeatureGroupsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::FeatureGroup>>();
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
FeatureRegistryServiceConnection::UpdateFeatureGroup(
    google::cloud::aiplatform::v1::UpdateFeatureGroupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceConnection::UpdateFeatureGroup(
    NoAwaitTag,
    google::cloud::aiplatform::v1::UpdateFeatureGroupRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>
FeatureRegistryServiceConnection::UpdateFeatureGroup(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::FeatureGroup>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureRegistryServiceConnection::DeleteFeatureGroup(
    google::cloud::aiplatform::v1::DeleteFeatureGroupRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceConnection::DeleteFeatureGroup(
    NoAwaitTag,
    google::cloud::aiplatform::v1::DeleteFeatureGroupRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureRegistryServiceConnection::DeleteFeatureGroup(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::Feature>>
FeatureRegistryServiceConnection::CreateFeature(
    google::cloud::aiplatform::v1::CreateFeatureRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::Feature>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceConnection::CreateFeature(
    NoAwaitTag, google::cloud::aiplatform::v1::CreateFeatureRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::Feature>>
FeatureRegistryServiceConnection::CreateFeature(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::Feature>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::aiplatform::v1::Feature>
FeatureRegistryServiceConnection::GetFeature(
    google::cloud::aiplatform::v1::GetFeatureRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::aiplatform::v1::Feature>
FeatureRegistryServiceConnection::ListFeatures(
    google::cloud::aiplatform::v1::
        ListFeaturesRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::aiplatform::v1::Feature>>();
}

future<StatusOr<google::cloud::aiplatform::v1::Feature>>
FeatureRegistryServiceConnection::UpdateFeature(
    google::cloud::aiplatform::v1::UpdateFeatureRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::Feature>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceConnection::UpdateFeature(
    NoAwaitTag, google::cloud::aiplatform::v1::UpdateFeatureRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::Feature>>
FeatureRegistryServiceConnection::UpdateFeature(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::Feature>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureRegistryServiceConnection::DeleteFeature(
    google::cloud::aiplatform::v1::DeleteFeatureRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceConnection::DeleteFeature(
    NoAwaitTag, google::cloud::aiplatform::v1::DeleteFeatureRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
FeatureRegistryServiceConnection::DeleteFeature(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::location::Location>
FeatureRegistryServiceConnection::ListLocations(
    google::cloud::location::
        ListLocationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::location::Location>>();
}

StatusOr<google::cloud::location::Location>
FeatureRegistryServiceConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy>
FeatureRegistryServiceConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy>
FeatureRegistryServiceConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
FeatureRegistryServiceConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation>
FeatureRegistryServiceConnection::ListOperations(
    google::longrunning::
        ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceConnection::GetOperation(
    google::longrunning::GetOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status FeatureRegistryServiceConnection::DeleteOperation(
    google::longrunning::DeleteOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status FeatureRegistryServiceConnection::CancelOperation(
    google::longrunning::CancelOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::longrunning::Operation>
FeatureRegistryServiceConnection::WaitOperation(
    google::longrunning::WaitOperationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<FeatureRegistryServiceConnection>
MakeFeatureRegistryServiceConnection(std::string const& location,
                                     Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 FeatureRegistryServicePolicyOptionList>(
      options, __func__);
  options = aiplatform_v1_internal::FeatureRegistryServiceDefaultOptions(
      location, std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = aiplatform_v1_internal::CreateDefaultFeatureRegistryServiceStub(
      std::move(auth), options);
  return aiplatform_v1_internal::MakeFeatureRegistryServiceTracingConnection(
      std::make_shared<
          aiplatform_v1_internal::FeatureRegistryServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google
