// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/identity/accesscontextmanager/v1/access_context_manager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ACCESSCONTEXTMANAGER_V1_ACCESS_CONTEXT_MANAGER_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ACCESSCONTEXTMANAGER_V1_ACCESS_CONTEXT_MANAGER_CONNECTION_H

#include "google/cloud/accesscontextmanager/v1/access_context_manager_connection_idempotency_policy.h"
#include "google/cloud/accesscontextmanager/v1/internal/access_context_manager_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/identity/accesscontextmanager/v1/access_context_manager.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace accesscontextmanager_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `AccessContextManagerConnection`.
class AccessContextManagerRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<AccessContextManagerRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `AccessContextManagerConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class AccessContextManagerLimitedErrorCountRetryPolicy
    : public AccessContextManagerRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit AccessContextManagerLimitedErrorCountRetryPolicy(
      int maximum_failures)
      : impl_(maximum_failures) {}

  AccessContextManagerLimitedErrorCountRetryPolicy(
      AccessContextManagerLimitedErrorCountRetryPolicy&& rhs) noexcept
      : AccessContextManagerLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}
  AccessContextManagerLimitedErrorCountRetryPolicy(
      AccessContextManagerLimitedErrorCountRetryPolicy const& rhs) noexcept
      : AccessContextManagerLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<AccessContextManagerRetryPolicy> clone() const override {
    return std::make_unique<AccessContextManagerLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = AccessContextManagerRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      accesscontextmanager_v1_internal::AccessContextManagerRetryTraits>
      impl_;
};

/**
 * A retry policy for `AccessContextManagerConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class AccessContextManagerLimitedTimeRetryPolicy
    : public AccessContextManagerRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit AccessContextManagerLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  AccessContextManagerLimitedTimeRetryPolicy(
      AccessContextManagerLimitedTimeRetryPolicy&& rhs) noexcept
      : AccessContextManagerLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  AccessContextManagerLimitedTimeRetryPolicy(
      AccessContextManagerLimitedTimeRetryPolicy const& rhs) noexcept
      : AccessContextManagerLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<AccessContextManagerRetryPolicy> clone() const override {
    return std::make_unique<AccessContextManagerLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = AccessContextManagerRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      accesscontextmanager_v1_internal::AccessContextManagerRetryTraits>
      impl_;
};

/**
 * The `AccessContextManagerConnection` object for `AccessContextManagerClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `AccessContextManagerClient`. This allows users to inject custom
 * behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `AccessContextManagerClient`.
 *
 * To create a concrete instance, see `MakeAccessContextManagerConnection()`.
 *
 * For mocking, see
 * `accesscontextmanager_v1_mocks::MockAccessContextManagerConnection`.
 */
class AccessContextManagerConnection {
 public:
  virtual ~AccessContextManagerConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::identity::accesscontextmanager::v1::AccessPolicy>
  ListAccessPolicies(
      google::identity::accesscontextmanager::v1::ListAccessPoliciesRequest
          request);

  virtual StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>
  GetAccessPolicy(
      google::identity::accesscontextmanager::v1::GetAccessPolicyRequest const&
          request);

  virtual future<
      StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
  CreateAccessPolicy(
      google::identity::accesscontextmanager::v1::AccessPolicy const& request);

  virtual StatusOr<google::longrunning::Operation> CreateAccessPolicy(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::AccessPolicy const& request);

  virtual future<
      StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
  CreateAccessPolicy(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
  UpdateAccessPolicy(google::identity::accesscontextmanager::v1::
                         UpdateAccessPolicyRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateAccessPolicy(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      UpdateAccessPolicyRequest const& request);

  virtual future<
      StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
  UpdateAccessPolicy(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::identity::accesscontextmanager::v1::
                              AccessContextManagerOperationMetadata>>
  DeleteAccessPolicy(google::identity::accesscontextmanager::v1::
                         DeleteAccessPolicyRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteAccessPolicy(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      DeleteAccessPolicyRequest const& request);

  virtual future<StatusOr<google::identity::accesscontextmanager::v1::
                              AccessContextManagerOperationMetadata>>
  DeleteAccessPolicy(google::longrunning::Operation const& operation);

  virtual StreamRange<google::identity::accesscontextmanager::v1::AccessLevel>
  ListAccessLevels(
      google::identity::accesscontextmanager::v1::ListAccessLevelsRequest
          request);

  virtual StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>
  GetAccessLevel(
      google::identity::accesscontextmanager::v1::GetAccessLevelRequest const&
          request);

  virtual future<
      StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  CreateAccessLevel(google::identity::accesscontextmanager::v1::
                        CreateAccessLevelRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateAccessLevel(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      CreateAccessLevelRequest const& request);

  virtual future<
      StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  CreateAccessLevel(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  UpdateAccessLevel(google::identity::accesscontextmanager::v1::
                        UpdateAccessLevelRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateAccessLevel(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      UpdateAccessLevelRequest const& request);

  virtual future<
      StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  UpdateAccessLevel(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::identity::accesscontextmanager::v1::
                              AccessContextManagerOperationMetadata>>
  DeleteAccessLevel(google::identity::accesscontextmanager::v1::
                        DeleteAccessLevelRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteAccessLevel(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      DeleteAccessLevelRequest const& request);

  virtual future<StatusOr<google::identity::accesscontextmanager::v1::
                              AccessContextManagerOperationMetadata>>
  DeleteAccessLevel(google::longrunning::Operation const& operation);

  virtual future<StatusOr<
      google::identity::accesscontextmanager::v1::ReplaceAccessLevelsResponse>>
  ReplaceAccessLevels(google::identity::accesscontextmanager::v1::
                          ReplaceAccessLevelsRequest const& request);

  virtual StatusOr<google::longrunning::Operation> ReplaceAccessLevels(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      ReplaceAccessLevelsRequest const& request);

  virtual future<StatusOr<
      google::identity::accesscontextmanager::v1::ReplaceAccessLevelsResponse>>
  ReplaceAccessLevels(google::longrunning::Operation const& operation);

  virtual StreamRange<
      google::identity::accesscontextmanager::v1::ServicePerimeter>
  ListServicePerimeters(
      google::identity::accesscontextmanager::v1::ListServicePerimetersRequest
          request);

  virtual StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>
  GetServicePerimeter(google::identity::accesscontextmanager::v1::
                          GetServicePerimeterRequest const& request);

  virtual future<
      StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  CreateServicePerimeter(google::identity::accesscontextmanager::v1::
                             CreateServicePerimeterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateServicePerimeter(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      CreateServicePerimeterRequest const& request);

  virtual future<
      StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  CreateServicePerimeter(google::longrunning::Operation const& operation);

  virtual future<
      StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  UpdateServicePerimeter(google::identity::accesscontextmanager::v1::
                             UpdateServicePerimeterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateServicePerimeter(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      UpdateServicePerimeterRequest const& request);

  virtual future<
      StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  UpdateServicePerimeter(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::identity::accesscontextmanager::v1::
                              AccessContextManagerOperationMetadata>>
  DeleteServicePerimeter(google::identity::accesscontextmanager::v1::
                             DeleteServicePerimeterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteServicePerimeter(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      DeleteServicePerimeterRequest const& request);

  virtual future<StatusOr<google::identity::accesscontextmanager::v1::
                              AccessContextManagerOperationMetadata>>
  DeleteServicePerimeter(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::identity::accesscontextmanager::v1::
                              ReplaceServicePerimetersResponse>>
  ReplaceServicePerimeters(google::identity::accesscontextmanager::v1::
                               ReplaceServicePerimetersRequest const& request);

  virtual StatusOr<google::longrunning::Operation> ReplaceServicePerimeters(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      ReplaceServicePerimetersRequest const& request);

  virtual future<StatusOr<google::identity::accesscontextmanager::v1::
                              ReplaceServicePerimetersResponse>>
  ReplaceServicePerimeters(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::identity::accesscontextmanager::v1::
                              CommitServicePerimetersResponse>>
  CommitServicePerimeters(google::identity::accesscontextmanager::v1::
                              CommitServicePerimetersRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CommitServicePerimeters(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      CommitServicePerimetersRequest const& request);

  virtual future<StatusOr<google::identity::accesscontextmanager::v1::
                              CommitServicePerimetersResponse>>
  CommitServicePerimeters(google::longrunning::Operation const& operation);

  virtual StreamRange<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
  ListGcpUserAccessBindings(google::identity::accesscontextmanager::v1::
                                ListGcpUserAccessBindingsRequest request);

  virtual StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
  GetGcpUserAccessBinding(google::identity::accesscontextmanager::v1::
                              GetGcpUserAccessBindingRequest const& request);

  virtual future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  CreateGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::
          CreateGcpUserAccessBindingRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateGcpUserAccessBinding(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      CreateGcpUserAccessBindingRequest const& request);

  virtual future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  CreateGcpUserAccessBinding(google::longrunning::Operation const& operation);

  virtual future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  UpdateGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::
          UpdateGcpUserAccessBindingRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateGcpUserAccessBinding(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      UpdateGcpUserAccessBindingRequest const& request);

  virtual future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  UpdateGcpUserAccessBinding(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::identity::accesscontextmanager::v1::
                              GcpUserAccessBindingOperationMetadata>>
  DeleteGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::
          DeleteGcpUserAccessBindingRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteGcpUserAccessBinding(
      NoAwaitTag, google::identity::accesscontextmanager::v1::
                      DeleteGcpUserAccessBindingRequest const& request);

  virtual future<StatusOr<google::identity::accesscontextmanager::v1::
                              GcpUserAccessBindingOperationMetadata>>
  DeleteGcpUserAccessBinding(google::longrunning::Operation const& operation);

  virtual StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::TestIamPermissionsResponse>
  TestIamPermissions(google::iam::v1::TestIamPermissionsRequest const& request);

  virtual StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request);
};

/**
 * A factory function to construct an object of type
 * `AccessContextManagerConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * AccessContextManagerClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `AccessContextManagerConnection`. Expected options are any of the
 * types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * -
 * `google::cloud::accesscontextmanager_v1::AccessContextManagerPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `AccessContextManagerConnection`
 * created by this function.
 */
std::shared_ptr<AccessContextManagerConnection>
MakeAccessContextManagerConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accesscontextmanager_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ACCESSCONTEXTMANAGER_V1_ACCESS_CONTEXT_MANAGER_CONNECTION_H
