// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/identity/accesscontextmanager/v1/access_context_manager.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ACCESSCONTEXTMANAGER_V1_ACCESS_CONTEXT_MANAGER_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ACCESSCONTEXTMANAGER_V1_ACCESS_CONTEXT_MANAGER_CLIENT_H

#include "google/cloud/accesscontextmanager/v1/access_context_manager_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace accesscontextmanager_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// API for setting [access levels]
/// [google.identity.accesscontextmanager.v1.AccessLevel] and [service
/// perimeters] [google.identity.accesscontextmanager.v1.ServicePerimeter]
/// for Google Cloud projects. Each organization has one [access policy]
/// [google.identity.accesscontextmanager.v1.AccessPolicy] that contains the
/// [access levels] [google.identity.accesscontextmanager.v1.AccessLevel]
/// and [service perimeters]
/// [google.identity.accesscontextmanager.v1.ServicePerimeter]. This
/// [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy] is
/// applicable to all resources in the organization.
/// AccessPolicies
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class AccessContextManagerClient {
 public:
  explicit AccessContextManagerClient(
      std::shared_ptr<AccessContextManagerConnection> connection,
      Options opts = {});
  ~AccessContextManagerClient();

  ///@{
  /// @name Copy and move support
  AccessContextManagerClient(AccessContextManagerClient const&) = default;
  AccessContextManagerClient& operator=(AccessContextManagerClient const&) =
      default;
  AccessContextManagerClient(AccessContextManagerClient&&) = default;
  AccessContextManagerClient& operator=(AccessContextManagerClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(AccessContextManagerClient const& a,
                         AccessContextManagerClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(AccessContextManagerClient const& a,
                         AccessContextManagerClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Lists all [access policies]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] in an
  /// organization.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.identity.accesscontextmanager.v1.AccessPolicy], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L36}
  /// [google.identity.accesscontextmanager.v1.ListAccessPoliciesRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L475}
  ///
  // clang-format on
  StreamRange<google::identity::accesscontextmanager::v1::AccessPolicy>
  ListAccessPolicies(
      google::identity::accesscontextmanager::v1::ListAccessPoliciesRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns an [access policy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] based on the name.
  ///
  /// @param name  Required. Resource name for the access policy to get.
  ///  @n
  ///  Format `accessPolicies/{policy_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.identity.accesscontextmanager.v1.AccessPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L36}
  /// [google.identity.accesscontextmanager.v1.GetAccessPolicyRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L507}
  ///
  // clang-format on
  StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>
  GetAccessPolicy(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Returns an [access policy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] based on the name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.GetAccessPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.identity.accesscontextmanager.v1.AccessPolicy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L36}
  /// [google.identity.accesscontextmanager.v1.GetAccessPolicyRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L507}
  ///
  // clang-format on
  StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>
  GetAccessPolicy(
      google::identity::accesscontextmanager::v1::GetAccessPolicyRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an access policy. This method fails if the organization already has
  /// an access policy. The long-running operation has a successful status
  /// after the access policy propagates to long-lasting storage.
  /// Syntactic and basic semantic errors are returned in `metadata` as a
  /// BadRequest proto.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.AccessPolicy].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.AccessPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L36}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
  CreateAccessPolicy(
      google::identity::accesscontextmanager::v1::AccessPolicy const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAccessPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAccessPolicy(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::AccessPolicy const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAccessPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
  CreateAccessPolicy(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Updates an [access policy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]. The
  /// long-running operation from this RPC has a successful status after the
  /// changes to the [access policy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] propagate
  /// to long-lasting storage.
  ///
  /// @param policy  Required. The updated AccessPolicy.
  /// @param update_mask  Required. Mask to control which fields get updated. Must be non-empty.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.AccessPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L36}
  /// [google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L520}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
  UpdateAccessPolicy(
      google::identity::accesscontextmanager::v1::AccessPolicy const& policy,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAccessPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAccessPolicy(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::AccessPolicy const& policy,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an [access policy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]. The
  /// long-running operation from this RPC has a successful status after the
  /// changes to the [access policy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] propagate
  /// to long-lasting storage.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.AccessPolicy] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L36}
  /// [google.identity.accesscontextmanager.v1.UpdateAccessPolicyRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L520}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
  UpdateAccessPolicy(google::identity::accesscontextmanager::v1::
                         UpdateAccessPolicyRequest const& request,
                     Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAccessPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAccessPolicy(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          UpdateAccessPolicyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAccessPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessPolicy>>
  UpdateAccessPolicy(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Deletes an [access policy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] based on the
  /// resource name. The long-running operation has a successful status after the
  /// [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy]
  /// is removed from long-lasting storage.
  ///
  /// @param name  Required. Resource name for the access policy to delete.
  ///  @n
  ///  Format `accessPolicies/{policy_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L984}
  /// [google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L529}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteAccessPolicy(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAccessPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAccessPolicy(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an [access policy]
  /// [google.identity.accesscontextmanager.v1.AccessPolicy] based on the
  /// resource name. The long-running operation has a successful status after the
  /// [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy]
  /// is removed from long-lasting storage.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L984}
  /// [google.identity.accesscontextmanager.v1.DeleteAccessPolicyRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L529}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteAccessPolicy(google::identity::accesscontextmanager::v1::
                         DeleteAccessPolicyRequest const& request,
                     Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAccessPolicy
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAccessPolicy(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          DeleteAccessPolicyRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAccessPolicy
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteAccessPolicy(google::longrunning::Operation const& operation,
                     Options opts = {});

  // clang-format off
  ///
  /// Lists all [access levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] for an access
  /// policy.
  ///
  /// @param parent  Required. Resource name for the access policy to list [Access Levels]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel] from.
  ///  @n
  ///  Format:
  ///  `accessPolicies/{policy_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.identity.accesscontextmanager.v1.AccessLevel], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessLevel]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L36}
  /// [google.identity.accesscontextmanager.v1.ListAccessLevelsRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L542}
  ///
  // clang-format on
  StreamRange<google::identity::accesscontextmanager::v1::AccessLevel>
  ListAccessLevels(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all [access levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] for an access
  /// policy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.ListAccessLevelsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.identity.accesscontextmanager.v1.AccessLevel], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessLevel]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L36}
  /// [google.identity.accesscontextmanager.v1.ListAccessLevelsRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L542}
  ///
  // clang-format on
  StreamRange<google::identity::accesscontextmanager::v1::AccessLevel>
  ListAccessLevels(
      google::identity::accesscontextmanager::v1::ListAccessLevelsRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets an [access level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
  /// name.
  ///
  /// @param name  Required. Resource name for the [Access Level]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel].
  ///  @n
  ///  Format:
  ///  `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.identity.accesscontextmanager.v1.AccessLevel])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessLevel]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L36}
  /// [google.identity.accesscontextmanager.v1.GetAccessLevelRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L583}
  ///
  // clang-format on
  StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>
  GetAccessLevel(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets an [access level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
  /// name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.GetAccessLevelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.identity.accesscontextmanager.v1.AccessLevel])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessLevel]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L36}
  /// [google.identity.accesscontextmanager.v1.GetAccessLevelRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L583}
  ///
  // clang-format on
  StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>
  GetAccessLevel(
      google::identity::accesscontextmanager::v1::GetAccessLevelRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an [access level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
  /// operation from this RPC has a successful status after the [access
  /// level] [google.identity.accesscontextmanager.v1.AccessLevel]
  /// propagates to long-lasting storage. If [access levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] contain
  /// errors, an error response is returned for the first error encountered.
  ///
  /// @param parent  Required. Resource name for the access policy which owns this [Access
  ///  Level] [google.identity.accesscontextmanager.v1.AccessLevel].
  ///  @n
  ///  Format: `accessPolicies/{policy_id}`
  /// @param access_level  Required. The [Access Level]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel] to create.
  ///  Syntactic correctness of the [Access Level]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel] is a
  ///  precondition for creation.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.AccessLevel] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessLevel]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L36}
  /// [google.identity.accesscontextmanager.v1.CreateAccessLevelRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L608}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  CreateAccessLevel(
      std::string const& parent,
      google::identity::accesscontextmanager::v1::AccessLevel const&
          access_level,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAccessLevel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAccessLevel(
      NoAwaitTag, std::string const& parent,
      google::identity::accesscontextmanager::v1::AccessLevel const&
          access_level,
      Options opts = {});

  // clang-format off
  ///
  /// Creates an [access level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
  /// operation from this RPC has a successful status after the [access
  /// level] [google.identity.accesscontextmanager.v1.AccessLevel]
  /// propagates to long-lasting storage. If [access levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] contain
  /// errors, an error response is returned for the first error encountered.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.CreateAccessLevelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.AccessLevel] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessLevel]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L36}
  /// [google.identity.accesscontextmanager.v1.CreateAccessLevelRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L608}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  CreateAccessLevel(google::identity::accesscontextmanager::v1::
                        CreateAccessLevelRequest const& request,
                    Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAccessLevel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateAccessLevel(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          CreateAccessLevelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateAccessLevel
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  CreateAccessLevel(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Updates an [access level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
  /// operation from this RPC has a successful status after the changes to
  /// the [access level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] propagate
  /// to long-lasting storage. If [access levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] contain
  /// errors, an error response is returned for the first error encountered.
  ///
  /// @param access_level  Required. The updated [Access Level]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel]. Syntactic
  ///  correctness of the [Access Level]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel] is a
  ///  precondition for creation.
  /// @param update_mask  Required. Mask to control which fields get updated. Must be non-empty.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.AccessLevel] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessLevel]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L36}
  /// [google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L629}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  UpdateAccessLevel(
      google::identity::accesscontextmanager::v1::AccessLevel const&
          access_level,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAccessLevel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAccessLevel(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::AccessLevel const&
          access_level,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates an [access level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
  /// operation from this RPC has a successful status after the changes to
  /// the [access level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] propagate
  /// to long-lasting storage. If [access levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] contain
  /// errors, an error response is returned for the first error encountered.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.AccessLevel] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessLevel]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L36}
  /// [google.identity.accesscontextmanager.v1.UpdateAccessLevelRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L629}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  UpdateAccessLevel(google::identity::accesscontextmanager::v1::
                        UpdateAccessLevelRequest const& request,
                    Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAccessLevel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateAccessLevel(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          UpdateAccessLevelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateAccessLevel
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::AccessLevel>>
  UpdateAccessLevel(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Deletes an [access level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
  /// name. The long-running operation from this RPC has a successful status
  /// after the [access level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
  /// from long-lasting storage.
  ///
  /// @param name  Required. Resource name for the [Access Level]
  ///  [google.identity.accesscontextmanager.v1.AccessLevel].
  ///  @n
  ///  Format:
  ///  `accessPolicies/{policy_id}/accessLevels/{access_level_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L984}
  /// [google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L642}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteAccessLevel(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAccessLevel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAccessLevel(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes an [access level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
  /// name. The long-running operation from this RPC has a successful status
  /// after the [access level]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
  /// from long-lasting storage.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L984}
  /// [google.identity.accesscontextmanager.v1.DeleteAccessLevelRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L642}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteAccessLevel(google::identity::accesscontextmanager::v1::
                        DeleteAccessLevelRequest const& request,
                    Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAccessLevel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteAccessLevel(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          DeleteAccessLevelRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteAccessLevel
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteAccessLevel(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Replaces all existing [access levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] in an [access
  /// policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with
  /// the [access levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] provided. This
  /// is done atomically. The long-running operation from this RPC has a
  /// successful status after all replacements propagate to long-lasting
  /// storage. If the replacement contains errors, an error response is returned
  /// for the first error encountered.  Upon error, the replacement is cancelled,
  /// and existing [access levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] are not
  /// affected. The Operation.response field contains
  /// ReplaceAccessLevelsResponse. Removing [access levels]
  /// [google.identity.accesscontextmanager.v1.AccessLevel] contained in existing
  /// [service perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] result in an
  /// error.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.ReplaceAccessLevelsRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L658}
  /// [google.identity.accesscontextmanager.v1.ReplaceAccessLevelsResponse]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L691}
  ///
  // clang-format on
  future<StatusOr<
      google::identity::accesscontextmanager::v1::ReplaceAccessLevelsResponse>>
  ReplaceAccessLevels(google::identity::accesscontextmanager::v1::
                          ReplaceAccessLevelsRequest const& request,
                      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ReplaceAccessLevels
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ReplaceAccessLevels(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          ReplaceAccessLevelsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ReplaceAccessLevels
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<
      google::identity::accesscontextmanager::v1::ReplaceAccessLevelsResponse>>
  ReplaceAccessLevels(google::longrunning::Operation const& operation,
                      Options opts = {});

  // clang-format off
  ///
  /// Lists all [service perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
  /// access policy.
  ///
  /// @param parent  Required. Resource name for the access policy to list [Service Perimeters]
  ///  [google.identity.accesscontextmanager.v1.ServicePerimeter] from.
  ///  @n
  ///  Format:
  ///  `accessPolicies/{policy_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.identity.accesscontextmanager.v1.ServicePerimeter], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.ListServicePerimetersRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L698}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L41}
  ///
  // clang-format on
  StreamRange<google::identity::accesscontextmanager::v1::ServicePerimeter>
  ListServicePerimeters(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all [service perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
  /// access policy.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.ListServicePerimetersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.identity.accesscontextmanager.v1.ServicePerimeter], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.ListServicePerimetersRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L698}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L41}
  ///
  // clang-format on
  StreamRange<google::identity::accesscontextmanager::v1::ServicePerimeter>
  ListServicePerimeters(
      google::identity::accesscontextmanager::v1::ListServicePerimetersRequest
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
  /// resource name.
  ///
  /// @param name  Required. Resource name for the [Service Perimeter]
  ///  [google.identity.accesscontextmanager.v1.ServicePerimeter].
  ///  @n
  ///  Format:
  ///  `accessPolicies/{policy_id}/servicePerimeters/{service_perimeters_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.identity.accesscontextmanager.v1.ServicePerimeter])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.GetServicePerimeterRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L734}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L41}
  ///
  // clang-format on
  StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>
  GetServicePerimeter(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
  /// resource name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.GetServicePerimeterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.identity.accesscontextmanager.v1.ServicePerimeter])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.GetServicePerimeterRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L734}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L41}
  ///
  // clang-format on
  StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>
  GetServicePerimeter(google::identity::accesscontextmanager::v1::
                          GetServicePerimeterRequest const& request,
                      Options opts = {});

  // clang-format off
  ///
  /// Creates a [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
  /// long-running operation from this RPC has a successful status after the
  /// [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]
  /// propagates to long-lasting storage. If a [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
  /// errors, an error response is returned for the first error encountered.
  ///
  /// @param parent  Required. Resource name for the access policy which owns this [Service
  ///  Perimeter] [google.identity.accesscontextmanager.v1.ServicePerimeter].
  ///  @n
  ///  Format: `accessPolicies/{policy_id}`
  /// @param service_perimeter  Required. The [Service Perimeter]
  ///  [google.identity.accesscontextmanager.v1.ServicePerimeter] to create.
  ///  Syntactic correctness of the [Service Perimeter]
  ///  [google.identity.accesscontextmanager.v1.ServicePerimeter] is a
  ///  precondition for creation.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.ServicePerimeter] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L749}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L41}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  CreateServicePerimeter(
      std::string const& parent,
      google::identity::accesscontextmanager::v1::ServicePerimeter const&
          service_perimeter,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServicePerimeter
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateServicePerimeter(
      NoAwaitTag, std::string const& parent,
      google::identity::accesscontextmanager::v1::ServicePerimeter const&
          service_perimeter,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
  /// long-running operation from this RPC has a successful status after the
  /// [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]
  /// propagates to long-lasting storage. If a [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
  /// errors, an error response is returned for the first error encountered.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.ServicePerimeter] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.CreateServicePerimeterRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L749}
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L41}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  CreateServicePerimeter(google::identity::accesscontextmanager::v1::
                             CreateServicePerimeterRequest const& request,
                         Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServicePerimeter
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateServicePerimeter(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          CreateServicePerimeterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateServicePerimeter
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  CreateServicePerimeter(google::longrunning::Operation const& operation,
                         Options opts = {});

  // clang-format off
  ///
  /// Updates a [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
  /// long-running operation from this RPC has a successful status after the
  /// [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]
  /// propagates to long-lasting storage. If a [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
  /// errors, an error response is returned for the first error encountered.
  ///
  /// @param service_perimeter  Required. The updated `ServicePerimeter`. Syntactic correctness of the
  ///  `ServicePerimeter` is a precondition for creation.
  /// @param update_mask  Required. Mask to control which fields get updated. Must be non-empty.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.ServicePerimeter] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L41}
  /// [google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L770}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  UpdateServicePerimeter(
      google::identity::accesscontextmanager::v1::ServicePerimeter const&
          service_perimeter,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateServicePerimeter
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateServicePerimeter(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::ServicePerimeter const&
          service_perimeter,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
  /// long-running operation from this RPC has a successful status after the
  /// [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]
  /// propagates to long-lasting storage. If a [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
  /// errors, an error response is returned for the first error encountered.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.ServicePerimeter] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/service_perimeter.proto#L41}
  /// [google.identity.accesscontextmanager.v1.UpdateServicePerimeterRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L770}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  UpdateServicePerimeter(google::identity::accesscontextmanager::v1::
                             UpdateServicePerimeterRequest const& request,
                         Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateServicePerimeter
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateServicePerimeter(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          UpdateServicePerimeterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateServicePerimeter
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::ServicePerimeter>>
  UpdateServicePerimeter(google::longrunning::Operation const& operation,
                         Options opts = {});

  // clang-format off
  ///
  /// Deletes a [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
  /// resource name. The long-running operation from this RPC has a successful
  /// status after the [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] is removed from
  /// long-lasting storage.
  ///
  /// @param name  Required. Resource name for the [Service Perimeter]
  ///  [google.identity.accesscontextmanager.v1.ServicePerimeter].
  ///  @n
  ///  Format:
  ///  `accessPolicies/{policy_id}/servicePerimeters/{service_perimeter_id}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L984}
  /// [google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L780}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteServicePerimeter(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteServicePerimeter
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteServicePerimeter(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
  /// resource name. The long-running operation from this RPC has a successful
  /// status after the [service perimeter]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] is removed from
  /// long-lasting storage.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessContextManagerOperationMetadata]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L984}
  /// [google.identity.accesscontextmanager.v1.DeleteServicePerimeterRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L780}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteServicePerimeter(google::identity::accesscontextmanager::v1::
                             DeleteServicePerimeterRequest const& request,
                         Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteServicePerimeter
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteServicePerimeter(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          DeleteServicePerimeterRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteServicePerimeter
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      AccessContextManagerOperationMetadata>>
  DeleteServicePerimeter(google::longrunning::Operation const& operation,
                         Options opts = {});

  // clang-format off
  ///
  /// Replace all existing [service perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an [access
  /// policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with the
  /// [service perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] provided. This
  /// is done atomically. The long-running operation from this RPC has a
  /// successful status after all replacements propagate to long-lasting storage.
  /// Replacements containing errors result in an error response for the first
  /// error encountered. Upon an error, replacement are cancelled and existing
  /// [service perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] are not
  /// affected. The Operation.response field contains
  /// ReplaceServicePerimetersResponse.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.ReplaceServicePerimetersRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L796}
  /// [google.identity.accesscontextmanager.v1.ReplaceServicePerimetersResponse]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L829}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      ReplaceServicePerimetersResponse>>
  ReplaceServicePerimeters(google::identity::accesscontextmanager::v1::
                               ReplaceServicePerimetersRequest const& request,
                           Options opts = {});

  // clang-format off
  ///
  /// @copybrief ReplaceServicePerimeters
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> ReplaceServicePerimeters(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          ReplaceServicePerimetersRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief ReplaceServicePerimeters
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      ReplaceServicePerimetersResponse>>
  ReplaceServicePerimeters(google::longrunning::Operation const& operation,
                           Options opts = {});

  // clang-format off
  ///
  /// Commits the dry-run specification for all the [service perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
  /// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
  /// A commit operation on a service perimeter involves copying its `spec` field
  /// to the `status` field of the service perimeter. Only [service perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] with
  /// `use_explicit_dry_run_spec` field set to true are affected by a commit
  /// operation. The long-running operation from this RPC has a successful
  /// status after the dry-run specifications for all the [service perimeters]
  /// [google.identity.accesscontextmanager.v1.ServicePerimeter] have been
  /// committed. If a commit fails, it causes the long-running operation to
  /// return an error response and the entire commit operation is cancelled.
  /// When successful, the Operation.response field contains
  /// CommitServicePerimetersResponse. The `dry_run` and the `spec` fields are
  /// cleared after a successful commit operation.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L36}
  /// [google.identity.accesscontextmanager.v1.CommitServicePerimetersRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L838}
  /// [google.identity.accesscontextmanager.v1.CommitServicePerimetersResponse]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L865}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      CommitServicePerimetersResponse>>
  CommitServicePerimeters(google::identity::accesscontextmanager::v1::
                              CommitServicePerimetersRequest const& request,
                          Options opts = {});

  // clang-format off
  ///
  /// @copybrief CommitServicePerimeters
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CommitServicePerimeters(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          CommitServicePerimetersRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CommitServicePerimeters
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      CommitServicePerimetersResponse>>
  CommitServicePerimeters(google::longrunning::Operation const& operation,
                          Options opts = {});

  // clang-format off
  ///
  /// Lists all [GcpUserAccessBindings]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
  /// Google Cloud organization.
  ///
  /// @param parent  Required. Example: "organizations/256"
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.identity.accesscontextmanager.v1.GcpUserAccessBinding], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L33}
  /// [google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L889}
  ///
  // clang-format on
  StreamRange<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
  ListGcpUserAccessBindings(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists all [GcpUserAccessBindings]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
  /// Google Cloud organization.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.identity.accesscontextmanager.v1.GcpUserAccessBinding], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L33}
  /// [google.identity.accesscontextmanager.v1.ListGcpUserAccessBindingsRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L889}
  ///
  // clang-format on
  StreamRange<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
  ListGcpUserAccessBindings(google::identity::accesscontextmanager::v1::
                                ListGcpUserAccessBindingsRequest request,
                            Options opts = {});

  // clang-format off
  ///
  /// Gets the [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
  /// the given name.
  ///
  /// @param name  Required. Example: "organizations/256/gcpUserAccessBindings/b3-BhcX_Ud5N"
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.identity.accesscontextmanager.v1.GcpUserAccessBinding])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L33}
  /// [google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L922}
  ///
  // clang-format on
  StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
  GetGcpUserAccessBinding(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets the [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
  /// the given name.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.identity.accesscontextmanager.v1.GcpUserAccessBinding])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L33}
  /// [google.identity.accesscontextmanager.v1.GetGcpUserAccessBindingRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L922}
  ///
  // clang-format on
  StatusOr<google::identity::accesscontextmanager::v1::GcpUserAccessBinding>
  GetGcpUserAccessBinding(google::identity::accesscontextmanager::v1::
                              GetGcpUserAccessBindingRequest const& request,
                          Options opts = {});

  // clang-format off
  ///
  /// Creates a [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
  /// client specifies a [name]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name],
  /// the server ignores it. Fails if a resource already exists with the same
  /// [group_key]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
  /// Completion of this long-running operation does not necessarily signify that
  /// the new binding is deployed onto all affected users, which may take more
  /// time.
  ///
  /// @param parent  Required. Example: "organizations/256"
  /// @param gcp_user_access_binding  Required. [GcpUserAccessBinding]
  ///  [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L934}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L33}
  ///
  // clang-format on
  future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  CreateGcpUserAccessBinding(
      std::string const& parent,
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding const&
          gcp_user_access_binding,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGcpUserAccessBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGcpUserAccessBinding(
      NoAwaitTag, std::string const& parent,
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding const&
          gcp_user_access_binding,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
  /// client specifies a [name]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name],
  /// the server ignores it. Fails if a resource already exists with the same
  /// [group_key]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
  /// Completion of this long-running operation does not necessarily signify that
  /// the new binding is deployed onto all affected users, which may take more
  /// time.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.CreateGcpUserAccessBindingRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L934}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L33}
  ///
  // clang-format on
  future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  CreateGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::
          CreateGcpUserAccessBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGcpUserAccessBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateGcpUserAccessBinding(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          CreateGcpUserAccessBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateGcpUserAccessBinding
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  CreateGcpUserAccessBinding(google::longrunning::Operation const& operation,
                             Options opts = {});

  // clang-format off
  ///
  /// Updates a [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
  /// Completion of this long-running operation does not necessarily signify that
  /// the changed binding is deployed onto all affected users, which may take
  /// more time.
  ///
  /// @param gcp_user_access_binding  Required. [GcpUserAccessBinding]
  ///  [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]
  /// @param update_mask  Required. Only the fields specified in this mask are updated. Because name and
  ///  group_key cannot be changed, update_mask is required and must always be:
  ///  @n
  ///  update_mask {
  ///  paths: "access_levels"
  ///  }
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L33}
  /// [google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L950}
  ///
  // clang-format on
  future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  UpdateGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding const&
          gcp_user_access_binding,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGcpUserAccessBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateGcpUserAccessBinding(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding const&
          gcp_user_access_binding,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
  /// Completion of this long-running operation does not necessarily signify that
  /// the changed binding is deployed onto all affected users, which may take
  /// more time.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/gcp_user_access_binding.proto#L33}
  /// [google.identity.accesscontextmanager.v1.UpdateGcpUserAccessBindingRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L950}
  ///
  // clang-format on
  future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  UpdateGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::
          UpdateGcpUserAccessBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGcpUserAccessBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateGcpUserAccessBinding(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          UpdateGcpUserAccessBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateGcpUserAccessBinding
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<
      google::identity::accesscontextmanager::v1::GcpUserAccessBinding>>
  UpdateGcpUserAccessBinding(google::longrunning::Operation const& operation,
                             Options opts = {});

  // clang-format off
  ///
  /// Deletes a [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
  /// Completion of this long-running operation does not necessarily signify that
  /// the binding deletion is deployed onto all affected users, which may take
  /// more time.
  ///
  /// @param name  Required. Example: "organizations/256/gcpUserAccessBindings/b3-BhcX_Ud5N"
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L966}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L979}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      GcpUserAccessBindingOperationMetadata>>
  DeleteGcpUserAccessBinding(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGcpUserAccessBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGcpUserAccessBinding(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a [GcpUserAccessBinding]
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
  /// Completion of this long-running operation does not necessarily signify that
  /// the binding deletion is deployed onto all affected users, which may take
  /// more time.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.identity.accesscontextmanager.v1.DeleteGcpUserAccessBindingRequest]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L966}
  /// [google.identity.accesscontextmanager.v1.GcpUserAccessBindingOperationMetadata]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_context_manager.proto#L979}
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      GcpUserAccessBindingOperationMetadata>>
  DeleteGcpUserAccessBinding(
      google::identity::accesscontextmanager::v1::
          DeleteGcpUserAccessBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGcpUserAccessBinding
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteGcpUserAccessBinding(
      NoAwaitTag,
      google::identity::accesscontextmanager::v1::
          DeleteGcpUserAccessBindingRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteGcpUserAccessBinding
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::identity::accesscontextmanager::v1::
                      GcpUserAccessBindingOperationMetadata>>
  DeleteGcpUserAccessBinding(google::longrunning::Operation const& operation,
                             Options opts = {});

  // clang-format off
  ///
  /// Sets the IAM policy for the specified Access Context Manager
  /// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
  /// This method replaces the existing IAM policy on the access policy. The IAM
  /// policy controls the set of users who can perform specific operations on the
  /// Access Context Manager [access
  /// policy][google.identity.accesscontextmanager.v1.AccessPolicy].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.SetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  /// [google.iam.v1.SetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L100}
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L36}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Gets the IAM policy for the specified Access Context Manager
  /// [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.GetIamPolicyRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.Policy])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.GetIamPolicyRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L123}
  /// [google.iam.v1.Policy]: @googleapis_reference_link{google/iam/v1/policy.proto#L102}
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L36}
  ///
  // clang-format on
  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request, Options opts = {});

  // clang-format off
  ///
  /// Returns the IAM permissions that the caller has on the specified Access
  /// Context Manager resource. The resource can be an
  /// [AccessPolicy][google.identity.accesscontextmanager.v1.AccessPolicy],
  /// [AccessLevel][google.identity.accesscontextmanager.v1.AccessLevel], or
  /// [ServicePerimeter][google.identity.accesscontextmanager.v1.ServicePerimeter
  /// ]. This method does not support other resources.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.iam.v1.TestIamPermissionsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.iam.v1.TestIamPermissionsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.iam.v1.TestIamPermissionsRequest]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L137}
  /// [google.iam.v1.TestIamPermissionsResponse]: @googleapis_reference_link{google/iam/v1/iam_policy.proto#L153}
  /// [google.identity.accesscontextmanager.v1.AccessLevel]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_level.proto#L36}
  /// [google.identity.accesscontextmanager.v1.AccessPolicy]: @googleapis_reference_link{google/identity/accesscontextmanager/v1/access_policy.proto#L36}
  ///
  // clang-format on
  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param name  The name of the operation resource.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(std::string const& name,
                                                        Options opts = {});

  // clang-format off
  ///
  /// Gets the latest state of a long-running operation.  Clients can use this
  /// method to poll the operation result at intervals as recommended by the API
  /// service.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.longrunning.GetOperationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.longrunning.Operation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.longrunning.GetOperationRequest]: @googleapis_reference_link{google/longrunning/operations.proto#L165}
  /// [google.longrunning.Operation]: @googleapis_reference_link{google/longrunning/operations.proto#L128}
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> GetOperation(
      google::longrunning::GetOperationRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<AccessContextManagerConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace accesscontextmanager_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_ACCESSCONTEXTMANAGER_V1_ACCESS_CONTEXT_MANAGER_CLIENT_H
