// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test_request_id.proto

#include "generator/integration_tests/golden/v1/internal/request_id_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

RequestIdServiceTracingStub::RequestIdServiceTracingStub(
    std::shared_ptr<RequestIdServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::test::requestid::v1::Foo> RequestIdServiceTracingStub::CreateFoo(
    grpc::ClientContext& context,
    Options const& options,
    google::test::requestid::v1::CreateFooRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.test.requestid.v1.RequestIdService", "CreateFoo");
  span->SetAttribute("gl-cpp.request_id", request.request_id());
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateFoo(context, options, request));
}

future<StatusOr<google::longrunning::Operation>>
RequestIdServiceTracingStub::AsyncRenameFoo(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::test::requestid::v1::RenameFooRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.test.requestid.v1.RequestIdService", "RenameFoo");
  span->SetAttribute("gl-cpp.request_id", request.request_id());
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncRenameFoo(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

StatusOr<google::longrunning::Operation>
RequestIdServiceTracingStub::RenameFoo(
      grpc::ClientContext& context,
      Options options,
      google::test::requestid::v1::RenameFooRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.test.requestid.v1.RequestIdService", "RenameFoo");
  span->SetAttribute("gl-cpp.request_id", request.request_id());
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->RenameFoo(context, options, request));
}

StatusOr<google::test::requestid::v1::ListFoosResponse> RequestIdServiceTracingStub::ListFoos(
    grpc::ClientContext& context,
    Options const& options,
    google::test::requestid::v1::ListFoosRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.test.requestid.v1.RequestIdService", "ListFoos");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListFoos(context, options, request));
}

future<StatusOr<google::test::requestid::v1::Foo>>
RequestIdServiceTracingStub::AsyncCreateFoo(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::test::requestid::v1::CreateFooRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.test.requestid.v1.RequestIdService", "CreateFoo");
  span->SetAttribute("gl-cpp.request_id", request.request_id());
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCreateFoo(cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<StatusOr<google::longrunning::Operation>>
RequestIdServiceTracingStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::GetOperationRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.longrunning.Operations", "GetOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncGetOperation(
      cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

future<Status> RequestIdServiceTracingStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions options,
    google::longrunning::CancelOperationRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.longrunning.Operations",
                                     "CancelOperation");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncCancelOperation(
      cq, context, std::move(options), request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<RequestIdServiceStub> MakeRequestIdServiceTracingStub(
    std::shared_ptr<RequestIdServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<RequestIdServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google
