// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test.proto

#include "generator/integration_tests/golden/v1/internal/golden_thing_admin_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace golden_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

GoldenThingAdminTracingConnection::GoldenThingAdminTracingConnection(
    std::shared_ptr<golden_v1::GoldenThingAdminConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::test::admin::database::v1::Database>
GoldenThingAdminTracingConnection::ListDatabases(google::test::admin::database::v1::ListDatabasesRequest request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::ListDatabases");
  internal::OTelScope scope(span);
  auto sr = child_->ListDatabases(std::move(request));
  return internal::MakeTracedStreamRange<google::test::admin::database::v1::Database>(
        std::move(span), std::move(sr));
}

future<StatusOr<google::test::admin::database::v1::Database>>
GoldenThingAdminTracingConnection::CreateDatabase(google::test::admin::database::v1::CreateDatabaseRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::CreateDatabase");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateDatabase(request));
}

StatusOr<google::longrunning::Operation>
GoldenThingAdminTracingConnection::CreateDatabase(
    NoAwaitTag, google::test::admin::database::v1::CreateDatabaseRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::CreateDatabase");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateDatabase(
      NoAwaitTag{}, request));
}

future<StatusOr<google::test::admin::database::v1::Database>>
GoldenThingAdminTracingConnection::CreateDatabase(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::CreateDatabase");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
      child_->CreateDatabase(operation));
}

StatusOr<google::test::admin::database::v1::Database>
GoldenThingAdminTracingConnection::GetDatabase(google::test::admin::database::v1::GetDatabaseRequest const& request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::GetDatabase");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDatabase(request));
}

future<StatusOr<google::test::admin::database::v1::UpdateDatabaseDdlMetadata>>
GoldenThingAdminTracingConnection::UpdateDatabaseDdl(google::test::admin::database::v1::UpdateDatabaseDdlRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::UpdateDatabaseDdl");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->UpdateDatabaseDdl(request));
}

StatusOr<google::longrunning::Operation>
GoldenThingAdminTracingConnection::UpdateDatabaseDdl(
    NoAwaitTag, google::test::admin::database::v1::UpdateDatabaseDdlRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::UpdateDatabaseDdl");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->UpdateDatabaseDdl(
      NoAwaitTag{}, request));
}

future<StatusOr<google::test::admin::database::v1::UpdateDatabaseDdlMetadata>>
GoldenThingAdminTracingConnection::UpdateDatabaseDdl(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::UpdateDatabaseDdl");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
      child_->UpdateDatabaseDdl(operation));
}

Status
GoldenThingAdminTracingConnection::DropDatabase(google::test::admin::database::v1::DropDatabaseRequest const& request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::DropDatabase");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DropDatabase(request));
}

StatusOr<google::test::admin::database::v1::GetDatabaseDdlResponse>
GoldenThingAdminTracingConnection::GetDatabaseDdl(google::test::admin::database::v1::GetDatabaseDdlRequest const& request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::GetDatabaseDdl");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetDatabaseDdl(request));
}

StatusOr<google::iam::v1::Policy>
GoldenThingAdminTracingConnection::SetIamPolicy(google::iam::v1::SetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::SetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->SetIamPolicy(request));
}

StatusOr<google::iam::v1::Policy>
GoldenThingAdminTracingConnection::GetIamPolicy(google::iam::v1::GetIamPolicyRequest const& request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::GetIamPolicy");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetIamPolicy(request));
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
GoldenThingAdminTracingConnection::TestIamPermissions(google::iam::v1::TestIamPermissionsRequest const& request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::TestIamPermissions");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->TestIamPermissions(request));
}

future<StatusOr<google::test::admin::database::v1::Backup>>
GoldenThingAdminTracingConnection::CreateBackup(google::test::admin::database::v1::CreateBackupRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::CreateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateBackup(request));
}

StatusOr<google::longrunning::Operation>
GoldenThingAdminTracingConnection::CreateBackup(
    NoAwaitTag, google::test::admin::database::v1::CreateBackupRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::CreateBackup");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->CreateBackup(
      NoAwaitTag{}, request));
}

future<StatusOr<google::test::admin::database::v1::Backup>>
GoldenThingAdminTracingConnection::CreateBackup(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::CreateBackup");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
      child_->CreateBackup(operation));
}

StatusOr<google::test::admin::database::v1::Backup>
GoldenThingAdminTracingConnection::GetBackup(google::test::admin::database::v1::GetBackupRequest const& request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::GetBackup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetBackup(request));
}

StatusOr<google::test::admin::database::v1::Backup>
GoldenThingAdminTracingConnection::UpdateBackup(google::test::admin::database::v1::UpdateBackupRequest const& request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::UpdateBackup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->UpdateBackup(request));
}

Status
GoldenThingAdminTracingConnection::DeleteBackup(google::test::admin::database::v1::DeleteBackupRequest const& request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::DeleteBackup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->DeleteBackup(request));
}

StreamRange<google::test::admin::database::v1::Backup>
GoldenThingAdminTracingConnection::ListBackups(google::test::admin::database::v1::ListBackupsRequest request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::ListBackups");
  internal::OTelScope scope(span);
  auto sr = child_->ListBackups(std::move(request));
  return internal::MakeTracedStreamRange<google::test::admin::database::v1::Backup>(
        std::move(span), std::move(sr));
}

future<StatusOr<google::test::admin::database::v1::Database>>
GoldenThingAdminTracingConnection::RestoreDatabase(google::test::admin::database::v1::RestoreDatabaseRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::RestoreDatabase");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->RestoreDatabase(request));
}

StatusOr<google::longrunning::Operation>
GoldenThingAdminTracingConnection::RestoreDatabase(
    NoAwaitTag, google::test::admin::database::v1::RestoreDatabaseRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::RestoreDatabase");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->RestoreDatabase(
      NoAwaitTag{}, request));
}

future<StatusOr<google::test::admin::database::v1::Database>>
GoldenThingAdminTracingConnection::RestoreDatabase(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::RestoreDatabase");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
      child_->RestoreDatabase(operation));
}

StreamRange<google::longrunning::Operation>
GoldenThingAdminTracingConnection::ListDatabaseOperations(google::test::admin::database::v1::ListDatabaseOperationsRequest request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::ListDatabaseOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListDatabaseOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
        std::move(span), std::move(sr));
}

StreamRange<google::longrunning::Operation>
GoldenThingAdminTracingConnection::ListBackupOperations(google::test::admin::database::v1::ListBackupOperationsRequest request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::ListBackupOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListBackupOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
        std::move(span), std::move(sr));
}

future<StatusOr<google::test::admin::database::v1::Database>>
GoldenThingAdminTracingConnection::LongRunningWithoutRouting(google::test::admin::database::v1::RestoreDatabaseRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::LongRunningWithoutRouting");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->LongRunningWithoutRouting(request));
}

StatusOr<google::longrunning::Operation>
GoldenThingAdminTracingConnection::LongRunningWithoutRouting(
    NoAwaitTag, google::test::admin::database::v1::RestoreDatabaseRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::LongRunningWithoutRouting");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->LongRunningWithoutRouting(
      NoAwaitTag{}, request));
}

future<StatusOr<google::test::admin::database::v1::Database>>
GoldenThingAdminTracingConnection::LongRunningWithoutRouting(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::LongRunningWithoutRouting");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span),
      child_->LongRunningWithoutRouting(operation));
}

StatusOr<google::cloud::location::Location>
GoldenThingAdminTracingConnection::GetLocation(google::cloud::location::GetLocationRequest const& request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::GetLocation");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetLocation(request));
}

StreamRange<google::longrunning::Operation>
GoldenThingAdminTracingConnection::ListOperations(google::longrunning::ListOperationsRequest request) {
  auto span = internal::MakeSpan("golden_v1::GoldenThingAdminConnection::ListOperations");
  internal::OTelScope scope(span);
  auto sr = child_->ListOperations(std::move(request));
  return internal::MakeTracedStreamRange<google::longrunning::Operation>(
        std::move(span), std::move(sr));
}

future<StatusOr<google::test::admin::database::v1::Database>>
GoldenThingAdminTracingConnection::AsyncGetDatabase(google::test::admin::database::v1::GetDatabaseRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::AsyncGetDatabase");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AsyncGetDatabase(request));
}

future<Status>
GoldenThingAdminTracingConnection::AsyncDropDatabase(google::test::admin::database::v1::DropDatabaseRequest const& request) {
  auto span = internal::MakeSpan(
      "golden_v1::GoldenThingAdminConnection::AsyncDropDatabase");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->AsyncDropDatabase(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<golden_v1::GoldenThingAdminConnection>
MakeGoldenThingAdminTracingConnection(
    std::shared_ptr<golden_v1::GoldenThingAdminConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<GoldenThingAdminTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1_internal
}  // namespace cloud
}  // namespace google
