// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test.proto

#ifndef GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_GOLDEN_THING_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_GOLDEN_THING_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/version.h"
#include <generator/integration_tests/test.grpc.pb.h>
#include <google/cloud/location/locations.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace golden_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class GoldenThingAdminConnectionIdempotencyPolicy {
 public:
  virtual ~GoldenThingAdminConnectionIdempotencyPolicy();

  /// Create a new copy of this object.
  virtual std::unique_ptr<GoldenThingAdminConnectionIdempotencyPolicy> clone() const;

  virtual google::cloud::Idempotency
  ListDatabases(google::test::admin::database::v1::ListDatabasesRequest request);

  virtual google::cloud::Idempotency
  CreateDatabase(google::test::admin::database::v1::CreateDatabaseRequest const& request);

  virtual google::cloud::Idempotency
  GetDatabase(google::test::admin::database::v1::GetDatabaseRequest const& request);

  virtual google::cloud::Idempotency
  UpdateDatabaseDdl(google::test::admin::database::v1::UpdateDatabaseDdlRequest const& request);

  virtual google::cloud::Idempotency
  DropDatabase(google::test::admin::database::v1::DropDatabaseRequest const& request);

  virtual google::cloud::Idempotency
  GetDatabaseDdl(google::test::admin::database::v1::GetDatabaseDdlRequest const& request);

  virtual google::cloud::Idempotency
  SetIamPolicy(google::iam::v1::SetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency
  GetIamPolicy(google::iam::v1::GetIamPolicyRequest const& request);

  virtual google::cloud::Idempotency
  TestIamPermissions(google::iam::v1::TestIamPermissionsRequest const& request);

  virtual google::cloud::Idempotency
  CreateBackup(google::test::admin::database::v1::CreateBackupRequest const& request);

  virtual google::cloud::Idempotency
  GetBackup(google::test::admin::database::v1::GetBackupRequest const& request);

  virtual google::cloud::Idempotency
  UpdateBackup(google::test::admin::database::v1::UpdateBackupRequest const& request);

  virtual google::cloud::Idempotency
  DeleteBackup(google::test::admin::database::v1::DeleteBackupRequest const& request);

  virtual google::cloud::Idempotency
  ListBackups(google::test::admin::database::v1::ListBackupsRequest request);

  virtual google::cloud::Idempotency
  RestoreDatabase(google::test::admin::database::v1::RestoreDatabaseRequest const& request);

  virtual google::cloud::Idempotency
  ListDatabaseOperations(google::test::admin::database::v1::ListDatabaseOperationsRequest request);

  virtual google::cloud::Idempotency
  ListBackupOperations(google::test::admin::database::v1::ListBackupOperationsRequest request);

  virtual google::cloud::Idempotency
  LongRunningWithoutRouting(google::test::admin::database::v1::RestoreDatabaseRequest const& request);

  virtual google::cloud::Idempotency
  GetLocation(google::cloud::location::GetLocationRequest const& request);

  virtual google::cloud::Idempotency
  ListOperations(google::longrunning::ListOperationsRequest request);
};

std::unique_ptr<GoldenThingAdminConnectionIdempotencyPolicy>
    MakeDefaultGoldenThingAdminConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GENERATOR_INTEGRATION_TESTS_GOLDEN_V1_GOLDEN_THING_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H
