// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test.proto

#include "generator/integration_tests/golden/v1/golden_thing_admin_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace golden_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

GoldenThingAdminConnectionIdempotencyPolicy::~GoldenThingAdminConnectionIdempotencyPolicy() = default;

std::unique_ptr<GoldenThingAdminConnectionIdempotencyPolicy>
GoldenThingAdminConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<GoldenThingAdminConnectionIdempotencyPolicy>(*this);
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::ListDatabases(google::test::admin::database::v1::ListDatabasesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::CreateDatabase(google::test::admin::database::v1::CreateDatabaseRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::GetDatabase(google::test::admin::database::v1::GetDatabaseRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::UpdateDatabaseDdl(google::test::admin::database::v1::UpdateDatabaseDdlRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::DropDatabase(google::test::admin::database::v1::DropDatabaseRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::GetDatabaseDdl(google::test::admin::database::v1::GetDatabaseDdlRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::GetIamPolicy(google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::TestIamPermissions(google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::CreateBackup(google::test::admin::database::v1::CreateBackupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::GetBackup(google::test::admin::database::v1::GetBackupRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::UpdateBackup(google::test::admin::database::v1::UpdateBackupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::DeleteBackup(google::test::admin::database::v1::DeleteBackupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::ListBackups(google::test::admin::database::v1::ListBackupsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::RestoreDatabase(google::test::admin::database::v1::RestoreDatabaseRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::ListDatabaseOperations(google::test::admin::database::v1::ListDatabaseOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::ListBackupOperations(google::test::admin::database::v1::ListBackupOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::LongRunningWithoutRouting(google::test::admin::database::v1::RestoreDatabaseRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::GetLocation(google::cloud::location::GetLocationRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency GoldenThingAdminConnectionIdempotencyPolicy::ListOperations(google::longrunning::ListOperationsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

std::unique_ptr<GoldenThingAdminConnectionIdempotencyPolicy>
    MakeDefaultGoldenThingAdminConnectionIdempotencyPolicy() {
  return std::make_unique<GoldenThingAdminConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1
}  // namespace cloud
}  // namespace google
