// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: generator/integration_tests/test.proto

#include "generator/integration_tests/golden/v1/golden_kitchen_sink_connection.h"
#include "generator/integration_tests/golden/v1/golden_kitchen_sink_options.h"
#include "generator/integration_tests/golden/v1/internal/golden_kitchen_sink_connection_impl.h"
#include "generator/integration_tests/golden/v1/internal/golden_kitchen_sink_option_defaults.h"
#include "generator/integration_tests/golden/v1/internal/golden_kitchen_sink_stub_factory.h"
#include "generator/integration_tests/golden/v1/internal/golden_kitchen_sink_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace golden_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

GoldenKitchenSinkConnection::~GoldenKitchenSinkConnection() = default;

StatusOr<google::test::admin::database::v1::GenerateAccessTokenResponse>
GoldenKitchenSinkConnection::GenerateAccessToken(
    google::test::admin::database::v1::GenerateAccessTokenRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::test::admin::database::v1::GenerateIdTokenResponse>
GoldenKitchenSinkConnection::GenerateIdToken(
    google::test::admin::database::v1::GenerateIdTokenRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::test::admin::database::v1::WriteLogEntriesResponse>
GoldenKitchenSinkConnection::WriteLogEntries(
    google::test::admin::database::v1::WriteLogEntriesRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<std::string> GoldenKitchenSinkConnection::ListLogs(
    google::test::admin::database::v1::ListLogsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<std::string>>();
}

StatusOr<google::test::admin::database::v1::ListServiceAccountKeysResponse>
GoldenKitchenSinkConnection::ListServiceAccountKeys(
    google::test::admin::database::v1::ListServiceAccountKeysRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status
GoldenKitchenSinkConnection::DoNothing(
    google::protobuf::Empty const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status
GoldenKitchenSinkConnection::Deprecated2(
    google::test::admin::database::v1::GenerateAccessTokenRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::test::admin::database::v1::Response> GoldenKitchenSinkConnection::StreamingRead(
    google::test::admin::database::v1::Request const&) {
  return google::cloud::internal::MakeStreamRange<
      google::test::admin::database::v1::Response>(
      []() -> absl::variant<Status,
      google::test::admin::database::v1::Response>{
        return Status(StatusCode::kUnimplemented, "not implemented");}
      );
}

std::unique_ptr<::google::cloud::AsyncStreamingReadWriteRpc<
    google::test::admin::database::v1::Request,
    google::test::admin::database::v1::Response>>
GoldenKitchenSinkConnection::AsyncStreamingReadWrite() {
  return std::make_unique<
      ::google::cloud::internal::AsyncStreamingReadWriteRpcError<
          google::test::admin::database::v1::Request,
          google::test::admin::database::v1::Response>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

Status
GoldenKitchenSinkConnection::ExplicitRouting1(
    google::test::admin::database::v1::ExplicitRoutingRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status
GoldenKitchenSinkConnection::ExplicitRouting2(
    google::test::admin::database::v1::ExplicitRoutingRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::location::Location>
GoldenKitchenSinkConnection::GetLocation(
    google::cloud::location::GetLocationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy>
GoldenKitchenSinkConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::longrunning::Operation> GoldenKitchenSinkConnection::ListOperations(
    google::longrunning::ListOperationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::longrunning::Operation>>();
}

std::shared_ptr<GoldenKitchenSinkConnection> MakeGoldenKitchenSinkConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
      UnifiedCredentialsOptionList,
      GoldenKitchenSinkPolicyOptionList>(options, __func__);
  options = golden_v1_internal::GoldenKitchenSinkDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = golden_v1_internal::CreateDefaultGoldenKitchenSinkStub(
    std::move(auth), options);
  return golden_v1_internal::MakeGoldenKitchenSinkTracingConnection(
      std::make_shared<golden_v1_internal::GoldenKitchenSinkConnectionImpl>(
      std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace golden_v1
}  // namespace cloud
}  // namespace google
