/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import java.text.Format;
import java.text.MessageFormat;

public class FilterEncoder {
    private static final String[] EMPTY = new String[0];

    public static String format(String filterTemplate, String ... values) throws IllegalArgumentException {
        MessageFormat mf;
        Format[] formats;
        if (values == null) {
            values = EMPTY;
        }
        if ((formats = (mf = new MessageFormat(filterTemplate)).getFormatsByArgumentIndex()).length != values.length) {
            String msg = "Filter template {0} has {1} placeholders but {2} arguments provided.";
            throw new IllegalArgumentException(MessageFormat.format(msg, filterTemplate, formats.length, values.length));
        }
        for (int i = 0; i < values.length; ++i) {
            values[i] = FilterEncoder.encodeFilterValue(values[i]);
        }
        String format = mf.format(values);
        return format;
    }

    public static String encodeFilterValue(String value) {
        StringBuilder sb = null;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            String replace = null;
            switch (ch) {
                case '*': {
                    replace = "\\2A";
                    break;
                }
                case '(': {
                    replace = "\\28";
                    break;
                }
                case ')': {
                    replace = "\\29";
                    break;
                }
                case '\\': {
                    replace = "\\5C";
                    break;
                }
                case '\u0000': {
                    replace = "\\00";
                }
            }
            if (replace != null) {
                if (sb == null) {
                    sb = new StringBuilder(value.length() * 2);
                    sb.append(value.substring(0, i));
                }
                sb.append(replace);
                continue;
            }
            if (sb == null) continue;
            sb.append(ch);
        }
        return sb == null ? value : sb.toString();
    }
}

