/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.controls.sort;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.asn1.util.Asn1StringUtils;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestContainer;
import org.apache.directory.api.ldap.model.message.controls.SortKey;
import org.apache.directory.api.ldap.model.message.controls.SortRequest;
import org.apache.directory.api.ldap.model.message.controls.SortRequestControlImpl;
import org.apache.directory.api.util.Strings;

public class SortRequestDecorator
extends ControlDecorator<SortRequest>
implements SortRequest {
    private Asn1Decoder decoder = new Asn1Decoder();
    private int sortReqLen = 0;
    private List<Integer> sortKeyLenList = new ArrayList<Integer>();
    public static int ORDERING_RULE_TAG = 128;
    public static int REVERSE_ORDER_TAG = 129;

    public SortRequestDecorator(LdapApiService codec) {
        super(codec, new SortRequestControlImpl());
    }

    public SortRequestDecorator(LdapApiService codec, SortRequest control) {
        super(codec, control);
    }

    @Override
    public int computeLength() {
        this.sortReqLen = 0;
        this.sortKeyLenList.clear();
        this.valueLength = 0;
        for (SortKey sk : this.getSortKeys()) {
            int skLen = 0;
            byte[] atBytes = Strings.getBytesUtf8(sk.getAttributeTypeDesc());
            skLen += 1 + TLV.getNbBytes(atBytes.length) + atBytes.length;
            if (sk.getMatchingRuleId() != null) {
                byte[] mrBytes = Strings.getBytesUtf8(sk.getMatchingRuleId());
                skLen += 1 + TLV.getNbBytes(mrBytes.length) + mrBytes.length;
            }
            if (sk.isReverseOrder()) {
                skLen += 3;
            }
            this.sortKeyLenList.add(skLen);
            this.sortReqLen += 1 + TLV.getNbBytes(skLen) + skLen;
        }
        this.valueLength = 1 + TLV.getNbBytes(this.sortReqLen) + this.sortReqLen;
        return this.valueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_04023, new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes(this.sortReqLen));
        List<SortKey> lst = this.getSortKeys();
        for (int i = 0; i < lst.size(); ++i) {
            SortKey sk = lst.get(i);
            int skLen = this.sortKeyLenList.get(i);
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes(skLen));
            BerValue.encode(buffer, sk.getAttributeTypeDesc());
            String mrId = sk.getMatchingRuleId();
            if (mrId != null) {
                buffer.put((byte)ORDERING_RULE_TAG);
                byte[] value = Asn1StringUtils.getBytesUtf8(mrId);
                buffer.put(TLV.getBytes(value.length));
                buffer.put(value);
            }
            if (!sk.isReverseOrder()) continue;
            buffer.put((byte)REVERSE_ORDER_TAG);
            buffer.put((byte)1);
            buffer.put((byte)-1);
        }
        return buffer;
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer buffer = ByteBuffer.wrap(controlBytes);
        SortRequestContainer container = new SortRequestContainer(this.getCodecService(), this);
        this.decoder.decode(buffer, container);
        return this;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                this.value = this.encode(buffer).array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    @Override
    public void setSortKeys(List<SortKey> sortKeys) {
        ((SortRequest)this.getDecorated()).setSortKeys(sortKeys);
    }

    @Override
    public List<SortKey> getSortKeys() {
        return ((SortRequest)this.getDecorated()).getSortKeys();
    }

    @Override
    public void addSortKey(SortKey sortKey) {
        ((SortRequest)this.getDecorated()).addSortKey(sortKey);
    }
}

