/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.api;

import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapApiServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LdapApiServiceFactory.class);
    private static LdapApiService ldapCodecService;
    private static boolean usingStandaloneImplementation;

    public static boolean isInitialized() {
        return ldapCodecService != null;
    }

    public static boolean isUsingStandaloneImplementation() {
        if (!LdapApiServiceFactory.isInitialized()) {
            String msg = "Not initialized yet!";
            LOG.error(msg);
            throw new IllegalStateException(msg);
        }
        return usingStandaloneImplementation;
    }

    public static LdapApiService getSingleton() {
        if (ldapCodecService == null) {
            LdapApiServiceFactory.initialize(null);
        }
        return ldapCodecService;
    }

    public static void initialize(LdapApiService ldapCodecService) {
        if (LdapApiServiceFactory.ldapCodecService != null) {
            StringBuilder sb = new StringBuilder("The LdapCodecService is already set to an instance of ");
            sb.append(LdapApiServiceFactory.class.getName());
            LOG.error(sb.toString());
            throw new IllegalStateException(sb.toString());
        }
        if (ldapCodecService == null) {
            try {
                Class<?> serviceClass = Class.forName("org.apache.directory.api.ldap.codec.standalone.StandaloneLdapApiService");
                LdapApiServiceFactory.ldapCodecService = (LdapApiService)serviceClass.newInstance();
                usingStandaloneImplementation = true;
            }
            catch (Exception e) {
                LOG.error("Failed to instantiate a viable instance, instantiating new instance of ", e);
            }
        } else {
            usingStandaloneImplementation = false;
            LdapApiServiceFactory.ldapCodecService = ldapCodecService;
        }
    }
}

