## Script for ClickHouse tests history

Allows to view test-suite history for master branch.

## Usage

```bash
$ sudo pip install -r requirements.txt
$ test-history --token XXX --since '2020-01-22 00:00:00' --substr Performance'
+---------------------|---------|--------------------+
| Date                | SHA     | Performance test   |
+=====================+=========+====================+
| 2020-01-22 12:54:59 | 47ffa40 | success             |
+---------------------|---------|--------------------+
| 2020-01-22 13:06:16 | 0d484be | failure            |
+---------------------|---------|--------------------+
| 2020-01-22 14:18:34 | 289f169 | success             |
+---------------------|---------|--------------------+
| 2020-01-22 14:27:27 | e357c6f | not run            |
+---------------------|---------|--------------------+
| 2020-01-22 15:29:30 | 6cd6b4d | not run            |
+---------------------|---------|--------------------+
| 2020-01-22 16:52:26 | 6fc7a82 | not run            |
+---------------------|---------|--------------------+
| 2020-01-22 16:55:52 | c683c77 | failure            |
+---------------------|---------|--------------------+
| 2020-01-22 16:58:36 | d68f8d1 | pending            |
+---------------------|---------|--------------------+
| 2020-01-22 17:59:43 | ba7ab32 | success             |
+---------------------|---------|--------------------+
| 2020-01-22 18:32:38 | eadb902 | failure            |
+---------------------|---------|--------------------+
| 2020-01-22 19:11:34 | 8f241ea | success             |
+---------------------|---------|--------------------+
| 2020-01-22 19:56:49 | f0b7422 | failure            |
+---------------------|---------|--------------------+
| 2020-01-22 21:26:16 | 55be790 | not run            |
+---------------------|---------|--------------------+
| 2020-01-22 22:23:59 | c00636b | not run            |
+---------------------|---------|--------------------+
| 2020-01-22 23:09:23 | 8cfe9a4 | failure            |
+---------------------|---------|--------------------+
| 2020-01-23 00:10:33 | a02b59f | success             |
+---------------------|---------|--------------------+
| 2020-01-23 05:56:11 | 48b3f33 | failure            |
+---------------------|---------|--------------------+
| 2020-01-23 05:56:54 | d807088 | success             |
+---------------------|---------|--------------------+
| 2020-01-23 06:01:48 | 2e84949 | failure            |
+---------------------|---------|--------------------+
| 2020-01-23 11:18:19 | b80e3dc | pending            |
+---------------------|---------|--------------------+
| 2020-01-23 11:53:30 | 0e906b2 | pending            |
+---------------------|---------|--------------------+
```

### Options

Script allows to specify start date for commits range in `'%Y-%m-%d %H:%M:%S'` format with `--since` option, default is three days. Also there is `--substr` option which allows to filter test suites by substring occurrence. Github token is required for script and can be found at https://github.com/settings/tokens.
