DROP TABLE IF EXISTS ties;

CREATE TABLE ties (id UInt8) ENGINE = MergeTree ORDER BY tuple();

INSERT INTO ties VALUES (1), (1), (1), (1), (2), (2), (2), (2), (3), (3);

SELECT id FROM ties ORDER BY id LIMIT 0.1 WITH TIES;
SELECT '*';
SELECT id FROM ties ORDER BY id LIMIT 0.2 WITH TIES;
SELECT '*';
SELECT id FROM ties ORDER BY id LIMIT 0.3 WITH TIES;
SELECT '';

SELECT id FROM ties ORDER BY id LIMIT 0.5 WITH TIES;
SELECT '*';
SELECT id FROM ties ORDER BY id LIMIT 0.6 WITH TIES;
SELECT '*';
SELECT id FROM ties ORDER BY id LIMIT 0.7 WITH TIES;
SELECT '';

SELECT id FROM ties ORDER BY id LIMIT 0.9 WITH TIES;
SELECT '*';
SELECT id FROM ties ORDER BY id;
SELECT '';

SET max_block_size = 2;

SELECT id FROM ties ORDER BY id LIMIT 0.1 WITH TIES;
SELECT '*';
SELECT id FROM ties ORDER BY id LIMIT 1, 0.1 WITH TIES;
SELECT '*';
SELECT id FROM ties ORDER BY id LIMIT 2, 0.1 WITH TIES;
SELECT '*';
SELECT id FROM ties ORDER BY id LIMIT 3, 0.1 WITH TIES;
SELECT '*';

SELECT id FROM ties ORDER BY id LIMIT 0.4, 0.1 WITH TIES;
SELECT '*';

SELECT id FROM ties ORDER BY id LIMIT 0.8, 0.1 WITH TIES;
SELECT '';

SET max_block_size = 3;

SELECT id FROM ties ORDER BY id LIMIT 0.1 WITH TIES;
SELECT '*';
SELECT id FROM ties ORDER BY id LIMIT 0.4, 0.1 WITH TIES;
SELECT '*';
SELECT id FROM ties ORDER BY id LIMIT 0.8, 0.1 WITH TIES;
SELECT '';

SELECT count() FROM (SELECT number > 100 AS n FROM numbers(2000) ORDER BY n LIMIT 1, 0.01 WITH TIES);
SELECT '*';
SET max_block_size = 5;
SELECT count() FROM (SELECT number < 100 AS n FROM numbers(2000) ORDER BY n DESC LIMIT 0.03 WITH TIES);
SELECT '*';
SELECT count() FROM (SELECT number div 10 AS n FROM numbers(20) ORDER BY n LIMIT 0.25 WITH TIES);
SELECT '';

DROP TABLE ties;