CREATE TEMPORARY TABLE t_src (id UInt32, val String) ENGINE = Memory;
INSERT INTO t_src VALUES (1,'a'), (2,'b'), (3,'c');

CREATE TEMPORARY VIEW tview_basic AS
SELECT id, upper(val) AS u
FROM t_src
WHERE id <= 2;

SELECT * FROM tview_basic ORDER BY id;

EXISTS TEMPORARY VIEW tview_basic;
SHOW TEMPORARY VIEW tview_basic;

CREATE TEMPORARY VIEW IF NOT EXISTS tview_basic AS SELECT 0;

CREATE OR REPLACE TEMPORARY VIEW tview_basic AS SELECT 0; -- { clientError SYNTAX_ERROR }

CREATE TEMPORARY VIEW default.tview_db AS SELECT 1; -- { serverError BAD_DATABASE_FOR_TEMPORARY_TABLE }

CREATE TEMPORARY VIEW tview_cluster ON CLUSTER 'test' AS SELECT 1; -- { serverError INCORRECT_QUERY }

CREATE TEMPORARY TABLE tsrc_cluster ON CLUSTER 'test' AS SELECT 1; -- { serverError INCORRECT_QUERY }

CREATE TEMPORARY VIEW tv_populate POPULATE AS SELECT 1; -- { clientError SYNTAX_ERROR }

CREATE TEMPORARY VIEW tv_refresh REFRESH AS SELECT 1; -- { clientError SYNTAX_ERROR }

CREATE TEMPORARY VIEW tv_to TO test_1602.tbl AS SELECT 1; -- { clientError SYNTAX_ERROR }

CREATE TEMPORARY VIEW tv_engine ENGINE = Memory AS SELECT 1; -- { clientError SYNTAX_ERROR }

CREATE TEMPORARY VIEW tv_empty EMPTY AS SELECT 1; -- { clientError SYNTAX_ERROR }

CREATE TEMPORARY VIEW tv_inner INNER ENGINE = Memory AS SELECT 1; -- { clientError SYNTAX_ERROR }

DROP TEMPORARY VIEW IF EXISTS tview_basic;
DROP TEMPORARY TABLE IF EXISTS t_src;