SET allow_suspicious_variant_types = 1;

DROP TABLE IF EXISTS geom1;
CREATE TABLE IF NOT EXISTS geom1 (geom Geometry) ENGINE = Memory();
INSERT INTO geom1 VALUES((10, 20));
INSERT INTO geom1 VALUES((30, 40));
INSERT INTO geom1 VALUES([(0, 0), (10, 0), (10, 10), (0, 10)]);
INSERT INTO geom1 VALUES([[(20, 20), (50, 20), (50, 50), (20, 50)], [(30, 30), (50, 50), (50, 30)]]);
SELECT count(*) FROM geom1;

DROP TABLE IF EXISTS geo;
CREATE TABLE IF NOT EXISTS geo (geom String, id Int) ENGINE = Memory();
INSERT INTO geo VALUES ('POLYGON((1 0,10 0,10 10,0 10,1 0),(4 4,5 4,5 5,4 5,4 4))', 1);
INSERT INTO geo VALUES ('POINT(0 0)', 2);
INSERT INTO geo VALUES ('MULTIPOLYGON(((1 0,10 0,10 10,0 10,1 0),(4 4,5 4,5 5,4 5,4 4)),((-10 -10,-10 -9,-9 10,-10 -10)))', 3);
INSERT INTO geo VALUES ('LINESTRING(1 0,10 0,10 10,0 10,1 0)', 4);
INSERT INTO geo VALUES ('MULTILINESTRING((1 0,10 0,10 10,0 10,1 0),(4 4,5 4,5 5,4 5,4 4))', 5);
SELECT readWkt(geom) FROM geo ORDER BY id;

DROP TABLE IF EXISTS geo;
CREATE TABLE geo (s String, id Int) engine=Memory();
INSERT INTO geo VALUES (unhex('010100000000000000000000000000000000000000'), 1);
INSERT INTO geo VALUES (unhex('0101000000000000000000f03f0000000000000000'), 2);
INSERT INTO geo VALUES (unhex('010100000000000000000000400000000000000000'), 3);
INSERT INTO geo VALUES (unhex('01030000000100000005000000000000000000f03f0000000000000000000000000000244000000000000000000000000000002440000000000000244000000000000000000000000000002440000000000000f03f0000000000000000'), 4);
INSERT INTO geo VALUES (unhex('010300000001000000050000000000000000000000000000000000000000000000000024400000000000000000000000000000244000000000000024400000000000000000000000000000244000000000000000000000000000000000'), 5);
INSERT INTO geo VALUES (unhex('010300000001000000050000000000000000000040000000000000000000000000000024400000000000000000000000000000244000000000000024400000000000000000000000000000244000000000000000400000000000000000'), 6);
INSERT INTO geo VALUES (unhex('010300000002000000050000000000000000000000000000000000000000000000000024400000000000000000000000000000244000000000000024400000000000000000000000000000244000000000000000000000000000000000050000000000000000001040000000000000104000000000000014400000000000001040000000000000144000000000000014400000000000001040000000000000144000000000000010400000000000001040'), 7);
INSERT INTO geo VALUES (unhex('010300000002000000050000000000000000000040000000000000000000000000000024400000000000000000000000000000244000000000000024400000000000000000000000000000244000000000000000400000000000000000050000000000000000001040000000000000104000000000000014400000000000001040000000000000144000000000000014400000000000001040000000000000144000000000000010400000000000001040'), 8);
INSERT INTO geo VALUES (unhex('01030000000200000005000000000000000000f03f0000000000000000000000000000244000000000000000000000000000002440000000000000244000000000000000000000000000002440000000000000f03f0000000000000000050000000000000000001040000000000000104000000000000014400000000000001040000000000000144000000000000014400000000000001040000000000000144000000000000010400000000000001040'), 9);
INSERT INTO geo VALUES (unhex('01060000000200000001030000000200000005000000000000000000f03f0000000000000000000000000000244000000000000000000000000000002440000000000000244000000000000000000000000000002440000000000000f03f00000000000000000500000000000000000010400000000000001040000000000000144000000000000010400000000000001440000000000000144000000000000010400000000000001440000000000000104000000000000010400103000000010000000400000000000000000024c000000000000024c000000000000024c000000000000022c000000000000022c0000000000000244000000000000024c000000000000024c0'), 10);
INSERT INTO geo VALUES (unhex('0106000000020000000103000000020000000500000000000000000000000000000000000000000000000000244000000000000000000000000000002440000000000000244000000000000000000000000000002440000000000000000000000000000000000500000000000000000010400000000000001040000000000000144000000000000010400000000000001440000000000000144000000000000010400000000000001440000000000000104000000000000010400103000000010000000400000000000000000024c000000000000024c000000000000024c000000000000022c000000000000022c0000000000000244000000000000024c000000000000024c0'), 11);
INSERT INTO geo VALUES (unhex('0106000000020000000103000000020000000500000000000000000000400000000000000000000000000000244000000000000000000000000000002440000000000000244000000000000000000000000000002440000000000000004000000000000000000500000000000000000010400000000000001040000000000000144000000000000010400000000000001440000000000000144000000000000010400000000000001440000000000000104000000000000010400103000000010000000400000000000000000024c000000000000024c000000000000024c000000000000022c000000000000022c0000000000000244000000000000024c000000000000024c0'), 12);
SELECT readWkb(s) FROM geo ORDER BY id;
