#!/usr/bin/env bash

CUR_DIR=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)
# shellcheck source=../shell_config.sh
. "$CUR_DIR"/../shell_config.sh


$CLICKHOUSE_CLIENT "
DROP TABLE IF EXISTS test;
CREATE TABLE test
(
    x UInt8 EPHEMERAL,
    s String MATERIALIZED format('Hello {} world', x)
) ORDER BY ();
"

$CLICKHOUSE_LOCAL "SELECT 12 AS x FORMAT TSV" | $CLICKHOUSE_CLIENT "INSERT INTO test (x) FORMAT TSV"
$CLICKHOUSE_LOCAL "SELECT 34 AS x FORMAT TSV" | $CLICKHOUSE_CLIENT "INSERT INTO test (*, x) FORMAT TSV"
$CLICKHOUSE_LOCAL "SELECT 56 AS x FORMAT Native" | $CLICKHOUSE_CLIENT "INSERT INTO test (x) FORMAT Native"
$CLICKHOUSE_LOCAL "SELECT 78 AS x FORMAT Native" | $CLICKHOUSE_CLIENT "INSERT INTO test (*, x) FORMAT Native"

$CLICKHOUSE_CLIENT "
SELECT s FROM test ORDER BY ALL;
DROP TABLE test;
"


$CLICKHOUSE_CLIENT "
DROP TABLE IF EXISTS test;
CREATE TABLE test
(
    x UInt8 EPHEMERAL,
    s String DEFAULT format('Hello {} world', x)
) ORDER BY ();
"

$CLICKHOUSE_LOCAL "SELECT 11 AS x FORMAT TSV" | $CLICKHOUSE_CLIENT "INSERT INTO test (x) FORMAT TSV"
$CLICKHOUSE_LOCAL "SELECT 22 AS x FORMAT Native" | $CLICKHOUSE_CLIENT "INSERT INTO test (x) FORMAT Native"

$CLICKHOUSE_CLIENT "
SELECT s FROM test ORDER BY ALL;
DROP TABLE test;
"


$CLICKHOUSE_CLIENT "
DROP TABLE IF EXISTS test;
CREATE TABLE test
(
    x UInt8,
    s String MATERIALIZED format('Hello {} world', x)
) ORDER BY ();
"

$CLICKHOUSE_LOCAL "SELECT 10 AS x FORMAT TSV" | $CLICKHOUSE_CLIENT "INSERT INTO test (x) FORMAT TSV"
$CLICKHOUSE_LOCAL "SELECT 30 AS x FORMAT Native" | $CLICKHOUSE_CLIENT "INSERT INTO test (x) FORMAT Native"

$CLICKHOUSE_CLIENT "
SELECT s FROM test ORDER BY ALL;
DROP TABLE test;
"


$CLICKHOUSE_CLIENT "
DROP TABLE IF EXISTS test;
CREATE TABLE test
(
    x UInt8,
    s String DEFAULT format('Hello {} world', x)
) ORDER BY ();
"

$CLICKHOUSE_LOCAL "SELECT 88 AS x FORMAT TSV" | $CLICKHOUSE_CLIENT "INSERT INTO test (x) FORMAT TSV"
$CLICKHOUSE_LOCAL "SELECT 99 AS x FORMAT Native" | $CLICKHOUSE_CLIENT "INSERT INTO test (x) FORMAT Native"

$CLICKHOUSE_CLIENT "
SELECT s FROM test ORDER BY ALL;
DROP TABLE test;
"


$CLICKHOUSE_CLIENT "
DROP TABLE IF EXISTS test;
CREATE TABLE test
(
    x UInt8 EPHEMERAL,
    s String MATERIALIZED format('Hello {} world', x)
) ORDER BY ();
"

$CLICKHOUSE_LOCAL "SELECT 12 AS x FORMAT TSV" | $CLICKHOUSE_CURL "${CLICKHOUSE_URL}&query=INSERT+INTO+test+(x)+FORMAT+TSV" --data-binary @-
$CLICKHOUSE_LOCAL "SELECT 34 AS x FORMAT TSV" | $CLICKHOUSE_CURL "${CLICKHOUSE_URL}&query=INSERT+INTO+test+(*,x)+FORMAT+TSV" --data-binary @-
$CLICKHOUSE_LOCAL "SELECT 56 AS x FORMAT Native" | $CLICKHOUSE_CURL "${CLICKHOUSE_URL}&query=INSERT+INTO+test+(x)+FORMAT+Native" --data-binary @-
$CLICKHOUSE_LOCAL "SELECT 78 AS x FORMAT Native" | $CLICKHOUSE_CURL "${CLICKHOUSE_URL}&query=INSERT+INTO+test+(*,x)+FORMAT+Native" --data-binary @-

$CLICKHOUSE_CLIENT "
SELECT s FROM test ORDER BY ALL;
DROP TABLE test;
"


$CLICKHOUSE_CLIENT "
DROP TABLE IF EXISTS test;
CREATE TABLE test
(
    x UInt8 EPHEMERAL,
    s String DEFAULT format('Hello {} world', x)
) ORDER BY ();
"

$CLICKHOUSE_LOCAL "SELECT 11 AS x FORMAT TSV" | $CLICKHOUSE_CURL "${CLICKHOUSE_URL}&query=INSERT+INTO+test+(x)+FORMAT+TSV" --data-binary @-
$CLICKHOUSE_LOCAL "SELECT 22 AS x FORMAT Native" | $CLICKHOUSE_CURL "${CLICKHOUSE_URL}&query=INSERT+INTO+test+(x)+FORMAT+Native" --data-binary @-

$CLICKHOUSE_CLIENT "
SELECT s FROM test ORDER BY ALL;
DROP TABLE test;
"


$CLICKHOUSE_CLIENT "
DROP TABLE IF EXISTS test;
CREATE TABLE test
(
    x UInt8,
    s String MATERIALIZED format('Hello {} world', x)
) ORDER BY ();
"

$CLICKHOUSE_LOCAL "SELECT 10 AS x FORMAT TSV" | $CLICKHOUSE_CURL "${CLICKHOUSE_URL}&query=INSERT+INTO+test+(x)+FORMAT+TSV" --data-binary @-
$CLICKHOUSE_LOCAL "SELECT 30 AS x FORMAT Native" | $CLICKHOUSE_CURL "${CLICKHOUSE_URL}&query=INSERT+INTO+test+(x)+FORMAT+Native" --data-binary @-

$CLICKHOUSE_CLIENT "
SELECT s FROM test ORDER BY ALL;
DROP TABLE test;
"


$CLICKHOUSE_CLIENT "
DROP TABLE IF EXISTS test;
CREATE TABLE test
(
    x UInt8,
    s String DEFAULT format('Hello {} world', x)
) ORDER BY ();
"

$CLICKHOUSE_LOCAL "SELECT 88 AS x FORMAT TSV" | $CLICKHOUSE_CURL "${CLICKHOUSE_URL}&query=INSERT+INTO+test+(x)+FORMAT+TSV" --data-binary @-
$CLICKHOUSE_LOCAL "SELECT 99 AS x FORMAT Native" | $CLICKHOUSE_CURL "${CLICKHOUSE_URL}&query=INSERT+INTO+test+(x)+FORMAT+Native" --data-binary @-

$CLICKHOUSE_CLIENT "
SELECT s FROM test ORDER BY ALL;
DROP TABLE test;
"
