DROP TABLE IF EXISTS t1;
CREATE TABLE t1
(
    id UInt64,
    external_id UInt64
)
ENGINE = MergeTree
ORDER BY id;

DROP TABLE IF EXISTS t2;
CREATE TABLE t2
(
    id UInt64,
    name String
)
ENGINE = MergeTree
ORDER BY id;

INSERT INTO t1 VALUES (1, 1);

INSERT INTO t2 VALUES (1, 'test');

DROP DICTIONARY IF EXISTS d2;
CREATE DICTIONARY d2
(
    id UInt64,
    name String,
)
PRIMARY KEY id
SOURCE(CLICKHOUSE(
    table t2))
LIFETIME(MIN 600 MAX 900)
LAYOUT(HASHED());

SELECT
    *
FROM
    t1
    LEFT JOIN d2 ON d2.id = t1.external_id
    WHERE t1.id = 1
LIMIT 1;

DROP DICTIONARY d2;
DROP TABLE t2;
DROP TABLE t1;
