DROP TABLE IF EXISTS pipe;
DROP TABLE IF EXISTS src;
DROP TABLE IF EXISTS dest;

CREATE TABLE src(v UInt64) ENGINE = Null;
CREATE TABLE dest(v UInt64) Engine = MergeTree() ORDER BY v;
CREATE MATERIALIZED VIEW pipe TO dest AS SELECT v FROM src;

ALTER TABLE dest ADD COLUMN v2 UInt64;

ALTER TABLE pipe MODIFY QUERY SELECT v * 2 as v, 1 as v2 FROM src;

DESCRIBE TABLE pipe;
SHOW CREATE TABLE pipe;

DROP TABLE IF EXISTS pipe;
DROP TABLE IF EXISTS src;
DROP TABLE IF EXISTS dest;
