-- Tags: no-fasttest, no-async-insert
-- no-async-insert: https://github.com/ClickHouse/ClickHouse/issues/80105

DROP TABLE IF EXISTS h3_indexes;

--Note: id column just exists to keep the test results sorted.
-- Order is not guaranteed with h3_index or res columns as we test the same h3_index at various resolutions.
CREATE TABLE h3_indexes (id UInt8, h3_index UInt64, res UInt8) ENGINE = Memory;
-- Test cases taken from fixture: https://github.com/uber/h3/blob/master/src/apps/testapps/testCellToCenterChild.c

INSERT INTO h3_indexes VALUES
(1,577023702256844799,1),
(2,577023702256844799,2),
(3,577023702256844799,3),
(4,577023702256844799,4),
(5,577023702256844799,5),
(6,577023702256844799,6),
(7,577023702256844799,7),
(8,577023702256844799,8),
(9,577023702256844799,9),
(10,577023702256844799,10),
(11,577023702256844799,11),
(12,577023702256844799,12),
(13,577023702256844799,13),
(14,577023702256844799,14),
(15,577023702256844799,15),
(16,581518505791193087,2),
(17,581518505791193087,3),
(18,581518505791193087,4),
(19,581518505791193087,5),
(20,581518505791193087,6),
(21,581518505791193087,7),
(22,581518505791193087,8),
(23,581518505791193087,9),
(24,581518505791193087,10),
(25,581518505791193087,11),
(26,581518505791193087,12),
(27,581518505791193087,13),
(28,581518505791193087,14),
(29,581518505791193087,15),
(30,586021555662749695,3),
(31,586021555662749695,4),
(32,586021555662749695,5),
(33,586021555662749695,6),
(34,586021555662749695,7),
(35,586021555662749695,8),
(36,586021555662749695,9),
(37,586021555662749695,10),
(38,586021555662749695,11),
(39,586021555662749695,12),
(40,586021555662749695,13),
(41,586021555662749695,14),
(42,586021555662749695,15),
(43,590525017851166719,4),
(44,590525017851166719,5),
(45,590525017851166719,6),
(46,590525017851166719,7),
(47,590525017851166719,8),
(48,590525017851166719,9),
(49,590525017851166719,10),
(50,590525017851166719,11),
(51,590525017851166719,12),
(52,590525017851166719,13),
(53,590525017851166719,14),
(54,590525017851166719,15),
(55,595028608888602623,5),
(56,595028608888602623,6),
(57,595028608888602623,7),
(58,595028608888602623,8),
(59,595028608888602623,9),
(60,595028608888602623,10),
(61,595028608888602623,11),
(62,595028608888602623,12),
(63,595028608888602623,13),
(64,595028608888602623,14),
(65,595028608888602623,15),
(66,599532206368489471,6),
(67,599532206368489471,7),
(68,599532206368489471,8),
(69,599532206368489471,9),
(70,599532206368489471,10),
(71,599532206368489471,11),
(72,599532206368489471,12),
(73,599532206368489471,13),
(74,599532206368489471,14),
(75,599532206368489471,15),
(76,604035805861642239,7),
(77,604035805861642239,8),
(78,604035805861642239,9),
(79,604035805861642239,10),
(80,604035805861642239,11),
(81,604035805861642239,12),
(82,604035805861642239,13),
(83,604035805861642239,14),
(84,604035805861642239,15),
(85,608136739873095679,8),
(86,608136739873095679,9),
(87,608136739873095679,10),
(88,608136739873095679,11),
(89,608136739873095679,12),
(90,608136739873095679,13),
(91,608136739873095679,14),
(92,608136739873095679,15),
(93,612640339489980415,9),
(94,612640339489980415,10),
(95,612640339489980415,11),
(96,612640339489980415,12),
(97,612640339489980415,13),
(98,612640339489980415,14),
(99,612640339489980415,15),
(100,617143939115515903,10),
(101,617143939115515903,11),
(102,617143939115515903,12),
(103,617143939115515903,13),
(104,617143939115515903,14),
(105,617143939115515903,15),
(106,621647538742657023,11),
(107,621647538742657023,12),
(108,621647538742657023,13),
(109,621647538742657023,14),
(110,621647538742657023,15),
(111,626151138369998847,12),
(112,626151138369998847,13),
(113,626151138369998847,14),
(114,626151138369998847,15),
(115,630654737997365759,13),
(116,630654737997365759,14),
(117,630654737997365759,15),
(118,635158337624735807,14),
(119,635158337624735807,15),
(120,639661937252106247,15);

SELECT h3ToCenterChild(h3_index,res) FROM h3_indexes ORDER BY id;

DROP TABLE h3_indexes;
