#include <base/extended_types.h>
#include <Common/intExp.h>

#include <cstdint>


namespace common
{

constexpr int64_t exp10_i64_table[]
    = {1LL,
       10LL,
       100LL,
       1000LL,
       10000LL,
       100000LL,
       1000000LL,
       10000000LL,
       100000000LL,
       1000000000LL,
       10000000000LL,
       100000000000LL,
       1000000000000LL,
       10000000000000LL,
       100000000000000LL,
       1000000000000000LL,
       10000000000000000LL,
       100000000000000000LL,
       1000000000000000000LL};

constexpr Int128 exp10_i128_table[]
    = {static_cast<Int128>(1LL),
       static_cast<Int128>(10LL),
       static_cast<Int128>(100LL),
       static_cast<Int128>(1000LL),
       static_cast<Int128>(10000LL),
       static_cast<Int128>(100000LL),
       static_cast<Int128>(1000000LL),
       static_cast<Int128>(10000000LL),
       static_cast<Int128>(100000000LL),
       static_cast<Int128>(1000000000LL),
       static_cast<Int128>(10000000000LL),
       static_cast<Int128>(100000000000LL),
       static_cast<Int128>(1000000000000LL),
       static_cast<Int128>(10000000000000LL),
       static_cast<Int128>(100000000000000LL),
       static_cast<Int128>(1000000000000000LL),
       static_cast<Int128>(10000000000000000LL),
       static_cast<Int128>(100000000000000000LL),
       static_cast<Int128>(1000000000000000000LL),
       static_cast<Int128>(1000000000000000000LL) * 10LL,
       static_cast<Int128>(1000000000000000000LL) * 100LL,
       static_cast<Int128>(1000000000000000000LL) * 1000LL,
       static_cast<Int128>(1000000000000000000LL) * 10000LL,
       static_cast<Int128>(1000000000000000000LL) * 100000LL,
       static_cast<Int128>(1000000000000000000LL) * 1000000LL,
       static_cast<Int128>(1000000000000000000LL) * 10000000LL,
       static_cast<Int128>(1000000000000000000LL) * 100000000LL,
       static_cast<Int128>(1000000000000000000LL) * 1000000000LL,
       static_cast<Int128>(1000000000000000000LL) * 10000000000LL,
       static_cast<Int128>(1000000000000000000LL) * 100000000000LL,
       static_cast<Int128>(1000000000000000000LL) * 1000000000000LL,
       static_cast<Int128>(1000000000000000000LL) * 10000000000000LL,
       static_cast<Int128>(1000000000000000000LL) * 100000000000000LL,
       static_cast<Int128>(1000000000000000000LL) * 1000000000000000LL,
       static_cast<Int128>(1000000000000000000LL) * 10000000000000000LL,
       static_cast<Int128>(1000000000000000000LL) * 100000000000000000LL,
       static_cast<Int128>(1000000000000000000LL) * 100000000000000000LL * 10LL,
       static_cast<Int128>(1000000000000000000LL) * 100000000000000000LL * 100LL,
       static_cast<Int128>(1000000000000000000LL) * 100000000000000000LL * 1000LL};

constexpr Int256 i10e18{1000000000000000000ll};
const Int256 exp10_i256_table[] = {
    static_cast<Int256>(1ll),
    static_cast<Int256>(10ll),
    static_cast<Int256>(100ll),
    static_cast<Int256>(1000ll),
    static_cast<Int256>(10000ll),
    static_cast<Int256>(100000ll),
    static_cast<Int256>(1000000ll),
    static_cast<Int256>(10000000ll),
    static_cast<Int256>(100000000ll),
    static_cast<Int256>(1000000000ll),
    static_cast<Int256>(10000000000ll),
    static_cast<Int256>(100000000000ll),
    static_cast<Int256>(1000000000000ll),
    static_cast<Int256>(10000000000000ll),
    static_cast<Int256>(100000000000000ll),
    static_cast<Int256>(1000000000000000ll),
    static_cast<Int256>(10000000000000000ll),
    static_cast<Int256>(100000000000000000ll),
    i10e18,
    i10e18 * 10ll,
    i10e18 * 100ll,
    i10e18 * 1000ll,
    i10e18 * 10000ll,
    i10e18 * 100000ll,
    i10e18 * 1000000ll,
    i10e18 * 10000000ll,
    i10e18 * 100000000ll,
    i10e18 * 1000000000ll,
    i10e18 * 10000000000ll,
    i10e18 * 100000000000ll,
    i10e18 * 1000000000000ll,
    i10e18 * 10000000000000ll,
    i10e18 * 100000000000000ll,
    i10e18 * 1000000000000000ll,
    i10e18 * 10000000000000000ll,
    i10e18 * 100000000000000000ll,
    i10e18 * 100000000000000000ll * 10ll,
    i10e18 * 100000000000000000ll * 100ll,
    i10e18 * 100000000000000000ll * 1000ll,
    i10e18 * 100000000000000000ll * 10000ll,
    i10e18 * 100000000000000000ll * 100000ll,
    i10e18 * 100000000000000000ll * 1000000ll,
    i10e18 * 100000000000000000ll * 10000000ll,
    i10e18 * 100000000000000000ll * 100000000ll,
    i10e18 * 100000000000000000ll * 1000000000ll,
    i10e18 * 100000000000000000ll * 10000000000ll,
    i10e18 * 100000000000000000ll * 100000000000ll,
    i10e18 * 100000000000000000ll * 1000000000000ll,
    i10e18 * 100000000000000000ll * 10000000000000ll,
    i10e18 * 100000000000000000ll * 100000000000000ll,
    i10e18 * 100000000000000000ll * 1000000000000000ll,
    i10e18 * 100000000000000000ll * 10000000000000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 10ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 100ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 1000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 10000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 100000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 1000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 10000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 100000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 1000000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 10000000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 100000000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 1000000000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 10000000000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 100000000000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 1000000000000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 10000000000000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 100000000000000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 100000000000000000ll * 10ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 100000000000000000ll * 100ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 100000000000000000ll * 1000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 100000000000000000ll * 10000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 100000000000000000ll * 100000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 100000000000000000ll * 1000000ll,
    i10e18 * 100000000000000000ll * 100000000000000000ll * 100000000000000000ll * 10000000ll,
};


}
