---
description: 'Landing page for Regular Functions'
slug: /sql-reference/functions/regular-functions
title: 'Regular functions'
doc_type: 'landing-page'
---

| Page                                             | Description                                                                                                                     |
|--------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------|
| [Overview](/sql-reference/functions/overview)    | Overview of all functions.                                                                                                      |
| [Machine Learning](/sql-reference/functions/machine-learning-functions) | Functions for machine learning.                                                                                                 |
| [Introspection](/sql-reference/functions/introspection) | Functions for introspection of ClickHouse.                                                                                      |
| [arrayJoin](/sql-reference/functions/array-join) | The arrayJoin function which takes each row and generates a set of rows (unfold)                                                |
| [Searching in Strings](/sql-reference/functions/string-search-functions) | Functions for searching within strings.                                                                                         |
| [Hash](/sql-reference/functions/hash-functions)  | Hashing functions.                                                                                                              |
| [UUIDs](/sql-reference/functions/uuid-functions) | Functions for Working with UUIDs.                                                                                               |
| [Time-Series](/sql-reference/functions/time-series-functions) | Functions for working with time series                                                                             |
| [Random Numbers](/sql-reference/functions/random-functions) | Functions for random number generation.                                                                                         |
| [NLP](/sql-reference/functions/nlp-functions)    | Functions for Natural Language Processing.                                                                                      |
| [Conditional](/sql-reference/functions/conditional-functions) | Conditional functions.                                                                                                          |
| [Nullable](/sql-reference/functions/functions-for-nulls) | Functions for working with NULL.                                                                                                |
| [Bit](/sql-reference/functions/bit-functions)    | Bitwise functions.                                                                                                              |
| [Time Window](/sql-reference/functions/time-window-functions) | Functions which return the inclusive lower and exclusive upper bound of the corresponding window.                               |
| [IP Address](/sql-reference/functions/ip-address-functions) | Functions for Working with IPv4 and IPv6 Addresses.                                                                             |
| [Splitting Strings](/sql-reference/functions/splitting-merging-functions) | Functions for splitting strings.                                                                                                |
| [Tuples](/sql-reference/functions/tuple-functions) | Functions for working with tuples.                                                                                              |
| [String replacement](/sql-reference/functions/string-replace-functions) | Functions for string replacement.                                                                                               |
| [User Defined Functions](/sql-reference/functions/udf) | User Defined Functions.                                                                                                         |
| [Comparison](/sql-reference/functions/comparison-functions) | Comparison functions (equals, less, greater etc.)                                                                               |
| [Other](/sql-reference/functions/other-functions) | Functions which don't fit into any other category.                                                                              |
| [JSON](/sql-reference/functions/json-functions)  | Functions for working with JSON.                                                                                                |
| [URL](/sql-reference/functions/url-functions)    | Functions for working with URLs.                                                                                                |
| [Encoding](/sql-reference/functions/encoding-functions) | Functions for encoding data.                                                                                                    |
| [ULID](/sql-reference/functions/ulid-functions)  | Functions for Working with ULID.                                                                                                |
| [Maps](/sql-reference/functions/tuple-map-functions) | Functions for working with Maps.                                                                                                |
| [Dictionaries](/sql-reference/functions/ext-dict-functions) | Functions for working with dictionaries.                                                                                        |
| [IN](/sql-reference/functions/in-functions)      | IN operators                                                                                                                    |
| [Files](/sql-reference/functions/files)          | The file function.                                                                                                              |
| [Arrays](/sql-reference/functions/array-functions) | Functions for working with arrays.                                                                                              |
| [String](/sql-reference/functions/string-functions) | Functions for working with Strings. (Functions for searching in strings and for replacing in strings are described separately.) |
| [DateTime](/sql-reference/functions/date-time-functions) | Functions for working with dates and times.                                                                                     |
| [Logical](/sql-reference/functions/logical-functions) | Functions which perform logical operations on arguments of arbitrary numeric types.                                             |
| [Rounding](/sql-reference/functions/rounding-functions) | Functions for rounding.                                                                                                         |
| [uniqTheta](/sql-reference/functions/uniqtheta-functions) | uniqTheta functions work on two uniqThetaSketch objects to do set operation calculations such as ∪ / ∩ / ×.                     |
| [Distance](/sql-reference/functions/distance-functions) | Functions for calculating vector norms, distances, normalization, and common operations in linear algebra and machine learning. |
| [Bitmap](/sql-reference/functions/bitmap-functions) | Functions for bitmaps.                                                                                                          |
| [Math](/sql-reference/functions/math-functions)  | Mathematical functions.                                                                                                         |
| [Financial](/sql-reference/functions/financial-functions) | Financial functions.                                                                                                            |
| [Encryption](/sql-reference/functions/encryption-functions) | Functions for encryption.                                                                                                       |
| [Arithmetic](/sql-reference/functions/arithmetic-functions) | Functions for performing arithmetic on `UInt`, `Int` or `Float` types.                                                          |
| [Embedded Dictionaries](/sql-reference/functions/ym-dict-functions) | Functions for Working with Embedded Dictionaries                                                                                |
| [Type Conversion](/sql-reference/functions/type-conversion-functions) | Functions for converting from one type to another type.                                                                         |
