---
description: 'Documentation for Json Functions'
sidebar_label: 'JSON'
slug: /sql-reference/functions/json-functions
title: 'JSON Functions'
doc_type: 'reference'
---

## Types of JSON functions {#types-of-functions}

There are two sets of functions to parse JSON:
- [`simpleJSON*` (`visitParam*`)](#simplejson-visitparam-functions) which is made for parsing a limited subset of JSON extremely fast.
- [`JSONExtract*`](#jsonextract-functions) which is made for parsing ordinary JSON.

### simpleJSON (visitParam) functions {#simplejson-visitparam-functions}

ClickHouse has special functions for working with simplified JSON. All these JSON functions are based on strong assumptions about what the JSON can be. They try to do as little as possible to get the job done as quickly as possible.

The following assumptions are made:

1.  The field name (function argument) must be a constant.
2.  The field name is somehow canonically encoded in JSON. For example: `simpleJSONHas('{"abc":"def"}', 'abc') = 1`, but `simpleJSONHas('{"\\u0061\\u0062\\u0063":"def"}', 'abc') = 0`
3.  Fields are searched for on any nesting level, indiscriminately. If there are multiple matching fields, the first occurrence is used.
4.  The JSON does not have space characters outside of string literals.

### JSONExtract functions {#jsonextract-functions}

These functions are based on [simdjson](https://github.com/lemire/simdjson), and designed for more complex JSON parsing requirements.

### Case-Insensitive JSONExtract Functions {#case-insensitive-jsonextract-functions}

These functions perform ASCII case-insensitive key matching when extracting values from JSON objects.
They work identically to their case-sensitive counterparts, except that object keys are matched without regard to case.
When multiple keys match with different cases, the first match is returned.

:::note
These functions may be less performant than their case-sensitive counterparts, so use the regular JSONExtract functions if possible.
:::

<!-- 
The inner content of the tags below are replaced at doc framework build time with 
docs generated from system.functions. Please do not modify or remove the tags.
See: https://github.com/ClickHouse/clickhouse-docs/blob/main/contribute/autogenerated-documentation-from-source.md
-->

<!--AUTOGENERATED_START-->
<!--AUTOGENERATED_END-->
