---
description: 'Documentation for Introspection Functions'
sidebar_label: 'Introspection'
slug: /sql-reference/functions/introspection
title: 'Introspection Functions'
doc_type: 'reference'
---

# Introspection functions

You can use functions described in this chapter to introspect [ELF](https://en.wikipedia.org/wiki/Executable_and_Linkable_Format) and [DWARF](https://en.wikipedia.org/wiki/DWARF) for query profiling.

:::note
These functions are slow and may impose security considerations.
:::

For proper operation of introspection functions:

- Install the `clickhouse-common-static-dbg` package.

- Set the [allow_introspection_functions](../../operations/settings/settings.md#allow_introspection_functions) setting to 1.

        For security reasons introspection functions are disabled by default.

ClickHouse saves profiler reports to the [trace_log](/operations/system-tables/trace_log) system table. Make sure the table and profiler are configured properly.

<!--
The inner content of the tags below are replaced at doc framework build time with
docs generated from system.functions. Please do not modify or remove the tags.
See: https://github.com/ClickHouse/clickhouse-docs/blob/main/contribute/autogenerated-documentation-from-source.md
-->

<!--AUTOGENERATED_START-->
<!--AUTOGENERATED_END-->
