---
description: 'System table containing descriptions of table engines supported by the
  server and the features they support.'
keywords: ['system table', 'table_engines']
slug: /operations/system-tables/table_engines
title: 'system.table_engines'
doc_type: 'reference'
---

# system.table_engines

Contains description of table engines supported by server and their feature support information.

This table contains the following columns (the column type is shown in brackets):

<!--AUTOGENERATED_START-->
<!--AUTOGENERATED_END-->

Example:

```sql
SELECT *
FROM system.table_engines
WHERE name IN ('Kafka', 'MergeTree', 'ReplicatedCollapsingMergeTree')
```

```text
┌─name──────────────────────────┬─supports_settings─┬─supports_skipping_indices─┬─supports_sort_order─┬─supports_ttl─┬─supports_replication─┬─supports_deduplication─┬─supports_parallel_insert─┐
│ MergeTree                     │                 1 │                         1 │                   1 │            1 │                    0 │                      0 │                        1 │
│ Kafka                         │                 1 │                         0 │                   0 │            0 │                    0 │                      0 │                        0 │
│ ReplicatedCollapsingMergeTree │                 1 │                         1 │                   1 │            1 │                    1 │                      1 │                        1 │
└───────────────────────────────┴───────────────────┴───────────────────────────┴─────────────────────┴──────────────┴──────────────────────┴────────────────────────┴──────────────────────────┘
```

**See also**

- MergeTree family [query clauses](../../engines/table-engines/mergetree-family/mergetree.md#mergetree-query-clauses)
- Kafka [settings](/engines/table-engines/integrations/kafka#creating-a-table)
- Join [settings](../../engines/table-engines/special/join.md#join-limitations-and-settings)
