---
description: 'System table containing information about in-progress data part moves
  of MergeTree tables. Each data part movement is represented by a single row.'
keywords: ['system table', 'moves']
slug: /operations/system-tables/moves
title: 'system.moves'
doc_type: 'reference'
---

# system.moves

The table contains information about in-progress [data part moves](/sql-reference/statements/alter/partition#move-partitionpart) of [MergeTree](/engines/table-engines/mergetree-family/mergetree.md) tables. Each data part movement is represented by a single row.

Columns:

<!--AUTOGENERATED_START-->
<!--AUTOGENERATED_END-->

**Example**

```sql
SELECT * FROM system.moves
```

```response
┌─database─┬─table─┬─────elapsed─┬─target_disk_name─┬─target_disk_path─┬─part_name─┬─part_size─┬─thread_id─┐
│ default  │ test2 │ 1.668056039 │ s3               │ ./disks/s3/      │ all_3_3_0 │       136 │    296146 │
└──────────┴───────┴─────────────┴──────────────────┴──────────────────┴───────────┴───────────┴───────────┘
```

**See Also**

- [MergeTree](/engines/table-engines/mergetree-family/mergetree.md) table engine
- [Using Multiple Block Devices for Data Storage](/engines/table-engines/mergetree-family/mergetree#table_engine-mergetree-multiple-volumes)
- [ALTER TABLE ... MOVE PART](/sql-reference/statements/alter/partition#move-partitionpart) command
