---
description: 'System table containing licenses of third-party libraries that are located
  in the contrib directory of ClickHouse sources.'
keywords: ['system table', 'licenses']
slug: /operations/system-tables/licenses
title: 'system.licenses'
doc_type: 'reference'
---

# system.licenses

Contains licenses of third-party libraries that are located in the [contrib](https://github.com/ClickHouse/ClickHouse/tree/master/contrib) directory of ClickHouse sources.

Columns:

<!--AUTOGENERATED_START-->
<!--AUTOGENERATED_END-->

**Example**

```sql
SELECT library_name, license_type, license_path FROM system.licenses LIMIT 15
```

```text
┌─library_name───────┬─license_type─┬─license_path────────────────────────┐
│ aws-c-common       │ Apache       │ /contrib/aws-c-common/LICENSE       │
│ base64             │ BSD 2-clause │ /contrib/aklomp-base64/LICENSE      │
│ brotli             │ MIT          │ /contrib/brotli/LICENSE             │
│ [...]              │ [...]        │ [...]                               │
└────────────────────┴──────────────┴─────────────────────────────────────┘

```
