---
description: 'System table containing information about tables that drop table has
  been executed on but for which data cleanup has not yet been performed'
keywords: ['system table', 'dropped_tables']
slug: /operations/system-tables/dropped_tables
title: 'system.dropped_tables'
doc_type: 'reference'
---

Contains information about tables that drop table has been executed on but for which data cleanup has not yet been performed.

Columns:
<!--AUTOGENERATED_START-->
<!--AUTOGENERATED_END-->

**Example**

The following example shows how to get information about `dropped_tables`.

```sql
SELECT *
FROM system.dropped_tables\G
```

```text
Row 1:
──────
index:                 0
database:              default
table:                 test
uuid:                  03141bb2-e97a-4d7c-a172-95cc066bb3bd
engine:                MergeTree
metadata_dropped_path: /data/ClickHouse/build/programs/data/metadata_dropped/default.test.03141bb2-e97a-4d7c-a172-95cc066bb3bd.sql
table_dropped_time:    2023-03-16 23:43:31
```
