---
description: 'System table containing information about contributors.'
keywords: ['system table', 'contributors']
slug: /operations/system-tables/contributors
title: 'system.contributors'
doc_type: 'reference'
---

Contains information about contributors. The order is random at query execution time.

Columns:

<!--AUTOGENERATED_START-->
<!--AUTOGENERATED_END-->

**Example**

```sql
SELECT * FROM system.contributors LIMIT 10
```

```text
┌─name─────────────┐
│ Olga Khvostikova │
│ Max Vetrov       │
│ LiuYangkuan      │
│ svladykin        │
│ zamulla          │
│ Šimon Podlipský  │
│ BayoNet          │
│ Ilya Khomutov    │
│ Amy Krishnevsky  │
│ Loud_Scream      │
└──────────────────┘
```

To find out yourself in the table, use a query:

```sql
SELECT * FROM system.contributors WHERE name = 'Olga Khvostikova'
```

```text
┌─name─────────────┐
│ Olga Khvostikova │
└──────────────────┘
```
