<!-- Note: This snippet is reused in any file it is imported by -->

The following settings are common to all `RowBinary` type formats.

| Setting                                                                                                                                              | Description                                                                                                                                                                                                                                         | Default |
|------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------|
| [`format_binary_max_string_size`](/operations/settings/settings-formats.md/#format_binary_max_string_size)                                           | The maximum allowed size for String in RowBinary format.                                                                                                                                                                                          | `1GiB`  |
| [`output_format_binary_encode_types_in_binary_format`](/operations/settings/formats#input_format_binary_decode_types_in_binary_format) | Allows to write types in header using [`binary encoding`](/sql-reference/data-types/data-types-binary-encoding.md) instead of strings with type names in [`RowBinaryWithNamesAndTypes`](../RowBinaryWithNamesAndTypes.md) output format.  | `false` |
| [`input_format_binary_decode_types_in_binary_format`](/operations/settings/formats#input_format_binary_decode_types_in_binary_format)   | Allows to read types in header using [`binary encoding`](/sql-reference/data-types/data-types-binary-encoding.md) instead of strings with type names in [`RowBinaryWithNamesAndTypes`](../RowBinaryWithNamesAndTypes.md) input format.    | `false` |
| [`output_format_binary_write_json_as_string`](/operations/settings/settings-formats.md/#output_format_binary_write_json_as_string)                   | Allows to write values of the [`JSON`](/sql-reference/data-types/newjson.md) data type as `JSON` [String](/sql-reference/data-types/string.md) values in [`RowBinary`](../RowBinary.md) output format.                            | `false` |
| [`input_format_binary_read_json_as_string`](/operations/settings/settings-formats.md/#input_format_binary_read_json_as_string)                       | Allows to read values of the [`JSON`](/sql-reference/data-types/newjson.md) data type as `JSON` [String](/sql-reference/data-types/string.md) values in [`RowBinary`](../RowBinary.md) input format.                              | `false` |
