---
description: 'List of format settings for the JSON format'
keywords: ['Format Settings', 'JSON']
slug: /interfaces/formats/JSON/format-settings
title: 'Format Settings For JSON'
doc_type: 'reference'
---

On this page you can find format settings common to all JSON formats.

<!-- TO DO - AUTOGENERATE THE TABLE BELOW -->

| Setting                                                                                                                                                                              | Description                                                                                                                                | Default | Note                                                                                                                                                                                        |
|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [`input_format_import_nested_json`](/operations/settings/settings-formats.md/#input_format_import_nested_json)                                                               | Map nested JSON data to nested tables (it works for JSONEachRow format).                                                                   | `false` |                                                                                                                                                                                             |
| [`input_format_json_read_bools_as_numbers`](/operations/settings/settings-formats.md/#input_format_json_read_bools_as_numbers)                                               | Allow to parse bools as numbers in JSON input formats.                                                                                     | `true`  |                                                                                                                                                                                             |
| [`input_format_json_read_bools_as_strings`](/operations/settings/settings-formats.md/#input_format_json_read_bools_as_strings)                                               | Allow to parse bools as strings in JSON input formats.                                                                                     | `true`  |                                                                                                                                                                                             |
| [`input_format_json_read_numbers_as_strings`](/operations/settings/settings-formats.md/#input_format_json_read_numbers_as_strings)                                           | Allow to parse numbers as strings in JSON input formats.                                                                                   | `true`  |                                                                                                                                                                                             |
| [`input_format_json_read_arrays_as_strings`](/operations/settings/settings-formats.md/#input_format_json_read_arrays_as_strings)                                             | Allow to parse JSON arrays as strings in JSON input formats.                                                                               | `true`  |                                                                                                                                                                                             |
| [`input_format_json_read_objects_as_strings`](/operations/settings/settings-formats.md/#input_format_json_read_objects_as_strings)                                           | Allow to parse JSON objects as strings in JSON input formats.                                                                              | `true`  |                                                                                                                                                                                             |
| [`input_format_json_named_tuples_as_objects`](/operations/settings/settings-formats.md/#input_format_json_named_tuples_as_objects)                                           | Parse named tuple columns as JSON objects.                                                                                                 | `true`  |                                                                                                                                                                                             |
| [`input_format_json_try_infer_numbers_from_strings`](/operations/settings/settings-formats.md/#input_format_json_try_infer_numbers_from_strings)                             | Try to infer numbers from string fields while schema inference.                                                                            | `false` |                                                                                                                                                                                             |
| [`input_format_json_try_infer_named_tuples_from_objects`](/operations/settings/settings-formats.md/#input_format_json_try_infer_named_tuples_from_objects)                   | Try to infer named tuple from JSON objects during schema inference.                                                                        | `true`  |                                                                                                                                                                                             |
| [`input_format_json_infer_incomplete_types_as_strings`](/operations/settings/settings-formats.md/#input_format_json_infer_incomplete_types_as_strings)                       | Use type String for keys that contains only Nulls or empty objects/arrays during schema inference in JSON input formats.                   | `true`  |                                                                                                                                                                                             |
| [`input_format_json_defaults_for_missing_elements_in_named_tuple`](/operations/settings/settings-formats.md/#input_format_json_defaults_for_missing_elements_in_named_tuple) | Insert default values for missing elements in JSON object while parsing named tuple.                                                       | `true`  |                                                                                                                                                                                             |
| [`input_format_json_ignore_unknown_keys_in_named_tuple`](/operations/settings/settings-formats.md/#input_format_json_ignore_unknown_keys_in_named_tuple)                     | Ignore unknown keys in json object for named tuples.                                                                                       | `false` |                                                                                                                                                                                             |
| [`input_format_json_compact_allow_variable_number_of_columns`](/operations/settings/settings-formats.md/#input_format_json_compact_allow_variable_number_of_columns)         | Allow variable number of columns in JSONCompact/JSONCompactEachRow format, ignore extra columns and use default values on missing columns. | `false` |                                                                                                                                                                                             |
| [`input_format_json_throw_on_bad_escape_sequence`](/operations/settings/settings-formats.md/#input_format_json_throw_on_bad_escape_sequence)                                 | Throw an exception if JSON string contains bad escape sequence. If disabled, bad escape sequences will remain as is in the data.           | `true`  |                                                                                                                                                                                             |
| [`input_format_json_empty_as_default`](/operations/settings/settings-formats.md/#input_format_json_empty_as_default)                                                         | Treat empty fields in JSON input as default values.                                                                                        | `false` | For complex default expressions [input_format_defaults_for_omitted_fields](/operations/settings/settings-formats.md/#input_format_defaults_for_omitted_fields) must be enabled too. |
| [`output_format_json_quote_64bit_integers`](/operations/settings/settings-formats.md/#output_format_json_quote_64bit_integers)                                               | Controls quoting of 64-bit integers in JSON output format.                                                                                 | `true`  |                                                                                                                                                                                             |
| [`output_format_json_quote_64bit_floats`](/operations/settings/settings-formats.md/#output_format_json_quote_64bit_floats)                                                   | Controls quoting of 64-bit floats in JSON output format.                                                                                   | `false` |                                                                                                                                                                                             |
| [`output_format_json_quote_denormals`](/operations/settings/settings-formats.md/#output_format_json_quote_denormals)                                                         | Enables '+nan', '-nan', '+inf', '-inf' outputs in JSON output format.                                                                      | `false` |                                                                                                                                                                                             |
| [`output_format_json_quote_decimals`](/operations/settings/settings-formats.md/#output_format_json_quote_decimals)                                                           | Controls quoting of decimals in JSON output format.                                                                                        | `false` |                                                                                                                                                                                             |
| [`output_format_json_escape_forward_slashes`](/operations/settings/settings-formats.md/#output_format_json_escape_forward_slashes)                                           | Controls escaping forward slashes for string outputs in JSON output format.                                                                | `true`  |                                                                                                                                                                                             |
| [`output_format_json_named_tuples_as_objects`](/operations/settings/settings-formats.md/#output_format_json_named_tuples_as_objects)                                         | Serialize named tuple columns as JSON objects.                                                                                             | `true`  |                                                                                                                                                                                             |
| [`output_format_json_array_of_rows`](/operations/settings/settings-formats.md/#output_format_json_array_of_rows)                                                             | Output a JSON array of all rows in JSONEachRow(Compact) format.                                                                            | `false` |                                                                                                                                                                                             |
| [`output_format_json_validate_utf8`](/operations/settings/settings-formats.md/#output_format_json_validate_utf8)                                                             | Enables validation of UTF-8 sequences in JSON output formats                                                                               | `false` | Note that it doesn't impact formats JSON/JSONCompact/JSONColumnsWithMetadata, they always validate utf8.                                                                                    |
