---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.9.2.1-stable (c2a9511f7bc) FIXME as compared to v25.9.1.1-new (524fe1daa94)

#### Backward Incompatible Change
* Disable non sensical binary operations with IPv4/IPv6: Plus / minus of a IPv4/IPv6 with a non integer type is disabled. Before it would allow operations with floating types and throw logical errors with some other types (such as DateTime). [#86336](https://github.com/ClickHouse/ClickHouse/pull/86336) ([Raúl Marín](https://github.com/Algunenano)).
* Deprecate setting `allow_dynamic_metadata_for_data_lakes`. Now all iceberg tables try to fetch up-to-date table schema from storage before executing of each query. [#86366](https://github.com/ClickHouse/ClickHouse/pull/86366) ([Daniil Ivanik](https://github.com/divanik)).
* The inverted text index was reworked from scratch to be scalable for datasets that don't fit into RAM. [#86485](https://github.com/ClickHouse/ClickHouse/pull/86485) ([Anton Popov](https://github.com/CurtizJ)).

#### New Feature
* Support table engine Alias. [#76569](https://github.com/ClickHouse/ClickHouse/pull/76569) ([RinChanNOW](https://github.com/RinChanNOWWW)).
* Added function `arrayExcept` that subtracts one array as a set from another. [#82368](https://github.com/ClickHouse/ClickHouse/pull/82368) ([Joanna Hulboj](https://github.com/jh0x)).
* Add a new system table `database_replicas` with information about database replicas. [#83408](https://github.com/ClickHouse/ClickHouse/pull/83408) ([Konstantin Morozov](https://github.com/k-morozov)).
* Users can now use NATS JetStream to consume messages by specifying the new settings of `nats_stream` and `nats_consumer` for the NATS engine. [#84799](https://github.com/ClickHouse/ClickHouse/pull/84799) ([Dmitry Novikov](https://github.com/dmitry-sles-novikov)).
* Adds a new `system.aggregated_zookeeper_log` table. The table contains statistics (e.g. number of operations, average latency, errors) of ZooKeeper operations grouped by session id, parent path and operation type, and periodically flushed to disk. [#85102](https://github.com/ClickHouse/ClickHouse/pull/85102) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Added `isValidASCII` function to check if string contains only ASCII characters. Close [#85377](https://github.com/ClickHouse/ClickHouse/issues/85377). [#85786](https://github.com/ClickHouse/ClickHouse/pull/85786) ([rajat mohan](https://github.com/rajatmohan22)).
* Treat a bare setting name in query setting as equal to `1` (e.g. `SELECT ... SETTINGS use_query_cache` is equivalent to `use_query_cache = 1`). [#85800](https://github.com/ClickHouse/ClickHouse/pull/85800) ([thraeka](https://github.com/thraeka)).
* New configuration options: `logger.startupLevel` & `logger.shutdownLevel` allow for overriding the log level during the startup & shutdown of Clickhouse respectively. [#85967](https://github.com/ClickHouse/ClickHouse/pull/85967) ([Lennard Eijsackers](https://github.com/Blokje5)).
* Aggregate functions `timeSeriesChangesToGrid` and `timeSeriesResetsToGrid`. Behaves similarly to `timeSeriesRateToGrid`, accepting parameters for start timestamp, end timestamp, step, and look back window, as well as two arguments for the timestamps and values, but requiring at least 1 sample per window instead of 2. Calculates a PromQL `changes`/`resets`, counting the number of times the sample value changes or decreases in the specified window for each timestamp in the time grid defined by the parameters. The return type is Array(Nullable(Float64)). [#86010](https://github.com/ClickHouse/ClickHouse/pull/86010) ([Stephen Chi](https://github.com/stephchi0)).
* `ALTER UPDATE` for Iceberg table engine. [#86059](https://github.com/ClickHouse/ClickHouse/pull/86059) ([scanhex12](https://github.com/scanhex12)).
* Add system table `iceberg_metadata_log` to retrieve Iceberg metadata files during SELECT statements. [#86152](https://github.com/ClickHouse/ClickHouse/pull/86152) ([scanhex12](https://github.com/scanhex12)).
* Allows users to create temporary views with the same syntax as temporary tables. [#86432](https://github.com/ClickHouse/ClickHouse/pull/86432) ([Aly Kafoury](https://github.com/AlyHKafoury)).
* Iceberg and delta lake tables with disk configuration. This allows to specify user tables with an existing disk. Add setting `allowed_disks_for_table_engines` which allows specific disks to use for Iceberg. Example: ``` CREATE TABLE test ENGINE = Iceberg('path/inside/disk') SETTING datalake_disk_name = '<some_user_disk>'; ``` ### Documentation entry for user-facing changes. [#86778](https://github.com/ClickHouse/ClickHouse/pull/86778) ([scanhex12](https://github.com/scanhex12)).
* Add warnings for cpu and memory to `system.warnings` table. [#86838](https://github.com/ClickHouse/ClickHouse/pull/86838) ([Bharat Nallan](https://github.com/bharatnc)).

#### Performance Improvement
* Improve prewhere optimization for conditions like `func(primary_column) = 'xx'` and `column in (xxx)`. [#85529](https://github.com/ClickHouse/ClickHouse/pull/85529) ([李扬](https://github.com/taiyang-li)).
* Implemented rewriting of JOIN: 1. Convert `LEFT ANY JOIN` and `RIGHT ANY JOIN` to `SEMI`/`ANTI` JOIN if the filter condition is always false for matched or non-matched rows. This optimization is controlled by a new setting `query_plan_convert_any_join_to_semi_or_anti_join`. 2. Convert `FULL ALL JOIN` to `LEFT ALL` or `RIGHT ALL` JOIN if the filter condition is always false for non-matched rows from one side. [#86028](https://github.com/ClickHouse/ClickHouse/pull/86028) ([Dmitry Novik](https://github.com/novikd)).
* Improved performance of vertical merges after executing a lightweight delete. [#86169](https://github.com/ClickHouse/ClickHouse/pull/86169) ([Anton Popov](https://github.com/CurtizJ)).
* `HashJoin` performance optimised slightly in the case of `LEFT/RIGHT` join having a lot of unmatched rows. [#86312](https://github.com/ClickHouse/ClickHouse/pull/86312) ([Nikita Taranov](https://github.com/nickitat)).
* RadixSort: Help the compiler use SIMD and the CPU do better prefetching. Uses dynamic dispatch to use software prefetching with Intel CPUs only. Continues the work by @taiyang-li in https://github.com/ClickHouse/ClickHouse/pull/77029. [#86378](https://github.com/ClickHouse/ClickHouse/pull/86378) ([Raúl Marín](https://github.com/Algunenano)).
* Join reordering now uses statistics. The feature can be enabled by setting `allow_statistics_optimize = 1` and `query_plan_optimize_join_order_limit = 10`. [#86822](https://github.com/ClickHouse/ClickHouse/pull/86822) ([Han Fei](https://github.com/hanfei1991)).
* Improves performance of fast queries with lots of parts in table (by optimizing `MarkRanges` by using `devector` over `deque`). [#86933](https://github.com/ClickHouse/ClickHouse/pull/86933) ([Azat Khuzhin](https://github.com/azat)).
* Improved performance of applying patch parts in join mode. [#87094](https://github.com/ClickHouse/ClickHouse/pull/87094) ([Anton Popov](https://github.com/CurtizJ)).

#### Improvement
* Support unity catalog on top of azure blob storage. [#80013](https://github.com/ClickHouse/ClickHouse/pull/80013) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Added experimental join order optimization that can automatically reorder JOINs for better performance (controlled by `query_plan_optimize_join_order_limit` setting). Note that the join order optimization currently has limited statistics support and primarily relies on row count estimates from storage engines - more sophisticated statistics collection and cardinality estimation will be added in future releases. **If you encounter issues with JOIN queries after upgrading**, you can temporarily disable the new implementation by setting `SET query_plan_use_new_logical_join_step = 0` and report the issue for investigation. **Note about resolution of identifiers from USING clause**: Changed resolving of the coalesced column from `OUTER JOIN ... USING` clause to be more consistent: previously, when selecting both the USING column and qualified columns (`a, t1.a, t2.a`) in a OUTER JOIN, the USING column would incorrectly be resolved to `t1.a`, showing 0/NULL for rows from the right table with no left match. Now identifiers from USING clause are always resolved to the coalesced column, while qualified identifiers resolve to the non-coalesced columns, regardless of which other identifiers are present in the query. For example: ```sql SELECT a, t1.a, t2.a FROM (SELECT 1 as a WHERE 0) t1 FULL JOIN (SELECT 2 as a) t2 USING (a) -- Before: a=0, t1.a=0, t2.a=2 (incorrect - 'a' resolved to t1.a) -- After: a=2, t1.a=0, t2.a=2 (correct - 'a' is coalesced). [#80848](https://github.com/ClickHouse/ClickHouse/pull/80848) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Support filtering data parts using skip indexes during reading to reduce unnecessary index reads. Controlled by the new setting `use_skip_indexes_on_data_read` (disabled by default). This addresses [#75774](https://github.com/ClickHouse/ClickHouse/issues/75774). This includes some common groundwork shared with [#81021](https://github.com/ClickHouse/ClickHouse/issues/81021). [#81526](https://github.com/ClickHouse/ClickHouse/pull/81526) ([Amos Bird](https://github.com/amosbird)).
* Make S3 retry strategy configurable and make settings of S3 disk can be hot reload if change the config XML file. [#82642](https://github.com/ClickHouse/ClickHouse/pull/82642) ([RinChanNOW](https://github.com/RinChanNOWWW)).
* Special column may be used to indicate presence of part of oneof. [#82885](https://github.com/ClickHouse/ClickHouse/pull/82885) ([Ilya Golshtein](https://github.com/ilejn)).
* Give more clear instruction for users when incorrect settings are specified for the new Kafka table engine. [#83701](https://github.com/ClickHouse/ClickHouse/pull/83701) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* It's no longer possible to specify time zones for the Time type. [#84689](https://github.com/ClickHouse/ClickHouse/pull/84689) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Simplified (and avoided some bugs) a logic related to parsing Time[64] in a `best_effort` format. [#84730](https://github.com/ClickHouse/ClickHouse/pull/84730) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* You can use query parameters after `TO` when creating a materialized view, for example: `CREATE MATERIALIZED VIEW mv TO {to_table:Identifier} AS SELECT * FROM src_table`. [#84899](https://github.com/ClickHouse/ClickHouse/pull/84899) ([Diskein](https://github.com/Diskein)).
* Update jemalloc to newer version. Improve allocation profiling based on jemalloc's internal tooling. Global jemalloc profiler can now be enabled with config `jemalloc_enable_global_profiler`. Sampled global allocations and deallocations can be stored in `system.trace_log` under `JemallocSample` type by enabling config `jemalloc_collect_global_profile_samples_in_trace_log`. Jemalloc profiling can now be enabled for each query independently using setting `jemalloc_enable_profiler`. Storing samples in `system.trace_log` can be controlled per query using setting `jemalloc_collect_profile_samples_in_trace_log`. [#85438](https://github.com/ClickHouse/ClickHouse/pull/85438) ([Antonio Andelic](https://github.com/antonio2368)).
* Added deltaLakeAzureCluster function (similar to deltaLakeAzure for cluster) and deltaLakeS3Cluster (alias to deltaLakeCluster) function.resolves [#85358](https://github.com/ClickHouse/ClickHouse/issues/85358). [#85547](https://github.com/ClickHouse/ClickHouse/pull/85547) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Apply azure_max_single_part_copy_size setting for normal copy operations in the same way as for backup. [#85767](https://github.com/ClickHouse/ClickHouse/pull/85767) ([Ilya Golshtein](https://github.com/ilejn)).
* Slow down S3 client threads on retryable errors in S3 Object Storage. This extends the previous setting `backup_slow_all_threads_after_retryable_s3_error` to S3 disks and renames it to the more general `s3_slow_all_threads_after_retryable_error`. [#85918](https://github.com/ClickHouse/ClickHouse/pull/85918) ([Julia Kartseva](https://github.com/jkartseva)).
* Mark settings allow_experimental_variant/dynamic/json and enable_variant/dynamic/json as obsolete. Now all three types are enabled unconditionally. [#85934](https://github.com/ClickHouse/ClickHouse/pull/85934) ([Pavel Kruglov](https://github.com/Avogar)).
* Improved S3(Azure)Queue table engine to allow it to survive zookeeper connection loss without potential duplicates. Requires enabling S3Queue setting `use_persistent_processing_nodes` (changeable by `ALTER TABLE MODIFY SETTING`). [#85995](https://github.com/ClickHouse/ClickHouse/pull/85995) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Added setting `query_condition_cache_selectivity_threshold` (default value: 1.0) which excludes scan results of predicates with low selectivity from insertion into the query condition cache. This allows to reduce the memory consumption of the query condition cache at the cost of a worse cache hit rate. [#86076](https://github.com/ClickHouse/ClickHouse/pull/86076) ([zhongyuankai](https://github.com/zhongyuankai)).
* Support filtering by complete URL string (`full_url` directive) in `http_handlers` (including schema and host:port). [#86155](https://github.com/ClickHouse/ClickHouse/pull/86155) ([Azat Khuzhin](https://github.com/azat)).
* Add an experimental setting to delta lake writes feature `allow_experimental_delta_lake_writes`, disabled by default. [#86180](https://github.com/ClickHouse/ClickHouse/pull/86180) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix detection of systemd in init.d script (fixes "Install packages" check). [#86187](https://github.com/ClickHouse/ClickHouse/pull/86187) ([Azat Khuzhin](https://github.com/azat)).
* Add a new `startup_scripts_failure_reason` dimensional metric. This metric is needed to distinguish between different error types that result in failing startup scripts. In particular, for alerting purposes, we need to distinguish between transient (e.g., `MEMORY_LIMIT_EXCEEDED` or `KEEPER_EXCEPTION`) and non-transient errors. [#86202](https://github.com/ClickHouse/ClickHouse/pull/86202) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Multiple data files in iceberg writes. [#86275](https://github.com/ClickHouse/ClickHouse/pull/86275) ([scanhex12](https://github.com/scanhex12)).
* More types for partitions in iceberg writes. This closes [#86206](https://github.com/ClickHouse/ClickHouse/issues/86206). [#86298](https://github.com/ClickHouse/ClickHouse/pull/86298) ([scanhex12](https://github.com/scanhex12)).
* Allow to omit `identity()` function for partition for Iceberg table. [#86314](https://github.com/ClickHouse/ClickHouse/pull/86314) ([scanhex12](https://github.com/scanhex12)).
* Add ability to enable JSON logging only for specific channel, for this set `logger.formatting.channel` to one of `syslog`/`console`/`errorlog`/`log`. [#86331](https://github.com/ClickHouse/ClickHouse/pull/86331) ([Azat Khuzhin](https://github.com/azat)).
* Add rows/bytes limit for inserted data files in delta lake. Controlled by settings `delta_lake_insert_max_rows_in_data_file` and `delta_lake_insert_max_bytes_in_data_file`. [#86357](https://github.com/ClickHouse/ClickHouse/pull/86357) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Allow using native numbers in `WHERE`. They are already allowed to be arguments of logical functions. This simplifies filter-push-down and move-to-prewhere optimizations. [#86390](https://github.com/ClickHouse/ClickHouse/pull/86390) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fixed error in case of executing `SYSTEM DROP REPLICA` against a Catalog with corrupted metadata. [#86391](https://github.com/ClickHouse/ClickHouse/pull/86391) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Add extra retries for disk access check (`skip_access_check=0`) in Azure because it may be provisioning access for quite a long time. [#86419](https://github.com/ClickHouse/ClickHouse/pull/86419) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Rename setting `evaluation_time` to `promql_evaluation_time`. [#86459](https://github.com/ClickHouse/ClickHouse/pull/86459) ([Vitaly Baranov](https://github.com/vitlibar)).
* Setting to delete files in iceberg drop. This closes [#86211](https://github.com/ClickHouse/ClickHouse/issues/86211). [#86501](https://github.com/ClickHouse/ClickHouse/pull/86501) ([scanhex12](https://github.com/scanhex12)).
* Reduce memory usage in iceberg writes. [#86544](https://github.com/ClickHouse/ClickHouse/pull/86544) ([scanhex12](https://github.com/scanhex12)).
* Make `today()` function case insensitive to make it consistent with other date/time related functions like `NOW()`. [#86561](https://github.com/ClickHouse/ClickHouse/pull/86561) ([Kaviraj Kanagaraj](https://github.com/kavirajk)).
* Make the staleness window in `timeSeries*()` functions left-open and right-closed. [#86588](https://github.com/ClickHouse/ClickHouse/pull/86588) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add `FailedInternal*Query` profile events. [#86627](https://github.com/ClickHouse/ClickHouse/pull/86627) ([Shane Andrade](https://github.com/mauidude)).
* Fixes handling of users with a dot in the name when added via config file. [#86633](https://github.com/ClickHouse/ClickHouse/pull/86633) ([Mikhail Koviazin](https://github.com/mkmkme)).
* Add asynchronous metric for memory usage in queries (`QueriesMemoryUsage` and `QueriesPeakMemoryUsage`). [#86669](https://github.com/ClickHouse/ClickHouse/pull/86669) ([Azat Khuzhin](https://github.com/azat)).
* You can use `clickhouse-benchmark --precise` flag for more precise reporting of QPS and other per-interval metrics. It helps to get consistent QPS in case if durations of queries are comparable to the reporting interval `--delay D`. [#86684](https://github.com/ClickHouse/ClickHouse/pull/86684) ([Sergei Trifonov](https://github.com/serxa)).
* Make nice values of Linux threads configurable to assign some threads (merge/mutate, query, materialized view, zookeeper client) higher or lower priorities. [#86703](https://github.com/ClickHouse/ClickHouse/pull/86703) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Fix misleading “specified upload does not exist” error, which occurs when the original exception is lost in multipart upload because of a race condition. [#86725](https://github.com/ClickHouse/ClickHouse/pull/86725) ([Julia Kartseva](https://github.com/jkartseva)).
* Limit query plan description in the `EXPLAIN` query. Do not calculate the description for queries other than `EXPLAIN`. Added a steeing `query_plan_max_step_description_length`. [#86741](https://github.com/ClickHouse/ClickHouse/pull/86741) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add ability to tune pending signals in attemp to overcome CANNOT_CREATE_TIMER (for query profilers, `query_profiler_real_time_period_ns`/`query_profiler_cpu_time_period_ns`). And also collect `SigQ` from the `/proc/self/status` for introspection (if `ProcessSignalQueueSize` is near to `ProcessSignalQueueLimit`, then you will likely get `CANNOT_CREATE_TIMER` errors). [#86760](https://github.com/ClickHouse/ClickHouse/pull/86760) ([Azat Khuzhin](https://github.com/azat)).
* Use tasktracker in src/io/s3/copys3file.cpp. [#86764](https://github.com/ClickHouse/ClickHouse/pull/86764) ([Sema Checherinda](https://github.com/CheSema)).
* Distributed insert/select for data lakes. [#86783](https://github.com/ClickHouse/ClickHouse/pull/86783) ([scanhex12](https://github.com/scanhex12)).
* Improve performance of RemoveRecursive request in Keeper. [#86789](https://github.com/ClickHouse/ClickHouse/pull/86789) ([Antonio Andelic](https://github.com/antonio2368)).
* Remove extra whitespace in PrettyJSONEachRow during JSON type output. [#86819](https://github.com/ClickHouse/ClickHouse/pull/86819) ([Pavel Kruglov](https://github.com/Avogar)).
* Increase replicated deduplication window up to 10000. [#86820](https://github.com/ClickHouse/ClickHouse/pull/86820) ([Sema Checherinda](https://github.com/CheSema)).
* Now we write blobs sizes of for `prefix.path` when directory is removed for plain rewriteable disk. [#86908](https://github.com/ClickHouse/ClickHouse/pull/86908) ([alesapin](https://github.com/alesapin)).
* Make `yesterday()` function case insensitive and consistent with `today()` function. [#86914](https://github.com/ClickHouse/ClickHouse/pull/86914) ([Kaviraj Kanagaraj](https://github.com/kavirajk)).
* Support `.xml` performance testing against remote ClickHouse instances, including ClickHouse Cloud. Usage example: `tests/performance/scripts/perf.py tests/performance/math.xml --runs 10 --user <username> --password <password> --host <hostname> --port <port> --secure`. [#86995](https://github.com/ClickHouse/ClickHouse/pull/86995) ([Raufs Dunamalijevs](https://github.com/rienath)).
* Respect memory limits in some places that are known to allocate significant (>16MiB) amount of memory (sorting, async inserts, file log). [#87035](https://github.com/ClickHouse/ClickHouse/pull/87035) ([Azat Khuzhin](https://github.com/azat)).
* Prevent nonboolean settings from not setting value in queries. Improvement of [#85800](https://github.com/ClickHouse/ClickHouse/issues/85800). [#87084](https://github.com/ClickHouse/ClickHouse/pull/87084) ([thraeka](https://github.com/thraeka)).
* Throw an exception if setting `network_compression_method` is not a supported generic codec. [#87097](https://github.com/ClickHouse/ClickHouse/pull/87097) ([Robert Schulze](https://github.com/rschu1ze)).
* System table `system.query_cache` now returns _all_ query result cache entries, whereas it previously returned only shared entries or non-shared entries of the same user and role. That is okay as non-shared entries are supposed to not reveal _query results_, whereas `system.query_cache` returns _query strings_. This makes the behavior of the system table more similar to `system.query_log`. [#87104](https://github.com/ClickHouse/ClickHouse/pull/87104) ([Robert Schulze](https://github.com/rschu1ze)).
* Added support for authentication and SSL in the `arrowFlight()` table function. [#87120](https://github.com/ClickHouse/ClickHouse/pull/87120) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add new parameter to `S3` table engine and `s3` table function named `storage_class_name` which allows to specify intelligent tiring supported by AWS. Supported both in key-value format and in positional (deprecated) format). [#87122](https://github.com/ClickHouse/ClickHouse/pull/87122) ([alesapin](https://github.com/alesapin)).
* Support azure for data lakes disks. [#87173](https://github.com/ClickHouse/ClickHouse/pull/87173) ([scanhex12](https://github.com/scanhex12)).
* Enable short circuit evaluation for parseDateTime function. [#87184](https://github.com/ClickHouse/ClickHouse/pull/87184) ([Pavel Kruglov](https://github.com/Avogar)).
* Support `alter table ... materialize statistics all` will materialize all the statistics of a table. [#87197](https://github.com/ClickHouse/ClickHouse/pull/87197) ([Han Fei](https://github.com/hanfei1991)).
* Backported in [#87429](https://github.com/ClickHouse/ClickHouse/issues/87429): Disable `s3_slow_all_threads_after_retryable_error` by default. [#87198](https://github.com/ClickHouse/ClickHouse/pull/87198) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Adds a new `system.aggregated_zookeeper_log` table. The table contains statistics (e.g. number of operations, average latency, errors) of ZooKeeper operations grouped by session id, parent path and operation type, and periodically flushed to disk. [#87208](https://github.com/ClickHouse/ClickHouse/pull/87208) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Add a new column `statistics` in system.parts_columns. [#87259](https://github.com/ClickHouse/ClickHouse/pull/87259) ([Han Fei](https://github.com/hanfei1991)).
* Support other formats (ORC, Avro) in iceberg writes. This closes [#86179](https://github.com/ClickHouse/ClickHouse/issues/86179). [#87277](https://github.com/ClickHouse/ClickHouse/pull/87277) ([scanhex12](https://github.com/scanhex12)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* The results of alter queries are only validated on the initiator node for replicated databases and internally replicated tables. This will fix situations where an already committed alter query could get stuck on other nodes. [#83849](https://github.com/ClickHouse/ClickHouse/pull/83849) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Limit the number of tasks of each type in `BackgroundSchedulePool`. Avoid situations when all slots are occupied by task of one type, while other tasks are starving. Also avoids deadlocks when tasks wait for each other. This is controlled by `background_schedule_pool_max_parallel_tasks_per_type_ratio` server setting. [#84008](https://github.com/ClickHouse/ClickHouse/pull/84008) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Shutdown tables properly when recovering database replica. Improper shutdown would lead to LOGICAL_ERROR for some table engines during database replica recovery. [#84744](https://github.com/ClickHouse/ClickHouse/pull/84744) ([Antonio Andelic](https://github.com/antonio2368)).
* Check access rights during typo correction hints generation for the database name. [#85371](https://github.com/ClickHouse/ClickHouse/pull/85371) ([Dmitry Novik](https://github.com/novikd)).
* 1. LowCardinality for hive columns 2. Fill hive columns before virtual columns (required for https://github.com/ClickHouse/ClickHouse/pull/81040) 3. LOGICAL_ERROR on empty format for hive [#85528](https://github.com/ClickHouse/ClickHouse/issues/85528) 4. Fix check for hive partition columns being the only columns 5. Assert all hive columns are specified in the schema 6. Partial fix for parallel_replicas_cluster with hive 7. Use ordered container in extractkeyValuePairs for hive utils (required for https://github.com/ClickHouse/ClickHouse/pull/81040). [#85538](https://github.com/ClickHouse/ClickHouse/pull/85538) ([Arthur Passos](https://github.com/arthurpassos)).
* Prevent unnecessary optimization of the first argument of `IN` functions sometimes resulting in error when array mapping is used. [#85546](https://github.com/ClickHouse/ClickHouse/pull/85546) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Mapping between iceberg source ids and parquet names was not adjusted to the schema when the parquet file was written. This PR processes schema relevant for each iceberg data file, not a current one. [#85829](https://github.com/ClickHouse/ClickHouse/pull/85829) ([Daniil Ivanik](https://github.com/divanik)).
* Fix reading file size separately from opening it. Relates to https://github.com/ClickHouse/ClickHouse/pull/33372, which was introduced in response to a bug in Linux kernels prior to `5.10` release. [#85837](https://github.com/ClickHouse/ClickHouse/pull/85837) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* ClickHouse Keeper no longer fails to start on systems where IPv6 is disabled at the kernel level (e.g., RHEL with ipv6.disable=1). It now attempts to fall back to an IPv4 listener if the initial IPv6 listener fails. [#85901](https://github.com/ClickHouse/ClickHouse/pull/85901) ([jskong1124](https://github.com/jskong1124)).
* This PR closes [#77990](https://github.com/ClickHouse/ClickHouse/issues/77990). Add TableFunctionRemote support for parallel replicas in globalJoin. [#85929](https://github.com/ClickHouse/ClickHouse/pull/85929) ([zoomxi](https://github.com/zoomxi)).
* Fix null pointer in orcschemareader::initializeifneeded(). this pr addresses the following issue: [#85292](https://github.com/ClickHouse/ClickHouse/issues/85292) ### documentation entry for user-facing changes. [#85951](https://github.com/ClickHouse/ClickHouse/pull/85951) ([yanglongwei](https://github.com/ylw510)).
* Add a check to allow correlated subqueries in the FROM clause only if they use columns from the outer query. Fixes [#85469](https://github.com/ClickHouse/ClickHouse/issues/85469). Fixes [#85402](https://github.com/ClickHouse/ClickHouse/issues/85402). [#85966](https://github.com/ClickHouse/ClickHouse/pull/85966) ([Dmitry Novik](https://github.com/novikd)).
* Fix alter update of a column with a subcolumn used in other column materialized expression. Previously materialized column with subcolumn in its expression was not updated properly. [#85985](https://github.com/ClickHouse/ClickHouse/pull/85985) ([Pavel Kruglov](https://github.com/Avogar)).
* Forbid altering columns whose subcolumns are used in PK or partition expression. [#86005](https://github.com/ClickHouse/ClickHouse/pull/86005) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix reading subcolumns with non-default column mapping mode in storage DeltaLake. [#86064](https://github.com/ClickHouse/ClickHouse/pull/86064) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix using wrong default values for path with Enum hint inside JSON. [#86065](https://github.com/ClickHouse/ClickHouse/pull/86065) ([Pavel Kruglov](https://github.com/Avogar)).
* DataLake hive catalog url parsing with input sanitisation. Closes [#86018](https://github.com/ClickHouse/ClickHouse/issues/86018). [#86092](https://github.com/ClickHouse/ClickHouse/pull/86092) ([rajat mohan](https://github.com/rajatmohan22)).
* Fix logical error during filesystem cache dynamic resize. Closes [#86122](https://github.com/ClickHouse/ClickHouse/issues/86122). Closes https://github.com/ClickHouse/clickhouse-core-incidents/issues/473. [#86130](https://github.com/ClickHouse/ClickHouse/pull/86130) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Use `NonZeroUInt64` for `logs_to_keep` in DatabaseReplicatedSettings. [#86142](https://github.com/ClickHouse/ClickHouse/pull/86142) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Exception was thrown by a `FINAL` query with skip index if the table (e.g `ReplacingMergeTree`) was created with setting`index_granularity_bytes = 0`. That exception has been fixed now. [#86147](https://github.com/ClickHouse/ClickHouse/pull/86147) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Removes UB and fixes problems with parsing of Iceberg partition expression. [#86166](https://github.com/ClickHouse/ClickHouse/pull/86166) ([Daniil Ivanik](https://github.com/divanik)).
* Fix crash in case of const and non-const blocks in one INSERT. [#86230](https://github.com/ClickHouse/ClickHouse/pull/86230) ([Azat Khuzhin](https://github.com/azat)).
* Process includes from `/etc/metrika.xml` as a default when creating disks from SQL. [#86232](https://github.com/ClickHouse/ClickHouse/pull/86232) ([alekar](https://github.com/alekar)).
* Fix accurateCastOrNull/accurateCastOrDefault from String to JSON. [#86240](https://github.com/ClickHouse/ClickHouse/pull/86240) ([Pavel Kruglov](https://github.com/Avogar)).
* Support directories without '/' in iceberg engine. [#86249](https://github.com/ClickHouse/ClickHouse/pull/86249) ([scanhex12](https://github.com/scanhex12)).
* Fix crash with replaceRegex, a FixedString haystack and an empty needle. [#86270](https://github.com/ClickHouse/ClickHouse/pull/86270) ([Raúl Marín](https://github.com/Algunenano)).
* Fix crash during ALTER UPDATE Nullable(JSON). [#86281](https://github.com/ClickHouse/ClickHouse/pull/86281) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix missing column definer in system.tables. [#86295](https://github.com/ClickHouse/ClickHouse/pull/86295) ([Raúl Marín](https://github.com/Algunenano)).
* Fix cast from LowCardinality(Nullable(T)) to Dynamic. [#86365](https://github.com/ClickHouse/ClickHouse/pull/86365) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix logical error during writes to DeltaLake. Closes [#86175](https://github.com/ClickHouse/ClickHouse/issues/86175). [#86367](https://github.com/ClickHouse/ClickHouse/pull/86367) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix `416 The range specified is invalid for the current size of the resource. The range specified is invalid for the current size of the resource` when reading empty blobs from Azure blob storage for plain_rewritable disk. [#86400](https://github.com/ClickHouse/ClickHouse/pull/86400) ([Julia Kartseva](https://github.com/jkartseva)).
* Fix GROUP BY Nullable(JSON). [#86410](https://github.com/ClickHouse/ClickHouse/pull/86410) ([Pavel Kruglov](https://github.com/Avogar)).
* Fixed a bug in Materialized Views: an MV might not work if it was created, dropped, and then created again with the same name. [#86413](https://github.com/ClickHouse/ClickHouse/pull/86413) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fail if all replicas are unavailable when reading from *cluster functions. [#86414](https://github.com/ClickHouse/ClickHouse/pull/86414) ([Julian Maicher](https://github.com/jmaicher)).
* Fix leaking of `MergesMutationsMemoryTracking` due to `Buffer` tables and fix `query_views_log` for streaming from `Kafka` (and others). [#86422](https://github.com/ClickHouse/ClickHouse/pull/86422) ([Azat Khuzhin](https://github.com/azat)).
* Fix show tables after dropping reference table of alias storage. [#86433](https://github.com/ClickHouse/ClickHouse/pull/86433) ([RinChanNOW](https://github.com/RinChanNOWWW)).
* Fix missing chunk header when send_chunk_header is enabled and UDF is invoked via HTTP protocol. [#86469](https://github.com/ClickHouse/ClickHouse/pull/86469) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fix possible deadlock in case of jemalloc profile flushes enabled. [#86473](https://github.com/ClickHouse/ClickHouse/pull/86473) ([Azat Khuzhin](https://github.com/azat)).
* Fix reading subcolumns in DeltaLake table engine. Closes [#86204](https://github.com/ClickHouse/ClickHouse/issues/86204). [#86477](https://github.com/ClickHouse/ClickHouse/pull/86477) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Handling loopback host ID properly to avoid collision when processing DDL tasks:. [#86479](https://github.com/ClickHouse/ClickHouse/pull/86479) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fix detach/attach for postgres database engine tables with numeric/decimal columns. [#86480](https://github.com/ClickHouse/ClickHouse/pull/86480) ([Julian Maicher](https://github.com/jmaicher)).
* Fix use of uninitialized memory in getSubcolumnType. [#86498](https://github.com/ClickHouse/ClickHouse/pull/86498) ([Raúl Marín](https://github.com/Algunenano)).
* Functions `searchAny` and `searchAll` when called with empty needles now return `true` (aka. "matches everything"). Previously, they returned `false`. (issue [#86300](https://github.com/ClickHouse/ClickHouse/issues/86300)). [#86500](https://github.com/ClickHouse/ClickHouse/pull/86500) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Fix function `timeSeriesResampleToGridWithStaleness()` when the first bucket has no value. [#86507](https://github.com/ClickHouse/ClickHouse/pull/86507) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix crash caused by `merge_tree_min_read_task_size` being set to 0. [#86527](https://github.com/ClickHouse/ClickHouse/pull/86527) ([yanglongwei](https://github.com/ylw510)).
* While reading takes format for each data file from Iceberg metadata (earlier it was taken from table arguments). [#86529](https://github.com/ClickHouse/ClickHouse/pull/86529) ([Daniil Ivanik](https://github.com/divanik)).
* Ignore exceptions during flushing log on shutdown and make shutdown more safe (to avoid SIGSEGV). [#86546](https://github.com/ClickHouse/ClickHouse/pull/86546) ([Azat Khuzhin](https://github.com/azat)).
* Fix Backup db engine raising exception on query with zero sized part files. [#86563](https://github.com/ClickHouse/ClickHouse/pull/86563) ([Max Justus Spransy](https://github.com/maxjustus)).
* Fix missing chunk header when send_chunk_header is enabled and UDF is invoked via HTTP protocol. [#86606](https://github.com/ClickHouse/ClickHouse/pull/86606) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fix S3Queue logical error "Expected current processor {} to be equal to {}", which happened because of keeper session expiration. [#86615](https://github.com/ClickHouse/ClickHouse/pull/86615) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Nullablity bugs in insert and pruning. This closes [#86407](https://github.com/ClickHouse/ClickHouse/issues/86407). [#86630](https://github.com/ClickHouse/ClickHouse/pull/86630) ([scanhex12](https://github.com/scanhex12)).
* Do not disable file system cache if Iceberg metadata cache is disabled. [#86635](https://github.com/ClickHouse/ClickHouse/pull/86635) ([Daniil Ivanik](https://github.com/divanik)).
* Fixed 'Deadlock in Parquet::ReadManager (single-threaded)' error in parquet reader v3. [#86644](https://github.com/ClickHouse/ClickHouse/pull/86644) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix support for IPv6 in `listen_host` for ArrowFlight. [#86664](https://github.com/ClickHouse/ClickHouse/pull/86664) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix shutdown in `ArrowFlight` handler. This PR fixes [#86596](https://github.com/ClickHouse/ClickHouse/issues/86596). [#86665](https://github.com/ClickHouse/ClickHouse/pull/86665) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix distributed queries with `describe_compact_output=1`. [#86676](https://github.com/ClickHouse/ClickHouse/pull/86676) ([Azat Khuzhin](https://github.com/azat)).
* Fix window definition parsing and applying query parameters. [#86720](https://github.com/ClickHouse/ClickHouse/pull/86720) ([Azat Khuzhin](https://github.com/azat)).
* Fix exception `Partition strategy wildcard can not be used without a '_partition_id' wildcard.` when creating a table with `PARTITION BY`, but without partition wildcard, which used to work in versions before 25.8. Closes https://github.com/ClickHouse/clickhouse-private/issues/37567. [#86748](https://github.com/ClickHouse/ClickHouse/pull/86748) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix LogicalError if parallel queries are trying to acquire single lock. [#86751](https://github.com/ClickHouse/ClickHouse/pull/86751) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Fix writing NULL into JSON shared data in RowBinary input format and add some additional validations in ColumnObject. [#86812](https://github.com/ClickHouse/ClickHouse/pull/86812) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix empty Tuple permutation with limit. [#86828](https://github.com/ClickHouse/ClickHouse/pull/86828) ([Pavel Kruglov](https://github.com/Avogar)).
* Do not use separate keeper node for persistent processing nodes. Fix for https://github.com/ClickHouse/ClickHouse/pull/85995. Closes [#86406](https://github.com/ClickHouse/ClickHouse/issues/86406). [#86841](https://github.com/ClickHouse/ClickHouse/pull/86841) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix TimeSeries engine table breaking creation of new replica in Replicated Database. [#86845](https://github.com/ClickHouse/ClickHouse/pull/86845) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix querying `system.distributed_ddl_queue` in cases where tasks are missing certain Keeper nodes. [#86848](https://github.com/ClickHouse/ClickHouse/pull/86848) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix seeking at the end of the decompressed block. [#86906](https://github.com/ClickHouse/ClickHouse/pull/86906) ([Pavel Kruglov](https://github.com/Avogar)).
* Process exception which is thrown during asyncronous execution of Iceberg Iterator. [#86932](https://github.com/ClickHouse/ClickHouse/pull/86932) ([Daniil Ivanik](https://github.com/divanik)).
* Fix saving of big preprocessed XML configs. [#86934](https://github.com/ClickHouse/ClickHouse/pull/86934) ([c-end](https://github.com/c-end)).
* Fix date field populating in system.iceberg_metadata_log table. [#86961](https://github.com/ClickHouse/ClickHouse/pull/86961) ([Daniil Ivanik](https://github.com/divanik)).
* Fixed infinite recalculation of `TTL` with `WHERE`. [#86965](https://github.com/ClickHouse/ClickHouse/pull/86965) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#87599](https://github.com/ClickHouse/ClickHouse/issues/87599): Fix result of function calculated in CTE being non-deterministic in the query. [#86967](https://github.com/ClickHouse/ClickHouse/pull/86967) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Fixed possible incorrect result of `uniqExact` function with `ROLLUP` and `CUBE` modifiers. [#87014](https://github.com/ClickHouse/ClickHouse/pull/87014) ([Nikita Taranov](https://github.com/nickitat)).
* Fix resolving table schema with `url()` table function when `parallel_replicas_for_cluster_functions` setting is set to 1. [#87029](https://github.com/ClickHouse/ClickHouse/pull/87029) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Correctly cast output of PREWHERE after splitting it into multiple steps. [#87040](https://github.com/ClickHouse/ClickHouse/pull/87040) ([Antonio Andelic](https://github.com/antonio2368)).
* Fixed lightweight updates with `ON CLUSTER` clause. [#87043](https://github.com/ClickHouse/ClickHouse/pull/87043) ([Anton Popov](https://github.com/CurtizJ)).
* Fix compatibility of some aggregate function states with String argument. [#87049](https://github.com/ClickHouse/ClickHouse/pull/87049) ([Pavel Kruglov](https://github.com/Avogar)).
* Fixes an issue where model name from OpenAI wasn't passed through. [#87100](https://github.com/ClickHouse/ClickHouse/pull/87100) ([Kaushik Iska](https://github.com/iskakaushik)).
* EmbeddedRocksDB: Path must be inside user_files. [#87109](https://github.com/ClickHouse/ClickHouse/pull/87109) ([Raúl Marín](https://github.com/Algunenano)).
* Fix KeeperMap tables created before 25.1, leaving data in ZooKeeper after the DROP query. [#87112](https://github.com/ClickHouse/ClickHouse/pull/87112) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix maps and arrays field ids reading parquet. [#87136](https://github.com/ClickHouse/ClickHouse/pull/87136) ([scanhex12](https://github.com/scanhex12)).
* Fix reading array with array sizes subcolumn in lazy materialization. [#87139](https://github.com/ClickHouse/ClickHouse/pull/87139) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#87386](https://github.com/ClickHouse/ClickHouse/issues/87386): Fixed incorrect accounting of temporary data deallocations in `max_temporary_data_on_disk_size` limit tracking, close [#87118](https://github.com/ClickHouse/ClickHouse/issues/87118). [#87140](https://github.com/ClickHouse/ClickHouse/pull/87140) ([JIaQi](https://github.com/JiaQiTang98)).
* Fix CASE function with Dynamic arguments. [#87177](https://github.com/ClickHouse/ClickHouse/pull/87177) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#87350](https://github.com/ClickHouse/ClickHouse/issues/87350): Fix logical error with parallel replicas for queries with multiple JOINs, with RIGHT JOIN after LEFT/INNER JOIN in particular. [#87178](https://github.com/ClickHouse/ClickHouse/pull/87178) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#87481](https://github.com/ClickHouse/ClickHouse/issues/87481): Make pathStartsWith only match paths under the prefix. [#87181](https://github.com/ClickHouse/ClickHouse/pull/87181) ([Raúl Marín](https://github.com/Algunenano)).
* Fix reading empty array from empty string in CSV. [#87182](https://github.com/ClickHouse/ClickHouse/pull/87182) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix possible wrong result of non-correlated `EXISTS`. It was broken with `execute_exists_as_scalar_subquery=1` which was introduced in https://github.com/ClickHouse/ClickHouse/pull/85481 and affects `25.8`. Fixes [#86415](https://github.com/ClickHouse/ClickHouse/issues/86415). [#87207](https://github.com/ClickHouse/ClickHouse/pull/87207) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#87439](https://github.com/ClickHouse/ClickHouse/issues/87439): Fix "Too large size passed to allocator" `LOGICAL_ERROR` in `JOIN` due to mixed const and non-const blocks. [#87231](https://github.com/ClickHouse/ClickHouse/pull/87231) ([Azat Khuzhin](https://github.com/azat)).
* Throws an error if iceberg_metadata_log is not configured, but user tries to get debug iceberg metadata info. Fixes nullptr access. [#87250](https://github.com/ClickHouse/ClickHouse/pull/87250) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#87539](https://github.com/ClickHouse/ClickHouse/issues/87539): Fixed applying patches to columns with default expression that are missing in data parts. [#87347](https://github.com/ClickHouse/ClickHouse/pull/87347) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#87411](https://github.com/ClickHouse/ClickHouse/issues/87411): Fix EmbeddedRocksDB upgrade. [#87392](https://github.com/ClickHouse/ClickHouse/pull/87392) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#87458](https://github.com/ClickHouse/ClickHouse/issues/87458): Ignore only not found errors for `s3_plain_rewritable` (which may lead to all sort of troubles). [#87426](https://github.com/ClickHouse/ClickHouse/pull/87426) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#87642](https://github.com/ClickHouse/ClickHouse/issues/87642): Exclude userspace page cache bytes (if possible) when computing memory overload warning. [#87610](https://github.com/ClickHouse/ClickHouse/pull/87610) ([Bharat Nallan](https://github.com/bharatnc)).

#### Build/Testing/Packaging Improvement
* Fix compatibility with abseil-cpp 20250814.0, https://github.com/abseil/abseil-cpp/issues/1923. [#85970](https://github.com/ClickHouse/ClickHouse/pull/85970) ([Yuriy Chernyshov](https://github.com/georgthegreat)).
* Put building standalone WASM lexer under a flag. [#86505](https://github.com/ClickHouse/ClickHouse/pull/86505) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix crc32c build on older ARM CPUs without support for the `vmull_p64` instruction. [#86521](https://github.com/ClickHouse/ClickHouse/pull/86521) ([Pablo Marcos](https://github.com/pamarcos)).
* Use `openldap` 2.6.10. [#86623](https://github.com/ClickHouse/ClickHouse/pull/86623) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Do not try to intercept `memalign` on darwin. [#86769](https://github.com/ClickHouse/ClickHouse/pull/86769) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Use `krb5` 1.22.1-final. [#86836](https://github.com/ClickHouse/ClickHouse/pull/86836) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Added missing Distributed Cache profile events. [#87283](https://github.com/ClickHouse/ClickHouse/pull/87283) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Fix unpacking Rust crate names in `list-licenses.sh`. [#87305](https://github.com/ClickHouse/ClickHouse/pull/87305) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Added missing Distributed cache throttlers references. [#87325](https://github.com/ClickHouse/ClickHouse/pull/87325) ([Pedro Ferreira](https://github.com/PedroTadim)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "try fix 00365_statistics_in_formats flakyness"'. [#86224](https://github.com/ClickHouse/ClickHouse/pull/86224) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'Revert "CI: Support for non-blocking job failures via new pipeline_status flag in GH Actions"'. [#86470](https://github.com/ClickHouse/ClickHouse/pull/86470) ([Max Kainov](https://github.com/maxknv)).
* NO CL ENTRY:  'Revert "Revert "CI: Support for non-blocking job failures via new pipeline_status flag in GH Actions""'. [#86475](https://github.com/ClickHouse/ClickHouse/pull/86475) ([Max Kainov](https://github.com/maxknv)).
* NO CL ENTRY:  'Revert "Fix key condition matches continuous range"'. [#86558](https://github.com/ClickHouse/ClickHouse/pull/86558) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* NO CL ENTRY:  'Forbid creating directories in non-user directories'. [#86844](https://github.com/ClickHouse/ClickHouse/pull/86844) ([scanhex12](https://github.com/scanhex12)).
* NO CL ENTRY:  'Revert "Iceberg + delta lake local and s3 disks"'. [#87051](https://github.com/ClickHouse/ClickHouse/pull/87051) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'Revert "Revert "Iceberg + delta lake local and s3 disks""'. [#87077](https://github.com/ClickHouse/ClickHouse/pull/87077) ([scanhex12](https://github.com/scanhex12)).
* NO CL ENTRY:  'Revert "aggregated zookeeper log"'. [#87185](https://github.com/ClickHouse/ClickHouse/pull/87185) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "Use Analyzer to generate actions from default expression"'. [#87229](https://github.com/ClickHouse/ClickHouse/pull/87229) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* NO CL ENTRY:  'Revert "CI: Fix log export configuration"'. [#87339](https://github.com/ClickHouse/ClickHouse/pull/87339) ([Max Kainov](https://github.com/maxknv)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Add a test for [#12286](https://github.com/ClickHouse/ClickHouse/issues/12286). [#80082](https://github.com/ClickHouse/ClickHouse/pull/80082) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Dump pipeline with metrics in logs after query is finished. Like this:. [#84096](https://github.com/ClickHouse/ClickHouse/pull/84096) ([李扬](https://github.com/taiyang-li)).
* Fix docs typos. [#84181](https://github.com/ClickHouse/ClickHouse/pull/84181) ([Alexey Khatskevich](https://github.com/Khatskevich)).
* Fix data race in DatabaseAtomic::drop and DatabaseOnDisk::drop. [#84481](https://github.com/ClickHouse/ClickHouse/pull/84481) ([Konstantin Morozov](https://github.com/k-morozov)).
* Add Nessie catalog integration tests for ClickHouse Iceberg support. [#85128](https://github.com/ClickHouse/ClickHouse/pull/85128) ([Somrat Dutta](https://github.com/somratdutta)).
* CI: Support for non-blocking job failures via new pipeline_status flag in GH Actions. [#85361](https://github.com/ClickHouse/ClickHouse/pull/85361) ([Max Kainov](https://github.com/maxknv)).
* CI: Refactor Compatibility check job. [#85639](https://github.com/ClickHouse/ClickHouse/pull/85639) ([Max Kainov](https://github.com/maxknv)).
* Use `chcache` in CI. [#85686](https://github.com/ClickHouse/ClickHouse/pull/85686) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* fix typos. [#85980](https://github.com/ClickHouse/ClickHouse/pull/85980) ([Philip Dubé](https://github.com/serprex)).
* Add concurrency benchmarking tool. [#86009](https://github.com/ClickHouse/ClickHouse/pull/86009) ([Sergei Trifonov](https://github.com/serxa)).
* Data Lakes fun. [#86042](https://github.com/ClickHouse/ClickHouse/pull/86042) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Fix deadlock in PipelineExecutor downscaling logic. [#86089](https://github.com/ClickHouse/ClickHouse/pull/86089) ([Sergei Trifonov](https://github.com/serxa)).
* Re-introduce [#80179](https://github.com/ClickHouse/ClickHouse/issues/80179). [#86095](https://github.com/ClickHouse/ClickHouse/pull/86095) ([Nikita Taranov](https://github.com/nickitat)).
* Fix use-after-free in parquet reader v3. [#86099](https://github.com/ClickHouse/ClickHouse/pull/86099) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix parquet reader v3 incorrectly skipping pages after prewhere. [#86100](https://github.com/ClickHouse/ClickHouse/pull/86100) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix double free in parquet reader v3 finishRowSubgroupStage. [#86105](https://github.com/ClickHouse/ClickHouse/pull/86105) ([Michael Kolupaev](https://github.com/al13n321)).
* Accept string values for allow_experimental_analyzer/enable_analyzer. [#86109](https://github.com/ClickHouse/ClickHouse/pull/86109) ([Azat Khuzhin](https://github.com/azat)).
* This closes [#85446](https://github.com/ClickHouse/ClickHouse/issues/85446). [#86116](https://github.com/ClickHouse/ClickHouse/pull/86116) ([scanhex12](https://github.com/scanhex12)).
* Update version after release. [#86118](https://github.com/ClickHouse/ClickHouse/pull/86118) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Follow-up for isValidASCII. [#86120](https://github.com/ClickHouse/ClickHouse/pull/86120) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Disable flaky test `02443_detach_attach_partition`. [#86128](https://github.com/ClickHouse/ClickHouse/pull/86128) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Text index: Some renamings in the C++ code. [#86131](https://github.com/ClickHouse/ClickHouse/pull/86131) ([Robert Schulze](https://github.com/rschu1ze)).
* Trivial count optimization in parquet reader v3. [#86144](https://github.com/ClickHouse/ClickHouse/pull/86144) ([Michael Kolupaev](https://github.com/al13n321)).
* Update README.md for Delhi, Pune, Bangkok meetups coming up. [#86146](https://github.com/ClickHouse/ClickHouse/pull/86146) ([Cheryl Tuquib](https://github.com/chetuquib)).
* Text index: small refactoring. [#86167](https://github.com/ClickHouse/ClickHouse/pull/86167) ([Robert Schulze](https://github.com/rschu1ze)).
* Add MT setting `max_digestion_size_per_segment` back, mark as obsolete. [#86170](https://github.com/ClickHouse/ClickHouse/pull/86170) ([Robert Schulze](https://github.com/rschu1ze)).
* Closes [#86134](https://github.com/ClickHouse/ClickHouse/issues/86134) Closes [#86133](https://github.com/ClickHouse/ClickHouse/issues/86133). [#86171](https://github.com/ClickHouse/ClickHouse/pull/86171) ([Pavel Kruglov](https://github.com/Avogar)).
* Update version_date.tsv and changelog after v25.5.10.95-stable. [#86173](https://github.com/ClickHouse/ClickHouse/pull/86173) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v25.7.5.34-stable. [#86176](https://github.com/ClickHouse/ClickHouse/pull/86176) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* `chcache`: add basic stats. [#86177](https://github.com/ClickHouse/ClickHouse/pull/86177) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Sync private. [#86203](https://github.com/ClickHouse/ClickHouse/pull/86203) ([Mikhail Artemenko](https://github.com/Michicosun)).
* `chcache`: collect more telemetry. [#86212](https://github.com/ClickHouse/ClickHouse/pull/86212) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Add test for [#70826](https://github.com/ClickHouse/ClickHouse/issues/70826). [#86223](https://github.com/ClickHouse/ClickHouse/pull/86223) ([Raúl Marín](https://github.com/Algunenano)).
* CI: Team notifications hook for the whole integrations team. [#86225](https://github.com/ClickHouse/ClickHouse/pull/86225) ([Mikhail Shustov](https://github.com/mshustov)).
* Fix some settings in 25.8. [#86226](https://github.com/ClickHouse/ClickHouse/pull/86226) ([Raúl Marín](https://github.com/Algunenano)).
* Add all fields of DataSourceDescription in its toString() to help debug. [#86229](https://github.com/ClickHouse/ClickHouse/pull/86229) ([Pablo Marcos](https://github.com/pamarcos)).
* Add EXPERIMENTAL flag to input_format_parquet_use_native_reader_v3 setting. [#86237](https://github.com/ClickHouse/ClickHouse/pull/86237) ([Michael Kolupaev](https://github.com/al13n321)).
* ci: add separate test "OOM in dmesg" in case of OOM in integration tests. [#86242](https://github.com/ClickHouse/ClickHouse/pull/86242) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix 00076_system_columns_bytes flakiness by excluding Merge tables. [#86245](https://github.com/ClickHouse/ClickHouse/pull/86245) ([Azat Khuzhin](https://github.com/azat)).
* ci: increase stop_grace_period for clickhouse containers to allow gdb finish. [#86246](https://github.com/ClickHouse/ClickHouse/pull/86246) ([Azat Khuzhin](https://github.com/azat)).
* CI: Add logs in Install check. [#86257](https://github.com/ClickHouse/ClickHouse/pull/86257) ([Max Kainov](https://github.com/maxknv)).
* CI: Build all targets in amd_compat. [#86258](https://github.com/ClickHouse/ClickHouse/pull/86258) ([Max Kainov](https://github.com/maxknv)).
* Update build check section in CI docs. [#86259](https://github.com/ClickHouse/ClickHouse/pull/86259) ([Max Kainov](https://github.com/maxknv)).
* Changing the query comment to `testcase-database` can help with flaky checks. [#86267](https://github.com/ClickHouse/ClickHouse/pull/86267) ([Mikhail Artemenko](https://github.com/Michicosun)).
* CI: Add clean up for docker buildx kit. [#86269](https://github.com/ClickHouse/ClickHouse/pull/86269) ([Max Kainov](https://github.com/maxknv)).
* Make a test a bit faster for debug builds. [#86272](https://github.com/ClickHouse/ClickHouse/pull/86272) ([Raúl Marín](https://github.com/Algunenano)).
* Disable `use_skip_indexes_on_data_read` by default. https://github.com/ClickHouse/ClickHouse/pull/81526 is merged with this setting enabled to do more thorough testing. cc @CurtizJ. [#86273](https://github.com/ClickHouse/ClickHouse/pull/86273) ([Amos Bird](https://github.com/amosbird)).
* Fix race condition in async insert tests and flushing asynchronous_insert_log. [#86280](https://github.com/ClickHouse/ClickHouse/pull/86280) ([Raúl Marín](https://github.com/Algunenano)).
* Fix consistency for Time64 encoding. [#86301](https://github.com/ClickHouse/ClickHouse/pull/86301) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* In this PR https://github.com/ClickHouse/ClickHouse/pull/85177, when acquiring the DB lock, we had retrying logic and threw `ErrorCodes::TIMEOUT_EXCEEDED` when it fails. [#86321](https://github.com/ClickHouse/ClickHouse/pull/86321) ([Tuan Pham Anh](https://github.com/tuanpach)).
* ci: fix integration tests execution time and some other improvements around. [#86329](https://github.com/ClickHouse/ClickHouse/pull/86329) ([Azat Khuzhin](https://github.com/azat)).
* Fix test_multiple_disks::test_system_tables. [#86338](https://github.com/ClickHouse/ClickHouse/pull/86338) ([Nikita Taranov](https://github.com/nickitat)).
* Closes [#84577](https://github.com/ClickHouse/ClickHouse/issues/84577). [#86354](https://github.com/ClickHouse/ClickHouse/pull/86354) ([Pavel Kruglov](https://github.com/Avogar)).
* Sync private. [#86359](https://github.com/ClickHouse/ClickHouse/pull/86359) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Add some more tests for SEMI joins. [#86368](https://github.com/ClickHouse/ClickHouse/pull/86368) ([Nikita Taranov](https://github.com/nickitat)).
* Fix `03580_improve_prewhere`. [#86388](https://github.com/ClickHouse/ClickHouse/pull/86388) ([Nikita Taranov](https://github.com/nickitat)).
* Fix ReadFromFormatInfo serialization. [#86397](https://github.com/ClickHouse/ClickHouse/pull/86397) ([Michael Kolupaev](https://github.com/al13n321)).
* fix typo in comment weekly_official_docker.yml. [#86404](https://github.com/ClickHouse/ClickHouse/pull/86404) ([Sergio de Cristofaro](https://github.com/serdec)).
* Update version_date.tsv and changelog after v25.8.1.5101-lts. [#86405](https://github.com/ClickHouse/ClickHouse/pull/86405) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* More verbose error in Iceberg Manifest File Initialization. [#86409](https://github.com/ClickHouse/ClickHouse/pull/86409) ([Daniil Ivanik](https://github.com/divanik)).
* Update README.md for Beijing, Singapore and Melbourne meetups. [#86412](https://github.com/ClickHouse/ClickHouse/pull/86412) ([Cheryl Tuquib](https://github.com/chetuquib)).
* CI: Rewrite perl whitespace check to py. [#86417](https://github.com/ClickHouse/ClickHouse/pull/86417) ([Max Kainov](https://github.com/maxknv)).
* More data lakes catalogs debugging. [#86418](https://github.com/ClickHouse/ClickHouse/pull/86418) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Closes [#86389](https://github.com/ClickHouse/ClickHouse/issues/86389). [#86421](https://github.com/ClickHouse/ClickHouse/pull/86421) ([Pavel Kruglov](https://github.com/Avogar)).
* Minor cleanup around memory tracking and not while reading the code. [#86423](https://github.com/ClickHouse/ClickHouse/pull/86423) ([Azat Khuzhin](https://github.com/azat)).
* CI: Fix sqlancer job. [#86427](https://github.com/ClickHouse/ClickHouse/pull/86427) ([Max Kainov](https://github.com/maxknv)).
* Better style for reading. [#86428](https://github.com/ClickHouse/ClickHouse/pull/86428) ([yanglongwei](https://github.com/ylw510)).
* Allow to start ttl drop merge for parts of any size. [#86439](https://github.com/ClickHouse/ClickHouse/pull/86439) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Fix messages like this. [#86441](https://github.com/ClickHouse/ClickHouse/pull/86441) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Remove redudant cgroup_memory_watcher_{soft,hard}_limit_ratio server settings. [#86458](https://github.com/ClickHouse/ClickHouse/pull/86458) ([Azat Khuzhin](https://github.com/azat)).
* Add a stress test for approximate vector search. [#86472](https://github.com/ClickHouse/ClickHouse/pull/86472) ([Shankar Iyer](https://github.com/shankar-iyer)).
* ci: increase waiting for gdb to collect stacktraces in integration tests during hangs. [#86474](https://github.com/ClickHouse/ClickHouse/pull/86474) ([Azat Khuzhin](https://github.com/azat)).
* Revert workaround for reading pass EOF (there was a bug in a kernel that returns EINVAL on 3.14..5.9). [#86483](https://github.com/ClickHouse/ClickHouse/pull/86483) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Mute `-Wmissing-noreturn`. [#86497](https://github.com/ClickHouse/ClickHouse/pull/86497) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Sync private. [#86514](https://github.com/ClickHouse/ClickHouse/pull/86514) ([Raúl Marín](https://github.com/Algunenano)).
* Update version_date.tsv and changelog after v25.6.9.98-stable. [#86522](https://github.com/ClickHouse/ClickHouse/pull/86522) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Add a test for file pruning with s3 + hive style partitioning. [#86523](https://github.com/ClickHouse/ClickHouse/pull/86523) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update version_date.tsv and changelog after v25.7.6.21-stable. [#86524](https://github.com/ClickHouse/ClickHouse/pull/86524) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* CI: Ensure changed files are stored in workflow data. [#86530](https://github.com/ClickHouse/ClickHouse/pull/86530) ([Max Kainov](https://github.com/maxknv)).
* Do not obtain mutations for index analysis if skip indexes is not in use. [#86537](https://github.com/ClickHouse/ClickHouse/pull/86537) ([Azat Khuzhin](https://github.com/azat)).
* Fix test_storage_delta/test.py::test_concurrent_queries. [#86545](https://github.com/ClickHouse/ClickHouse/pull/86545) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Check feature flag when adding RemoveRecursive request to Multi. [#86554](https://github.com/ClickHouse/ClickHouse/pull/86554) ([Antonio Andelic](https://github.com/antonio2368)).
* Add missing changelog entry for 25.8. [#86555](https://github.com/ClickHouse/ClickHouse/pull/86555) ([Pavel Kruglov](https://github.com/Avogar)).
* Unrevert "Fix key condition matches continuous range". [#86574](https://github.com/ClickHouse/ClickHouse/pull/86574) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix flaky `test_keeper_reconfig_remove`. [#86617](https://github.com/ClickHouse/ClickHouse/pull/86617) ([Antonio Andelic](https://github.com/antonio2368)).
* Better exception message on different path formats. This closes [#85409](https://github.com/ClickHouse/ClickHouse/issues/85409). [#86621](https://github.com/ClickHouse/ClickHouse/pull/86621) ([scanhex12](https://github.com/scanhex12)).
* Fixing keep-alive on inter-server calls. [#86631](https://github.com/ClickHouse/ClickHouse/pull/86631) ([Sema Checherinda](https://github.com/CheSema)).
* Fix check_cpp.sh not detecting multiline comments. [#86646](https://github.com/ClickHouse/ClickHouse/pull/86646) ([Michael Kolupaev](https://github.com/al13n321)).
* Sync private changes. [#86659](https://github.com/ClickHouse/ClickHouse/pull/86659) ([Antonio Andelic](https://github.com/antonio2368)).
* Deduplicate zookeeper watches (v2). [#86660](https://github.com/ClickHouse/ClickHouse/pull/86660) ([Azat Khuzhin](https://github.com/azat)).
* Add new allocation profiling docs. [#86662](https://github.com/ClickHouse/ClickHouse/pull/86662) ([Antonio Andelic](https://github.com/antonio2368)).
* Close [#83977](https://github.com/ClickHouse/ClickHouse/issues/83977). [#86663](https://github.com/ClickHouse/ClickHouse/pull/86663) ([Vladimir Cherkasov](https://github.com/vdimir)).
* More data lakes testing. [#86666](https://github.com/ClickHouse/ClickHouse/pull/86666) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Update version_date.tsv and changelog after v25.8.2.29-lts. [#86668](https://github.com/ClickHouse/ClickHouse/pull/86668) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* CI: Retry specific error in docker build. [#86682](https://github.com/ClickHouse/ClickHouse/pull/86682) ([Max Kainov](https://github.com/maxknv)).
* CI: Fix stress azure job. [#86697](https://github.com/ClickHouse/ClickHouse/pull/86697) ([Max Kainov](https://github.com/maxknv)).
* ci: increase timeout for build jobs (temporary solution). [#86722](https://github.com/ClickHouse/ClickHouse/pull/86722) ([Azat Khuzhin](https://github.com/azat)).
* Fix test. [#86737](https://github.com/ClickHouse/ClickHouse/pull/86737) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix test_jemalloc_global_profiler. [#86739](https://github.com/ClickHouse/ClickHouse/pull/86739) ([Antonio Andelic](https://github.com/antonio2368)).
* Better integration iceberg tests structure. [#86745](https://github.com/ClickHouse/ClickHouse/pull/86745) ([Daniil Ivanik](https://github.com/divanik)).
* CI: Support requesting multiple AWS params at once, fix throttling. [#86747](https://github.com/ClickHouse/ClickHouse/pull/86747) ([Max Kainov](https://github.com/maxknv)).
* Few fuzzer fixes. [#86749](https://github.com/ClickHouse/ClickHouse/pull/86749) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Rewrite several delta lake tests without spark. [#86752](https://github.com/ClickHouse/ClickHouse/pull/86752) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Propely set source relation to 1 to right side of join. [#86765](https://github.com/ClickHouse/ClickHouse/pull/86765) ([Alexander Gololobov](https://github.com/davenger)).
* More forward declarations around HashTables and Enums. [#86781](https://github.com/ClickHouse/ClickHouse/pull/86781) ([Azat Khuzhin](https://github.com/azat)).
* Fix bad log message. [#86782](https://github.com/ClickHouse/ClickHouse/pull/86782) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* This closes [#86683](https://github.com/ClickHouse/ClickHouse/issues/86683). [#86784](https://github.com/ClickHouse/ClickHouse/pull/86784) ([scanhex12](https://github.com/scanhex12)).
* Bump usearch from 2.19.1 to v2.21.0. [#86790](https://github.com/ClickHouse/ClickHouse/pull/86790) ([Robert Schulze](https://github.com/rschu1ze)).
* Sync MergeTreeReaderSettings::create() with private. [#86794](https://github.com/ClickHouse/ClickHouse/pull/86794) ([Azat Khuzhin](https://github.com/azat)).
* [cleanup] Replace StringRef with std::string_view in Keeper. [#86796](https://github.com/ClickHouse/ClickHouse/pull/86796) ([Antonio Andelic](https://github.com/antonio2368)).
* Remove redundant mutability in `SerializationMap` deserialization. [#86798](https://github.com/ClickHouse/ClickHouse/pull/86798) ([Raufs Dunamalijevs](https://github.com/rienath)).
* CI: Support batch request for GH secrets or vars. [#86811](https://github.com/ClickHouse/ClickHouse/pull/86811) ([Max Kainov](https://github.com/maxknv)).
* Update README.md for Tokyo meetup in September. [#86818](https://github.com/ClickHouse/ClickHouse/pull/86818) ([Cheryl Tuquib](https://github.com/chetuquib)).
* Return fallback for schema resolution for a manifest file entry. [#86832](https://github.com/ClickHouse/ClickHouse/pull/86832) ([Daniil Ivanik](https://github.com/divanik)).
* Just move, nothing more. [#86842](https://github.com/ClickHouse/ClickHouse/pull/86842) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Lower the alignment for the graph allocator in usearch. [#86843](https://github.com/ClickHouse/ClickHouse/pull/86843) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Update s3_queue_common.py. [#86847](https://github.com/ClickHouse/ClickHouse/pull/86847) ([Kseniia Sumarokova](https://github.com/kssenii)).
* CI: Add stress tests with s3. [#86849](https://github.com/ClickHouse/ClickHouse/pull/86849) ([Max Kainov](https://github.com/maxknv)).
* Fix missing closing parenthesis in `AVX_FUNCTION_SPECIFIC_ATTRIBUTE` macro. [#86881](https://github.com/ClickHouse/ClickHouse/pull/86881) ([Raufs Dunamalijevs](https://github.com/rienath)).
* Update version_date.tsv and changelog after v25.6.10.16-stable. [#86883](https://github.com/ClickHouse/ClickHouse/pull/86883) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update delta-kernel to v0.15.2. [#86893](https://github.com/ClickHouse/ClickHouse/pull/86893) ([Kseniia Sumarokova](https://github.com/kssenii)).
* PR: fix n-way join with GLOBAL join. [#86895](https://github.com/ClickHouse/ClickHouse/pull/86895) ([Igor Nikonov](https://github.com/devcrafter)).
* Remove gin index. [#86896](https://github.com/ClickHouse/ClickHouse/pull/86896) ([Robert Schulze](https://github.com/rschu1ze)).
* CI: Fix artifact download error. [#86898](https://github.com/ClickHouse/ClickHouse/pull/86898) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* allow increment CurrentMetrics::end(). [#86899](https://github.com/ClickHouse/ClickHouse/pull/86899) ([Sema Checherinda](https://github.com/CheSema)).
* pull out parser from UsersConfigAccessStorage. [#86909](https://github.com/ClickHouse/ClickHouse/pull/86909) ([Krishna Mannem](https://github.com/kcmannem)).
* ITableFunction: Enforce that the engine name is found when checking permissions. [#86962](https://github.com/ClickHouse/ClickHouse/pull/86962) ([Raúl Marín](https://github.com/Algunenano)).
* Update README.md. [#86968](https://github.com/ClickHouse/ClickHouse/pull/86968) ([Zoe Steinkamp](https://github.com/zoesteinkamp)).
* Use stdin/stdout/stderr fd instead of /dev/tty when possible. [#86970](https://github.com/ClickHouse/ClickHouse/pull/86970) ([Michael Kolupaev](https://github.com/al13n321)).
* CI: git unshallow for both parents in ci. [#86991](https://github.com/ClickHouse/ClickHouse/pull/86991) ([Max Kainov](https://github.com/maxknv)).
* Update version_date.tsv and changelog after v25.6.11.18-stable. [#87002](https://github.com/ClickHouse/ClickHouse/pull/87002) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Remove code which looks really stupid. [#87011](https://github.com/ClickHouse/ClickHouse/pull/87011) ([alesapin](https://github.com/alesapin)).
* `isIPAddressInRange`: Rename file after the function it contains. [#87017](https://github.com/ClickHouse/ClickHouse/pull/87017) ([Robert Schulze](https://github.com/rschu1ze)).
* CI: Switch build cache to sccache. [#87021](https://github.com/ClickHouse/ClickHouse/pull/87021) ([Max Kainov](https://github.com/maxknv)).
* `Clickhouse` -> `ClickHouse`. [#87023](https://github.com/ClickHouse/ClickHouse/pull/87023) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Move common code to base class. [#87048](https://github.com/ClickHouse/ClickHouse/pull/87048) ([Anton Popov](https://github.com/CurtizJ)).
* add private server setting os_threads_nice_value_distributed_cache_tcp_handler. [#87050](https://github.com/ClickHouse/ClickHouse/pull/87050) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Parallel Replicas: fix join with group by in subquery. [#87090](https://github.com/ClickHouse/ClickHouse/pull/87090) ([Igor Nikonov](https://github.com/devcrafter)).
* tests: disable 02700_s3_part_INT_MAX for slow builds. [#87105](https://github.com/ClickHouse/ClickHouse/pull/87105) ([Azat Khuzhin](https://github.com/azat)).
* Update Community Call links and dates. [#87107](https://github.com/ClickHouse/ClickHouse/pull/87107) ([Raúl Marín](https://github.com/Algunenano)).
* Revert "Make today() and yesterday() functions case insensitive". [#87108](https://github.com/ClickHouse/ClickHouse/pull/87108) ([Bharat Nallan](https://github.com/bharatnc)).
* Improve --help for status/start/restart/stop. [#87116](https://github.com/ClickHouse/ClickHouse/pull/87116) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v25.6.12.10-stable. [#87170](https://github.com/ClickHouse/ClickHouse/pull/87170) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v25.8.3.66-lts. [#87171](https://github.com/ClickHouse/ClickHouse/pull/87171) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Remove test_disks_app_interactive from parallel integration tests execution. [#87194](https://github.com/ClickHouse/ClickHouse/pull/87194) ([Daniil Ivanik](https://github.com/divanik)).
* Add better exception about column mapper inconsistency in parquet reader. [#87196](https://github.com/ClickHouse/ClickHouse/pull/87196) ([Daniil Ivanik](https://github.com/divanik)).
* Add a test for GHSA-m53h-672c-wqqr. [#87215](https://github.com/ClickHouse/ClickHouse/pull/87215) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#58243](https://github.com/ClickHouse/ClickHouse/issues/58243). [#87216](https://github.com/ClickHouse/ClickHouse/pull/87216) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#7341](https://github.com/ClickHouse/ClickHouse/issues/7341). [#87217](https://github.com/ClickHouse/ClickHouse/pull/87217) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#41127](https://github.com/ClickHouse/ClickHouse/issues/41127). [#87218](https://github.com/ClickHouse/ClickHouse/pull/87218) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#46698](https://github.com/ClickHouse/ClickHouse/issues/46698). [#87219](https://github.com/ClickHouse/ClickHouse/pull/87219) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Fix log export configuration. [#87240](https://github.com/ClickHouse/ClickHouse/pull/87240) ([Max Kainov](https://github.com/maxknv)).
* Increase look back log lines. [#87243](https://github.com/ClickHouse/ClickHouse/pull/87243) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Update version_date.tsv and changelog after v25.8.4.13-lts. [#87278](https://github.com/ClickHouse/ClickHouse/pull/87278) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Backported in [#87507](https://github.com/ClickHouse/ClickHouse/issues/87507): Change `datalake_disk_name` to `disk`. [#87388](https://github.com/ClickHouse/ClickHouse/pull/87388) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#87505](https://github.com/ClickHouse/ClickHouse/issues/87505): Rename settings and change defaults. [#87389](https://github.com/ClickHouse/ClickHouse/pull/87389) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#87483](https://github.com/ClickHouse/ClickHouse/issues/87483): Fix settings changes test for backup_slow_all_threads_after_retryable_s3_error. [#87449](https://github.com/ClickHouse/ClickHouse/pull/87449) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#87504](https://github.com/ClickHouse/ClickHouse/issues/87504): EmbeddedRocksDB: Go back to using data/ path by default. [#87463](https://github.com/ClickHouse/ClickHouse/pull/87463) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#87634](https://github.com/ClickHouse/ClickHouse/issues/87634): Revert "Query condition cache: introduce selectivity threshold". [#87498](https://github.com/ClickHouse/ClickHouse/pull/87498) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#87659](https://github.com/ClickHouse/ClickHouse/issues/87659): Fix usage of text index with expressions. [#87590](https://github.com/ClickHouse/ClickHouse/pull/87590) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#87686](https://github.com/ClickHouse/ClickHouse/issues/87686): Rename the log level settings from startupLevel and shutdownLevel to startup_level and shutdown_level to match the general settings format. [#87624](https://github.com/ClickHouse/ClickHouse/pull/87624) ([Nikita Fomichev](https://github.com/fm4v)).
* Backported in [#87650](https://github.com/ClickHouse/ClickHouse/issues/87650): make os_thread_priority alias on os_threads_nice_value_query. [#87629](https://github.com/ClickHouse/ClickHouse/pull/87629) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Backport to 25.9: Revert "Merge pull request [#76569](https://github.com/ClickHouse/ClickHouse/issues/76569) from RinChanNOWWW/alias". [#87712](https://github.com/ClickHouse/ClickHouse/pull/87712) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
