---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.8.11.66-lts (fa393206741) FIXME as compared to v25.8.10.7-lts (02ec3a1ea1e)

#### Improvement
* Backported in [#88492](https://github.com/ClickHouse/ClickHouse/issues/88492): Use S3 storage client with backup-specific settings (for example, backup_slow_all_threads_after_retryable_s3_error) for server-side (native) copy to a backup destination. Make s3_slow_all_threads_after_retryable_error obsolete. [#87660](https://github.com/ClickHouse/ClickHouse/pull/87660) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#88537](https://github.com/ClickHouse/ClickHouse/issues/88537): Add more information for performance tracking in Iceberg SELECTs. [#87903](https://github.com/ClickHouse/ClickHouse/pull/87903) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#88300](https://github.com/ClickHouse/ClickHouse/issues/88300): Update azure sdk to include 'Content-Length' fix that is seen with copy and create container functionalities. [#88278](https://github.com/ClickHouse/ClickHouse/pull/88278) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Backported in [#88742](https://github.com/ClickHouse/ClickHouse/issues/88742): Add config `keeper_server.coordination_settings.check_node_acl_on_remove`. If enabled, before each delete of a node, ACLs of both the node itself and parent node will be verified. Otherwise, only the ACL of the parent node will be verified. [#88513](https://github.com/ClickHouse/ClickHouse/pull/88513) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#88781](https://github.com/ClickHouse/ClickHouse/issues/88781): Fixes memory leak due to `GLOBAL IN` (https://github.com/ClickHouse/ClickHouse/issues/88615). [#88617](https://github.com/ClickHouse/ClickHouse/pull/88617) ([pranavmehta94](https://github.com/pranavmehta94)).
* Backported in [#88764](https://github.com/ClickHouse/ClickHouse/issues/88764): Add a step to postinstall script for `clickhouse-keeper` which enables starting on boot. [#88746](https://github.com/ClickHouse/ClickHouse/pull/88746) ([YenchangChan](https://github.com/YenchangChan)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#88848](https://github.com/ClickHouse/ClickHouse/issues/88848): Fix inferring Date/DateTime/DateTime64 on dates that are out of supported range. [#86184](https://github.com/ClickHouse/ClickHouse/pull/86184) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#88594](https://github.com/ClickHouse/ClickHouse/issues/88594): Fix resolving table schema with `url()` table function when `parallel_replicas_for_cluster_functions` setting is set to 1. [#87029](https://github.com/ClickHouse/ClickHouse/pull/87029) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#88843](https://github.com/ClickHouse/ClickHouse/issues/88843): Fix unknown table error in insert select query with CTE, [#85368](https://github.com/ClickHouse/ClickHouse/issues/85368). [#87789](https://github.com/ClickHouse/ClickHouse/pull/87789) ([Guang Zhao](https://github.com/zheguang)).
* Backported in [#88509](https://github.com/ClickHouse/ClickHouse/issues/88509): Fix reading null map subcolumn from Variants that cannot be inside Nullable. [#87798](https://github.com/ClickHouse/ClickHouse/pull/87798) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#88390](https://github.com/ClickHouse/ClickHouse/issues/88390): In AzureBlobStorage, updated to try native copy first and go to read & write on 'Unauthroized' error (In AzureBlobStorage, if storage accounts are different for source & destination we get 'Unauthorized' error). And fix applying "use_native_copy" when endpoint is defined in configuration. [#87826](https://github.com/ClickHouse/ClickHouse/pull/87826) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Backported in [#88436](https://github.com/ClickHouse/ClickHouse/issues/88436): Fix for incorrect granules/partitions elimination for datetime-based keys, when using `session_timezone` setting in queries. [#87987](https://github.com/ClickHouse/ClickHouse/pull/87987) ([Eduard Karacharov](https://github.com/korowa)).
* Backported in [#88420](https://github.com/ClickHouse/ClickHouse/issues/88420): Applies URI normalization before evaluation for the grants check introduced by https://github.com/ClickHouse/ClickHouse/pull/84503. [#88089](https://github.com/ClickHouse/ClickHouse/pull/88089) ([pufit](https://github.com/pufit)).
* Backported in [#88656](https://github.com/ClickHouse/ClickHouse/issues/88656): Now DDL worker cleanup outdated hosts from replicas set. It will reduce amount of stored metadata in ZooKeeper. [#88154](https://github.com/ClickHouse/ClickHouse/pull/88154) ([alesapin](https://github.com/alesapin)).
* Backported in [#88284](https://github.com/ClickHouse/ClickHouse/issues/88284): Fixed propagation of `is_shared` flag in `ColumnLowCardinality`. It may lead to a wrong group-by result if a new value is inserted in a column after hash values are already pre-calculated and cached in the `ReverseIndex`. [#88213](https://github.com/ClickHouse/ClickHouse/pull/88213) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#88459](https://github.com/ClickHouse/ClickHouse/issues/88459): Fixes a workload setting `max_cpu_share`. Now it can be used without `max_cpus` workload setting being set. [#88217](https://github.com/ClickHouse/ClickHouse/pull/88217) ([Neerav](https://github.com/neeravsalaria)).
* Backported in [#88336](https://github.com/ClickHouse/ClickHouse/issues/88336): Now correlated subqueries will work with object storages. [#88290](https://github.com/ClickHouse/ClickHouse/pull/88290) ([alesapin](https://github.com/alesapin)).
* Backported in [#88356](https://github.com/ClickHouse/ClickHouse/issues/88356): Avoid trying to initialize DataLake databases while accessing `system.projections` and `system.data_skipping_indices`. [#88330](https://github.com/ClickHouse/ClickHouse/pull/88330) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#88430](https://github.com/ClickHouse/ClickHouse/issues/88430): Fix quadratic complexity in the `countMatches` function. Closes [#88400](https://github.com/ClickHouse/ClickHouse/issues/88400). [#88401](https://github.com/ClickHouse/ClickHouse/pull/88401) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#88649](https://github.com/ClickHouse/ClickHouse/issues/88649): Big clusters with node numbers > 10 have a high probability of failing the restore with error `[941] 67c45db4-4df4-4879-87c5-25b8d1e0d414 <Trace>: RestoreCoordinationOnCluster The version of node /clickhouse/backups/restore-7c551a77-bd76-404c-bad0-3213618ac58e/stage/num_hosts changed (attempt #9), will try again`. The `num_hosts` node is overwritten by many hosts at the same time. The fix makes the setting to control attempts dynamic. Closes [#87721](https://github.com/ClickHouse/ClickHouse/issues/87721). [#88484](https://github.com/ClickHouse/ClickHouse/pull/88484) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Backported in [#88716](https://github.com/ClickHouse/ClickHouse/issues/88716): Fix potential crash caused by concurrent mutation of underlying const PREWHERE columns. [#88605](https://github.com/ClickHouse/ClickHouse/pull/88605) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#88906](https://github.com/ClickHouse/ClickHouse/issues/88906): After recovering, a Replicated database replica might get stuck for a long time printing messages like `Failed to marked query-0004647339 as finished (finished=No node, synced=No node)`, it's fixed. [#88671](https://github.com/ClickHouse/ClickHouse/pull/88671) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#88890](https://github.com/ClickHouse/ClickHouse/issues/88890): Fixes access validation on select for `loop` table function. [#88802](https://github.com/ClickHouse/ClickHouse/pull/88802) ([pufit](https://github.com/pufit)).
* Backported in [#88835](https://github.com/ClickHouse/ClickHouse/issues/88835): Catch exceptions when async logging fails to prevent program aborts. [#88814](https://github.com/ClickHouse/ClickHouse/pull/88814) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#88940](https://github.com/ClickHouse/ClickHouse/issues/88940): Fix bug in the function `reverseUTF8`. In previous versions, it mistakenly reversed the bytes of UTF-8 code points of length 4. This closes [#88913](https://github.com/ClickHouse/ClickHouse/issues/88913). [#88914](https://github.com/ClickHouse/ClickHouse/pull/88914) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#88976](https://github.com/ClickHouse/ClickHouse/issues/88976): Do not check access `SET DEFINER <current_user>:definer` when creating a view with SQL SECURITY DEFINER. [#88968](https://github.com/ClickHouse/ClickHouse/pull/88968) ([pufit](https://github.com/pufit)).

#### NO CL CATEGORY

* Backported in [#88952](https://github.com/ClickHouse/ClickHouse/issues/88952):. [#88828](https://github.com/ClickHouse/ClickHouse/pull/88828) ([scanhex12](https://github.com/scanhex12)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#87948](https://github.com/ClickHouse/ClickHouse/issues/87948): Fix bool decoding in parquet reader v3. [#87442](https://github.com/ClickHouse/ClickHouse/pull/87442) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#88451](https://github.com/ClickHouse/ClickHouse/issues/88451): fix threads count for inserts. [#88339](https://github.com/ClickHouse/ClickHouse/pull/88339) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#88581](https://github.com/ClickHouse/ClickHouse/issues/88581): Fix `ColumnBLOB should be converted to a regular column before usage` from `CREATE AS SELECT`. [#88544](https://github.com/ClickHouse/ClickHouse/pull/88544) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#88961](https://github.com/ClickHouse/ClickHouse/issues/88961): Add profiling and logging on merge destruction. [#88672](https://github.com/ClickHouse/ClickHouse/pull/88672) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).

