---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.8.1.5101-lts (4f2b50b8c92) FIXME as compared to v25.8.1.1-new (d4d4c9f77fa)

#### Backward Incompatible Change
* Disable quoting 64 bit integers in JSON formats by default. [#74079](https://github.com/ClickHouse/ClickHouse/pull/74079) ([Pavel Kruglov](https://github.com/Avogar)).
* Infer `Array(Dynamic)` instead of unnamed `Tuple` for arrays of values with different types in JSON. To use previous behaviour, disable setting `input_format_json_infer_array_of_dynamic_from_array_of_different_types`. [#80859](https://github.com/ClickHouse/ClickHouse/pull/80859) ([Pavel Kruglov](https://github.com/Avogar)).
* Move S3 latency metrics to histograms for homogeneity and simplicity. [#82305](https://github.com/ClickHouse/ClickHouse/pull/82305) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Require backticks around identifiers with dots in default expressions to prevent them from being parsed as compound identifiers. [#83162](https://github.com/ClickHouse/ClickHouse/pull/83162) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Lazy materialization is enabled only with analyzer to avoid maintenance without analyzer, — which, in our experience, have some issues (for example, when using `indexHint()` in conditions). [#83791](https://github.com/ClickHouse/ClickHouse/pull/83791) ([Igor Nikonov](https://github.com/devcrafter)).
* Write values of `Enum` type as `BYTE_ARRAY` with `ENUM` logical type in Parquet output format by default. [#84169](https://github.com/ClickHouse/ClickHouse/pull/84169) ([Pavel Kruglov](https://github.com/Avogar)).
* Enable MergeTree setting `write_marks_for_substreams_in_compact_parts` by default. It significantly improves performance of subcolumns reading from newly created Compact parts. Servers with version less then 25.5 won't be able to read new Compact parts. [#84171](https://github.com/ClickHouse/ClickHouse/pull/84171) ([Pavel Kruglov](https://github.com/Avogar)).
* The previous `concurrent_threads_scheduler` default value was `round_robin`, which proved unfair in the presence of a high number of single-threaded queries (e.g., INSERTs). This change makes a safer alternative `fair_round_robin` scheduler, the default. [#84747](https://github.com/ClickHouse/ClickHouse/pull/84747) ([Sergei Trifonov](https://github.com/serxa)).
* ClickHouse supports PostgreSQL-style heredoc syntax: `$tag$ string contents... $tag$`, also known as dollar-quoted string literals. In previous versions, there were fewer restrictions on tags: they could contain arbitrary characters, including punctuation and whitespace. This introduces parsing ambiguity with identifiers that can also start with a dollar character. At the same time, PostgreSQL only allows word characters for tags. To resolve the problem, we now restrict heredoc tags only to contain word characters. Closes [#84731](https://github.com/ClickHouse/ClickHouse/issues/84731). [#84846](https://github.com/ClickHouse/ClickHouse/pull/84846) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The functions `azureBlobStorage`, `deltaLakeAzure`, and `icebergAzure` have been updated to properly validate `AZURE` permissions. All cluster-variant functions (`-Cluster` functions) now verify permissions against their corresponding non-clustered counterparts. Additionally, the `icebergLocal` and `deltaLakeLocal` functions now enforce `FILE` permission checks. [#84938](https://github.com/ClickHouse/ClickHouse/pull/84938) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Enables allow_dynamic_metadata_for_data_lakes setting (Table Engine level setting) by default. [#85044](https://github.com/ClickHouse/ClickHouse/pull/85044) ([Daniil Ivanik](https://github.com/divanik)).

#### New Feature
* Not only for Merge tables, but all tables support the _table virtual column. [#63665](https://github.com/ClickHouse/ClickHouse/pull/63665) ([Xiaozhe Yu](https://github.com/wudidapaopao)).
* System table to keep erroneous incoming messages from engines like kafka. [#68873](https://github.com/ClickHouse/ClickHouse/pull/68873) ([Ilya Golshtein](https://github.com/ilejn)).
* This PR introduces the restore database replica functionality for replicated databases, similar to the existing functionality for restore in ReplicatedMergeTree. [#73100](https://github.com/ClickHouse/ClickHouse/pull/73100) ([Konstantin Morozov](https://github.com/k-morozov)).
* Implement support for [ArrowFlight RPC](https://arrow.apache.org/docs/format/Flight.html) protocol by adding: - new table function `arrowflight()`: ``` SELECT * FROM arrowflight('host:port', 'dataset_name') ```. [#74184](https://github.com/ClickHouse/ClickHouse/pull/74184) ([zakr600](https://github.com/zakr600)).
* PostgreSQL protocol `COPY` command support. [#74344](https://github.com/ClickHouse/ClickHouse/pull/74344) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Basic support for the PromQL dialect is added. To use it, set `dialect='promql'` in clickhouse-client, point it to the TimeSeries table using the setting `promql_table_name='X'` and execute queries like `rate(ClickHouseProfileEvents_ReadCompressedBytes[1m])[5m:1m]`. In addition you can wrap the PromQL query with SQL: `SELECT * FROM prometheusQuery('up', ...);`. So far only functions `rate`, `delta` and `increase` are supported. No unary/binary operators. No HTTP API. [#75036](https://github.com/ClickHouse/ClickHouse/pull/75036) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add support for hive partition style writes and refactor reads implementation (hive partition columns are no longer virtual). [#76802](https://github.com/ClickHouse/ClickHouse/pull/76802) ([Arthur Passos](https://github.com/arthurpassos)).
* Add `zookeeper_connection_log` system table to store historical information about ZooKeeper connections. [#79494](https://github.com/ClickHouse/ClickHouse/pull/79494) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Server setting `cpu_slot_preemption` enables preemptive CPU scheduling for workloads and ensures max-min fair allocation of CPU time among workloads. New workload settings for CPU throttling are added: `max_cpus`, `max_cpu_share` and `max_burst_cpu_seconds`. More details: https://clickhouse.com/docs/operations/workload-scheduling#cpu_scheduling. [#80879](https://github.com/ClickHouse/ClickHouse/pull/80879) ([Sergei Trifonov](https://github.com/serxa)).
* Drop TCP connection after configured number of queries or time threshold. Resolves [#68000](https://github.com/ClickHouse/ClickHouse/issues/68000). [#81472](https://github.com/ClickHouse/ClickHouse/pull/81472) ([Kenny Sun](https://github.com/hwabis)).
* Reading from projections is implemented for parallel replicas. A new setting `parallel_replicas_support_projection` has been added to control whether projection support is enabled. To simplify the implementation, support for projection is only enabled when `parallel_replicas_local_plan` is active. [#82807](https://github.com/ClickHouse/ClickHouse/pull/82807) ([zoomxi](https://github.com/zoomxi)).
* Support DESCRIBE SELECT in addition to DESCRIBE (SELECT ...). [#82947](https://github.com/ClickHouse/ClickHouse/pull/82947) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Force secure connection for mysql_port and postgresql_port. [#82962](https://github.com/ClickHouse/ClickHouse/pull/82962) ([tiandiwonder](https://github.com/tiandiwonder)).
* Support position deletes for Iceberg TableEngine. [#83094](https://github.com/ClickHouse/ClickHouse/pull/83094) ([Daniil Ivanik](https://github.com/divanik)).
* Users can now do case-insensitive JSON key lookups using `JSONExtractCaseInsensitive` (and other variants of `JSONExtract`). [#83770](https://github.com/ClickHouse/ClickHouse/pull/83770) ([Alistair Evans](https://github.com/alistairjevans)).
* AI Powered SQL generation can now infer from env ANTHROPIC_API_KEY and OPENAI_API_KEY if available, this is to make it so that we can have a zero config option to use this feature. [#83787](https://github.com/ClickHouse/ClickHouse/pull/83787) ([Kaushik Iska](https://github.com/iskakaushik)).
* Introduction of `system.completions` table. Closes [#81889](https://github.com/ClickHouse/ClickHouse/issues/81889). [#83833](https://github.com/ClickHouse/ClickHouse/pull/83833) ([|2ustam](https://github.com/RuS2m)).
* Iceberg writes for create. Closes [#83927](https://github.com/ClickHouse/ClickHouse/issues/83927). [#83983](https://github.com/ClickHouse/ClickHouse/pull/83983) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Glue catalogs for writes. [#84136](https://github.com/ClickHouse/ClickHouse/pull/84136) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Added a new function `nowInBlock64`. Example usage: `SELECT nowInBlock64(6)` returns `2025-07-29 17:09:37.775725`. [#84178](https://github.com/ClickHouse/ClickHouse/pull/84178) ([Halersson Paris](https://github.com/halersson)).
* Add extra_credentials to AzureBlobStorage to authenticate with client_id and tenant_id. [#84235](https://github.com/ClickHouse/ClickHouse/pull/84235) ([Pablo Marcos](https://github.com/pamarcos)).
* Added function `dateTimeToUUIDv7` to convert a DateTime value to a UUIDv7. Example usage: `SELECT dateTimeToUUIDv7(toDateTime('2025-08-15 18:57:56'))` returns `0198af18-8320-7a7d-abd3-358db23b9d5c`. [#84319](https://github.com/ClickHouse/ClickHouse/pull/84319) ([samradovich](https://github.com/samradovich)).
* `timeSeriesDerivToGrid` and `timeSeriesPredictLinearToGrid` aggregate functions to re-sample data to a time grid defined by the specified start timestamp, end timestamp, and step; calculates PromQL-like `deriv` and `predict_linear`, respectively. [#84328](https://github.com/ClickHouse/ClickHouse/pull/84328) ([Stephen Chi](https://github.com/stephchi0)).
* Support C# client for mysql protocol. This closes [#83992](https://github.com/ClickHouse/ClickHouse/issues/83992). [#84397](https://github.com/ClickHouse/ClickHouse/pull/84397) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* New syntax added `GRANT READ ON S3('s3://foo/.*') TO user`. [#84503](https://github.com/ClickHouse/ClickHouse/pull/84503) ([pufit](https://github.com/pufit)).
* Added `Hash` as a new output format. It calculates a single hash value for all columns and rows of the result. This is useful for calculating a "fingerprint" of the result, for example, in use cases where data transfer is a bottleneck. Example: `SELECT arrayJoin(['abc', 'def']), 42 FORMAT Hash` returns `e5f9e676db098fdb9530d2059d8c23ef`. [#84607](https://github.com/ClickHouse/ClickHouse/pull/84607) ([Robert Schulze](https://github.com/rschu1ze)).
* Iceberg Rest catalogs for writes. [#84684](https://github.com/ClickHouse/ClickHouse/pull/84684) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Add the ability to set up arbitrary watches in Keeper Multi queries. [#84964](https://github.com/ClickHouse/ClickHouse/pull/84964) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Merge all iceberg position delete files into data files. This will reduce amount and sizes of parquet files in iceberg storage. Syntax: `OPTIMIZE TABLE table_name`. [#85250](https://github.com/ClickHouse/ClickHouse/pull/85250) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Support partially aggregated metrics. [#85328](https://github.com/ClickHouse/ClickHouse/pull/85328) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Support `drop table` for iceberg (Removing from REST/Glue catalogs + removing metadata about table). [#85395](https://github.com/ClickHouse/ClickHouse/pull/85395) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Support alter delete mutations for iceberg in merge-on-read format. [#85549](https://github.com/ClickHouse/ClickHouse/pull/85549) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Support writes into DeltaLake. Closes [#79603](https://github.com/ClickHouse/ClickHouse/issues/79603). [#85564](https://github.com/ClickHouse/ClickHouse/pull/85564) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Write more iceberg statistics (column sizes, lower and upper bounds) in metadata (manifest entries) for min-max pruning. [#85746](https://github.com/ClickHouse/ClickHouse/pull/85746) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Support add/drop/modify columns in iceberg for simple types. [#85769](https://github.com/ClickHouse/ClickHouse/pull/85769) ([Konstantin Vedernikov](https://github.com/scanhex12)).

#### Experimental Feature
* Ytsaurus table engine and table function. [#77606](https://github.com/ClickHouse/ClickHouse/pull/77606) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Moved catalog to beta. [#85848](https://github.com/ClickHouse/ClickHouse/pull/85848) ([Melvyn Peignon](https://github.com/melvynator)).
* Lightweight updates moved to the Beta stage from Experimental. [#85952](https://github.com/ClickHouse/ClickHouse/pull/85952) ([Anton Popov](https://github.com/CurtizJ)).

#### Performance Improvement
* `azureBlobStorage` table engine: cache and reuse managed identity authentication tokens when possible to avoid throttling. [#79860](https://github.com/ClickHouse/ClickHouse/pull/79860) ([Nick Blakely](https://github.com/niblak)).
* Added new logic (controlled by the setting `enable_producing_buckets_out_of_order_in_aggregation`, enabled by default) that allows sending some buckets out of order during memory-efficient aggregation. When some aggregation buckets take significantly longer to merge than others, it improves performance by allowing the initiator to merge buckets with higher bucket id-s in the meantime. The downside is potentially higher memory usage (shouldn't be significant). [#80179](https://github.com/ClickHouse/ClickHouse/pull/80179) ([Nikita Taranov](https://github.com/nickitat)).
* New parquet reader implementation. It's generally faster and supports page-level filter pushdown and PREWHERE. Currently experimental. Use setting `input_format_parquet_use_native_reader_v3` to enable. [#82789](https://github.com/ClickHouse/ClickHouse/pull/82789) ([Michael Kolupaev](https://github.com/al13n321)).
* Process `max_joined_block_rows` outside of hash JOIN main loop. Slightly better performance for ALL JOIN. [#83216](https://github.com/ClickHouse/ClickHouse/pull/83216) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Replace curl http client with poco http client for azure blob storage. Introduced multiple settings for this clients which mirror settings from S3. Introduced aggressive connect timeouts for both Azure and S3. Improved introspection into Azure profile events and metrics. New client is enabled by default, provide much better latencies for cold queries on top of Azure Blob Storage. Old `Curl` client can be returned back by setting `azure_sdk_use_native_client=false`. [#83294](https://github.com/ClickHouse/ClickHouse/pull/83294) ([alesapin](https://github.com/alesapin)).
* Significantly improve performance of `JSON` subcolumns reading from shared data in MergeTree by implementing new serializations for `JSON` shared data in MergeTree. [#83777](https://github.com/ClickHouse/ClickHouse/pull/83777) ([Pavel Kruglov](https://github.com/Avogar)).
* Process higher granularity min-max indexes first. Closes [#75381](https://github.com/ClickHouse/ClickHouse/issues/75381). [#83798](https://github.com/ClickHouse/ClickHouse/pull/83798) ([Maruth Goyal](https://github.com/maruthgoyal)).
* Vector search queries using a vector similarity index complete with lower latency due to reduced storage reads and reduced CPU usage. [#83803](https://github.com/ClickHouse/ClickHouse/pull/83803) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Implement addManyDefaults for If combinators. [#83870](https://github.com/ClickHouse/ClickHouse/pull/83870) ([Raúl Marín](https://github.com/Algunenano)).
* Calculate serialized key columnarly when group by multiple string or number columns. [#83884](https://github.com/ClickHouse/ClickHouse/pull/83884) ([李扬](https://github.com/taiyang-li)).
* Try -falign-functions=64 in attempt for more stable perf tests. [#83920](https://github.com/ClickHouse/ClickHouse/pull/83920) ([Azat Khuzhin](https://github.com/azat)).
* The bloom filter index is now used for conditions like `has([c1, c2, ...], column)`, where `column` is not of an `Array` type. This improves performance for such queries, making them as efficient as the `IN` operator. [#83945](https://github.com/ClickHouse/ClickHouse/pull/83945) ([Doron David](https://github.com/dorki)).
* Reduce unnecessary memcpy calls in CompressedReadBufferBase::readCompressedData. [#83986](https://github.com/ClickHouse/ClickHouse/pull/83986) ([Raúl Marín](https://github.com/Algunenano)).
* `All` `LEFT/INNER` JOINs will be automatically converted to `RightAny` if the right side is functionally determined by the join key columns (all rows have unique join key values). [#84010](https://github.com/ClickHouse/ClickHouse/pull/84010) ([Nikita Taranov](https://github.com/nickitat)).
* Processes indexes in increasing order of file size. The net index ordering prioritizes minmax and vector indexes (due to simplicity and selectivity respectively), and small indexes thereafter. Within the minmax/vector indexes smaller indexes are also preferred. [#84094](https://github.com/ClickHouse/ClickHouse/pull/84094) ([Maruth Goyal](https://github.com/maruthgoyal)).
* Optimize `largestTriangleThreeBuckets` by removing temporary data. [#84479](https://github.com/ClickHouse/ClickHouse/pull/84479) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Optimize string deserialization by simplifying the code. Closes [#38564](https://github.com/ClickHouse/ClickHouse/issues/38564). [#84561](https://github.com/ClickHouse/ClickHouse/pull/84561) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Previously, the text index data would be separated into multiple segments (each segment size by default was 256 MiB). This might reduce the memory consumption while building the text index, however this increases the space requirement on the disk and increase the query response time. [#84590](https://github.com/ClickHouse/ClickHouse/pull/84590) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Fixed the calculation of the minimal task size for parallel replicas. [#84752](https://github.com/ClickHouse/ClickHouse/pull/84752) ([Nikita Taranov](https://github.com/nickitat)).
* Improved performance of applying patch parts in `Join` mode. [#85040](https://github.com/ClickHouse/ClickHouse/pull/85040) ([Anton Popov](https://github.com/CurtizJ)).
* Remove zero byte. Closes [#85062](https://github.com/ClickHouse/ClickHouse/issues/85062). A few minor bugs were fixed. Functions `structureToProtobufSchema`, `structureToCapnProtoSchema` didn't correctly put a zero-terminating byte and were using a newline instead of it. That was leading to a missing newline in the output, and could lead to buffer overflows while using other functions that depend on the zero byte (such as `logTrace`, `demangle`, `extractURLParameter`, `toStringCutToZero`, and `encrypt`/`decrypt`). The `regexp_tree` dictionary layout didn't support processing strings with zero bytes. The `formatRowNoNewline` function, called with `Values` format or with any other format without a newline at the end of rows, erroneously cuts the last character of the output. Function `stem` contained an exception-safety error that could lead to a memory leak in a very rare scenario. The `initcap` function worked in the wrong way for `FixedString` arguments: it didn't recognize the start of the word at the start of the string if the previous string in a block ended with a word character. Fixed a security vulnerability of the Apache `ORC` format, which could lead to the exposure of uninitialized memory. Changed behavior of the function `replaceRegexpAll` and the corresponding alias, `REGEXP_REPLACE`: now it can do an empty match at the end of the string even if the previous match processed the whole string, such as in the case of `^a*|a*$` or `^|.*` - this corresponds to the semantic of JavaScript, Perl, Python, PHP, Ruby, but differs to the semantic of PostgreSQL. Implementation of many functions has been simplified and optimized. Documentation for several functions was wrong and has now been fixed. Keep in mind that the output of `byteSize` for String columns and complex types, which consisted of String columns, has changed (from 9 bytes per empty string to 8 bytes per empty string), and this is normal. [#85063](https://github.com/ClickHouse/ClickHouse/pull/85063) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Optimize the materialization of constants in cases when we do this materialization only to return a single row. [#85071](https://github.com/ClickHouse/ClickHouse/pull/85071) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve parallel files processing with delta-kernel-rs backend. [#85642](https://github.com/ClickHouse/ClickHouse/pull/85642) ([Azat Khuzhin](https://github.com/azat)).

#### Improvement
* Show the number of ranges to be read in the output of `EXPLAIN indexes = 1`. [#79938](https://github.com/ClickHouse/ClickHouse/pull/79938) ([Christoph Wurm](https://github.com/cwurm)).
* Introduce settings to set ORC compression block size, and update its default value from 64KB to 256KB to keep consistent with spark or hive. [#80602](https://github.com/ClickHouse/ClickHouse/pull/80602) ([李扬](https://github.com/taiyang-li)).
* Add `columns_substreams.txt` file to Wide part to track all substreams stored in the part. It helps to track dynamic streams in JSON and Dynamic types and so avoid reading sample of these columns to get the list of dynamic streams (for example for columns sizes calculation). Also now all dynamic streams are reflected in `system.parts_columns`. [#81091](https://github.com/ClickHouse/ClickHouse/pull/81091) ([Pavel Kruglov](https://github.com/Avogar)).
* Add a CLI flag --show_secrets to clickhouse format to hide sensitive data by default. [#81524](https://github.com/ClickHouse/ClickHouse/pull/81524) ([Nikolai Ryzhov](https://github.com/Dolaxom)).
* S3 read and write requests are throttled on the HTTP socket level (instead of whole S3 requests) to avoid issues with `max_remote_read_network_bandwidth_for_server` and `max_remote_write_network_bandwidth_for_server` throttling. [#81837](https://github.com/ClickHouse/ClickHouse/pull/81837) ([Sergei Trifonov](https://github.com/serxa)).
* A new setting, enable_add_distinct_to_in_subqueries, has been introduced. When enabled, ClickHouse will automatically add DISTINCT to subqueries in IN clauses for distributed queries. This can significantly reduce the size of temporary tables transferred between shards and improve network efficiency. Note: This is a trade-off—while network transfer is reduced, additional merging (deduplication) work is required on each node. Enable this setting when network transfer is a bottleneck and the merging cost is acceptable. [#81908](https://github.com/ClickHouse/ClickHouse/pull/81908) ([fhw12345](https://github.com/fhw12345)).
* Introduced the `optimize_rewrite_regexp_functions` setting (enabled by default), which allows the optimizer to rewrite certain `replaceRegexpAll`, `replaceRegexpOne`, and `extract` calls into simpler and more efficient forms when specific regular expression patterns are detected. (issue [#81981](https://github.com/ClickHouse/ClickHouse/issues/81981)). [#81992](https://github.com/ClickHouse/ClickHouse/pull/81992) ([Amos Bird](https://github.com/amosbird)).
* Rendezvous hashing for improve cache locality. [#82511](https://github.com/ClickHouse/ClickHouse/pull/82511) ([Anton Ivashkin](https://github.com/ianton-ru)).
* Allow to mix different collations for the same column in different windows. [#82877](https://github.com/ClickHouse/ClickHouse/pull/82877) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Add support of `remote-()` table functions with parallel replicas if cluster is provided in `address_expression` argument. Also, fixes [#73295](https://github.com/ClickHouse/ClickHouse/issues/73295). [#82904](https://github.com/ClickHouse/ClickHouse/pull/82904) ([Igor Nikonov](https://github.com/devcrafter)).
* Set all log messages for writing backup files to TRACE. [#82907](https://github.com/ClickHouse/ClickHouse/pull/82907) ([Hans Krutzer](https://github.com/hkrutzer)).
* User-defined functions with unusual names and codecs can be formatted inconsistently by the SQL formatter. This closes [#83092](https://github.com/ClickHouse/ClickHouse/issues/83092). [#83644](https://github.com/ClickHouse/ClickHouse/pull/83644) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Users can now use Time and Time64 types inside the JSON type. [#83784](https://github.com/ClickHouse/ClickHouse/pull/83784) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Joins with parallel replicas now use the join logical step. In case of any issues with join queries using parallel replicas, try `SET query_plan_use_new_logical_join_step=0` and report an issue. [#83801](https://github.com/ClickHouse/ClickHouse/pull/83801) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Add `max_joined_block_size_bytes` in addition to `max_joined_block_size_rows` to limit the memory usage of JOINs with heavy columns. [#83869](https://github.com/ClickHouse/ClickHouse/pull/83869) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Reduce query memory tracking overhead for executable user-defined functions. [#83929](https://github.com/ClickHouse/ClickHouse/pull/83929) ([Eduard Karacharov](https://github.com/korowa)).
* Fix compatibility for cluster_function_process_archive_on_multiple_nodes. [#83968](https://github.com/ClickHouse/ClickHouse/pull/83968) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Support changing mv insert settings on `S3Queue` table level. Added new `S3Queue` level settings: `min_insert_block_size_rows_for_materialized_views` and `min_insert_block_size_bytes_for_materialized_views`. By default profile level settings will be used and `S3Queue` level settings will override those. [#83971](https://github.com/ClickHouse/ClickHouse/pull/83971) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Added profile event `MutationAffectedRowsUpperBound` that shows the number of affected rows in a mutation (e.g., the total number of rows that satisfy the condition in `ALTER UPDATE` or `ALTER DELETE` query. [#83978](https://github.com/ClickHouse/ClickHouse/pull/83978) ([Anton Popov](https://github.com/CurtizJ)).
* Use information from cgroup (if applicable, i.e. `memory_worker_use_cgroup` and cgroups are available) to adjust memory tracker (`memory_worker_correct_memory_tracker`). [#83981](https://github.com/ClickHouse/ClickHouse/pull/83981) ([Azat Khuzhin](https://github.com/azat)).
* Splits FormatParserGroup on two independent structs, the first one is responsible for shared compute and IO resources, the second one is responsible for shared filter resources (filter ActionDag, KeyCondition). This is done for more flexible shared usage of these structures by different threads. [#83997](https://github.com/ClickHouse/ClickHouse/pull/83997) ([Daniil Ivanik](https://github.com/divanik)).
* Implement internal `delta-kernel-rs` filtering (statistics and partition pruning) in storage `DeltaLake`. [#84006](https://github.com/ClickHouse/ClickHouse/pull/84006) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Implement AWS S3 authentication with an explicitly provided IAM role. Implement OAuth for GCS. These features were recently only available in ClickHouse Cloud and are now open-sourced. Synchronize some interfaces such as serialization of the connection parameters for object storages. [#84011](https://github.com/ClickHouse/ClickHouse/pull/84011) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Made the table columns in the web UI (play) resizable. [#84012](https://github.com/ClickHouse/ClickHouse/pull/84012) ([Doron David](https://github.com/dorki)).
* MongoDB: Implicit parsing of strings to numeric types. Previously, if a string value was received from a MongoDB source for a numeric column in a ClickHouse table, an exception was thrown. Now, the engine attempts to parse the numeric value from the string automatically. Closes [#81167](https://github.com/ClickHouse/ClickHouse/issues/81167). [#84069](https://github.com/ClickHouse/ClickHouse/pull/84069) ([Kirill Nikiforov](https://github.com/allmazz)).
* Highlight digit groups in `Pretty` formats for `Nullable` numbers. [#84070](https://github.com/ClickHouse/ClickHouse/pull/84070) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Dashboard: the tooltip will not overflow the container at the top. [#84072](https://github.com/ClickHouse/ClickHouse/pull/84072) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Slightly better-looking dots on the dashboard. [#84074](https://github.com/ClickHouse/ClickHouse/pull/84074) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Dashboard now has a slightly better favicon. [#84076](https://github.com/ClickHouse/ClickHouse/pull/84076) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* All the allocations done by external libraries are now visible to ClickHouse's memory tracker and accounted properly. This may result in "increased" reported memory usage for certain queries or failures with `MEMORY_LIMIT_EXCEEDED`. [#84082](https://github.com/ClickHouse/ClickHouse/pull/84082) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Web UI: Give browsers a chance to save the password. Also, it will remember the URL values. [#84087](https://github.com/ClickHouse/ClickHouse/pull/84087) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add support for applying extra ACL on specific Keeper nodes using `apply_to_children` config. [#84137](https://github.com/ClickHouse/ClickHouse/pull/84137) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix usage of "compact" Variant discriminators serialization in MergeTree. Perviously it wasn't used in some cases when it could be used. [#84141](https://github.com/ClickHouse/ClickHouse/pull/84141) ([Pavel Kruglov](https://github.com/Avogar)).
* Added a server setting, `logs_to_keep` to database replicated settings, that allows changing the default `logs_to_keep` parameter for replicated databases. Lower values reduce the number of ZNodes (especially if there are many databases), while higher values allow a missing replica to catch up after a longer period of time. [#84183](https://github.com/ClickHouse/ClickHouse/pull/84183) ([Alexey Khatskevich](https://github.com/Khatskevich)).
* Add a setting `json_type_escape_dots_in_keys` to escape dots in JSON keys during JSON type parsing. The setting is disabled by default. [#84207](https://github.com/ClickHouse/ClickHouse/pull/84207) ([Pavel Kruglov](https://github.com/Avogar)).
* Check if connection is cancelled before checking for EOF to prevent reading from closed connection. Fixes [#83893](https://github.com/ClickHouse/ClickHouse/issues/83893). [#84227](https://github.com/ClickHouse/ClickHouse/pull/84227) ([Raufs Dunamalijevs](https://github.com/rienath)).
* Disable skipping indexes that depend on columns updated on the fly or by patch parts more granularly. Now, skipping indexes are not used only in parts affected by on-the-fly mutations or patch parts; previously, those indexes were disabled for all parts. [#84241](https://github.com/ClickHouse/ClickHouse/pull/84241) ([Anton Popov](https://github.com/CurtizJ)).
* Slightly better colors of text selection in Web UI. The difference is significant only for selected table cells in the dark mode. In previous versions, there was not enough contrast between the text and the selection background. [#84258](https://github.com/ClickHouse/ClickHouse/pull/84258) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improved server shutdown handling for client connections by simplifying internal checks. [#84312](https://github.com/ClickHouse/ClickHouse/pull/84312) ([Raufs Dunamalijevs](https://github.com/rienath)).
* Added a setting `delta_lake_enable_expression_visitor_logging` to turn off expression visitor logs as they can be too verbose even for test log level when debugging something. [#84315](https://github.com/ClickHouse/ClickHouse/pull/84315) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Cgroup-level and system-wide metrics are reported now altogether. Cgroup-level metrics have names `CGroup<Metric>` and OS-level metrics (collected from procfs) have names `OS<Metric>`. [#84317](https://github.com/ClickHouse/ClickHouse/pull/84317) ([Nikita Taranov](https://github.com/nickitat)).
* Slightly better charts in Web UI. Not much, but better. [#84326](https://github.com/ClickHouse/ClickHouse/pull/84326) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Change the default of the Replicated database setting `max_retries_before_automatic_recovery` to 10, so it will recover faster in some cases. [#84369](https://github.com/ClickHouse/ClickHouse/pull/84369) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix formatting of CREATE USER with query parameters (i.e. `CREATE USER {username:Identifier} IDENTIFIED WITH no_password`). [#84376](https://github.com/ClickHouse/ClickHouse/pull/84376) ([Azat Khuzhin](https://github.com/azat)).
* Replace tab characters with spaces when pasting in interactive clickhouse-client. Closes [#83922](https://github.com/ClickHouse/ClickHouse/issues/83922). [#84412](https://github.com/ClickHouse/ClickHouse/pull/84412) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Introduce `backup_restore_s3_retry_initial_backoff_ms`, `backup_restore_s3_retry_max_backoff_ms`, `backup_restore_s3_retry_jitter_factor` to configure the S3 retry backoff strategy used during backup and restore operations. [#84421](https://github.com/ClickHouse/ClickHouse/pull/84421) ([Julia Kartseva](https://github.com/jkartseva)).
* Allocate the minimum amount of memory needed for encrypted_buffer for encrypted named collections. [#84432](https://github.com/ClickHouse/ClickHouse/pull/84432) ([Pablo Marcos](https://github.com/pamarcos)).
* S3Queue ordered mode fix: quit earlier if shutdown was called. [#84463](https://github.com/ClickHouse/ClickHouse/pull/84463) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Support iceberg writes to read from pyiceberg. [#84466](https://github.com/ClickHouse/ClickHouse/pull/84466) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Allow set values type casting when pushing down `IN` / `GLOBAL IN` filters over KeyValue storage primary keys (e.g., EmbeddedRocksDB, KeeperMap). [#84515](https://github.com/ClickHouse/ClickHouse/pull/84515) ([Eduard Karacharov](https://github.com/korowa)).
* Bump chdig to [25.7.1](https://github.com/azat/chdig/releases/tag/v25.7.1). [#84521](https://github.com/ClickHouse/ClickHouse/pull/84521) ([Azat Khuzhin](https://github.com/azat)).
* Low-level errors during UDF execution now fail with error code `UDF_EXECUTION_FAILED`, whereas previously different error codes could be returned. [#84547](https://github.com/ClickHouse/ClickHouse/pull/84547) ([Xu Jia](https://github.com/XuJia0210)).
* Add `get_acl` command to KeeperClient. [#84641](https://github.com/ClickHouse/ClickHouse/pull/84641) ([Antonio Andelic](https://github.com/antonio2368)).
* Adds snapshot version to data lake table engines. [#84659](https://github.com/ClickHouse/ClickHouse/pull/84659) ([Pete Hampton](https://github.com/pjhampton)).
* This change adds a dimensional metric for the size of `ConcurrentBoundedQueue`, labelled by the queue type (i.e. what the queue is there for) and queue id (i.e. randomly generated id for the current instance of the queue). [#84675](https://github.com/ClickHouse/ClickHouse/pull/84675) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* The `system.columns` table now provides `column` as an alias for the existing `name` column. [#84695](https://github.com/ClickHouse/ClickHouse/pull/84695) ([Yunchi Pang](https://github.com/yunchipang)).
* Improved support for bloom filter indexes (regular, ngram, and token) to be utilized when the first argument is a constant array (the set) and the second is the indexed column (the subset), enabling more efficient query execution. [#84700](https://github.com/ClickHouse/ClickHouse/pull/84700) ([Doron David](https://github.com/dorki)).
* New MergeTree setting `search_orphaned_parts_drives` to limit scope to look for parts e.g. by disks with local metadata. [#84710](https://github.com/ClickHouse/ClickHouse/pull/84710) ([Ilya Golshtein](https://github.com/ilejn)).
* Add 4LW in Keeper, `lgrq`, for toggling request logging of received requests. [#84719](https://github.com/ClickHouse/ClickHouse/pull/84719) ([Antonio Andelic](https://github.com/antonio2368)).
* Reduce contention on storage lock in Keeper. [#84732](https://github.com/ClickHouse/ClickHouse/pull/84732) ([Antonio Andelic](https://github.com/antonio2368)).
* Allow to use any storage policy (i.e. object storage, such as S3) for external aggregation/sorting. [#84734](https://github.com/ClickHouse/ClickHouse/pull/84734) ([Azat Khuzhin](https://github.com/azat)).
* Match external auth forward_headers in case-insensitive way. [#84737](https://github.com/ClickHouse/ClickHouse/pull/84737) ([ingodwerust](https://github.com/ingodwerust)).
* Views, created by ephemeral users, will now store a copy of an actual user and will no longer be invalidated after the ephemeral user is deleted. [#84763](https://github.com/ClickHouse/ClickHouse/pull/84763) ([pufit](https://github.com/pufit)).
* The `encrypt_decrypt` tool now supports encrypted ZooKeeper connections. [#84764](https://github.com/ClickHouse/ClickHouse/pull/84764) ([Roman Vasin](https://github.com/rvasin)).
* Add format string column to `system.errors`. This column is needed to group by the same error type in alerting rules. [#84776](https://github.com/ClickHouse/ClickHouse/pull/84776) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Updated `clickhouse-format` to accept `--highlight` as an alias for `--hilite`. - Updated `clickhouse-client` to accept `--hilite` as an alias for `--highlight`. - Updated `clickhouse-format` documentation to reflect the change. [#84806](https://github.com/ClickHouse/ClickHouse/pull/84806) ([Rishabh Bhardwaj](https://github.com/rishabh1815769)).
* Fix iceberg reading by field ids for complex types. [#84821](https://github.com/ClickHouse/ClickHouse/pull/84821) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Add missing support of `read_in_order_use_virtual_row` for `WHERE`. It allows to skip reading more parts for queries with filters that were not fully pushed to `PREWHERE`. [#84835](https://github.com/ClickHouse/ClickHouse/pull/84835) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Introduce a new `backup_slow_all_threads_after_retryable_s3_error` setting to reduce pressure on S3 during retry storms caused by errors such as `SlowDown`, by slowing down all threads once a single retryable error is observed. [#84854](https://github.com/ClickHouse/ClickHouse/pull/84854) ([Julia Kartseva](https://github.com/jkartseva)).
* Skip creating and renaming the old temp table of non-append RMV DDLs in Replicated DBs. [#84858](https://github.com/ClickHouse/ClickHouse/pull/84858) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Limit Keeper log entry cache size by number of entries using `keeper_server.coordination_settings.latest_logs_cache_entry_count_threshold` and `keeper_server.coordination_settings.commit_logs_cache_entry_count_threshold`. [#84877](https://github.com/ClickHouse/ClickHouse/pull/84877) ([Antonio Andelic](https://github.com/antonio2368)).
* Allow using `simdjson` on unsupported architectures (previously leads to `CANNOT_ALLOCATE_MEMORY` errors). [#84966](https://github.com/ClickHouse/ClickHouse/pull/84966) ([Azat Khuzhin](https://github.com/azat)).
* Eliminated full scans for the cases when index analysis results in empty ranges for parallel replicas reading. [#84971](https://github.com/ClickHouse/ClickHouse/pull/84971) ([Eduard Karacharov](https://github.com/korowa)).
* The vector similarity index now supports binary quantization. Binary quantization significantly reduces the memory consumption and speeds up the process of building a vector index (due to faster distance calculation). Also, the existing setting `vector_search_postfilter_multiplier `was made obsolete and replaced by a more general setting : `vector_search_index_fetch_multiplier`. [#85024](https://github.com/ClickHouse/ClickHouse/pull/85024) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Async log: Make limits tuneable and add introspection. [#85105](https://github.com/ClickHouse/ClickHouse/pull/85105) ([Raúl Marín](https://github.com/Algunenano)).
* Enable correlated subqueries support by default. [#85107](https://github.com/ClickHouse/ClickHouse/pull/85107) ([Dmitry Novik](https://github.com/novikd)).
* Add `database_replicated` settings defining the default values of DatabaseReplicatedSettings. If the setting is not present in the Replicated DB create query, the value from this setting is used. [#85127](https://github.com/ClickHouse/ClickHouse/pull/85127) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Iceberg: support writing version-hint file. This closes [#85097](https://github.com/ClickHouse/ClickHouse/issues/85097). [#85130](https://github.com/ClickHouse/ClickHouse/pull/85130) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Allow key value arguments in `s3` or `s3Cluster` table engine/function, e.g. for example `s3('url', CSV, structure = 'a Int32', compression_method = 'gzip')`. [#85134](https://github.com/ClickHouse/ClickHouse/pull/85134) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Support compressed `.metadata.json` file via `iceberg_metadata_compression_method` setting. It supports all clickhouse compression methods. This closes [#84895](https://github.com/ClickHouse/ClickHouse/issues/84895). [#85196](https://github.com/ClickHouse/ClickHouse/pull/85196) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Added setting `delta_lake_snapshot_version` to allow reading specific snapshot version in table engine `DeltaLake`. [#85295](https://github.com/ClickHouse/ClickHouse/pull/85295) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Collect all removed objects to execute single object storage remove operation. [#85316](https://github.com/ClickHouse/ClickHouse/pull/85316) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Iceberg's current implementation of positional delete files keeps all data in RAM. This can be quite expensive if the positional delete files are large, which is often the case. My implementation keeps only the last row-group of Parquet delete files in RAM, which is significantly cheaper. [#85329](https://github.com/ClickHouse/ClickHouse/pull/85329) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Chdig: fix leftovers on the screen, fix crash after edit query in editor, search in `path` for `editor`, update to [25.8.1](https://github.com/azat/chdig/releases/tag/v25.8.1). [#85341](https://github.com/ClickHouse/ClickHouse/pull/85341) ([Azat Khuzhin](https://github.com/azat)).
* Allows asynchronously iterating objects from Iceberg table without storing objects for each data file explicitly. [#85369](https://github.com/ClickHouse/ClickHouse/pull/85369) ([Daniil Ivanik](https://github.com/divanik)).
* Add missing `partition_columns_in_data_file` to azure configuration. [#85373](https://github.com/ClickHouse/ClickHouse/pull/85373) ([Arthur Passos](https://github.com/arthurpassos)).
* Allow zero step in functions `timeSeries*ToGrid()` This is part `#3` of https://github.com/ClickHouse/ClickHouse/pull/75036. [#85390](https://github.com/ClickHouse/ClickHouse/pull/85390) ([Vitaly Baranov](https://github.com/vitlibar)).
* Added show_data_lake_catalogs_in_system_tables flag to manage adding data lake tables in system.tables resolves [#85384](https://github.com/ClickHouse/ClickHouse/issues/85384). [#85411](https://github.com/ClickHouse/ClickHouse/pull/85411) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Add 2 new TimeSeries functions: - `timeSeriesRange(start_timestamp, end_timestamp, step)`, - `timeSeriesFromGrid(start_timestamp, end_timestamp, step, values)`,. [#85435](https://github.com/ClickHouse/ClickHouse/pull/85435) ([Vitaly Baranov](https://github.com/vitlibar)).
* Added support for macro expansion in `remote_fs_zero_copy_zookeeper_path`. [#85437](https://github.com/ClickHouse/ClickHouse/pull/85437) ([Mikhail Koviazin](https://github.com/mkmkme)).
* AI in clickhouse-client will look slightly better. [#85447](https://github.com/ClickHouse/ClickHouse/pull/85447) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Enable trace_log.symbolize for old deployments by default. [#85456](https://github.com/ClickHouse/ClickHouse/pull/85456) ([Azat Khuzhin](https://github.com/azat)).
* Execute non-correlated `EXISTS` as a scalar subquery. This allows using a scalar subquery cache and constant-folding the result, which is helpful for indexes. For compatibility, the new setting `execute_exists_as_scalar_subquery=1` is added. [#85481](https://github.com/ClickHouse/ClickHouse/pull/85481) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Support resolution of more cases for compound identifiers. Particularly, it improves the compatibility of `ARRAY JOIN` with the old analyzer. Introduce a new setting `analyzer_compatibility_allow_compound_identifiers_in_unflatten_nested` to keep the old behaviour. [#85492](https://github.com/ClickHouse/ClickHouse/pull/85492) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Adds an option `--max-concurrency` for the `clickhouse-benchmark` tool that enables a mode with a gradual increase in the number of parallel queries. [#85623](https://github.com/ClickHouse/ClickHouse/pull/85623) ([Sergei Trifonov](https://github.com/serxa)).
* Ignore UNKNOWN_DATABASE while obtaining table columns sizes for system.columns. [#85632](https://github.com/ClickHouse/ClickHouse/pull/85632) ([Azat Khuzhin](https://github.com/azat)).
* Added limit (table setting `max_uncompressed_bytes_in_patches`) for total uncompressed bytes in patch parts. It prevents significant slowdowns of SELECT queries after lightweight updates and prevents possible misuse of lightweight updates. [#85641](https://github.com/ClickHouse/ClickHouse/pull/85641) ([Anton Popov](https://github.com/CurtizJ)).
* Add a `parameter` column to `system.grants` to determine source type for `GRANT READ/WRITE` and the table engine for `GRANT TABLE ENGINE`. [#85643](https://github.com/ClickHouse/ClickHouse/pull/85643) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Fix parsing of a trailing comma in columns of the CREATE DICTIONARY query after a column with parameters, for example, Decimal(8). Closes [#85586](https://github.com/ClickHouse/ClickHouse/issues/85586). [#85653](https://github.com/ClickHouse/ClickHouse/pull/85653) ([Nikolay Degterinsky](https://github.com/evillique)).
* Support inner arrays for the function `nested`. [#85719](https://github.com/ClickHouse/ClickHouse/pull/85719) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Support Iceberg Equality Deletes. [#85843](https://github.com/ClickHouse/ClickHouse/pull/85843) ([Han Fei](https://github.com/hanfei1991)).
* Approximate vector search with vector similarity indexes is now GA. [#85888](https://github.com/ClickHouse/ClickHouse/pull/85888) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#86221](https://github.com/ClickHouse/ClickHouse/issues/86221): Slow down S3 client threads on retryable errors in S3 Object Storage. This extends the previous setting `backup_slow_all_threads_after_retryable_s3_error` to S3 disks and renames it to the more general `s3_slow_all_threads_after_retryable_error`. [#85918](https://github.com/ClickHouse/ClickHouse/pull/85918) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#86239](https://github.com/ClickHouse/ClickHouse/issues/86239): Mark settings allow_experimental_variant/dynamic/json and enable_variant/dynamic/json as obsolete. Now all three types are enabled unconditionally. [#85934](https://github.com/ClickHouse/ClickHouse/pull/85934) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86377](https://github.com/ClickHouse/ClickHouse/issues/86377): Improved S3(Azure)Queue table engine to allow it to survive zookeeper connection loss without potential duplicates. Requires enabling S3Queue setting `use_persistent_processing_nodes` (changeable by `ALTER TABLE MODIFY SETTING`). [#85995](https://github.com/ClickHouse/ClickHouse/pull/85995) ([Kseniia Sumarokova](https://github.com/kssenii)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Make `DISTINCT` window aggregates run in linear time and fix a bug in `sumDistinct`. Closes [#79792](https://github.com/ClickHouse/ClickHouse/issues/79792). Closes [#52253](https://github.com/ClickHouse/ClickHouse/issues/52253). [#79859](https://github.com/ClickHouse/ClickHouse/pull/79859) ([Nihal Z. Miaji](https://github.com/nihalzp)).
* This pr fixes the metadata resolution when querying iceberg tables through rest catalog. ... [#80562](https://github.com/ClickHouse/ClickHouse/pull/80562) ([Saurabh Kumar Ojha](https://github.com/saurabhojha)).
* Fix markReplicasActive in DDLWorker and DatabaseReplicatedDDLWorker. [#81395](https://github.com/ClickHouse/ClickHouse/pull/81395) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fix rollback of Dynamic column on parsing failure. [#82169](https://github.com/ClickHouse/ClickHouse/pull/82169) ([Pavel Kruglov](https://github.com/Avogar)).
* If function `trim` called with all-constant inputs now produces a constant output string. (Bug [#78796](https://github.com/ClickHouse/ClickHouse/issues/78796)). [#82900](https://github.com/ClickHouse/ClickHouse/pull/82900) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix logical error with duplicate subqueries when `optimize_syntax_fuse_functions` is enabled, close [#75511](https://github.com/ClickHouse/ClickHouse/issues/75511). [#83300](https://github.com/ClickHouse/ClickHouse/pull/83300) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fixed incorrect result of queries with `WHERE ... IN (<subquery>)` clause and enabled query condition cache (setting `use_query_condition_cache`). [#83445](https://github.com/ClickHouse/ClickHouse/pull/83445) ([LB7666](https://github.com/acking-you)).
* Historically, `gcs` function did not require any access to use. Now it will check `GRANT READ ON S3` permission for usage. Closes [#70567](https://github.com/ClickHouse/ClickHouse/issues/70567). [#83503](https://github.com/ClickHouse/ClickHouse/pull/83503) ([pufit](https://github.com/pufit)).
* Skip unavailable nodes during INSERT SELECT from s3Cluster() into replicated MergeTree. [#83676](https://github.com/ClickHouse/ClickHouse/pull/83676) ([Igor Nikonov](https://github.com/devcrafter)).
* Fix write with append (in MergeTree used for experimental transactions) with `plain_rewritable`/`plain` metadata types, previously they were simply ignored. [#83695](https://github.com/ClickHouse/ClickHouse/pull/83695) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Mask Avro schema registry authentication details to be not visible to user or in logs. [#83713](https://github.com/ClickHouse/ClickHouse/pull/83713) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Fix the issue where, if a MergeTree table is created with `add_minmax_index_for_numeric_columns=1` or `add_minmax_index_for_string_columns=1`, the index is later materialized during an ALTER operation, and it prevents the Replicated database from initializing correctly on a new replica. [#83751](https://github.com/ClickHouse/ClickHouse/pull/83751) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fixed parquet writer outputting incorrect statistics (min/max) for Decimal types. [#83754](https://github.com/ClickHouse/ClickHouse/pull/83754) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix sort of NaN values in `LowCardinality(Float32|Float64|BFloat16)` type. [#83786](https://github.com/ClickHouse/ClickHouse/pull/83786) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* When restoring from backup, the definer user may not be backed up, which will cause the whole backup to be broken. To fix this, we postpone the permissions check on the target table's creation during restore and only check it during runtime. [#83818](https://github.com/ClickHouse/ClickHouse/pull/83818) ([pufit](https://github.com/pufit)).
* Fix crash in client due to connection left in disconnected state after bad INSERT. [#83842](https://github.com/ClickHouse/ClickHouse/pull/83842) ([Azat Khuzhin](https://github.com/azat)).
* Allow referencing any table in `view(...)` argument of `remote` table function with enabled analyzer. Fixes [#78717](https://github.com/ClickHouse/ClickHouse/issues/78717). Fixes [#79377](https://github.com/ClickHouse/ClickHouse/issues/79377). [#83844](https://github.com/ClickHouse/ClickHouse/pull/83844) ([Dmitry Novik](https://github.com/novikd)).
* Onprogress call in jsoneachrowwithprogress is synchronized with finalization. [#83879](https://github.com/ClickHouse/ClickHouse/pull/83879) ([Sema Checherinda](https://github.com/CheSema)).
* This closes [#81303](https://github.com/ClickHouse/ClickHouse/issues/81303). [#83892](https://github.com/ClickHouse/ClickHouse/pull/83892) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Fix colorSRGBToOKLCH/colorOKLCHToSRGB for mix of const and non-const args. [#83906](https://github.com/ClickHouse/ClickHouse/pull/83906) ([Azat Khuzhin](https://github.com/azat)).
* Fix writing JSON paths with NULL values in RowBinary format. [#83923](https://github.com/ClickHouse/ClickHouse/pull/83923) ([Pavel Kruglov](https://github.com/Avogar)).
* Overflow large values (>2106-02-07) when casting from Date to DateTime64 is fixed. [#83982](https://github.com/ClickHouse/ClickHouse/pull/83982) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Always apply `filesystem_prefetches_limit` (not only from `MergeTreePrefetchedReadPool`). [#83999](https://github.com/ClickHouse/ClickHouse/pull/83999) ([Azat Khuzhin](https://github.com/azat)).
* Fix rare bug when `MATERIALIZE COLUMN` query could lead to unexpected files in `checksums.txt` and eventually detached data parts. [#84007](https://github.com/ClickHouse/ClickHouse/pull/84007) ([alesapin](https://github.com/alesapin)).
* Fix the logical error `Expected single dictionary argument for function` while doing JOIN on an inequality condition when one of the columns is `LowCardinality` and the other is a constant. Closes [#81779](https://github.com/ClickHouse/ClickHouse/issues/81779). [#84019](https://github.com/ClickHouse/ClickHouse/pull/84019) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix crash with clickhouse client when used in interactive mode with syntax highlighting. [#84025](https://github.com/ClickHouse/ClickHouse/pull/84025) ([Bharat Nallan](https://github.com/bharatnc)).
* Fixed wrong results when the query condition cache is used in conjunction with recursive CTEs (issue [#81506](https://github.com/ClickHouse/ClickHouse/issues/81506)). [#84026](https://github.com/ClickHouse/ClickHouse/pull/84026) ([zhongyuankai](https://github.com/zhongyuankai)).
* Handle exceptions properly in periodic parts refresh. [#84083](https://github.com/ClickHouse/ClickHouse/pull/84083) ([Azat Khuzhin](https://github.com/azat)).
* Fix filter merging into JOIN condition in cases when equality operands have different types or they reference constants. Fixes [#83432](https://github.com/ClickHouse/ClickHouse/issues/83432). [#84145](https://github.com/ClickHouse/ClickHouse/pull/84145) ([Dmitry Novik](https://github.com/novikd)).
* Fix rare clickhouse crash when table has projection, `lightweight_mutation_projection_mode = 'rebuild'` and user execute lighweight delete which deletes ALL rows from any block in table. [#84158](https://github.com/ClickHouse/ClickHouse/pull/84158) ([alesapin](https://github.com/alesapin)).
* Fix deadlock caused by background cancellation checker thread. [#84203](https://github.com/ClickHouse/ClickHouse/pull/84203) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix infinite recursive analysis of invalid `WINDOW` definitions. Fixes [#83131](https://github.com/ClickHouse/ClickHouse/issues/83131). [#84242](https://github.com/ClickHouse/ClickHouse/pull/84242) ([Dmitry Novik](https://github.com/novikd)).
* Fixed a bug that was causing incorrect Bech32 Encoding and Decoding. The bug wasn't caught originally due to an online implementation of the algorithm used for testing having the same issue. [#84257](https://github.com/ClickHouse/ClickHouse/pull/84257) ([George Larionov](https://github.com/george-larionov)).
* Fixed incorrect construction of empty tuples in the `array()` function. This fixes [#84202](https://github.com/ClickHouse/ClickHouse/issues/84202). [#84297](https://github.com/ClickHouse/ClickHouse/pull/84297) ([Amos Bird](https://github.com/amosbird)).
* Fix `LOGICAL_ERROR` for queries with parallel replicas and multiple INNER joins followed by RIGHT join. Do not use parallel replicas for such queries. [#84299](https://github.com/ClickHouse/ClickHouse/pull/84299) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Previously, `set` indexes didn't consider `Nullable` columns while checking if granules passed the filter (issue [#75485](https://github.com/ClickHouse/ClickHouse/issues/75485)). [#84305](https://github.com/ClickHouse/ClickHouse/pull/84305) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Now ClickHouse read tables from Glue Catalog where table type specified in lower case. [#84316](https://github.com/ClickHouse/ClickHouse/pull/84316) ([alesapin](https://github.com/alesapin)).
* Do not try to substitute table functions to its cluster alternative in presence of a JOIN or subquery. [#84335](https://github.com/ClickHouse/ClickHouse/pull/84335) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix logger usage in `IAccessStorage`. [#84365](https://github.com/ClickHouse/ClickHouse/pull/84365) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fixed a logical error in lightweight updates that update all columns in the table. [#84380](https://github.com/ClickHouse/ClickHouse/pull/84380) ([Anton Popov](https://github.com/CurtizJ)).
* Codec `DoubleDelta` codec can now only be applied to columns of numeric type. In particular `FixedString` columns can no longer be compressed using `DoubleDelta`. (fixes [#80220](https://github.com/ClickHouse/ClickHouse/issues/80220)). [#84383](https://github.com/ClickHouse/ClickHouse/pull/84383) ([Jimmy Aguilar Mena](https://github.com/Ergus)).
* The comparison against nan value was not using the correct ranges during `MinMax` index evaluation. [#84386](https://github.com/ClickHouse/ClickHouse/pull/84386) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Fix reading Variant column with lazy materialization. [#84400](https://github.com/ClickHouse/ClickHouse/pull/84400) ([Pavel Kruglov](https://github.com/Avogar)).
* Make `zoutofmemory` hardware error, otherwise it will throw logical error. see https://github.com/clickhouse/clickhouse-core-incidents/issues/877. [#84420](https://github.com/ClickHouse/ClickHouse/pull/84420) ([Han Fei](https://github.com/hanfei1991)).
* Fixed server crash when a user created with `no_password` attempts to login after the server setting `allow_no_password` was changed to 0. [#84426](https://github.com/ClickHouse/ClickHouse/pull/84426) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Fix out-of-order writes to Keeper changelog. Previously, we could have in-flight writes to changelog, but rollback could cause concurrent change of the destination file. This would lead to inconsistent logs, and possible data loss. [#84434](https://github.com/ClickHouse/ClickHouse/pull/84434) ([Antonio Andelic](https://github.com/antonio2368)).
* Now if all TTL are removed from table MergeTree will do nothing related to TTL. [#84441](https://github.com/ClickHouse/ClickHouse/pull/84441) ([alesapin](https://github.com/alesapin)).
* Parallel distributed INSERT SELECT with LIMIT was allowed which is not correct, it leads to data duplication in target table. [#84477](https://github.com/ClickHouse/ClickHouse/pull/84477) ([Igor Nikonov](https://github.com/devcrafter)).
* Fix pruning files by virtual column in data lakes. [#84520](https://github.com/ClickHouse/ClickHouse/pull/84520) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix leaks for keeper with rocksdb storage (iterators was not destroyed). [#84523](https://github.com/ClickHouse/ClickHouse/pull/84523) ([Azat Khuzhin](https://github.com/azat)).
* Fix ALTER MODIFY ORDER BY not validating TTL columns in sorting keys. TTL columns are now properly rejected when used in ORDER BY clauses during ALTER operations, preventing potential table corruption. [#84536](https://github.com/ClickHouse/ClickHouse/pull/84536) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Change pre-25.5 value of `allow_experimental_delta_kernel_rs` to `false` for compatibility. [#84587](https://github.com/ClickHouse/ClickHouse/pull/84587) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Stops taking schema from manifest files but stores relevant schemas for each snapshot independently. Infer relevant schema for each data file from its corresponding snapshot. Previous behaviour violated Iceberg specification for manifest files entries with existing status. [#84588](https://github.com/ClickHouse/ClickHouse/pull/84588) ([Daniil Ivanik](https://github.com/divanik)).
* Fixed issue where Keeper setting `rotate_log_storage_interval = 0` would cause ClickHouse to crash. (issue [#83975](https://github.com/ClickHouse/ClickHouse/issues/83975)). [#84637](https://github.com/ClickHouse/ClickHouse/pull/84637) ([George Larionov](https://github.com/george-larionov)).
* Fix logical error from S3Queue "Table is already registered". Closes [#84433](https://github.com/ClickHouse/ClickHouse/issues/84433). Broken after https://github.com/ClickHouse/ClickHouse/pull/83530. [#84677](https://github.com/ClickHouse/ClickHouse/pull/84677) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Lock 'mutex' when getting zookeeper from 'view' in RefreshTask. [#84699](https://github.com/ClickHouse/ClickHouse/pull/84699) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fix `CORRUPTED_DATA` error when lazy columns are used with external sort. [#84738](https://github.com/ClickHouse/ClickHouse/pull/84738) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Fix column pruning with delta-kernel in storage `DeltaLake`. Closes [#84543](https://github.com/ClickHouse/ClickHouse/issues/84543). [#84745](https://github.com/ClickHouse/ClickHouse/pull/84745) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Refresh credentials in delta-kernel in storage DeltaLake. [#84751](https://github.com/ClickHouse/ClickHouse/pull/84751) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix starting superfluous internal backups after connection problems. [#84755](https://github.com/ClickHouse/ClickHouse/pull/84755) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fixed issue where querying a delayed remote source could result in vector out of bounds. [#84820](https://github.com/ClickHouse/ClickHouse/pull/84820) ([George Larionov](https://github.com/george-larionov)).
* The `ngram` and `no_op` tokenizers no longer crash the (experimental) text index for empty input tokens. [#84849](https://github.com/ClickHouse/ClickHouse/pull/84849) ([Robert Schulze](https://github.com/rschu1ze)).
* Fixed lightweight updates for tables with `ReplacingMergeTree` and `CollapsingMergeTree` engines. [#84851](https://github.com/ClickHouse/ClickHouse/pull/84851) ([Anton Popov](https://github.com/CurtizJ)).
* Correctly store all settings in table metadata for tables using object queue engine. [#84860](https://github.com/ClickHouse/ClickHouse/pull/84860) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix total watches count returned by Keeper. [#84890](https://github.com/ClickHouse/ClickHouse/pull/84890) ([Antonio Andelic](https://github.com/antonio2368)).
* Fixed lightweight updates for tables with `ReplicatedMergeTree` engine created on servers with a version lower than 25.7. [#84933](https://github.com/ClickHouse/ClickHouse/pull/84933) ([Anton Popov](https://github.com/CurtizJ)).
* Fixed lightweight updates for tables with non-replicated `MergeTree` engine after running a `ALTER TABLE ... REPLACE PARTITION` query. [#84941](https://github.com/ClickHouse/ClickHouse/pull/84941) ([Anton Popov](https://github.com/CurtizJ)).
* Fixes column name generation for boolean literals to use "true"/"false" instead of "1"/"0", preventing column name conflicts between boolean and integer literals in queries. [#84945](https://github.com/ClickHouse/ClickHouse/pull/84945) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Fix memory tracking drift from background schedule pool and executor. [#84946](https://github.com/ClickHouse/ClickHouse/pull/84946) ([Azat Khuzhin](https://github.com/azat)).
* Fix potential inaccurate sorting issues in the Merge table engine. [#85025](https://github.com/ClickHouse/ClickHouse/pull/85025) ([Xiaozhe Yu](https://github.com/wudidapaopao)).
* Implement missing APIs for DiskEncrypted. [#85028](https://github.com/ClickHouse/ClickHouse/pull/85028) ([Azat Khuzhin](https://github.com/azat)).
* Add a check if a correlated subquery is used in a distributed context to avoid a crash. Fixes [#82205](https://github.com/ClickHouse/ClickHouse/issues/82205). [#85030](https://github.com/ClickHouse/ClickHouse/pull/85030) ([Dmitry Novik](https://github.com/novikd)).
* Now Iceberg doesn't try to cache relevant snapshot version between select queries and always try to resolve snapshot honestly. Earlier attempt to cache iceberg snapshot led to problems with usage of Iceberg table with time travel. [#85038](https://github.com/ClickHouse/ClickHouse/pull/85038) ([Daniil Ivanik](https://github.com/divanik)).
* Fixed double-free in `AzureIteratorAsync`. [#85064](https://github.com/ClickHouse/ClickHouse/pull/85064) ([Nikita Taranov](https://github.com/nickitat)).
* Improve error message on attempt to create user identified with JWT. [#85072](https://github.com/ClickHouse/ClickHouse/pull/85072) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fixed cleanup of patch parts in `ReplicatedMergeTree`. Previously, the result of a lightweight update may temporarily not be visible on the replica until the merged or mutated part that materializes the patch parts is downloaded from another replica. [#85121](https://github.com/ClickHouse/ClickHouse/pull/85121) ([Anton Popov](https://github.com/CurtizJ)).
* Fixing illegal_type_of_argument in mv when types are different. [#85135](https://github.com/ClickHouse/ClickHouse/pull/85135) ([Sema Checherinda](https://github.com/CheSema)).
* Fix segfault in delta-kernel implementation. [#85160](https://github.com/ClickHouse/ClickHouse/pull/85160) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix recovering replicated databases when moving the metadata file takes a long time. [#85177](https://github.com/ClickHouse/ClickHouse/pull/85177) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fix `Not-ready Set` for `IN (subquery)` inside `additional_table_filters expression` setting. [#85210](https://github.com/ClickHouse/ClickHouse/pull/85210) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Get rid of unnecessary `getStatus()` calls during SYSTEM DROP REPLICA queries. Fixes the case when a table is dropped in the background, and the `Shutdown for storage is called` exception is thrown. [#85220](https://github.com/ClickHouse/ClickHouse/pull/85220) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix race in `DeltaLake` engine delta-kernel implementation. [#85221](https://github.com/ClickHouse/ClickHouse/pull/85221) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix reading partitioned data with disabled delta-kernel in `DeltaLake` engine. It was broken in 25.7 (https://github.com/ClickHouse/ClickHouse/pull/81136). [#85223](https://github.com/ClickHouse/ClickHouse/pull/85223) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Added missing table name length checks in CREATE OR REPLACE and RENAME queries. [#85326](https://github.com/ClickHouse/ClickHouse/pull/85326) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix the creation of RMV on a new replica of the Replicated database if DEFINER is dropped. [#85327](https://github.com/ClickHouse/ClickHouse/pull/85327) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix iceberg writes for complex types. [#85330](https://github.com/ClickHouse/ClickHouse/pull/85330) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Writing lower and upper bounds are not supported for complex types. [#85332](https://github.com/ClickHouse/ClickHouse/pull/85332) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Fix logical error while reading from object storage functions through Distributed table or remote table function. Fixes: [#84658](https://github.com/ClickHouse/ClickHouse/issues/84658), Fixes [#85173](https://github.com/ClickHouse/ClickHouse/issues/85173), Fixes [#52022](https://github.com/ClickHouse/ClickHouse/issues/52022). [#85359](https://github.com/ClickHouse/ClickHouse/pull/85359) ([alesapin](https://github.com/alesapin)).
* Fix backup of parts with broken projections. [#85362](https://github.com/ClickHouse/ClickHouse/pull/85362) ([Antonio Andelic](https://github.com/antonio2368)).
* Forbid using `_part_offset` column in projection in releases until it is stabilized. [#85372](https://github.com/ClickHouse/ClickHouse/pull/85372) ([Sema Checherinda](https://github.com/CheSema)).
* Fix crash and data corruption during ALTER UPDATE for JSON. [#85383](https://github.com/ClickHouse/ClickHouse/pull/85383) ([Pavel Kruglov](https://github.com/Avogar)).
* Queries with parallel replicas which uses reading reverse in order optimization can produce incorrect result. [#85406](https://github.com/ClickHouse/ClickHouse/pull/85406) ([Igor Nikonov](https://github.com/devcrafter)).
* Fix possible UB (crashes) in case of MEMORY_LIMIT_EXCEEDED during String deserialization. [#85440](https://github.com/ClickHouse/ClickHouse/pull/85440) ([Azat Khuzhin](https://github.com/azat)).
* Fix incorrect metrics KafkaAssignedPartitions and KafkaConsumersWithAssignment. [#85494](https://github.com/ClickHouse/ClickHouse/pull/85494) ([Ilya Golshtein](https://github.com/ilejn)).
* Fixed processed bytes stat being underestimated when PREWHERE (explicit or automatic) is used. [#85495](https://github.com/ClickHouse/ClickHouse/pull/85495) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix early return condition for S3 request rate slowdown: require either s3_slow_all_threads_after_network_error or backup_slow_all_threads_after_retryable_s3_error to be true to enable slowdown behavior when all threads are paused due to a retryable error, instead of requiring both. [#85505](https://github.com/ClickHouse/ClickHouse/pull/85505) ([Julia Kartseva](https://github.com/jkartseva)).
* This pr fixes the metadata resolution when querying iceberg tables through rest catalog. ... [#85531](https://github.com/ClickHouse/ClickHouse/pull/85531) ([Saurabh Kumar Ojha](https://github.com/saurabhojha)).
* Backported in [#86136](https://github.com/ClickHouse/ClickHouse/issues/86136): 1. LowCardinality for hive columns 2. Fill hive columns before virtual columns (required for https://github.com/ClickHouse/ClickHouse/pull/81040) 3. LOGICAL_ERROR on empty format for hive [#85528](https://github.com/ClickHouse/ClickHouse/issues/85528) 4. Fix check for hive partition columns being the only columns 5. Assert all hive columns are specified in the schema 6. Partial fix for parallel_replicas_cluster with hive 7. Use ordered container in extractkeyValuePairs for hive utils (required for https://github.com/ClickHouse/ClickHouse/pull/81040). [#85538](https://github.com/ClickHouse/ClickHouse/pull/85538) ([Arthur Passos](https://github.com/arthurpassos)).
* Fixed rare crash in asynchronous inserts that change settings `log_comment` or `insert_deduplication_token`. [#85540](https://github.com/ClickHouse/ClickHouse/pull/85540) ([Anton Popov](https://github.com/CurtizJ)).
* Parameters like date_time_input_format were ignored when using HTTP with multipart/form-data. [#85570](https://github.com/ClickHouse/ClickHouse/pull/85570) ([Sema Checherinda](https://github.com/CheSema)).
* Fix secrets masking in icebergS3Cluster and icebergAzureCluster table functions. [#85658](https://github.com/ClickHouse/ClickHouse/pull/85658) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Fix precision loss in `JSONExtract` when converting JSON numbers to Decimal types. Now numeric JSON values preserve their exact decimal representation, avoiding floating-point rounding errors. [#85665](https://github.com/ClickHouse/ClickHouse/pull/85665) ([ssive7b](https://github.com/ssive7b)).
* Fixed `LOGICAL_ERROR` when using `COMMENT COLUMN IF EXISTS` in the same `ALTER` statement after `DROP COLUMN`. The `IF EXISTS` clause now correctly skips the comment operation when the column has been dropped within the same statement. [#85688](https://github.com/ClickHouse/ClickHouse/pull/85688) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Fix reading count from cache for delta lake. [#85704](https://github.com/ClickHouse/ClickHouse/pull/85704) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix coalescing merge tree segfault for large strings. This closes [#84582](https://github.com/ClickHouse/ClickHouse/issues/84582). [#85709](https://github.com/ClickHouse/ClickHouse/pull/85709) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Update metadata timestamp in iceberg writes. [#85711](https://github.com/ClickHouse/ClickHouse/pull/85711) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Using `distributed_depth` as an indicator of *Cluster function was incorrect and may lead to data duplication; use `client_info.collaborate_with_initiator` instead. [#85734](https://github.com/ClickHouse/ClickHouse/pull/85734) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Spark can't read position delete files. [#85762](https://github.com/ClickHouse/ClickHouse/pull/85762) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Fix send_logs_source_regexp (after async logging refactoring in [#85105](https://github.com/ClickHouse/ClickHouse/issues/85105)). [#85797](https://github.com/ClickHouse/ClickHouse/pull/85797) ([Azat Khuzhin](https://github.com/azat)).
* Fix possible inconsistency for dictionaries with update_field on MEMORY_LIMIT_EXCEEDED errors. [#85807](https://github.com/ClickHouse/ClickHouse/pull/85807) ([Azat Khuzhin](https://github.com/azat)).
* Support global constants from `WITH` statement for the parallel distributed `INSERT SELECT` with the `Distributed` destination table. Before, the query could throw an `Unknown expression identifier` error. [#85811](https://github.com/ClickHouse/ClickHouse/pull/85811) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Mask credentials for `deltaLakeAzure`, `deltaLakeCluster`, `icebergS3Cluster` and `icebergAzureCluster`. [#85889](https://github.com/ClickHouse/ClickHouse/pull/85889) ([Julian Maicher](https://github.com/jmaicher)).
* Fix logical error on attempt to `CREATE ... AS (SELECT * FROM s3Cluster(...))` with `DatabaseReplicated`. [#85904](https://github.com/ClickHouse/ClickHouse/pull/85904) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fixes HTTP requests made by the `url()` table function to properly include port numbers in the Host header when accessing non-standard ports. This resolves authentication failures when using presigned URLs with S3-compatible services like MinIO running on custom ports, which is common in development environments. (Fixes [#85898](https://github.com/ClickHouse/ClickHouse/issues/85898)). [#85921](https://github.com/ClickHouse/ClickHouse/pull/85921) ([Tom Quist](https://github.com/tomquist)).
* Now unity catalog will ignore schemas with weird data types in case of non-delta tables. Fixes [#85699](https://github.com/ClickHouse/ClickHouse/issues/85699). [#85950](https://github.com/ClickHouse/ClickHouse/pull/85950) ([alesapin](https://github.com/alesapin)).
* Recover the Replicated Database forcefully after restoring the database metadata in Keeper. [#85960](https://github.com/ClickHouse/ClickHouse/pull/85960) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fix nullability of fields in iceberg. [#85977](https://github.com/ClickHouse/ClickHouse/pull/85977) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Fixed a bug in `Replicated` database recovery: if a table name contains the `%` symbol, it could re-create the table with a different name during recovery. [#85987](https://github.com/ClickHouse/ClickHouse/pull/85987) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix backup restores failing due to `BACKUP_ENTRY_NOT_FOUND` error when restoring an empty `Memory` table. [#86012](https://github.com/ClickHouse/ClickHouse/pull/86012) ([Julia Kartseva](https://github.com/jkartseva)).
* Add checks for sharding_key during ALTER of the Distributed table. Previously incorrect ALTER would break the table definition and server restart. [#86015](https://github.com/ClickHouse/ClickHouse/pull/86015) ([Nikolay Degterinsky](https://github.com/evillique)).
* Don't create empty iceberg delete file. [#86061](https://github.com/ClickHouse/ClickHouse/pull/86061) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Backported in [#86201](https://github.com/ClickHouse/ClickHouse/issues/86201): Fix using wrong default values for path with Enum hint inside JSON. [#86065](https://github.com/ClickHouse/ClickHouse/pull/86065) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix large setting values breaking S3Queue tables and replica restart. [#86074](https://github.com/ClickHouse/ClickHouse/pull/86074) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#86220](https://github.com/ClickHouse/ClickHouse/issues/86220): Fix logical error during filesystem cache dynamic resize. Closes [#86122](https://github.com/ClickHouse/ClickHouse/issues/86122). Closes https://github.com/ClickHouse/clickhouse-core-incidents/issues/473. [#86130](https://github.com/ClickHouse/ClickHouse/pull/86130) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#86149](https://github.com/ClickHouse/ClickHouse/issues/86149): Use `NonZeroUInt64` for `logs_to_keep` in DatabaseReplicatedSettings. [#86142](https://github.com/ClickHouse/ClickHouse/pull/86142) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Backported in [#86293](https://github.com/ClickHouse/ClickHouse/issues/86293): Exception was thrown by a `FINAL` query with skip index if the table (e.g `ReplacingMergeTree`) was created with setting`index_granularity_bytes = 0`. That exception has been fixed now. [#86147](https://github.com/ClickHouse/ClickHouse/pull/86147) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Backported in [#86310](https://github.com/ClickHouse/ClickHouse/issues/86310): Fix crash in case of const and non-const blocks in one INSERT. [#86230](https://github.com/ClickHouse/ClickHouse/pull/86230) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#86320](https://github.com/ClickHouse/ClickHouse/issues/86320): Fix crash with replaceRegex, a FixedString haystack and an empty needle. [#86270](https://github.com/ClickHouse/ClickHouse/pull/86270) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#86350](https://github.com/ClickHouse/ClickHouse/issues/86350): Fix crash during ALTER UPDATE Nullable(JSON). [#86281](https://github.com/ClickHouse/ClickHouse/pull/86281) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86328](https://github.com/ClickHouse/ClickHouse/issues/86328): Fix missing column definer in system.tables. [#86295](https://github.com/ClickHouse/ClickHouse/pull/86295) ([Raúl Marín](https://github.com/Algunenano)).

#### Build/Testing/Packaging Improvement
* Use encrypted disks for tests with S3 by default. [#59898](https://github.com/ClickHouse/ClickHouse/pull/59898) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Use `clickhouse` binary in integrations tests to get unstripped debug symbols. [#83779](https://github.com/ClickHouse/ClickHouse/pull/83779) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Revert changes from https://github.com/ClickHouse/ClickHouse/pull/83041 to check if https://github.com/ClickHouse/ClickHouse/pull/83327 is enough. [#83843](https://github.com/ClickHouse/ClickHouse/pull/83843) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Bumped the internal libxml2 from 2.14.4 to 2.14.5. [#84230](https://github.com/ClickHouse/ClickHouse/pull/84230) ([Robert Schulze](https://github.com/rschu1ze)).
* Bumped internal curl from 8.14.0 to 8.15.0. [#84231](https://github.com/ClickHouse/ClickHouse/pull/84231) ([Robert Schulze](https://github.com/rschu1ze)).
* Display port numbers of connections in HTTP server log of integration tests. This makes debugging flaky tests easier when the problems are with network. [#84470](https://github.com/ClickHouse/ClickHouse/pull/84470) ([Raufs Dunamalijevs](https://github.com/rienath)).
* Small improvements into the test. [#84589](https://github.com/ClickHouse/ClickHouse/pull/84589) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Now we use less memory for caches in CI and have better tests for eviction. [#84676](https://github.com/ClickHouse/ClickHouse/pull/84676) ([alesapin](https://github.com/alesapin)).
* Fix flaky test test_storage_nats/test.py::test_nats_no_connection_at_startup_1. [#85631](https://github.com/ClickHouse/ClickHouse/pull/85631) ([Dmitry Novikov](https://github.com/dmitry-sles-novikov)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Revert "Using file offsets instead of virtual memory addresses in `system.symbols` and `addressToSymbol`""'. [#82809](https://github.com/ClickHouse/ClickHouse/pull/82809) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "add assertion that checksums.txt is consistent"'. [#83930](https://github.com/ClickHouse/ClickHouse/pull/83930) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Add a test for [#56334](https://github.com/ClickHouse/ClickHouse/issues/56334)"'. [#84024](https://github.com/ClickHouse/ClickHouse/pull/84024) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'antlr - added upd and del stmts'. [#84205](https://github.com/ClickHouse/ClickHouse/pull/84205) ([M Lorek](https://github.com/mlorek)).
* NO CL ENTRY:  'Revert "CI: Fix long output truncation in ci report"'. [#84281](https://github.com/ClickHouse/ClickHouse/pull/84281) ([Max Kainov](https://github.com/maxknv)).
* NO CL ENTRY:  'Revert "add sync to the test 03352_concurrent_rename_alter.sh"'. [#84294](https://github.com/ClickHouse/ClickHouse/pull/84294) ([Sema Checherinda](https://github.com/CheSema)).
* NO CL ENTRY:  'Revert "Support DESCRIBE SELECT without parentheses around SELECT"'. [#84375](https://github.com/ClickHouse/ClickHouse/pull/84375) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "Disable query condition cache for recursive CTEs"'. [#84404](https://github.com/ClickHouse/ClickHouse/pull/84404) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "Fix inconsistent formatting of TTL"'. [#84475](https://github.com/ClickHouse/ClickHouse/pull/84475) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* NO CL ENTRY:  'Revert "Fix incorrect S3 metadata path resolution when config is populated in Iceberg REST catalog /v1/config response "'. [#84483](https://github.com/ClickHouse/ClickHouse/pull/84483) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Text index: Add bloom filter into FST segments"'. [#84512](https://github.com/ClickHouse/ClickHouse/pull/84512) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Improve interactive client: replace tab characters with spaces"'. [#84605](https://github.com/ClickHouse/ClickHouse/pull/84605) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* NO CL ENTRY:  'Revert "Move `getMergeTreeReaderSettings` to a static member function"'. [#84749](https://github.com/ClickHouse/ClickHouse/pull/84749) ([Robert Schulze](https://github.com/rschu1ze)).
* NO CL ENTRY:  'Update README.md'. [#84943](https://github.com/ClickHouse/ClickHouse/pull/84943) ([Zoe Steinkamp](https://github.com/zoesteinkamp)).
* NO CL ENTRY:  'Revert "Text index: add internal bloom filter layer"'. [#84977](https://github.com/ClickHouse/ClickHouse/pull/84977) ([Robert Schulze](https://github.com/rschu1ze)).
* NO CL ENTRY:  'Revert "Text index: add internal bloom filter layer"'. [#85271](https://github.com/ClickHouse/ClickHouse/pull/85271) ([Robert Schulze](https://github.com/rschu1ze)).
* NO CL ENTRY:  'Revert "CI: Refactor compatibility check job"'. [#85516](https://github.com/ClickHouse/ClickHouse/pull/85516) ([Max Kainov](https://github.com/maxknv)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Add a tool to simulate, visualize and compare merge selectors. [#71496](https://github.com/ClickHouse/ClickHouse/pull/71496) ([Sergei Trifonov](https://github.com/serxa)).
* Preserve blobs when zero copy lock does not exist. [#72933](https://github.com/ClickHouse/ClickHouse/pull/72933) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Randomize setting `use_async_executor_for_materialized_views` introduced in https://github.com/ClickHouse/ClickHouse/pull/72497. [#73377](https://github.com/ClickHouse/ClickHouse/pull/73377) ([Alexander Gololobov](https://github.com/davenger)).
* Add a test for [#51649](https://github.com/ClickHouse/ClickHouse/issues/51649), but it is another case with parallel replicas. [#80311](https://github.com/ClickHouse/ClickHouse/pull/80311) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Attempt to fix bad tests. [#80384](https://github.com/ClickHouse/ClickHouse/pull/80384) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Split parallel and sequential tests. [#82337](https://github.com/ClickHouse/ClickHouse/pull/82337) ([Max Kainov](https://github.com/maxknv)).
* Text index: Add bloom filter into FST segments. [#83485](https://github.com/ClickHouse/ClickHouse/pull/83485) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Move `getMergeTreeReaderSettings` to a static member function. [#83531](https://github.com/ClickHouse/ClickHouse/pull/83531) ([Jimmy Aguilar Mena](https://github.com/Ergus)).
* `sccache` supports explicit server start. We should start it before the `ninja` build stage. [#83600](https://github.com/ClickHouse/ClickHouse/pull/83600) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix race in ddl worker queue. [#83705](https://github.com/ClickHouse/ClickHouse/pull/83705) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Add performance comparison jobs with release branch baseline. [#83714](https://github.com/ClickHouse/ClickHouse/pull/83714) ([Max Kainov](https://github.com/maxknv)).
* Remove unused parameter from TCPHandler::processCancel(). [#83788](https://github.com/ClickHouse/ClickHouse/pull/83788) ([Azat Khuzhin](https://github.com/azat)).
* estimate cardinality by statistics. [#83806](https://github.com/ClickHouse/ClickHouse/pull/83806) ([Han Fei](https://github.com/hanfei1991)).
* Bump gdb on CI and fix dependencies. [#83828](https://github.com/ClickHouse/ClickHouse/pull/83828) ([Azat Khuzhin](https://github.com/azat)).
* add sync to the test 03352_concurrent_rename_alter.sh. [#83830](https://github.com/ClickHouse/ClickHouse/pull/83830) ([Sema Checherinda](https://github.com/CheSema)).
* Fix cleanup in `ON CLUSTER` backups. We need to clean coordination nodes in ZooKeeper correctly after a backup or restore failed or got cancelled. [#83835](https://github.com/ClickHouse/ClickHouse/pull/83835) ([Vitaly Baranov](https://github.com/vitlibar)).
* Small fuzzer update. [#83838](https://github.com/ClickHouse/ClickHouse/pull/83838) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Shutdown `DDLWorker` before shutting down `BackupsWorker`. [#83840](https://github.com/ClickHouse/ClickHouse/pull/83840) ([Vitaly Baranov](https://github.com/vitlibar)).
* Previously, `FilterTransform` could stop reading if the expression for any chunk returned a constant `false`. This can lead to a bug, because constant columns are allowed to appear during the execution, and most function default implementations will preserve constants as well. [#83855](https://github.com/ClickHouse/ClickHouse/pull/83855) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix  test_storage_s3_queue/test_5.py::test_shutdown_order. [#83867](https://github.com/ClickHouse/ClickHouse/pull/83867) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add missing profile events for throttling. [#83868](https://github.com/ClickHouse/ClickHouse/pull/83868) ([Sergei Trifonov](https://github.com/serxa)).
* Fix parquet writer outputting incorrect row indices in offset index. [#83876](https://github.com/ClickHouse/ClickHouse/pull/83876) ([Michael Kolupaev](https://github.com/al13n321)).
* Try to improve JSON column size lazy calculation. [#83877](https://github.com/ClickHouse/ClickHouse/pull/83877) ([Pavel Kruglov](https://github.com/Avogar)).
* Update version after release. [#83885](https://github.com/ClickHouse/ClickHouse/pull/83885) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix 02233_HTTP_ranged. [#83891](https://github.com/ClickHouse/ClickHouse/pull/83891) ([Antonio Andelic](https://github.com/antonio2368)).
* Mark allow_remote_fs_zero_copy_replication as experimental. [#83895](https://github.com/ClickHouse/ClickHouse/pull/83895) ([Raúl Marín](https://github.com/Algunenano)).
* Changelog for 25.7. [#83900](https://github.com/ClickHouse/ClickHouse/pull/83900) ([Raúl Marín](https://github.com/Algunenano)).
* Text index: remove `CONTAINS_ALL` flag from postings list. [#83901](https://github.com/ClickHouse/ClickHouse/pull/83901) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Update version_date.tsv and changelog after v25.4.12.9-stable. [#83902](https://github.com/ClickHouse/ClickHouse/pull/83902) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix E2E test. [#83903](https://github.com/ClickHouse/ClickHouse/pull/83903) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Initialize tmp disks at later point. [#83904](https://github.com/ClickHouse/ClickHouse/pull/83904) ([Antonio Andelic](https://github.com/antonio2368)).
* Update version_date.tsv and changelog after v25.5.8.13-stable. [#83907](https://github.com/ClickHouse/ClickHouse/pull/83907) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Use `runner_options` when running flaky checks. [#83909](https://github.com/ClickHouse/ClickHouse/pull/83909) ([Nikita Taranov](https://github.com/nickitat)).
* Hardcode config paths in tests. [#83925](https://github.com/ClickHouse/ClickHouse/pull/83925) ([Raúl Marín](https://github.com/Algunenano)).
* CI: Fix gh label for release PRs. [#83943](https://github.com/ClickHouse/ClickHouse/pull/83943) ([Max Kainov](https://github.com/maxknv)).
* Unblock compilation with CMake 3.28. [#83956](https://github.com/ClickHouse/ClickHouse/pull/83956) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix `max_cpu_shares` does not take effect independently in CPU scheduling. [#83960](https://github.com/ClickHouse/ClickHouse/pull/83960) ([Fan Ziqi](https://github.com/f2quantum)).
* CI: PerfTests: download dataset fix. [#83964](https://github.com/ClickHouse/ClickHouse/pull/83964) ([Max Kainov](https://github.com/maxknv)).
* CI: Report: Fix downloading data files on startup. [#83970](https://github.com/ClickHouse/ClickHouse/pull/83970) ([Max Kainov](https://github.com/maxknv)).
* Fix clang-20 build. [#83972](https://github.com/ClickHouse/ClickHouse/pull/83972) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix 03164_parallel_replicas_range_filter_min_max. [#83973](https://github.com/ClickHouse/ClickHouse/pull/83973) ([Igor Nikonov](https://github.com/devcrafter)).
* Fix disabling of skip indexes for columns updated in patches. [#83976](https://github.com/ClickHouse/ClickHouse/pull/83976) ([Anton Popov](https://github.com/CurtizJ)).
* sync current metrics with private repo. [#83980](https://github.com/ClickHouse/ClickHouse/pull/83980) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Fix flaky 03002_part_log_rmt_fetch_merge_error. [#83989](https://github.com/ClickHouse/ClickHouse/pull/83989) ([Eduard Karacharov](https://github.com/korowa)).
* CI: Remove inline build log from the report. [#83996](https://github.com/ClickHouse/ClickHouse/pull/83996) ([Max Kainov](https://github.com/maxknv)).
* Do not fall back to an infinite cycle when a Decimal with zero scale is used in the Iceberg schema. [#84001](https://github.com/ClickHouse/ClickHouse/pull/84001) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Synchronize Disks/IO. [#84003](https://github.com/ClickHouse/ClickHouse/pull/84003) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Run perf comparison with release merge-base on master. [#84009](https://github.com/ClickHouse/ClickHouse/pull/84009) ([Max Kainov](https://github.com/maxknv)).
* Remove part of the test about `system.query_metric_log` that cannot work in theory. [#84014](https://github.com/ClickHouse/ClickHouse/pull/84014) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#56334](https://github.com/ClickHouse/ClickHouse/issues/56334). [#84016](https://github.com/ClickHouse/ClickHouse/pull/84016) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better exceptions. [#84018](https://github.com/ClickHouse/ClickHouse/pull/84018) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix too long test for vector search. [#84021](https://github.com/ClickHouse/ClickHouse/pull/84021) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix test `03532_json_dynamic_updates`. [#84022](https://github.com/ClickHouse/ClickHouse/pull/84022) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix test `03221_insert_timeout_overflow_mode`. [#84023](https://github.com/ClickHouse/ClickHouse/pull/84023) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Size runners and parallelism for functional tests. [#84040](https://github.com/ClickHouse/ClickHouse/pull/84040) ([Max Kainov](https://github.com/maxknv)).
* Fix TSan in clang-20. [#84052](https://github.com/ClickHouse/ClickHouse/pull/84052) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Miscellaneous (11). [#84053](https://github.com/ClickHouse/ClickHouse/pull/84053) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix TSan report in main thread status. [#84054](https://github.com/ClickHouse/ClickHouse/pull/84054) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Fix functional tests exception. [#84055](https://github.com/ClickHouse/ClickHouse/pull/84055) ([Max Kainov](https://github.com/maxknv)).
* Better test `01825_new_type_json_ghdata_insert_select`. [#84066](https://github.com/ClickHouse/ClickHouse/pull/84066) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Faster test `00988_expansion_aliases_limit`. [#84067](https://github.com/ClickHouse/ClickHouse/pull/84067) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove GWP-ASan. [#84068](https://github.com/ClickHouse/ClickHouse/pull/84068) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Minor vector search improvements. [#84073](https://github.com/ClickHouse/ClickHouse/pull/84073) ([Robert Schulze](https://github.com/rschu1ze)).
* Closes [#81834](https://github.com/ClickHouse/ClickHouse/issues/81834). [#84075](https://github.com/ClickHouse/ClickHouse/pull/84075) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Highlight regexps in REGEXP_REPLACE. [#84086](https://github.com/ClickHouse/ClickHouse/pull/84086) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better test `02932_set_ttl_where`. [#84088](https://github.com/ClickHouse/ClickHouse/pull/84088) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix heavy test `03325_alter_modify_projection_primary_key_column`. [#84089](https://github.com/ClickHouse/ClickHouse/pull/84089) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix deadlock while printing sanitizer reports. [#84098](https://github.com/ClickHouse/ClickHouse/pull/84098) ([Azat Khuzhin](https://github.com/azat)).
* Avoid building big objects in Google Cloud Cpp. [#84100](https://github.com/ClickHouse/ClickHouse/pull/84100) ([Pablo Marcos](https://github.com/pamarcos)).
* Introduce rate limiter to azure write buffer. [#84101](https://github.com/ClickHouse/ClickHouse/pull/84101) ([alesapin](https://github.com/alesapin)).
* ci: properly wait for additional servers for database replicated. [#84112](https://github.com/ClickHouse/ClickHouse/pull/84112) ([Azat Khuzhin](https://github.com/azat)).
* CI: Fix report url in CIDB. [#84113](https://github.com/ClickHouse/ClickHouse/pull/84113) ([Max Kainov](https://github.com/maxknv)).
* CI: Parallel and sequential job batches follow up. [#84127](https://github.com/ClickHouse/ClickHouse/pull/84127) ([Max Kainov](https://github.com/maxknv)).
* No idea where this issue comes from, some random attempt to fix. Another attempt to fix [#79109](https://github.com/ClickHouse/ClickHouse/issues/79109). [#84132](https://github.com/ClickHouse/ClickHouse/pull/84132) ([alesapin](https://github.com/alesapin)).
* Remove platform-dependent part of sz3 test. [#84138](https://github.com/ClickHouse/ClickHouse/pull/84138) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Revert Support bloom_filter usage for "has" on const array. [#84142](https://github.com/ClickHouse/ClickHouse/pull/84142) ([Shankar Iyer](https://github.com/shankar-iyer)).
* test_database_delta: do not ignore spark query errors. [#84146](https://github.com/ClickHouse/ClickHouse/pull/84146) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix NULL dereference in fetchSQLiteTableStructure() on error. [#84149](https://github.com/ClickHouse/ClickHouse/pull/84149) ([Azat Khuzhin](https://github.com/azat)).
* Related [#84078](https://github.com/ClickHouse/ClickHouse/issues/84078). [#84153](https://github.com/ClickHouse/ClickHouse/pull/84153) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Fix recursive static var initialization in ThreadFuzzer. [#84156](https://github.com/ClickHouse/ClickHouse/pull/84156) ([Azat Khuzhin](https://github.com/azat)).
* Remove leftovers from full-text search. [#84175](https://github.com/ClickHouse/ClickHouse/pull/84175) ([Robert Schulze](https://github.com/rschu1ze)).
* Replace LOGICAL_ERROR with BAD_ARGUMENTS for invalid failpoints. [#84179](https://github.com/ClickHouse/ClickHouse/pull/84179) ([Azat Khuzhin](https://github.com/azat)).
* Fix flaky tests with parquet by partially reverting [#82949](https://github.com/ClickHouse/ClickHouse/issues/82949). [#84180](https://github.com/ClickHouse/ClickHouse/pull/84180) ([Julia Kartseva](https://github.com/jkartseva)).
* CI: Fix job result update in the report on rerun. [#84191](https://github.com/ClickHouse/ClickHouse/pull/84191) ([Max Kainov](https://github.com/maxknv)).
* Update version_date.tsv and changelog after v25.5.9.14-stable. [#84197](https://github.com/ClickHouse/ClickHouse/pull/84197) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* CI: Report links in PR summary comment. [#84209](https://github.com/ClickHouse/ClickHouse/pull/84209) ([Max Kainov](https://github.com/maxknv)).
* Sync from private repo. [#84211](https://github.com/ClickHouse/ClickHouse/pull/84211) ([Han Fei](https://github.com/hanfei1991)).
* Fix possible LOGICAL_ERROR in queries with `parallel_hash` join and thin key columns (like Int16). [#84213](https://github.com/ClickHouse/ClickHouse/pull/84213) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fix noisy debug message. [#84232](https://github.com/ClickHouse/ClickHouse/pull/84232) ([Max Kainov](https://github.com/maxknv)).
* Fix test_storage_rabbitmq timeouts. [#84234](https://github.com/ClickHouse/ClickHouse/pull/84234) ([Pablo Marcos](https://github.com/pamarcos)).
* Downgrade log level message to less noisy level to suppress failing test https://s3.amazonaws.com/clickhouse-test-reports/json.html?REF=master&sha=bd37b543f1c94465e12cdac808194aa883995dce&name_0=MasterCI&name_1=Stateless%20tests%20%28arm_asan%2C%20azure%2C%20sequential%29. [#84250](https://github.com/ClickHouse/ClickHouse/pull/84250) ([alesapin](https://github.com/alesapin)).
* Fix `test_parallel_replicas_protocol`. [#84251](https://github.com/ClickHouse/ClickHouse/pull/84251) ([Nikita Taranov](https://github.com/nickitat)).
* Add `runner --debug` option to enable ClickHouse root folder mount for debugging. [#84252](https://github.com/ClickHouse/ClickHouse/pull/84252) ([Sergei Trifonov](https://github.com/serxa)).
* Bump mongo-c-driver to remove usage of harmful function rand(). [#84253](https://github.com/ClickHouse/ClickHouse/pull/84253) ([Azat Khuzhin](https://github.com/azat)).
* Make test `00160_merge_and_index_in_in` lighter. [#84255](https://github.com/ClickHouse/ClickHouse/pull/84255) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Don't run 01825_new_type_json_ghdata_insert_select in tsan + msan tests. [#84259](https://github.com/ClickHouse/ClickHouse/pull/84259) ([Robert Schulze](https://github.com/rschu1ze)).
* Partially clean warnings.cmake. [#84263](https://github.com/ClickHouse/ClickHouse/pull/84263) ([Raúl Marín](https://github.com/Algunenano)).
* CI: Fix report info on dead job or runner. [#84264](https://github.com/ClickHouse/ClickHouse/pull/84264) ([Max Kainov](https://github.com/maxknv)).
* CI: Fix long output truncation in ci report. [#84275](https://github.com/ClickHouse/ClickHouse/pull/84275) ([Max Kainov](https://github.com/maxknv)).
* PR planner cleanup. [#84278](https://github.com/ClickHouse/ClickHouse/pull/84278) ([Igor Nikonov](https://github.com/devcrafter)).
* A little bit better 03569_materialize_alias_issue. [#84291](https://github.com/ClickHouse/ClickHouse/pull/84291) ([alesapin](https://github.com/alesapin)).
* disable test 03352_concurrent_rename_alter.sh. [#84302](https://github.com/ClickHouse/ClickHouse/pull/84302) ([Sema Checherinda](https://github.com/CheSema)).
* Fix formatting in docs. [#84303](https://github.com/ClickHouse/ClickHouse/pull/84303) ([Anton Popov](https://github.com/CurtizJ)).
* tests: disable 00328_long_case_construction under msan (too slow). [#84307](https://github.com/ClickHouse/ClickHouse/pull/84307) ([Azat Khuzhin](https://github.com/azat)).
* Fuzzer updates. [#84308](https://github.com/ClickHouse/ClickHouse/pull/84308) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Removing temprary parts may take a while (especially with S3), and currently we do it while holding a global lock in `MergeTreeBackgroundExecutor`. When we need to restart all tables due to connection loss and we wait for background tasks to finish - tables may even stuck in readonly mode for an hour. But looks like we don't need this lock for calling `cancel`. [#84311](https://github.com/ClickHouse/ClickHouse/pull/84311) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Increase from 4 to 6 number of batches for Integration tests (release). [#84313](https://github.com/ClickHouse/ClickHouse/pull/84313) ([Pablo Marcos](https://github.com/pamarcos)).
* Fix the omit `repo` field in logs cluster, use single `ClickHouseProc` class. [#84314](https://github.com/ClickHouse/ClickHouse/pull/84314) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Yet another sz3 fuzzer compression fix. [#84320](https://github.com/ClickHouse/ClickHouse/pull/84320) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Fix `repo` field in exported CI logs. [#84321](https://github.com/ClickHouse/ClickHouse/pull/84321) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix overflow in `estimateNumRowsForMaxSizeColumn`. [#84323](https://github.com/ClickHouse/ClickHouse/pull/84323) ([Nikita Taranov](https://github.com/nickitat)).
* make canKeepAlive thread safe. [#84324](https://github.com/ClickHouse/ClickHouse/pull/84324) ([Sema Checherinda](https://github.com/CheSema)).
* Remove wrong assert from `StorageGenerateRandom`. [#84325](https://github.com/ClickHouse/ClickHouse/pull/84325) ([Nikita Taranov](https://github.com/nickitat)).
* Fix: PR with remote() in subquery. [#84330](https://github.com/ClickHouse/ClickHouse/pull/84330) ([Igor Nikonov](https://github.com/devcrafter)).
* Fix AddressSanitizer: SEGV : Add null pointer check in getQuotaUsage(). [#84334](https://github.com/ClickHouse/ClickHouse/pull/84334) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Add a test for [#60000](https://github.com/ClickHouse/ClickHouse/issues/60000). [#84354](https://github.com/ClickHouse/ClickHouse/pull/84354) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Revert "Revert "Revert "Add SZ3 compression codec""". [#84358](https://github.com/ClickHouse/ClickHouse/pull/84358) ([Raúl Marín](https://github.com/Algunenano)).
* Fix update-modules.sh. [#84366](https://github.com/ClickHouse/ClickHouse/pull/84366) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Update version_date.tsv and changelog after v25.4.13.22-stable. [#84370](https://github.com/ClickHouse/ClickHouse/pull/84370) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* More readable job config. [#84371](https://github.com/ClickHouse/ClickHouse/pull/84371) ([Antonio Andelic](https://github.com/antonio2368)).
* Randomize encrypted disk in functional tests. [#84373](https://github.com/ClickHouse/ClickHouse/pull/84373) ([Antonio Andelic](https://github.com/antonio2368)).
* Print more info of output nodes which are not in processors when printing pipeline. [#84377](https://github.com/ClickHouse/ClickHouse/pull/84377) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Update version_date.tsv and changelog after v25.6.5.41-stable. [#84379](https://github.com/ClickHouse/ClickHouse/pull/84379) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix flaky test_disk_checker/test.py::test_disk_readonly_status. [#84382](https://github.com/ClickHouse/ClickHouse/pull/84382) ([Alexander Gololobov](https://github.com/davenger)).
* Sync ProfileEvents with private. [#84385](https://github.com/ClickHouse/ClickHouse/pull/84385) ([Azat Khuzhin](https://github.com/azat)).
* Disable `00984_parser_stack_overflow` under heavy sanitizers. [#84399](https://github.com/ClickHouse/ClickHouse/pull/84399) ([Nikita Taranov](https://github.com/nickitat)).
* Fix settings sync. [#84410](https://github.com/ClickHouse/ClickHouse/pull/84410) ([Raúl Marín](https://github.com/Algunenano)).
* Replace error with warning during object storage table attaching. [#84414](https://github.com/ClickHouse/ClickHouse/pull/84414) ([Daniil Ivanik](https://github.com/divanik)).
* Remove positional deletes. [#84415](https://github.com/ClickHouse/ClickHouse/pull/84415) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make HTTPHandler's logger protected, enable use in subclasses. [#84416](https://github.com/ClickHouse/ClickHouse/pull/84416) ([Dan Checkoway](https://github.com/dcheckoway)).
* Update README.md. [#84417](https://github.com/ClickHouse/ClickHouse/pull/84417) ([Tyler Hannan](https://github.com/tylerhannan)).
* Try fix `02023_storage_filelog`. [#84418](https://github.com/ClickHouse/ClickHouse/pull/84418) ([Nikita Taranov](https://github.com/nickitat)).
* Update README.md. [#84422](https://github.com/ClickHouse/ClickHouse/pull/84422) ([Zoe Steinkamp](https://github.com/zoesteinkamp)).
* Disallow `00111_shard_external_sort_distributed` test with slow sanitizers. [#84429](https://github.com/ClickHouse/ClickHouse/pull/84429) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Text index: compress on-disk posting lists by Delta + FastPFOR. [#84435](https://github.com/ClickHouse/ClickHouse/pull/84435) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Fixing some table engines while fuzzing. [#84438](https://github.com/ClickHouse/ClickHouse/pull/84438) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Fix test: https://s3.amazonaws.com/clickhouse-test-reports/json.html?PR=83695&sha=latest&name_0=PR&name_1=Integration+tests+%28asan%2C+old+analyzer%2C+1%2F6%29. [#84443](https://github.com/ClickHouse/ClickHouse/pull/84443) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Remove long tests from MSan runs. [#84482](https://github.com/ClickHouse/ClickHouse/pull/84482) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better formatting for INTERPOLATE. [#84496](https://github.com/ClickHouse/ClickHouse/pull/84496) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Minor fixes for Web UI. [#84497](https://github.com/ClickHouse/ClickHouse/pull/84497) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Exclude two tests for vector search from tsan. [#84510](https://github.com/ClickHouse/ClickHouse/pull/84510) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix `00002_log_and_exception_messages_formatting` (1). [#84511](https://github.com/ClickHouse/ClickHouse/pull/84511) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix build after merge. [#84514](https://github.com/ClickHouse/ClickHouse/pull/84514) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove the remainings of MaterializedMySQL. [#84516](https://github.com/ClickHouse/ClickHouse/pull/84516) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Query condition cache: Add tests for issues [#81506](https://github.com/ClickHouse/ClickHouse/issues/81506) and [#84508](https://github.com/ClickHouse/ClickHouse/issues/84508). [#84517](https://github.com/ClickHouse/ClickHouse/pull/84517) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix bad function call in cache policy. [#84519](https://github.com/ClickHouse/ClickHouse/pull/84519) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix leak in gtest_delta_kernel. [#84522](https://github.com/ClickHouse/ClickHouse/pull/84522) ([Azat Khuzhin](https://github.com/azat)).
* Cleanup options for sanitizers (and fix sanitizers reports for unit tests on CI). [#84526](https://github.com/ClickHouse/ClickHouse/pull/84526) ([Azat Khuzhin](https://github.com/azat)).
* Ci: dump stacktraces in case of unit tests aborted or timed out. [#84527](https://github.com/ClickHouse/ClickHouse/pull/84527) ([Azat Khuzhin](https://github.com/azat)).
* Fix `00002_log_and_exception_messages_formatting` (2). [#84537](https://github.com/ClickHouse/ClickHouse/pull/84537) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix `00002_log_and_exception_messages_formatting` (3). [#84538](https://github.com/ClickHouse/ClickHouse/pull/84538) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* ci: disable LTO for slow non-production builds. [#84578](https://github.com/ClickHouse/ClickHouse/pull/84578) ([Azat Khuzhin](https://github.com/azat)).
* tests: optimize 03300_merge_parts_metric. [#84580](https://github.com/ClickHouse/ClickHouse/pull/84580) ([Azat Khuzhin](https://github.com/azat)).
* Add 25.8 release call. [#84581](https://github.com/ClickHouse/ClickHouse/pull/84581) ([Raúl Marín](https://github.com/Algunenano)).
* Fix changelog link. [#84583](https://github.com/ClickHouse/ClickHouse/pull/84583) ([Raúl Marín](https://github.com/Algunenano)).
* Text index: remove multi format versions handling. [#84606](https://github.com/ClickHouse/ClickHouse/pull/84606) ([Elmi Ahmadov](https://github.com/ahmadov)).
* make test 01396_inactive_replica_cleanup_nodes_zookeeper more lightwe…. [#84613](https://github.com/ClickHouse/ClickHouse/pull/84613) ([Han Fei](https://github.com/hanfei1991)).
* Follow-up to [#84311](https://github.com/ClickHouse/ClickHouse/issues/84311). [#84614](https://github.com/ClickHouse/ClickHouse/pull/84614) ([Alexander Tokmakov](https://github.com/tavplubix)).
* ci: add logs for python http server. [#84625](https://github.com/ClickHouse/ClickHouse/pull/84625) ([Azat Khuzhin](https://github.com/azat)).
* follow up for [#84025](https://github.com/ClickHouse/ClickHouse/issues/84025) - fix clickhouse-client crash during highlighting. [#84628](https://github.com/ClickHouse/ClickHouse/pull/84628) ([Bharat Nallan](https://github.com/bharatnc)).
* ci: add missing --text/-a for grep. [#84638](https://github.com/ClickHouse/ClickHouse/pull/84638) ([Azat Khuzhin](https://github.com/azat)).
* Enable encrypted storage in stress checks. [#84643](https://github.com/ClickHouse/ClickHouse/pull/84643) ([Antonio Andelic](https://github.com/antonio2368)).
* Default enable rescoring optimization in ANN search. [#84644](https://github.com/ClickHouse/ClickHouse/pull/84644) ([Shankar Iyer](https://github.com/shankar-iyer)).
* CI: Fix main report result update on rerun. [#84660](https://github.com/ClickHouse/ClickHouse/pull/84660) ([Max Kainov](https://github.com/maxknv)).
* CI: Remove AMD tidy build. [#84665](https://github.com/ClickHouse/ClickHouse/pull/84665) ([Max Kainov](https://github.com/maxknv)).
* Fix for https://s3.amazonaws.com/clickhouse-test-reports/json.html?REF=master&sha=51f0b57edd4bd8c26cba96e7f5dac053dda18d60&name_0=MasterCI&name_1=Stress%20test%20%28azure%2C%20msan%29&name_1=Stress%20test%20%28azure%2C%20msan%29. [#84667](https://github.com/ClickHouse/ClickHouse/pull/84667) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix optional params in table function `mergeTreeIndex`. [#84673](https://github.com/ClickHouse/ClickHouse/pull/84673) ([Anton Popov](https://github.com/CurtizJ)).
* `sccache` sometimes could start during `cmake` configuration, and fail to start. This change starts the server before cmake. [#84674](https://github.com/ClickHouse/ClickHouse/pull/84674) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix inconsistent formatting of query parameters. [#84681](https://github.com/ClickHouse/ClickHouse/pull/84681) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update version_date.tsv and changelog after v25.7.1.3997-stable. [#84685](https://github.com/ClickHouse/ClickHouse/pull/84685) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Add ability to lock/unlock `SharedLockGuard` explicitly. [#84687](https://github.com/ClickHouse/ClickHouse/pull/84687) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Hopefully fix flaky test_refreshable_mat_view/test.py::test_simple_append. [#84690](https://github.com/ClickHouse/ClickHouse/pull/84690) ([Michael Kolupaev](https://github.com/al13n321)).
* Hopefully fix flaky test_refreshable_mv/test.py::test_backup_outer_table. [#84693](https://github.com/ClickHouse/ClickHouse/pull/84693) ([Michael Kolupaev](https://github.com/al13n321)).
* CIDB [link](https://d1k2gkhrlfqv31.cloudfront.net/clickhouse-test-reports-private/json.html?REF=master&sha=9815ee852cba6ea1e945fd5e7599c5f8eb0f07dd&name_0=MasterCI&name_1=Integration%20tests%20%28tsan%2C%204%2F6%29&name_1=Integration%20tests%20%28tsan%2C%204%2F6%29). [#84705](https://github.com/ClickHouse/ClickHouse/pull/84705) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Client: sort logs by time (for send_logs_level) to make debugging easier. [#84706](https://github.com/ClickHouse/ClickHouse/pull/84706) ([Azat Khuzhin](https://github.com/azat)).
* Text index: add internal bloom filter layer. [#84709](https://github.com/ClickHouse/ClickHouse/pull/84709) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Integration tests: add test for detach of replicated table. [#84712](https://github.com/ClickHouse/ClickHouse/pull/84712) ([Nikita Fomichev](https://github.com/fm4v)).
* More stable 01825_new_type_json_ghdata_insert_select [2]. [#84716](https://github.com/ClickHouse/ClickHouse/pull/84716) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* CI: Make debug build faster. [#84739](https://github.com/ClickHouse/ClickHouse/pull/84739) ([Max Kainov](https://github.com/maxknv)).
* Better performance of calculating statistics. [#84740](https://github.com/ClickHouse/ClickHouse/pull/84740) ([Anton Popov](https://github.com/CurtizJ)).
* Avoid kafka consumer group collision. [#84741](https://github.com/ClickHouse/ClickHouse/pull/84741) ([Ilya Golshtein](https://github.com/ilejn)).
* Fix race in `02962_system_sync_replica_lightweight_from_modifier`. [#84743](https://github.com/ClickHouse/ClickHouse/pull/84743) ([Sergei Trifonov](https://github.com/serxa)).
* Reduce amount of data left after test. [#84746](https://github.com/ClickHouse/ClickHouse/pull/84746) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Reduce logging level for "No blob storage log, not writing blob". [#84773](https://github.com/ClickHouse/ClickHouse/pull/84773) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v25.6.6.29-stable. [#84774](https://github.com/ClickHouse/ClickHouse/pull/84774) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Sync changes. [#84801](https://github.com/ClickHouse/ClickHouse/pull/84801) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Make error messages more accurate in CI. [#84802](https://github.com/ClickHouse/ClickHouse/pull/84802) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* `searchAny/searchAll`: do not tokenize input needles. [#84804](https://github.com/ClickHouse/ClickHouse/pull/84804) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Add @tavplubix to official docker maintainers. [#84811](https://github.com/ClickHouse/ClickHouse/pull/84811) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* CI: Integration Tests remove legacy ci wrappers. [#84823](https://github.com/ClickHouse/ClickHouse/pull/84823) ([Max Kainov](https://github.com/maxknv)).
* Change the compatibility value of `apply_patch_parts`. [#84848](https://github.com/ClickHouse/ClickHouse/pull/84848) ([Anton Popov](https://github.com/CurtizJ)).
* Manual private sync. [#84852](https://github.com/ClickHouse/ClickHouse/pull/84852) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Slightly better test `test_restore_replica`. [#84855](https://github.com/ClickHouse/ClickHouse/pull/84855) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Add cached issues, add cache to cherry-pick job. [#84874](https://github.com/ClickHouse/ClickHouse/pull/84874) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Update `03203_hive_style_partitioning.sh`. [#84875](https://github.com/ClickHouse/ClickHouse/pull/84875) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Split Iceberg integration tests. [#84880](https://github.com/ClickHouse/ClickHouse/pull/84880) ([Daniil Ivanik](https://github.com/divanik)).
* Maybe this will fix the crashes like this:. [#84887](https://github.com/ClickHouse/ClickHouse/pull/84887) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Fix `test_keeper_invalid_digest`. [#84897](https://github.com/ClickHouse/ClickHouse/pull/84897) ([Antonio Andelic](https://github.com/antonio2368)).
* ci: improve gathering sanitizers reports by clickhouse-test launcher. [#84898](https://github.com/ClickHouse/ClickHouse/pull/84898) ([Azat Khuzhin](https://github.com/azat)).
* Text index: add tests for `searchAny/searchAll(..., tokens(...))`. [#84900](https://github.com/ClickHouse/ClickHouse/pull/84900) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Sync some changes. [#84929](https://github.com/ClickHouse/ClickHouse/pull/84929) ([alesapin](https://github.com/alesapin)).
* Ci: speed up integration test discovery (10min -> ~10-20sec). [#84936](https://github.com/ClickHouse/ClickHouse/pull/84936) ([Azat Khuzhin](https://github.com/azat)).
* CI: modify `feature_docs.py` to account for autogenerated docs. [#84944](https://github.com/ClickHouse/ClickHouse/pull/84944) ([Shaun Struwig](https://github.com/Blargian)).
* Ignore UNKNOWN_FUNCTION for UDFs during querying system.functions. [#84955](https://github.com/ClickHouse/ClickHouse/pull/84955) ([Azat Khuzhin](https://github.com/azat)).
* CI: Enable final job in MasterCI. [#84963](https://github.com/ClickHouse/ClickHouse/pull/84963) ([Max Kainov](https://github.com/maxknv)).
* tests: fix test_dictionaries_all_layouts_separate_sources flakiness. [#84969](https://github.com/ClickHouse/ClickHouse/pull/84969) ([Azat Khuzhin](https://github.com/azat)).
* Hide LLVM from header files. [#84973](https://github.com/ClickHouse/ClickHouse/pull/84973) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Relax "No system memory limits configured. Ignoring max_bytes_ratio_before_external_*" warning. [#84975](https://github.com/ClickHouse/ClickHouse/pull/84975) ([Azat Khuzhin](https://github.com/azat)).
* `for i in *.oldanalyzer.reference; do diff -q -s $i ${i/oldanalyzer./} >/dev/null && echo $i; done | xargs git rm`. [#84978](https://github.com/ClickHouse/ClickHouse/pull/84978) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Tune Parallelism in Functional tests. [#84980](https://github.com/ClickHouse/ClickHouse/pull/84980) ([Max Kainov](https://github.com/maxknv)).
* Fix flaky test_backup_restore_new/test_cancel_backup.py. [#84985](https://github.com/ClickHouse/ClickHouse/pull/84985) ([Eduard Karacharov](https://github.com/korowa)).
* Functional tests: disable test `03208_multiple_joins_with_storage_join` in parallel replicas job. [#84986](https://github.com/ClickHouse/ClickHouse/pull/84986) ([Nikita Fomichev](https://github.com/fm4v)).
* Allow to use bigger timeouts for zookeeper. [#85008](https://github.com/ClickHouse/ClickHouse/pull/85008) ([Azat Khuzhin](https://github.com/azat)).
* Cleanup test. [#85020](https://github.com/ClickHouse/ClickHouse/pull/85020) ([Kseniia Sumarokova](https://github.com/kssenii)).
* CI: Disable scrapping of minio_audit_log for TSAN. [#85032](https://github.com/ClickHouse/ClickHouse/pull/85032) ([Max Kainov](https://github.com/maxknv)).
* CI: Disable scrapping of minio_audit_log for TSAN. [#85033](https://github.com/ClickHouse/ClickHouse/pull/85033) ([Max Kainov](https://github.com/maxknv)).
* Fix scraping minio_audit_logs for TSan build. [#85039](https://github.com/ClickHouse/ClickHouse/pull/85039) ([Azat Khuzhin](https://github.com/azat)).
* It doesn't really make sense after https://github.com/ClickHouse/ClickHouse/pull/84040 It has to be reimplemented to check logs from all tests. [#85042](https://github.com/ClickHouse/ClickHouse/pull/85042) ([Alexander Tokmakov](https://github.com/tavplubix)).
* This closes [#84401](https://github.com/ClickHouse/ClickHouse/issues/84401). [#85043](https://github.com/ClickHouse/ClickHouse/pull/85043) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Text index: add internal bloom filter layer. [#85054](https://github.com/ClickHouse/ClickHouse/pull/85054) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Add missing skip_unavailable_shards=1 for Cloud Memory (host) dashboard. [#85068](https://github.com/ClickHouse/ClickHouse/pull/85068) ([Azat Khuzhin](https://github.com/azat)).
* CI: Checkout submodules with xargs. [#85074](https://github.com/ClickHouse/ClickHouse/pull/85074) ([Max Kainov](https://github.com/maxknv)).
* Fuzzing Data Lakes. [#85078](https://github.com/ClickHouse/ClickHouse/pull/85078) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Add introspection if `execute_spark_query` failed. [#85080](https://github.com/ClickHouse/ClickHouse/pull/85080) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update version_date.tsv and changelog after v25.6.7.23-stable. [#85085](https://github.com/ClickHouse/ClickHouse/pull/85085) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Apparently, getHashOfLoadedBinary can be slow with sanitizers. https://s3.amazonaws.com/clickhouse-test-reports/REFs/master/31ba6973264659334b6ed911f254ecfa61689ee5//integration_tests_asan_old_analyzer_5_6/integration_run_parallel3_0.log. [#85086](https://github.com/ClickHouse/ClickHouse/pull/85086) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Reduce FormatSettings constructors calls (micro optimization). [#85089](https://github.com/ClickHouse/ClickHouse/pull/85089) ([Azat Khuzhin](https://github.com/azat)).
* Fix typo in iceberg settings. [#85096](https://github.com/ClickHouse/ClickHouse/pull/85096) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Update wait condition for system flush logs. [#85108](https://github.com/ClickHouse/ClickHouse/pull/85108) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Translate comments in very old files. [#85120](https://github.com/ClickHouse/ClickHouse/pull/85120) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix the `--order` parameter in `clickhouse-test`. [#85123](https://github.com/ClickHouse/ClickHouse/pull/85123) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve error message for functions unavailable in FIPS mode. [#85125](https://github.com/ClickHouse/ClickHouse/pull/85125) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Avoid some copies in Keeper. [#85131](https://github.com/ClickHouse/ClickHouse/pull/85131) ([Antonio Andelic](https://github.com/antonio2368)).
* Add name of the broken file to log exception message on failed parse while reading from system.remote_data_path. [#85136](https://github.com/ClickHouse/ClickHouse/pull/85136) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Update README.md. [#85137](https://github.com/ClickHouse/ClickHouse/pull/85137) ([Zoe Steinkamp](https://github.com/zoesteinkamp)).
* Flush jemalloc profile in CI. [#85139](https://github.com/ClickHouse/ClickHouse/pull/85139) ([Antonio Andelic](https://github.com/antonio2368)).
* This closes [#85103](https://github.com/ClickHouse/ClickHouse/issues/85103). [#85147](https://github.com/ClickHouse/ClickHouse/pull/85147) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Avoid Field ctor in QueryLog element. [#85159](https://github.com/ClickHouse/ClickHouse/pull/85159) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Follow-up to [#84854](https://github.com/ClickHouse/ClickHouse/issues/84854). [#85166](https://github.com/ClickHouse/ClickHouse/pull/85166) ([Julia Kartseva](https://github.com/jkartseva)).
* Undo Nix. [#85168](https://github.com/ClickHouse/ClickHouse/pull/85168) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Drop support for `multiSearchAny` from text index. [#85180](https://github.com/ClickHouse/ClickHouse/pull/85180) ([Robert Schulze](https://github.com/rschu1ze)).
* CI: Refactor Install check jobs. [#85182](https://github.com/ClickHouse/ClickHouse/pull/85182) ([Max Kainov](https://github.com/maxknv)).
* This closes: [#85183](https://github.com/ClickHouse/ClickHouse/issues/85183). [#85185](https://github.com/ClickHouse/ClickHouse/pull/85185) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* sync changes to `TemporaryReplaceTableName` from private. [#85186](https://github.com/ClickHouse/ClickHouse/pull/85186) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Disable `01201_read_single_thread_in_order` under MSan. [#85187](https://github.com/ClickHouse/ClickHouse/pull/85187) ([Nikita Taranov](https://github.com/nickitat)).
* Update version_date.tsv and changelog after v25.6.8.10-stable. [#85191](https://github.com/ClickHouse/ClickHouse/pull/85191) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Disable msan/tsan runs for 03394_pr_insert_select_threads. [#85193](https://github.com/ClickHouse/ClickHouse/pull/85193) ([Igor Nikonov](https://github.com/devcrafter)).
* Update version_date.tsv and changelog after v25.7.2.54-stable. [#85194](https://github.com/ClickHouse/ClickHouse/pull/85194) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* keeper-utils: configurable limit for dumping top subtress. [#85198](https://github.com/ClickHouse/ClickHouse/pull/85198) ([Azat Khuzhin](https://github.com/azat)).
* Integration tests: Split tests into batches based on historical test execution time. [#85199](https://github.com/ClickHouse/ClickHouse/pull/85199) ([Nikita Fomichev](https://github.com/fm4v)).
* Disable 01747_system_session_log_long in fips mode. [#85201](https://github.com/ClickHouse/ClickHouse/pull/85201) ([Raúl Marín](https://github.com/Algunenano)).
* Fix test_storage_delta tests run with disabled delta-kernel. [#85237](https://github.com/ClickHouse/ClickHouse/pull/85237) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Allow join sides swapping for ANY join. [#85240](https://github.com/ClickHouse/ClickHouse/pull/85240) ([Nikita Taranov](https://github.com/nickitat)).
* Closes [#84280](https://github.com/ClickHouse/ClickHouse/issues/84280). [#85251](https://github.com/ClickHouse/ClickHouse/pull/85251) ([Nikolay Degterinsky](https://github.com/evillique)).
* Query condition cache: introduce selectivity threshold. [#85253](https://github.com/ClickHouse/ClickHouse/pull/85253) ([zhongyuankai](https://github.com/zhongyuankai)).
* Log scheduled execution time for postponed TTLDelete tasks. [#85266](https://github.com/ClickHouse/ClickHouse/pull/85266) ([yanglongwei](https://github.com/ylw510)).
* Integration tests: CI batching: fix 'updated_at' for master and add skipped tests. [#85272](https://github.com/ClickHouse/ClickHouse/pull/85272) ([Nikita Fomichev](https://github.com/fm4v)).
* Fix sparse checkout for arrow. [#85285](https://github.com/ClickHouse/ClickHouse/pull/85285) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix flaky test_storage_delta::test_filtering_by_virtual_columns. [#85286](https://github.com/ClickHouse/ClickHouse/pull/85286) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update delta-kernel-rs to v0.14.0. [#85287](https://github.com/ClickHouse/ClickHouse/pull/85287) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Do not add result column several times for scalar correlated subquery. [#85307](https://github.com/ClickHouse/ClickHouse/pull/85307) ([Dmitry Novik](https://github.com/novikd)).
* More data lake fixes. [#85311](https://github.com/ClickHouse/ClickHouse/pull/85311) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Threadpool readers configuration as server settings. [#85319](https://github.com/ClickHouse/ClickHouse/pull/85319) ([Eduard Karacharov](https://github.com/korowa)).
* Don't allow to set `prefetch_threadpool_pool_size=0`. [#85322](https://github.com/ClickHouse/ClickHouse/pull/85322) ([Nikita Taranov](https://github.com/nickitat)).
* Move getMergeTreeReaderSettings to a static function. [#85323](https://github.com/ClickHouse/ClickHouse/pull/85323) ([Jimmy Aguilar Mena](https://github.com/Ergus)).
* CI: Refactor compatibility check job. [#85324](https://github.com/ClickHouse/ClickHouse/pull/85324) ([Max Kainov](https://github.com/maxknv)).
* Integration tests: CI batches - do not distribute skipped tests. [#85325](https://github.com/ClickHouse/ClickHouse/pull/85325) ([Nikita Fomichev](https://github.com/fm4v)).
* Fix flaky 03552_filesystem_read_prefetches_log. [#85335](https://github.com/ClickHouse/ClickHouse/pull/85335) ([Eduard Karacharov](https://github.com/korowa)).
* CI: Add retries for get changed files api call. [#85352](https://github.com/ClickHouse/ClickHouse/pull/85352) ([Max Kainov](https://github.com/maxknv)).
* Text index: add internal bloom filter layer. [#85356](https://github.com/ClickHouse/ClickHouse/pull/85356) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Add promql parser `#1`: Add contrib and build scripts. This is part `#1` of https://github.com/ClickHouse/ClickHouse/pull/75036. [#85366](https://github.com/ClickHouse/ClickHouse/pull/85366) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fixup compat of vector search compat setting. [#85370](https://github.com/ClickHouse/ClickHouse/pull/85370) ([Robert Schulze](https://github.com/rschu1ze)).
* Add template function for parsing integers in a non-decimal base. This is part `#2` of https://github.com/ClickHouse/ClickHouse/pull/75036. [#85375](https://github.com/ClickHouse/ClickHouse/pull/85375) ([Vitaly Baranov](https://github.com/vitlibar)).
* Disable some slow tests from some runs. [#85376](https://github.com/ClickHouse/ClickHouse/pull/85376) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add convenient way to enable thread_fuzzer in integration test. [#85378](https://github.com/ClickHouse/ClickHouse/pull/85378) ([Daniil Ivanik](https://github.com/divanik)).
* Fix Prometheus RemoteWrite protocol implementation. This is part `#4` of https://github.com/ClickHouse/ClickHouse/pull/75036. [#85394](https://github.com/ClickHouse/ClickHouse/pull/85394) ([Vitaly Baranov](https://github.com/vitlibar)).
* Sync read if content is in page cache. [#85405](https://github.com/ClickHouse/ClickHouse/pull/85405) ([Antonio Andelic](https://github.com/antonio2368)).
* ci: fix collecting trace_log in ci-logs cluster. [#85429](https://github.com/ClickHouse/ClickHouse/pull/85429) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v25.7.3.13-stable. [#85430](https://github.com/ClickHouse/ClickHouse/pull/85430) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Try fix data race on default ssl context. [#85441](https://github.com/ClickHouse/ClickHouse/pull/85441) ([Nikita Taranov](https://github.com/nickitat)).
* Add ability to crash the server in case of LOGICAL_ERROR. [#85445](https://github.com/ClickHouse/ClickHouse/pull/85445) ([Azat Khuzhin](https://github.com/azat)).
* Lower the level of log entry for retryable s3 errors. [#85449](https://github.com/ClickHouse/ClickHouse/pull/85449) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* CI: Hot import fix. [#85484](https://github.com/ClickHouse/ClickHouse/pull/85484) ([Max Kainov](https://github.com/maxknv)).
* Rework tests for prometheus protocols. Make them faster, use presets via the RemoteWrite protocol for checking instead of scraping metrics each time. [#85485](https://github.com/ClickHouse/ClickHouse/pull/85485) ([Vitaly Baranov](https://github.com/vitlibar)).
* Add compatibility setting to write Date as UInt16 to parquet files. [#85510](https://github.com/ClickHouse/ClickHouse/pull/85510) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix possible UAF of total_memory_tracker on shutdown. [#85513](https://github.com/ClickHouse/ClickHouse/pull/85513) ([Azat Khuzhin](https://github.com/azat)).
* CI: Install check job config fix. [#85515](https://github.com/ClickHouse/ClickHouse/pull/85515) ([Max Kainov](https://github.com/maxknv)).
* Cosmetics in text index code. [#85530](https://github.com/ClickHouse/ClickHouse/pull/85530) ([Robert Schulze](https://github.com/rschu1ze)).
* Integration tests: add filelock for tests with shared networking. [#85532](https://github.com/ClickHouse/ClickHouse/pull/85532) ([Nikita Fomichev](https://github.com/fm4v)).
* CI: Fix import issues in integration tests. [#85537](https://github.com/ClickHouse/ClickHouse/pull/85537) ([Max Kainov](https://github.com/maxknv)).
* Collect jemalloc profiles in integration tests. [#85539](https://github.com/ClickHouse/ClickHouse/pull/85539) ([Azat Khuzhin](https://github.com/azat)).
* Update README.md. [#85541](https://github.com/ClickHouse/ClickHouse/pull/85541) ([craigfinnelly](https://github.com/craigfinnelly)).
* Function `nowInBlock64`: Fix bug [#85534](https://github.com/ClickHouse/ClickHouse/issues/85534). [#85542](https://github.com/ClickHouse/ClickHouse/pull/85542) ([Robert Schulze](https://github.com/rschu1ze)).
* Do manual private sync. [#85543](https://github.com/ClickHouse/ClickHouse/pull/85543) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Validate Variant compact discriminators granule format. [#85544](https://github.com/ClickHouse/ClickHouse/pull/85544) ([Pavel Kruglov](https://github.com/Avogar)).
* Text index: add logging for writing/reading of segment. [#85551](https://github.com/ClickHouse/ClickHouse/pull/85551) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Add a cast if distance function return type different from `_distance` virtual column. [#85557](https://github.com/ClickHouse/ClickHouse/pull/85557) ([Shankar Iyer](https://github.com/shankar-iyer)).
* tests: fix test_async_logger_metrics flakiness. [#85578](https://github.com/ClickHouse/ClickHouse/pull/85578) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix 02933_group_by_memory_usage flakiness (limit number of threads). [#85619](https://github.com/ClickHouse/ClickHouse/pull/85619) ([Alexei Fedotov](https://github.com/leshikus)).
* Update version_date.tsv and changelog after v25.7.4.11-stable. [#85625](https://github.com/ClickHouse/ClickHouse/pull/85625) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Text index: avoid initializing FastPfor CODECFactory. [#85635](https://github.com/ClickHouse/ClickHouse/pull/85635) ([Elmi Ahmadov](https://github.com/ahmadov)).
* CI: Weekly stress job for vector search. [#85638](https://github.com/ClickHouse/ClickHouse/pull/85638) ([Max Kainov](https://github.com/maxknv)).
* Text index: avoid unnecessary copies while generating tokens. [#85640](https://github.com/ClickHouse/ClickHouse/pull/85640) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Small fuzzer fixes. [#85654](https://github.com/ClickHouse/ClickHouse/pull/85654) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Add `--exclude-dependencies` from https://github.com/tox-dev/pipdeptree/pull/488 to build dependencies excluding pipdeptree. Run `reqgenerator.py` first time for style-test container. Add `opanai` package for completion tasks. [#85655](https://github.com/ClickHouse/ClickHouse/pull/85655) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* CI: Weekly stress test. continue. [#85657](https://github.com/ClickHouse/ClickHouse/pull/85657) ([Max Kainov](https://github.com/maxknv)).
* In production, the cardinality is too high for Prometheus to handle. We can still avoid exporting zero values for `merge_failures` because generally the metric indicates a sustained issue and keeps growing, so `increase` and `rate` functions will eventually return non-zero values. (And if the issue is not sustained, then the metric is not of interest to us anyway.). [#85659](https://github.com/ClickHouse/ClickHouse/pull/85659) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Please do not use `xirr.cpp` as a file name. [#85670](https://github.com/ClickHouse/ClickHouse/pull/85670) ([Robert Schulze](https://github.com/rschu1ze)).
* Try fix flaky test_threadpool_readers/test.py. [#85691](https://github.com/ClickHouse/ClickHouse/pull/85691) ([Kseniia Sumarokova](https://github.com/kssenii)).
* ci: increase delay for server startup. [#85698](https://github.com/ClickHouse/ClickHouse/pull/85698) ([Azat Khuzhin](https://github.com/azat)).
* Text index: avoid redundant re-initializing in searchAny/searchAll functions. [#85701](https://github.com/ClickHouse/ClickHouse/pull/85701) ([Elmi Ahmadov](https://github.com/ahmadov)).
* ci: wrap ninja invocations with time to measure memory and CPU time. [#85713](https://github.com/ClickHouse/ClickHouse/pull/85713) ([Azat Khuzhin](https://github.com/azat)).
* Don't store whole manifest file entries for position deletes in object info. [#85740](https://github.com/ClickHouse/ClickHouse/pull/85740) ([Daniil Ivanik](https://github.com/divanik)).
* ci: enable memory profiler. [#85743](https://github.com/ClickHouse/ClickHouse/pull/85743) ([Azat Khuzhin](https://github.com/azat)).
* tests: better 03532_crash_in_aggregation_because_of_lost_exception. [#85744](https://github.com/ClickHouse/ClickHouse/pull/85744) ([Azat Khuzhin](https://github.com/azat)).
* Dynamic memory_limit_mb for TSan (should fix OOMs for TSan stateless jobs). [#85745](https://github.com/ClickHouse/ClickHouse/pull/85745) ([Azat Khuzhin](https://github.com/azat)).
* Fix out-of-order ActionDAG JIT compilation. [#85747](https://github.com/ClickHouse/ClickHouse/pull/85747) ([Jimmy Aguilar Mena](https://github.com/Ergus)).
* ci: fix distribution of integration tests on weekends. [#85761](https://github.com/ClickHouse/ClickHouse/pull/85761) ([Azat Khuzhin](https://github.com/azat)).
* Always schedule direct IO to threadpool for pread_threadpool. [#85765](https://github.com/ClickHouse/ClickHouse/pull/85765) ([Eduard Karacharov](https://github.com/korowa)).
* Fix test: https://s3.amazonaws.com/clickhouse-test-reports/json.html?PR=85698&sha=528856cc8dba02ab2b6ecb7024ac6e23b0e4fc8a&name_0=PR&name_1=Integration%20tests%20%28amd_tsan%2C%204%2F6%29. [#85775](https://github.com/ClickHouse/ClickHouse/pull/85775) ([Tuan Pham Anh](https://github.com/tuanpach)).
* delta lake: add TSA_GUARDED_BY for table snapshot. [#85783](https://github.com/ClickHouse/ClickHouse/pull/85783) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Deprecate unused MergeTree setting. [#85802](https://github.com/ClickHouse/ClickHouse/pull/85802) ([Raúl Marín](https://github.com/Algunenano)).
* Fix flakiness in 03549_system_query_metric_log_with_queries_with_same_query_id. [#85808](https://github.com/ClickHouse/ClickHouse/pull/85808) ([Pablo Marcos](https://github.com/pamarcos)).
* Un-flake `03164_materialize_skip_index_on_merge`. [#85810](https://github.com/ClickHouse/ClickHouse/pull/85810) ([Robert Schulze](https://github.com/rschu1ze)).
* FunctionDocumentation: Improve debug-ability of some weird exceptions. [#85836](https://github.com/ClickHouse/ClickHouse/pull/85836) ([Robert Schulze](https://github.com/rschu1ze)).
* Revert "Merge pull request [#80179](https://github.com/ClickHouse/ClickHouse/issues/80179) from ClickHouse/out_of_order_buckets". [#85844](https://github.com/ClickHouse/ClickHouse/pull/85844) ([Nikita Taranov](https://github.com/nickitat)).
* Add check and logs. [#85885](https://github.com/ClickHouse/ClickHouse/pull/85885) ([Kseniia Sumarokova](https://github.com/kssenii)).
* build: add missing quotes for replacing `AVRO_VERSION`. [#85886](https://github.com/ClickHouse/ClickHouse/pull/85886) ([Zypperia](https://github.com/zypperia)).
* try fix 00365_statistics_in_formats flakyness. [#85896](https://github.com/ClickHouse/ClickHouse/pull/85896) ([Bharat Nallan](https://github.com/bharatnc)).
* Closes [#84577](https://github.com/ClickHouse/ClickHouse/issues/84577). [#85900](https://github.com/ClickHouse/ClickHouse/pull/85900) ([Pavel Kruglov](https://github.com/Avogar)).
* CI: remove swagger from docs job. [#85902](https://github.com/ClickHouse/ClickHouse/pull/85902) ([Shaun Struwig](https://github.com/Blargian)).
* CI: Fix integration tests CIDB results. [#85905](https://github.com/ClickHouse/ClickHouse/pull/85905) ([Max Kainov](https://github.com/maxknv)).
* Integration tests: increase the period of selected tests for batch splitting to 30 days. [#85907](https://github.com/ClickHouse/ClickHouse/pull/85907) ([Nikita Fomichev](https://github.com/fm4v)).
* Slightly better reading of patch parts minmax indexes. [#85935](https://github.com/ClickHouse/ClickHouse/pull/85935) ([Anton Popov](https://github.com/CurtizJ)).
* Closes [#85148](https://github.com/ClickHouse/ClickHouse/issues/85148). [#85936](https://github.com/ClickHouse/ClickHouse/pull/85936) ([Pavel Kruglov](https://github.com/Avogar)).
* Better native integration tests execution. [#85937](https://github.com/ClickHouse/ClickHouse/pull/85937) ([Azat Khuzhin](https://github.com/azat)).
* tests: better searching for clickhouse binary in clickhouse-test. [#85938](https://github.com/ClickHouse/ClickHouse/pull/85938) ([Azat Khuzhin](https://github.com/azat)).
* ci: sanity checks for cherry pick script against empty responses from GitHub. [#85957](https://github.com/ClickHouse/ClickHouse/pull/85957) ([Azat Khuzhin](https://github.com/azat)).
* Revert "Query condition cache: introduce selectivity threshold". [#85965](https://github.com/ClickHouse/ClickHouse/pull/85965) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix broken test 03573_json_keys_with_dots. [#85978](https://github.com/ClickHouse/ClickHouse/pull/85978) ([Pavel Kruglov](https://github.com/Avogar)).
* Text index: Refactor GinFilter a bit. [#85979](https://github.com/ClickHouse/ClickHouse/pull/85979) ([Jimmy Aguilar Mena](https://github.com/Ergus)).
* Allow to write parquet field ids for simple types in native output format. [#85983](https://github.com/ClickHouse/ClickHouse/pull/85983) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Fix flaky test 01730_distributed_group_by_no_merge_order_by_long. [#85984](https://github.com/ClickHouse/ClickHouse/pull/85984) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Fix broken test 03595_alter_drop_column_comment_if_exists. [#86001](https://github.com/ClickHouse/ClickHouse/pull/86001) ([Pavel Kruglov](https://github.com/Avogar)).
* Closes [#85999](https://github.com/ClickHouse/ClickHouse/issues/85999). [#86003](https://github.com/ClickHouse/ClickHouse/pull/86003) ([Pavel Kruglov](https://github.com/Avogar)).
* Refactoring: Unnest `GinFilter::QueryString`. [#86004](https://github.com/ClickHouse/ClickHouse/pull/86004) ([Robert Schulze](https://github.com/rschu1ze)).
* tests: remove 02432_s3_parallel_parts_cleanup (uses zero-copy). [#86006](https://github.com/ClickHouse/ClickHouse/pull/86006) ([Azat Khuzhin](https://github.com/azat)).
* Improve local (running pytest directly from host) integration tests execution. [#86029](https://github.com/ClickHouse/ClickHouse/pull/86029) ([Azat Khuzhin](https://github.com/azat)).
* Improve waiting for specific line in logs in integration tests (fixes some flakiness on CI). [#86030](https://github.com/ClickHouse/ClickHouse/pull/86030) ([Azat Khuzhin](https://github.com/azat)).
* Capture server stacktrace in integration tests if it hanged during shutdown. [#86043](https://github.com/ClickHouse/ClickHouse/pull/86043) ([Azat Khuzhin](https://github.com/azat)).
* Fix tuple deserialization cleanup order. [#86060](https://github.com/ClickHouse/ClickHouse/pull/86060) ([Raufs Dunamalijevs](https://github.com/rienath)).
* `LogsSeriesLimiter` appeared to be not thread-safe, thus it's removed from the S3Client. This closes: [#86088](https://github.com/ClickHouse/ClickHouse/issues/86088). [#86090](https://github.com/ClickHouse/ClickHouse/pull/86090) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Backported in [#86125](https://github.com/ClickHouse/ClickHouse/issues/86125): Fix use-after-free in parquet reader v3. [#86099](https://github.com/ClickHouse/ClickHouse/pull/86099) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#86318](https://github.com/ClickHouse/ClickHouse/issues/86318): Fix parquet reader v3 incorrectly skipping pages after prewhere. [#86100](https://github.com/ClickHouse/ClickHouse/pull/86100) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#86127](https://github.com/ClickHouse/ClickHouse/issues/86127): Fix double free in parquet reader v3 finishRowSubgroupStage. [#86105](https://github.com/ClickHouse/ClickHouse/pull/86105) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#86316](https://github.com/ClickHouse/ClickHouse/issues/86316): Trivial count optimization in parquet reader v3. [#86144](https://github.com/ClickHouse/ClickHouse/pull/86144) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#86236](https://github.com/ClickHouse/ClickHouse/issues/86236): Add MT setting `max_digestion_size_per_segment` back, mark as obsolete. [#86170](https://github.com/ClickHouse/ClickHouse/pull/86170) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#86235](https://github.com/ClickHouse/ClickHouse/issues/86235): Closes [#86134](https://github.com/ClickHouse/ClickHouse/issues/86134) Closes [#86133](https://github.com/ClickHouse/ClickHouse/issues/86133). [#86171](https://github.com/ClickHouse/ClickHouse/pull/86171) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86284](https://github.com/ClickHouse/ClickHouse/issues/86284): Fix some settings in 25.8. [#86226](https://github.com/ClickHouse/ClickHouse/pull/86226) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#86352](https://github.com/ClickHouse/ClickHouse/issues/86352): Add EXPERIMENTAL flag to input_format_parquet_use_native_reader_v3 setting. [#86237](https://github.com/ClickHouse/ClickHouse/pull/86237) ([Michael Kolupaev](https://github.com/al13n321)).

