---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.7.8.71-stable (172d0882453) FIXME as compared to v25.7.7.68-stable (7e68b82051a)

#### Improvement
* Backported in [#87814](https://github.com/ClickHouse/ClickHouse/issues/87814): Make flushing to `system.crash_log` in signal handling synchronous. [#87253](https://github.com/ClickHouse/ClickHouse/pull/87253) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Backported in [#87977](https://github.com/ClickHouse/ClickHouse/issues/87977): Filesystem cache improvement: reuse cache priority iterator among threads concurrently reserving space in cache. [#87914](https://github.com/ClickHouse/ClickHouse/pull/87914) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#88298](https://github.com/ClickHouse/ClickHouse/issues/88298): Update azure sdk to include 'Content-Length' fix that is seen with copy and create container functionalities. [#88278](https://github.com/ClickHouse/ClickHouse/pull/88278) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#87740](https://github.com/ClickHouse/ClickHouse/issues/87740): Fixed GeoParquet causing client protocol errors. [#84020](https://github.com/ClickHouse/ClickHouse/pull/84020) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#87523](https://github.com/ClickHouse/ClickHouse/issues/87523): Check access rights during typo correction hints generation for the database name. [#85371](https://github.com/ClickHouse/ClickHouse/pull/85371) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#87666](https://github.com/ClickHouse/ClickHouse/issues/87666): Fix detach/attach for postgres database engine tables with numeric/decimal columns. [#86480](https://github.com/ClickHouse/ClickHouse/pull/86480) ([Julian Maicher](https://github.com/jmaicher)).
* Backported in [#88222](https://github.com/ClickHouse/ClickHouse/issues/88222): Fixes a crash where some valid user-submitted data to an `AggregateFunction(quantileDD)` column could cause merges to recurse infinitely. [#86560](https://github.com/ClickHouse/ClickHouse/pull/86560) ([Raphaël Thériault](https://github.com/raphael-theriault-swi)).
* Backported in [#87638](https://github.com/ClickHouse/ClickHouse/issues/87638): Fix result of function calculated in CTE being non-deterministic in the query. [#86967](https://github.com/ClickHouse/ClickHouse/pull/86967) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Backported in [#87237](https://github.com/ClickHouse/ClickHouse/issues/87237): Fixed lightweight updates with `ON CLUSTER` clause. [#87043](https://github.com/ClickHouse/ClickHouse/pull/87043) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#87166](https://github.com/ClickHouse/ClickHouse/issues/87166): Fix reading array with array sizes subcolumn in lazy materialization. [#87139](https://github.com/ClickHouse/ClickHouse/pull/87139) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#87820](https://github.com/ClickHouse/ClickHouse/issues/87820): The function checkHeaders is now properly validating the provided headers and reject forbidden headers. Original author: Michael Anastasakis (@michael-anastasakis). [#87172](https://github.com/ClickHouse/ClickHouse/pull/87172) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#87477](https://github.com/ClickHouse/ClickHouse/issues/87477): Make pathStartsWith only match paths under the prefix. [#87181](https://github.com/ClickHouse/ClickHouse/pull/87181) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#87812](https://github.com/ClickHouse/ClickHouse/issues/87812): Fixed lightweight updates with subqueries that read from another `MergeTree` tables. [#87285](https://github.com/ClickHouse/ClickHouse/pull/87285) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#87454](https://github.com/ClickHouse/ClickHouse/issues/87454): Ignore only not found errors for `s3_plain_rewritable` (which may lead to all sort of troubles). [#87426](https://github.com/ClickHouse/ClickHouse/pull/87426) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#87728](https://github.com/ClickHouse/ClickHouse/issues/87728): Fixes access validation on select and insert for Buffer tables. [#87545](https://github.com/ClickHouse/ClickHouse/pull/87545) ([pufit](https://github.com/pufit)).
* Backported in [#87832](https://github.com/ClickHouse/ClickHouse/issues/87832): Avoid leaking of tracked memory for async logging (can have a significant drift, for 10 hours, ~100GiB) and text_log (almost same drift is possible). [#87584](https://github.com/ClickHouse/ClickHouse/pull/87584) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#87769](https://github.com/ClickHouse/ClickHouse/issues/87769): Fixed a bug that might lead to overriding global server settings with SELECT settings of a View or Materialized View, if this view was dropped asynchronously and the server was restarted before finishing background cleanup. [#87603](https://github.com/ClickHouse/ClickHouse/pull/87603) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#88507](https://github.com/ClickHouse/ClickHouse/issues/88507): Fix reading null map subcolumn from Variants that cannot be inside Nullable. [#87798](https://github.com/ClickHouse/ClickHouse/pull/87798) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#87907](https://github.com/ClickHouse/ClickHouse/issues/87907): Fix several skip indices bugs. [#87817](https://github.com/ClickHouse/ClickHouse/pull/87817) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#88071](https://github.com/ClickHouse/ClickHouse/issues/88071): Fix merge with projections when the last block is empty. [#87928](https://github.com/ClickHouse/ClickHouse/pull/87928) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#88488](https://github.com/ClickHouse/ClickHouse/issues/88488): Fix for incorrect granules/partitions elimination for datetime-based keys, when using `session_timezone` setting in queries. [#87987](https://github.com/ClickHouse/ClickHouse/pull/87987) ([Eduard Karacharov](https://github.com/korowa)).
* Backported in [#88145](https://github.com/ClickHouse/ClickHouse/issues/88145): Fixed possible data corruption in `MergeTree` tables with set column `TTL`. [#88095](https://github.com/ClickHouse/ClickHouse/pull/88095) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#88172](https://github.com/ClickHouse/ClickHouse/issues/88172): Fix possible uncaught exception while reading `system.tables` with invalid tables in external databases (`PostgreSQL`/`SQLite`/...) attached. [#88105](https://github.com/ClickHouse/ClickHouse/pull/88105) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#88283](https://github.com/ClickHouse/ClickHouse/issues/88283): Fixed propagation of `is_shared` flag in `ColumnLowCardinality`. It may lead to a wrong group-by result if a new value is inserted in a column after hash values are already pre-calculated and cached in the `ReverseIndex`. [#88213](https://github.com/ClickHouse/ClickHouse/pull/88213) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#88334](https://github.com/ClickHouse/ClickHouse/issues/88334): Now correlated subqueries will work with object storages. [#88290](https://github.com/ClickHouse/ClickHouse/pull/88290) ([alesapin](https://github.com/alesapin)).
* Backported in [#88354](https://github.com/ClickHouse/ClickHouse/issues/88354): Avoid trying to initialize DataLake databases while accessing `system.projections` and `system.data_skipping_indices`. [#88330](https://github.com/ClickHouse/ClickHouse/pull/88330) ([Azat Khuzhin](https://github.com/azat)).

#### Build/Testing/Packaging Improvement
* Backported in [#87880](https://github.com/ClickHouse/ClickHouse/issues/87880): Use `postgres` 18.0. [#87647](https://github.com/ClickHouse/ClickHouse/pull/87647) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### NO CL ENTRY

* NO CL ENTRY:  'Fix output_format_parquet_date_as_uint16 backport'. [#87867](https://github.com/ClickHouse/ClickHouse/pull/87867) ([Michael Kolupaev](https://github.com/al13n321)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#87749](https://github.com/ClickHouse/ClickHouse/issues/87749): Fix RMV tryEnqueueReplicatedDDL shutdown crash again. [#78873](https://github.com/ClickHouse/ClickHouse/pull/78873) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#87500](https://github.com/ClickHouse/ClickHouse/issues/87500): EmbeddedRocksDB: Go back to using data/ path by default. [#87463](https://github.com/ClickHouse/ClickHouse/pull/87463) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#87857](https://github.com/ClickHouse/ClickHouse/issues/87857): Don't crash if a vector similarity index cannot be saved to / loaded from persistence. [#87803](https://github.com/ClickHouse/ClickHouse/pull/87803) ([Azat Khuzhin](https://github.com/azat)).
* 25.7 backport. Fix missing bitnami image. [#88194](https://github.com/ClickHouse/ClickHouse/pull/88194) ([Nikita Fomichev](https://github.com/fm4v)).
* Backported in [#88449](https://github.com/ClickHouse/ClickHouse/issues/88449): fix threads count for inserts. [#88339](https://github.com/ClickHouse/ClickHouse/pull/88339) ([Sema Checherinda](https://github.com/CheSema)).

