---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.7.2.54-stable (f3e0b608695) FIXME as compared to v25.7.1.3997-stable (28a03cae61b)

#### Improvement
* Backported in [#84783](https://github.com/ClickHouse/ClickHouse/issues/84783): This change adds a dimensional metric for the size of `ConcurrentBoundedQueue`, labelled by the queue type (i.e. what the queue is there for) and queue id (i.e. randomly generated id for the current instance of the queue). [#84675](https://github.com/ClickHouse/ClickHouse/pull/84675) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Backported in [#85007](https://github.com/ClickHouse/ClickHouse/issues/85007): Add 4LW in Keeper, `lgrq`, for toggling request logging of received requests. [#84719](https://github.com/ClickHouse/ClickHouse/pull/84719) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#84869](https://github.com/ClickHouse/ClickHouse/issues/84869): Reduce contention on storage lock in Keeper. [#84732](https://github.com/ClickHouse/ClickHouse/pull/84732) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85001](https://github.com/ClickHouse/ClickHouse/issues/85001): Limit Keeper log entry cache size by number of entries using `keeper_server.coordination_settings.latest_logs_cache_entry_count_threshold` and `keeper_server.coordination_settings.commit_logs_cache_entry_count_threshold`. [#84877](https://github.com/ClickHouse/ClickHouse/pull/84877) ([Antonio Andelic](https://github.com/antonio2368)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#84845](https://github.com/ClickHouse/ClickHouse/issues/84845): This closes [#81303](https://github.com/ClickHouse/ClickHouse/issues/81303). [#83892](https://github.com/ClickHouse/ClickHouse/pull/83892) ([Konstantin Vedernikov](https://github.com/scanhex12)).
* Backported in [#84833](https://github.com/ClickHouse/ClickHouse/issues/84833): Fix logger usage in `IAccessStorage`. [#84365](https://github.com/ClickHouse/ClickHouse/pull/84365) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#85091](https://github.com/ClickHouse/ClickHouse/issues/85091): Stops taking schema from manifest files but stores relevant schemas for each snapshot independently. Infer relevant schema for each data file from its corresponding snapshot. Previous behaviour violated Iceberg specification for manifest files entries with existing status. [#84588](https://github.com/ClickHouse/ClickHouse/pull/84588) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#85079](https://github.com/ClickHouse/ClickHouse/issues/85079): Fix logical error from S3Queue "Table is already registered". Closes [#84433](https://github.com/ClickHouse/ClickHouse/issues/84433). Broken after https://github.com/ClickHouse/ClickHouse/pull/83530. [#84677](https://github.com/ClickHouse/ClickHouse/pull/84677) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#84729](https://github.com/ClickHouse/ClickHouse/issues/84729): Lock 'mutex' when getting zookeeper from 'view' in RefreshTask. [#84699](https://github.com/ClickHouse/ClickHouse/pull/84699) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Backported in [#84819](https://github.com/ClickHouse/ClickHouse/issues/84819): Fix `CORRUPTED_DATA` error when lazy columns are used with external sort. [#84738](https://github.com/ClickHouse/ClickHouse/pull/84738) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Backported in [#84813](https://github.com/ClickHouse/ClickHouse/issues/84813): Fix column pruning with delta-kernel in storage `DeltaLake`. Closes [#84543](https://github.com/ClickHouse/ClickHouse/issues/84543). [#84745](https://github.com/ClickHouse/ClickHouse/pull/84745) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#85143](https://github.com/ClickHouse/ClickHouse/issues/85143): Refresh credentials in delta-kernel in storage DeltaLake. [#84751](https://github.com/ClickHouse/ClickHouse/pull/84751) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#84883](https://github.com/ClickHouse/ClickHouse/issues/84883): Fixed lightweight updates for tables with `ReplacingMergeTree` and `CollapsingMergeTree` engines. [#84851](https://github.com/ClickHouse/ClickHouse/pull/84851) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#84995](https://github.com/ClickHouse/ClickHouse/issues/84995): Fix total watches count returned by Keeper. [#84890](https://github.com/ClickHouse/ClickHouse/pull/84890) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#84948](https://github.com/ClickHouse/ClickHouse/issues/84948): Fixed lightweight updates for tables with `ReplicatedMergeTree` engine created on servers with a version lower than 25.7. [#84933](https://github.com/ClickHouse/ClickHouse/pull/84933) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#85047](https://github.com/ClickHouse/ClickHouse/issues/85047): Fixed lightweight updates for tables with non-replicated `MergeTree` engine after running a `ALTER TABLE ... REPLACE PARTITION` query. [#84941](https://github.com/ClickHouse/ClickHouse/pull/84941) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#84962](https://github.com/ClickHouse/ClickHouse/issues/84962): Fix memory tracking drift from background schedule pool and executor. [#84946](https://github.com/ClickHouse/ClickHouse/pull/84946) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#85117](https://github.com/ClickHouse/ClickHouse/issues/85117): Add a check if a correlated subquery is used in a distributed context to avoid a crash. Fixes [#82205](https://github.com/ClickHouse/ClickHouse/issues/82205). [#85030](https://github.com/ClickHouse/ClickHouse/pull/85030) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#85158](https://github.com/ClickHouse/ClickHouse/issues/85158): Fixed double-free in `AzureIteratorAsync`. [#85064](https://github.com/ClickHouse/ClickHouse/pull/85064) ([Nikita Taranov](https://github.com/nickitat)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#84797](https://github.com/ClickHouse/ClickHouse/issues/84797): Previously, `FilterTransform` could stop reading if the expression for any chunk returned a constant `false`. This can lead to a bug, because constant columns are allowed to appear during the execution, and most function default implementations will preserve constants as well. [#83855](https://github.com/ClickHouse/ClickHouse/pull/83855) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#85053](https://github.com/ClickHouse/ClickHouse/issues/85053): Fix  test_storage_s3_queue/test_5.py::test_shutdown_order. [#83867](https://github.com/ClickHouse/ClickHouse/pull/83867) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#84757](https://github.com/ClickHouse/ClickHouse/issues/84757): follow up for [#84025](https://github.com/ClickHouse/ClickHouse/issues/84025) - fix clickhouse-client crash during highlighting. [#84628](https://github.com/ClickHouse/ClickHouse/pull/84628) ([Bharat Nallan](https://github.com/bharatnc)).
* Backported in [#85037](https://github.com/ClickHouse/ClickHouse/issues/85037): Fix for https://s3.amazonaws.com/clickhouse-test-reports/json.html?REF=master&sha=51f0b57edd4bd8c26cba96e7f5dac053dda18d60&name_0=MasterCI&name_1=Stress%20test%20%28azure%2C%20msan%29&name_1=Stress%20test%20%28azure%2C%20msan%29. [#84667](https://github.com/ClickHouse/ClickHouse/pull/84667) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#84839](https://github.com/ClickHouse/ClickHouse/issues/84839): Add ability to lock/unlock `SharedLockGuard` explicitly. [#84687](https://github.com/ClickHouse/ClickHouse/pull/84687) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Backported in [#85065](https://github.com/ClickHouse/ClickHouse/issues/85065): Reduce amount of data left after test. [#84746](https://github.com/ClickHouse/ClickHouse/pull/84746) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#84892](https://github.com/ClickHouse/ClickHouse/issues/84892): Change the compatibility value of `apply_patch_parts`. [#84848](https://github.com/ClickHouse/ClickHouse/pull/84848) ([Anton Popov](https://github.com/CurtizJ)).

