---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.5.7.52-stable (6e66ab95d8a) FIXME as compared to v25.5.6.14-stable (ac7909e3af3)

#### Performance Improvement
* Backported in [#83341](https://github.com/ClickHouse/ClickHouse/issues/83341): Try to speedup QueryTreeHash a bit. [#82617](https://github.com/ClickHouse/ClickHouse/pull/82617) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).

#### Improvement
* Backported in [#83014](https://github.com/ClickHouse/ClickHouse/issues/83014): Keeper improvement: move changelog files between disk in a background thread. Previously, moving changelog to a different disk would block Keeper globally until the move is finished. This lead to performance degradation if moving is a long operation (e.g. to S3 disk). [#82485](https://github.com/ClickHouse/ClickHouse/pull/82485) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#83268](https://github.com/ClickHouse/ClickHouse/issues/83268): Fix the wrong default value for the `--reconnect` option in `clickhouse-benchmark`. It was changed by mistake in [#79465](https://github.com/ClickHouse/ClickHouse/issues/79465). [#82677](https://github.com/ClickHouse/ClickHouse/pull/82677) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#83152](https://github.com/ClickHouse/ClickHouse/issues/83152): Add columns `commit_time`, `commit_id` to `system.s3queue_log`. [#83016](https://github.com/ClickHouse/ClickHouse/pull/83016) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#83634](https://github.com/ClickHouse/ClickHouse/issues/83634): When `distributed_ddl_output_mode='*_only_active'`, don't wait for new or recovered replicas that have replication lag bigger than `max_replication_lag_to_enqueue`. This should help to avoid `DDL task is not finished on some hosts` when a new replica becomes active after finishing initialization or recovery, but it accumulated huge replication log while initializing. Also, implement `SYSTEM SYNC DATABASE REPLICA STRICT` query that waits for replication log to become below `max_replication_lag_to_enqueue`. [#83302](https://github.com/ClickHouse/ClickHouse/pull/83302) ([Alexander Tokmakov](https://github.com/tavplubix)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#83256](https://github.com/ClickHouse/ClickHouse/issues/83256): Fix disabling boundary alignment for cached buffer in external table engines. It was broken in https://github.com/ClickHouse/ClickHouse/pull/81868. [#82493](https://github.com/ClickHouse/ClickHouse/pull/82493) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#82913](https://github.com/ClickHouse/ClickHouse/issues/82913): In AzureBlobStorage, for native copy we compare authentication methods, during which if we get an exception, updated the code to fallback to read and copy (i.e. non native copy). [#82693](https://github.com/ClickHouse/ClickHouse/pull/82693) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Backported in [#83112](https://github.com/ClickHouse/ClickHouse/issues/83112): Fix exception safety in union/intersect/except_default_mode rewrite. Closes [#82664](https://github.com/ClickHouse/ClickHouse/issues/82664). [#82820](https://github.com/ClickHouse/ClickHouse/pull/82820) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#83289](https://github.com/ClickHouse/ClickHouse/issues/83289): Set salt for auth data when parsing from AST with type SCRAM_SHA256_PASSWORD. [#82888](https://github.com/ClickHouse/ClickHouse/pull/82888) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Backported in [#83027](https://github.com/ClickHouse/ClickHouse/issues/83027): Fix filter modification for queries with a JOIN expression with a table with storage `Merge`. Fixes [#82092](https://github.com/ClickHouse/ClickHouse/issues/82092). [#82950](https://github.com/ClickHouse/ClickHouse/pull/82950) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#83311](https://github.com/ClickHouse/ClickHouse/issues/83311): Fix LOGICAL_ERROR in QueryMetricLog: Mutex cannot be NULL. [#82979](https://github.com/ClickHouse/ClickHouse/pull/82979) ([Pablo Marcos](https://github.com/pamarcos)).
* Backported in [#83240](https://github.com/ClickHouse/ClickHouse/issues/83240): Fix performance degradation with the enabled analyzer when secondary queries always read all columns from the VIEWs. Fixes [#81718](https://github.com/ClickHouse/ClickHouse/issues/81718). [#83036](https://github.com/ClickHouse/ClickHouse/pull/83036) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#83173](https://github.com/ClickHouse/ClickHouse/issues/83173): Fix misleading error message when restoring a backup on a read-only disk. [#83051](https://github.com/ClickHouse/ClickHouse/pull/83051) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#83142](https://github.com/ClickHouse/ClickHouse/issues/83142): Do not use unrelated parts of a shared dictionary in the `lowCardinalityKeys` function. [#83118](https://github.com/ClickHouse/ClickHouse/pull/83118) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#83404](https://github.com/ClickHouse/ClickHouse/issues/83404): Fix `no_sign_request` for S3 client. It can be used to explicitly avoid signing S3 requests. It can also be defined for specific endpoints using endpoint-based settings. [#83379](https://github.com/ClickHouse/ClickHouse/pull/83379) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#83722](https://github.com/ClickHouse/ClickHouse/issues/83722): Fixes a crash that may happen for a query with a setting 'max_threads=1' when executed under load with CPU scheduling enabled. [#83387](https://github.com/ClickHouse/ClickHouse/pull/83387) ([Fan Ziqi](https://github.com/f2quantum)).
* Backported in [#83452](https://github.com/ClickHouse/ClickHouse/issues/83452): Fix `TOO_DEEP_SUBQUERIES` exception when CTE definition references another table expression with the same name. [#83413](https://github.com/ClickHouse/ClickHouse/pull/83413) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#83555](https://github.com/ClickHouse/ClickHouse/issues/83555): Disable bounds-based file pruning for iceberg array element and iceberg map values, including all their nested subfields. [#83520](https://github.com/ClickHouse/ClickHouse/pull/83520) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#83672](https://github.com/ClickHouse/ClickHouse/issues/83672): Fix incorrect memory around max_untracked_memory. [#83607](https://github.com/ClickHouse/ClickHouse/pull/83607) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#83662](https://github.com/ClickHouse/ClickHouse/issues/83662): INSERT SELECT with UNION ALL could lead to a null pointer dereference in a corner case. This closes [#83618](https://github.com/ClickHouse/ClickHouse/issues/83618). [#83643](https://github.com/ClickHouse/ClickHouse/pull/83643) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#83743](https://github.com/ClickHouse/ClickHouse/issues/83743): Fix endless loop in estimateCompressionRatio() with block_size_bytes=0. [#83704](https://github.com/ClickHouse/ClickHouse/pull/83704) ([Azat Khuzhin](https://github.com/azat)).

#### Build/Testing/Packaging Improvement
* Backported in [#83651](https://github.com/ClickHouse/ClickHouse/issues/83651): Apply fix for CVE-2025-6375 in Poco from upstream. [#82647](https://github.com/ClickHouse/ClickHouse/pull/82647) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#83537](https://github.com/ClickHouse/ClickHouse/issues/83537): Use `expat` 2.7.1 inside Poco. [#82661](https://github.com/ClickHouse/ClickHouse/pull/82661) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#82766](https://github.com/ClickHouse/ClickHouse/issues/82766): Add a setting to preserve old behaviour of dateTrunc function. [#82530](https://github.com/ClickHouse/ClickHouse/pull/82530) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#83568](https://github.com/ClickHouse/ClickHouse/issues/83568): Bring back `--pre-pull` command to the integration tests jobs, it was deleted in [#73291](https://github.com/ClickHouse/ClickHouse/issues/73291). [#83528](https://github.com/ClickHouse/ClickHouse/pull/83528) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

