---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.5.3.75-stable (3321577b6dd) FIXME as compared to v25.5.2.47-stable (bb5f156f689)

#### Performance Improvement
* Backported in [#81856](https://github.com/ClickHouse/ClickHouse/issues/81856): Avoid unnecessary update and reduce lock contention in QueryConditionCache. [#80247](https://github.com/ClickHouse/ClickHouse/pull/80247) ([Jiebin Sun](https://github.com/jiebinn)).
* Backported in [#81748](https://github.com/ClickHouse/ClickHouse/issues/81748): Fixed performance regression in memory tracking. [#81694](https://github.com/ClickHouse/ClickHouse/pull/81694) ([Michael Kolupaev](https://github.com/al13n321)).

#### Improvement
* Backported in [#81179](https://github.com/ClickHouse/ClickHouse/issues/81179): Now `system.iceberg_history` shows history for catalogs databases like glue or iceberg rest. Also renamed `table_name` and `database_name` columns to `table` and `database` in `system.iceberg_history` for consistency. [#80975](https://github.com/ClickHouse/ClickHouse/pull/80975) ([alesapin](https://github.com/alesapin)).
* Backported in [#81230](https://github.com/ClickHouse/ClickHouse/issues/81230): Upgrade libarchive to 3.7.9 to address: CVE-2024-20696 CVE-2025-25724 CVE-2024-48958 CVE-2024-57970 CVE-2025-1632 CVE-2024-48957 CVE-2024-48615. [#81174](https://github.com/ClickHouse/ClickHouse/pull/81174) ([larryluogit](https://github.com/larryluogit)).
* Backported in [#81538](https://github.com/ClickHouse/ClickHouse/issues/81538): Upgrade libxml2 to 2.14.3. [#81187](https://github.com/ClickHouse/ClickHouse/pull/81187) ([larryluogit](https://github.com/larryluogit)).
* Backported in [#81317](https://github.com/ClickHouse/ClickHouse/issues/81317): MemoryResidentWithoutPageCache provides the amount of physical memory used by the server process, excluding userspace page cache, in bytes. This provides a more accurate view of actual memory usage when userspace page cache is utilized. When userspace page cache is disabled, this value equals MemoryResident. [#81233](https://github.com/ClickHouse/ClickHouse/pull/81233) ([Jayme Bird](https://github.com/jaymebrd)).
* Backported in [#81411](https://github.com/ClickHouse/ClickHouse/issues/81411): In filesystem with journal `mkdir` is written to the journal of filesystem which is persisted to disk. In case of slow disk this can take long time. Definitely make sense to move out from reserve lock scope. [#81371](https://github.com/ClickHouse/ClickHouse/pull/81371) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#81488](https://github.com/ClickHouse/ClickHouse/issues/81488): Use `krb5` 1.21.3-final. [#81453](https://github.com/ClickHouse/ClickHouse/pull/81453) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#81480](https://github.com/ClickHouse/ClickHouse/issues/81480): Use `orc` 2.1.2. [#81455](https://github.com/ClickHouse/ClickHouse/pull/81455) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#81668](https://github.com/ClickHouse/ClickHouse/issues/81668): Postpone reading of Iceberg manifest files until first reading query. [#81619](https://github.com/ClickHouse/ClickHouse/pull/81619) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#81803](https://github.com/ClickHouse/ClickHouse/issues/81803): Add profile event `PageCacheReadBytes`. [#81742](https://github.com/ClickHouse/ClickHouse/pull/81742) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#81932](https://github.com/ClickHouse/ClickHouse/issues/81932): Try fix logical error in filesystem cache: "Having zero bytes but range is not finished". [#81868](https://github.com/ClickHouse/ClickHouse/pull/81868) ([Kseniia Sumarokova](https://github.com/kssenii)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#81448](https://github.com/ClickHouse/ClickHouse/issues/81448): Fix CTE usage in pushed-down predicates when `allow_push_predicate_ast_for_distributed_subqueries` is enabled. Fixes [#75647](https://github.com/ClickHouse/ClickHouse/issues/75647). Fixes [#79672](https://github.com/ClickHouse/ClickHouse/issues/79672). [#77316](https://github.com/ClickHouse/ClickHouse/pull/77316) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#81428](https://github.com/ClickHouse/ClickHouse/issues/81428): Fix logical errors about a column's unknown origin scope produced while checking if this column is correlated. Fixes [#78183](https://github.com/ClickHouse/ClickHouse/issues/78183). Fixes [#79451](https://github.com/ClickHouse/ClickHouse/issues/79451). [#79727](https://github.com/ClickHouse/ClickHouse/pull/79727) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#81298](https://github.com/ClickHouse/ClickHouse/issues/81298): Disabling hive partitioning for datalakes Partially addresses https://github.com/issues/assigned?issue=ClickHouse%7CClickHouse%7C79937. [#80005](https://github.com/ClickHouse/ClickHouse/pull/80005) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#80835](https://github.com/ClickHouse/ClickHouse/issues/80835): Fix possible logical errors and crashes in projections with subcolumns. [#80333](https://github.com/ClickHouse/ClickHouse/pull/80333) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81291](https://github.com/ClickHouse/ClickHouse/issues/81291): Fix incorrect result during reading column that exists in subset of tables in Merge engine. [#80643](https://github.com/ClickHouse/ClickHouse/pull/80643) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81813](https://github.com/ClickHouse/ClickHouse/issues/81813): Fix `Table does not exist` error for distributed queries with pushed-down predicate (`allow_push_predicate_ast_for_distributed_subqueries=1`) when the source table does not exist on the initialtor. Fixes [#77281](https://github.com/ClickHouse/ClickHouse/issues/77281). [#80915](https://github.com/ClickHouse/ClickHouse/pull/80915) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#81280](https://github.com/ClickHouse/ClickHouse/issues/81280): Fix parsing of DateTime64 from integers in JSONExtract and JSON type parsing. [#81050](https://github.com/ClickHouse/ClickHouse/pull/81050) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81207](https://github.com/ClickHouse/ClickHouse/issues/81207): Fixed `Too large size ... passed to allocator` errors or possible crashes on inserts via http protocol with text formats (`JSON`, `Values`, ...) and omitted `Enum` fields. [#81145](https://github.com/ClickHouse/ClickHouse/pull/81145) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#82016](https://github.com/ClickHouse/ClickHouse/issues/82016): Fix `Unknown table expression identifier` for `distributed_product_mode_local=local` with cross-replication. [#81162](https://github.com/ClickHouse/ClickHouse/pull/81162) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#81190](https://github.com/ClickHouse/ClickHouse/issues/81190): Fixed incorrectly caching number of rows in parquet files after filtering. [#81184](https://github.com/ClickHouse/ClickHouse/pull/81184) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#81343](https://github.com/ClickHouse/ClickHouse/issues/81343): Fixed clickhouse-local crashing when outputting const tuples or maps in Parquet format. [#81249](https://github.com/ClickHouse/ClickHouse/pull/81249) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#81368](https://github.com/ClickHouse/ClickHouse/issues/81368): Fix some corner case in query that joins empty tables and uses window functions. The bug leads to exploding number of parallel streams which leads to OOMs. [#81299](https://github.com/ClickHouse/ClickHouse/pull/81299) ([Alexander Gololobov](https://github.com/davenger)).
* Backported in [#81422](https://github.com/ClickHouse/ClickHouse/issues/81422): Fix region error in delta-kernel. Fixes [#79914](https://github.com/ClickHouse/ClickHouse/issues/79914). [#81353](https://github.com/ClickHouse/ClickHouse/pull/81353) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#81493](https://github.com/ClickHouse/ClickHouse/issues/81493): Disable incorrect JIT for divideOrNull. [#81370](https://github.com/ClickHouse/ClickHouse/pull/81370) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#81504](https://github.com/ClickHouse/ClickHouse/issues/81504): Don't store content of several manifest files in memory. [#81470](https://github.com/ClickHouse/ClickHouse/pull/81470) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#81683](https://github.com/ClickHouse/ClickHouse/issues/81683): Make scalar correlated subqueries return a nullable result of the projection expression. Fix the case when a correlated subquery produces an empty result set. [#81632](https://github.com/ClickHouse/ClickHouse/pull/81632) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#82126](https://github.com/ClickHouse/ClickHouse/issues/82126): Fix "Context has expired" during merges when dict used in TTL expression. [#81690](https://github.com/ClickHouse/ClickHouse/pull/81690) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#81848](https://github.com/ClickHouse/ClickHouse/issues/81848): Fix crash in `ConcurrentHashJoin` with empty `USING ()` and old analyzer enabled. [#81754](https://github.com/ClickHouse/ClickHouse/pull/81754) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#81907](https://github.com/ClickHouse/ClickHouse/issues/81907): Keeper fix: block commits of new logs if there is invalid entry in the logs. Previously, if leader applied some logs incorrectly, it would continue to commit new logs, even though the follower would detect digest mismatch and abort. [#81780](https://github.com/ClickHouse/ClickHouse/pull/81780) ([Antonio Andelic](https://github.com/antonio2368)).

#### NO CL CATEGORY

* Backported in [#81608](https://github.com/ClickHouse/ClickHouse/issues/81608):. [#81372](https://github.com/ClickHouse/ClickHouse/pull/81372) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Backported in [#81984](https://github.com/ClickHouse/ClickHouse/issues/81984):. [#81975](https://github.com/ClickHouse/ClickHouse/pull/81975) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#81322](https://github.com/ClickHouse/ClickHouse/issues/81322): Disable collecting job stack traces by default. [#80978](https://github.com/ClickHouse/ClickHouse/pull/80978) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#81832](https://github.com/ClickHouse/ClickHouse/issues/81832): Make NATS connection retries less noisy in the logs. [#81587](https://github.com/ClickHouse/ClickHouse/pull/81587) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81732](https://github.com/ClickHouse/ClickHouse/issues/81732): Fix CVE-2023-0286 / CVE-2023-5678. [#81672](https://github.com/ClickHouse/ClickHouse/pull/81672) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#81775](https://github.com/ClickHouse/ClickHouse/issues/81775): Fix: `appendRemovalTIDToVersionMetadata` for covered_parts in `MergeTreeTransaction::addNewPartAndRemoveCovered `so that there is a removal_id in the transaction metadata file even when it is removed without a transaction. Hence, when restarting, it can load the outdated parts successfully without triggering: ``` Logical error: \'Data part 202410_1_42_8 is Outdated and has creation TID (94, 40, 3ce64a6c-c10e-4c02-8891-47977f2b6a1a) and CSN 95, but does not have removal tid. It\'s a bug or a result of manual intervention.\'. ```. [#81734](https://github.com/ClickHouse/ClickHouse/pull/81734) ([Tuan Pham Anh](https://github.com/tuanpach)).

