---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.5.10.95-stable (e54ec61bcfe) FIXME as compared to v25.5.9.14-stable (3ff229371cc)

#### Performance Improvement
* Backported in [#85681](https://github.com/ClickHouse/ClickHouse/issues/85681): Improve parallel files processing with delta-kernel-rs backend. [#85642](https://github.com/ClickHouse/ClickHouse/pull/85642) ([Azat Khuzhin](https://github.com/azat)).

#### Improvement
* Backported in [#84502](https://github.com/ClickHouse/ClickHouse/issues/84502): Two mini improvements in Web UI: - correctly handle queries without output, such as `CREATE`, `INSERT` (until recently, these queries resulted in an infinite spinner); - when double clicking on a table, scroll to the top. [#81131](https://github.com/ClickHouse/ClickHouse/pull/81131) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#83182](https://github.com/ClickHouse/ClickHouse/issues/83182): Consolidate unknown settings warnings in clickhouse client and log them as a summary. [#83042](https://github.com/ClickHouse/ClickHouse/pull/83042) ([Bharat Nallan](https://github.com/bharatnc)).
* Backported in [#84595](https://github.com/ClickHouse/ClickHouse/issues/84595): S3Queue ordered mode fix: quit earlier if shutdown was called. [#84463](https://github.com/ClickHouse/ClickHouse/pull/84463) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#85018](https://github.com/ClickHouse/ClickHouse/issues/85018): Add 4LW in Keeper, `lgrq`, for toggling request logging of received requests. [#84719](https://github.com/ClickHouse/ClickHouse/pull/84719) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#84867](https://github.com/ClickHouse/ClickHouse/issues/84867): Reduce contention on storage lock in Keeper. [#84732](https://github.com/ClickHouse/ClickHouse/pull/84732) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85015](https://github.com/ClickHouse/ClickHouse/issues/85015): Limit Keeper log entry cache size by number of entries using `keeper_server.coordination_settings.latest_logs_cache_entry_count_threshold` and `keeper_server.coordination_settings.commit_logs_cache_entry_count_threshold`. [#84877](https://github.com/ClickHouse/ClickHouse/pull/84877) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85732](https://github.com/ClickHouse/ClickHouse/issues/85732): Added show_data_lake_catalogs_in_system_tables flag to manage adding data lake tables in system.tables resolves [#85384](https://github.com/ClickHouse/ClickHouse/issues/85384). [#85411](https://github.com/ClickHouse/ClickHouse/pull/85411) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#84393](https://github.com/ClickHouse/ClickHouse/issues/84393): Fix rollback of Dynamic column on parsing failure. [#82169](https://github.com/ClickHouse/ClickHouse/pull/82169) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#85755](https://github.com/ClickHouse/ClickHouse/issues/85755): Fixed parquet writer outputting incorrect statistics (min/max) for Decimal types. [#83754](https://github.com/ClickHouse/ClickHouse/pull/83754) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#84222](https://github.com/ClickHouse/ClickHouse/issues/84222): Allow referencing any table in `view(...)` argument of `remote` table function with enabled analyzer. Fixes [#78717](https://github.com/ClickHouse/ClickHouse/issues/78717). Fixes [#79377](https://github.com/ClickHouse/ClickHouse/issues/79377). [#83844](https://github.com/ClickHouse/ClickHouse/pull/83844) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#85792](https://github.com/ClickHouse/ClickHouse/issues/85792): Fix writing JSON paths with NULL values in RowBinary format. [#83923](https://github.com/ClickHouse/ClickHouse/pull/83923) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#84270](https://github.com/ClickHouse/ClickHouse/issues/84270): Fixed wrong results when the query condition cache is used in conjunction with recursive CTEs (issue [#81506](https://github.com/ClickHouse/ClickHouse/issues/81506)). [#84026](https://github.com/ClickHouse/ClickHouse/pull/84026) ([zhongyuankai](https://github.com/zhongyuankai)).
* Backported in [#84670](https://github.com/ClickHouse/ClickHouse/issues/84670): Fix filter merging into JOIN condition in cases when equality operands have different types or they reference constants. Fixes [#83432](https://github.com/ClickHouse/ClickHouse/issues/83432). [#84145](https://github.com/ClickHouse/ClickHouse/pull/84145) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#84286](https://github.com/ClickHouse/ClickHouse/issues/84286): Fix rare clickhouse crash when table has projection, `lightweight_mutation_projection_mode = 'rebuild'` and user execute lighweight delete which deletes ALL rows from any block in table. [#84158](https://github.com/ClickHouse/ClickHouse/pull/84158) ([alesapin](https://github.com/alesapin)).
* Backported in [#84491](https://github.com/ClickHouse/ClickHouse/issues/84491): Fixed incorrect construction of empty tuples in the `array()` function. This fixes [#84202](https://github.com/ClickHouse/ClickHouse/issues/84202). [#84297](https://github.com/ClickHouse/ClickHouse/pull/84297) ([Amos Bird](https://github.com/amosbird)).
* Backported in [#84829](https://github.com/ClickHouse/ClickHouse/issues/84829): Fix logger usage in `IAccessStorage`. [#84365](https://github.com/ClickHouse/ClickHouse/pull/84365) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#85879](https://github.com/ClickHouse/ClickHouse/issues/85879): Fix reading Variant column with lazy materialization. [#84400](https://github.com/ClickHouse/ClickHouse/pull/84400) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#84451](https://github.com/ClickHouse/ClickHouse/issues/84451): Make `zoutofmemory` hardware error, otherwise it will throw logical error. see https://github.com/clickhouse/clickhouse-core-incidents/issues/877. [#84420](https://github.com/ClickHouse/ClickHouse/pull/84420) ([Han Fei](https://github.com/hanfei1991)).
* Backported in [#86054](https://github.com/ClickHouse/ClickHouse/issues/86054): Fixed server crash when a user created with `no_password` attempts to login after the server setting `allow_no_password` was changed to 0. [#84426](https://github.com/ClickHouse/ClickHouse/pull/84426) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Backported in [#84650](https://github.com/ClickHouse/ClickHouse/issues/84650): Fix out-of-order writes to Keeper changelog. Previously, we could have in-flight writes to changelog, but rollback could cause concurrent change of the destination file. This would lead to inconsistent logs, and possible data loss. [#84434](https://github.com/ClickHouse/ClickHouse/pull/84434) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85309](https://github.com/ClickHouse/ClickHouse/issues/85309): Now if all TTL are removed from table MergeTree will do nothing related to TTL. [#84441](https://github.com/ClickHouse/ClickHouse/pull/84441) ([alesapin](https://github.com/alesapin)).
* Backported in [#85302](https://github.com/ClickHouse/ClickHouse/issues/85302): Fix ALTER MODIFY ORDER BY not validating TTL columns in sorting keys. TTL columns are now properly rejected when used in ORDER BY clauses during ALTER operations, preventing potential table corruption. [#84536](https://github.com/ClickHouse/ClickHouse/pull/84536) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Backported in [#84630](https://github.com/ClickHouse/ClickHouse/issues/84630): Change pre-25.5 value of `allow_experimental_delta_kernel_rs` to `false` for compatibility. [#84587](https://github.com/ClickHouse/ClickHouse/pull/84587) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#84725](https://github.com/ClickHouse/ClickHouse/issues/84725): Lock 'mutex' when getting zookeeper from 'view' in RefreshTask. [#84699](https://github.com/ClickHouse/ClickHouse/pull/84699) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Backported in [#84878](https://github.com/ClickHouse/ClickHouse/issues/84878): Fix `CORRUPTED_DATA` error when lazy columns are used with external sort. [#84738](https://github.com/ClickHouse/ClickHouse/pull/84738) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Backported in [#84991](https://github.com/ClickHouse/ClickHouse/issues/84991): Fix total watches count returned by Keeper. [#84890](https://github.com/ClickHouse/ClickHouse/pull/84890) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85113](https://github.com/ClickHouse/ClickHouse/issues/85113): Add a check if a correlated subquery is used in a distributed context to avoid a crash. Fixes [#82205](https://github.com/ClickHouse/ClickHouse/issues/82205). [#85030](https://github.com/ClickHouse/ClickHouse/pull/85030) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#85154](https://github.com/ClickHouse/ClickHouse/issues/85154): Fixed double-free in `AzureIteratorAsync`. [#85064](https://github.com/ClickHouse/ClickHouse/pull/85064) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#85232](https://github.com/ClickHouse/ClickHouse/issues/85232): Fix `Not-ready Set` for `IN (subquery)` inside `additional_table_filters expression` setting. [#85210](https://github.com/ClickHouse/ClickHouse/pull/85210) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#85260](https://github.com/ClickHouse/ClickHouse/issues/85260): Get rid of unnecessary `getStatus()` calls during SYSTEM DROP REPLICA queries. Fixes the case when a table is dropped in the background, and the `Shutdown for storage is called` exception is thrown. [#85220](https://github.com/ClickHouse/ClickHouse/pull/85220) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#85500](https://github.com/ClickHouse/ClickHouse/issues/85500): Added missing table name length checks in CREATE OR REPLACE and RENAME queries. [#85326](https://github.com/ClickHouse/ClickHouse/pull/85326) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#85522](https://github.com/ClickHouse/ClickHouse/issues/85522): Fix backup of parts with broken projections. [#85362](https://github.com/ClickHouse/ClickHouse/pull/85362) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85615](https://github.com/ClickHouse/ClickHouse/issues/85615): Queries with parallel replicas which uses reading reverse in order optimization can produce incorrect result. [#85406](https://github.com/ClickHouse/ClickHouse/pull/85406) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#85695](https://github.com/ClickHouse/ClickHouse/issues/85695): Fix possible UB (crashes) in case of MEMORY_LIMIT_EXCEEDED during String deserialization. [#85440](https://github.com/ClickHouse/ClickHouse/pull/85440) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#85822](https://github.com/ClickHouse/ClickHouse/issues/85822): Fix incorrect metrics KafkaAssignedPartitions and KafkaConsumersWithAssignment. [#85494](https://github.com/ClickHouse/ClickHouse/pull/85494) ([Ilya Golshtein](https://github.com/ilejn)).
* Backported in [#85912](https://github.com/ClickHouse/ClickHouse/issues/85912): Fix secrets masking in icebergS3Cluster and icebergAzureCluster table functions. [#85658](https://github.com/ClickHouse/ClickHouse/pull/85658) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Backported in [#85857](https://github.com/ClickHouse/ClickHouse/issues/85857): Fix possible inconsistency for dictionaries with update_field on MEMORY_LIMIT_EXCEEDED errors. [#85807](https://github.com/ClickHouse/ClickHouse/pull/85807) ([Azat Khuzhin](https://github.com/azat)).

#### Build/Testing/Packaging Improvement
* Backported in [#85386](https://github.com/ClickHouse/ClickHouse/issues/85386): Increase timeout for test_ttl_compatibility under sanitizers. [#83789](https://github.com/ClickHouse/ClickHouse/pull/83789) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Use OpenSSL 3.2.4. [#85809](https://github.com/ClickHouse/ClickHouse/pull/85809) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Backport [#84026](https://github.com/ClickHouse/ClickHouse/issues/84026) to 25.5: Disable query condition cache for recursive CTEs"'. [#84406](https://github.com/ClickHouse/ClickHouse/pull/84406) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Fix query condition cache usage with non-deterministic IN sets'. [#84621](https://github.com/ClickHouse/ClickHouse/pull/84621) ([Robert Schulze](https://github.com/rschu1ze)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#84337](https://github.com/ClickHouse/ClickHouse/issues/84337): tests: avoid possible "Bind for 0.0.0.0:2181 failed: port is already allocated" in kafka tests. [#81108](https://github.com/ClickHouse/ClickHouse/pull/81108) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#84793](https://github.com/ClickHouse/ClickHouse/issues/84793): Previously, `FilterTransform` could stop reading if the expression for any chunk returned a constant `false`. This can lead to a bug, because constant columns are allowed to appear during the execution, and most function default implementations will preserve constants as well. [#83855](https://github.com/ClickHouse/ClickHouse/pull/83855) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#85591](https://github.com/ClickHouse/ClickHouse/issues/85591): Fix parquet writer outputting incorrect row indices in offset index. [#83876](https://github.com/ClickHouse/ClickHouse/pull/83876) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#85280](https://github.com/ClickHouse/ClickHouse/issues/85280): Avoid some copies in Keeper. [#85131](https://github.com/ClickHouse/ClickHouse/pull/85131) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85603](https://github.com/ClickHouse/ClickHouse/issues/85603): Sync read if content is in page cache. [#85405](https://github.com/ClickHouse/ClickHouse/pull/85405) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85831](https://github.com/ClickHouse/ClickHouse/issues/85831): Add compatibility setting to write Date as UInt16 to parquet files. [#85510](https://github.com/ClickHouse/ClickHouse/pull/85510) ([Michael Kolupaev](https://github.com/al13n321)).

