---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.5.1.2782-stable (e0a8a231c68) FIXME as compared to v25.5.1.1-new (90b13185583)

#### Backward Incompatible Change
* Function `geoToH3()` now accepts the input in the order (lat, lon,res) (which is the standard order for geometric functions). Users who wish to retain the legacy result order (lon, lat,res) can set setting `geotoh3_lon_lat_input_order = true`. [#78852](https://github.com/ClickHouse/ClickHouse/pull/78852) ([Pratima Patel](https://github.com/pratimapatel2008)).
* Indexes of type `full_text` were renamed to `gin`. This follows the more familiar terminology of PostgreSQL and other databases. Existing indexes of type `full_text` remain loadable but they will throw an exception (suggesting `gin` indexes instead) when one tries to use them in searches. [#79024](https://github.com/ClickHouse/ClickHouse/pull/79024) ([Robert Schulze](https://github.com/rschu1ze)).
* Add a filesystem cache setting `allow_dynamic_cache_resize`, by default `false`, to allow dynamic resize of filesystem cache. Why: in certain environments (ClickHouse Cloud) all the scaling events happen through the restart of the process and we would love this feature to be explicitly disabled to have more control over the behaviour + as a safety measure. This PR is marked as backward incompatible, because in older versions dynamic cache resize worked by default without special setting. [#79148](https://github.com/ClickHouse/ClickHouse/pull/79148) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Removed support for legacy index types `annoy` and `usearch`. Both have been stubs for a long time, i.e. every attempt to use the legacy indexes returned an error anyways. If you still have `annoy` and `usearch` indexes, please drop them. [#79802](https://github.com/ClickHouse/ClickHouse/pull/79802) ([Robert Schulze](https://github.com/rschu1ze)).
* Remove `format_alter_commands_with_parentheses` server setting. The setting was introduced and disabled by default in 24.2. It was enabled by default in 25.2. As there are no LTS versions that don't support the new format, we can remove the setting. [#79970](https://github.com/ClickHouse/ClickHouse/pull/79970) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).

#### New Feature
* Add a new option to MergeTree SETTINGS which specifies a default compression codec in case the CREATE query does not explicitly define one for the given columns. This closes [#42005](https://github.com/ClickHouse/ClickHouse/issues/42005). [#66394](https://github.com/ClickHouse/ClickHouse/pull/66394) ([gvoelfin](https://github.com/gvoelfin)).
* Follow up for https://github.com/ClickHouse/ClickHouse/pull/71943. This PR implements Time/Time64 data types. Implements new data types: Time (HHH:MM:SS) and Time64 (HHH:MM:SS.`<fractional>`) and some basic cast functions and functions to interact with other data types. Also, changed the existing function's name toTime to toTimeWithFixedDate because the function toTime is required for the cast function. [#75735](https://github.com/ClickHouse/ClickHouse/pull/75735) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Support correlated subqueries as an argument of `EXISTS` expression in the WHERE clause. Closes [#72459](https://github.com/ClickHouse/ClickHouse/issues/72459). [#76078](https://github.com/ClickHouse/ClickHouse/pull/76078) ([Dmitry Novik](https://github.com/novikd)).
* Distributed INSERT SELECT for replicated MergeTree tables now efficiently uses parallel replicas to parallelize INSERTs by selecting different data on different nodes and inserting them independently. [#78041](https://github.com/ClickHouse/ClickHouse/pull/78041) ([Igor Nikonov](https://github.com/devcrafter)).
* Add system.iceberg_history table. [#78244](https://github.com/ClickHouse/ClickHouse/pull/78244) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Add getServerSetting and getMergeTreeSetting function. Closes https://github.com/clickhouse/clickhouse/issues/78318. [#78439](https://github.com/ClickHouse/ClickHouse/pull/78439) ([NamNguyenHoai](https://github.com/NamHoaiNguyen)).
* Add new `iceberg_enable_version_hint` setting to leverage `version-hint.text` file. [#78594](https://github.com/ClickHouse/ClickHouse/pull/78594) ([Arnaud Briche](https://github.com/arnaudbriche)).
* Gives the possibility to truncate specific tables from a database, filtered with the `LIKE` keyword. [#78597](https://github.com/ClickHouse/ClickHouse/pull/78597) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* `clickhouse-local` (and its shorthand alias, `ch`) now use an implicit `FROM table` when there is input data for processing. This closes [#65023](https://github.com/ClickHouse/ClickHouse/issues/65023). Also enabled format inference in clickhouse-local if `--input-format` is not specified and it processes a regular file. [#79085](https://github.com/ClickHouse/ClickHouse/pull/79085) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add [`icebergHash`](https://iceberg.apache.org/spec/#appendix-b-32-bit-hash-requirements) and [`icebergBucketTransform`](https://iceberg.apache.org/spec/#bucket-transform-details) functions. Support data files pruning in `Iceberg` tables partitioned with [`bucket transfom`](https://iceberg.apache.org/spec/#partitioning). [#79262](https://github.com/ClickHouse/ClickHouse/pull/79262) ([Daniil Ivanik](https://github.com/divanik)).
* Add `stringBytesUniq` and `stringBytesEntropy` functions to search for possibly random or encrypted data. [#79350](https://github.com/ClickHouse/ClickHouse/pull/79350) ([Sachin Kumar Singh](https://github.com/sachinkumarsingh092)).
* Support `_part_starting_offset` virtual column in MergeTree-family tables. This column represents the cumulative row count of all preceding parts, calculated at query time based on the current part list. The cumulative values are retained throughout query execution and remain effective even after part pruning. Related internal logic has been refactored to support this behavior. [#79417](https://github.com/ClickHouse/ClickHouse/pull/79417) ([Amos Bird](https://github.com/amosbird)).
* Support geo parquet. This closes [#75317](https://github.com/ClickHouse/ClickHouse/issues/75317). [#79777](https://github.com/ClickHouse/ClickHouse/pull/79777) ([scanhex12](https://github.com/scanhex12)).
* Added base32 encode/decode functionality. [#79809](https://github.com/ClickHouse/ClickHouse/pull/79809) ([Joanna Hulboj](https://github.com/jh0x)).
* Clickhouse vector search now supports both pre-filtering and post-filtering and provides related settings for finer control. (issue [#78161](https://github.com/ClickHouse/ClickHouse/issues/78161)). [#79854](https://github.com/ClickHouse/ClickHouse/pull/79854) ([Shankar Iyer](https://github.com/shankar-iyer)).

#### Experimental Feature
* Hive metastore catalog for iceberg datalake. [#77677](https://github.com/ClickHouse/ClickHouse/pull/77677) ([scanhex12](https://github.com/scanhex12)).

#### Performance Improvement
* Speed up secondary indices by evaluating their expressions on multiple granules at once. [#64109](https://github.com/ClickHouse/ClickHouse/pull/64109) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Introduced threshold (regulated by setting `parallel_hash_join_threshold`) to fall back to the `hash` algorithm when the size of the right table is below the threshold. [#76185](https://github.com/ClickHouse/ClickHouse/pull/76185) ([Nikita Taranov](https://github.com/nickitat)).
* Improve performance of S3Queue/AzureQueue by allowing INSERTs data in parallel (can be enabled with `parallel_inserts=true` queue setting). Previously S3Queue/AzureQueue can only do first part of pipeline in parallel (downloading, parsing), INSERT was single-threaded. And `INSERT`s are almost always the bottleneck. Now it will scale almost linear with `processing_threads_num`. [#77671](https://github.com/ClickHouse/ClickHouse/pull/77671) ([Azat Khuzhin](https://github.com/azat)).
* Change the Compact part format to save marks for each substream to be able to read individual subcolumns. Old Compact format is still supported for reads and can be enabled for writes using MergeTree setting `write_marks_for_substreams_in_compact_parts`. It's disabled by default for safer upgrades as it changes the compact parts storage. It will be enabled by default in one of the next releases. [#77940](https://github.com/ClickHouse/ClickHouse/pull/77940) ([Pavel Kruglov](https://github.com/Avogar)).
* New setting introduced : `use_skip_indexes_in_final_exact_mode`. If a query on a `ReplacingMergeTree` table has FINAL clause, reading only table ranges based on skip indexes may produce incorrect result. This setting can ensure that correct results are returned by scanning newer parts that have overlap with primary key ranges returned by the skip index. Set to 0 to disable, 1 to enable. [#78350](https://github.com/ClickHouse/ClickHouse/pull/78350) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Now we use number of replicas to determine task size for reading with parallel replicas enabled. This provides better work distribution between replicas when the amount of data to read is not really big. [#78695](https://github.com/ClickHouse/ClickHouse/pull/78695) ([Nikita Taranov](https://github.com/nickitat)).
* Allow parallel merging of `uniqExact` states during the final stage of distributed aggregation. [#78703](https://github.com/ClickHouse/ClickHouse/pull/78703) ([Nikita Taranov](https://github.com/nickitat)).
* Fix possible performance degradation of the parallel merging of `uniqExact` states for aggregation with key. [#78724](https://github.com/ClickHouse/ClickHouse/pull/78724) ([Nikita Taranov](https://github.com/nickitat)).
* Reduce the number of List Blobs API calls to Azure storage. [#78860](https://github.com/ClickHouse/ClickHouse/pull/78860) ([Julia Kartseva](https://github.com/jkartseva)).
* Merge equality conditions from filter query plan step into JOIN condition if possible to allow using them as hash table keys. [#78877](https://github.com/ClickHouse/ClickHouse/pull/78877) ([Dmitry Novik](https://github.com/novikd)).
* Improve performance of hive path parsing by using `extractKeyValuePairs` instead of regex. [#79067](https://github.com/ClickHouse/ClickHouse/pull/79067) ([Arthur Passos](https://github.com/arthurpassos)).
* Fix performance of the distributed INSERT SELECT with parallel replicas. [#79441](https://github.com/ClickHouse/ClickHouse/pull/79441) ([Azat Khuzhin](https://github.com/azat)).
* Allow moving conditions with subcolumns to prewhere. [#79489](https://github.com/ClickHouse/ClickHouse/pull/79489) ([Pavel Kruglov](https://github.com/Avogar)).
* Prevent `LogSeriesLimiter` from doing cleanup on every construction, avoiding lock contention and performance regressions in high-concurrency scenarios. [#79864](https://github.com/ClickHouse/ClickHouse/pull/79864) ([filimonov](https://github.com/filimonov)).
* Enable `compile_expressions` (JIT compiler for fragments of ordinary expressions) by default. This closes [#51264](https://github.com/ClickHouse/ClickHouse/issues/51264) and [#56386](https://github.com/ClickHouse/ClickHouse/issues/56386) and [#66486](https://github.com/ClickHouse/ClickHouse/issues/66486). [#79907](https://github.com/ClickHouse/ClickHouse/pull/79907) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Speedup queries with trivial count optimization. [#79945](https://github.com/ClickHouse/ClickHouse/pull/79945) ([Raúl Marín](https://github.com/Algunenano)).
* Add `__attribute__((always_inline))` to `convertDecimalsImpl`. [#79999](https://github.com/ClickHouse/ClickHouse/pull/79999) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Set `input_format_parquet_bloom_filter_push_down` to true by default. Also, fix a mistake in the settings changes history. [#80058](https://github.com/ClickHouse/ClickHouse/pull/80058) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Improvement
* `clickhouse-local` will retain its databases after restart if you specify the `--path` command line argument. This closes [#50647](https://github.com/ClickHouse/ClickHouse/issues/50647). This closes [#49947](https://github.com/ClickHouse/ClickHouse/issues/49947). [#71722](https://github.com/ClickHouse/ClickHouse/pull/71722) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Object storage cluster table functions (e.g. `s3Cluster`) will now assign files to replicas for reading based on consistent hash to improve cache locality. [#77326](https://github.com/ClickHouse/ClickHouse/pull/77326) ([Andrej Hoos](https://github.com/adikus)).
* Embed proxy configuration in some HTTP buffers with the help of builders. [#77693](https://github.com/ClickHouse/ClickHouse/pull/77693) ([Arthur Passos](https://github.com/arthurpassos)).
* Add functions `divideOrNull`,`moduloOrNull`, `intDivOrNull`,`positiveModuloOrNull` to return NULL when right argument is zero. [#78276](https://github.com/ClickHouse/ClickHouse/pull/78276) ([kevinyhzou](https://github.com/KevinyhZou)).
* Extend the isIPAddressInRange function to String, IPv4, IPv6, Nullable(String) Nullable(IPv4) and Nullable(IPv6) data types. [#78364](https://github.com/ClickHouse/ClickHouse/pull/78364) ([YjyJeff](https://github.com/YjyJeff)).
* Change PostgreSQL engine connection pooler settings dynamically. [#78414](https://github.com/ClickHouse/ClickHouse/pull/78414) ([Samay Sharma](https://github.com/samay-sharma)).
* Allow to specify `_part_offset` in normal projection. This is the first step to build projection index. It can be used with [#58224](https://github.com/ClickHouse/ClickHouse/issues/58224) and can help improve https://github.com/ClickHouse/ClickHouse/pull/63207. [#78429](https://github.com/ClickHouse/ClickHouse/pull/78429) ([Amos Bird](https://github.com/amosbird)).
* Add new columns(`create_query` and `source`) for `system.named_collections`. Closes [#78179](https://github.com/ClickHouse/ClickHouse/issues/78179). [#78582](https://github.com/ClickHouse/ClickHouse/pull/78582) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Added field `condition` to system table `system.query_condition_cache`. It stores the plaintext condition whose hash is used as a key in the query condition cache. [#78671](https://github.com/ClickHouse/ClickHouse/pull/78671) ([Robert Schulze](https://github.com/rschu1ze)).
* Add table settings for SASL configuration and credentials to the `Kafka` table engine. This allows configuring SASL-based authentication to Kafka and Kafka-compatible systems directly in the CREATE TABLE statement rather than having to use configuration files or named collections. [#78810](https://github.com/ClickHouse/ClickHouse/pull/78810) ([Christoph Wurm](https://github.com/cwurm)).
* Vector similarity indexes can now be created on top of `BFloat16` columns. [#78850](https://github.com/ClickHouse/ClickHouse/pull/78850) ([Robert Schulze](https://github.com/rschu1ze)).
* Support unix timestapms with fractional part in best effort DateTime64 parsing. [#78908](https://github.com/ClickHouse/ClickHouse/pull/78908) ([Pavel Kruglov](https://github.com/Avogar)).
* In storage DeltaLake delta-kernel implementation fix for columnMappingMode.name, add tests for schema evolution. [#78921](https://github.com/ClickHouse/ClickHouse/pull/78921) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Improve insert into Variant column in Values format by better conversion of values. [#78923](https://github.com/ClickHouse/ClickHouse/pull/78923) ([Pavel Kruglov](https://github.com/Avogar)).
* The `tokens` function was extended to accept an additional "tokenizer" argument plus further tokenizer-specific arguments. [#79001](https://github.com/ClickHouse/ClickHouse/pull/79001) ([Elmi Ahmadov](https://github.com/ahmadov)).
* The "SHOW CLUSTER" statement now expands macros (if any) in its argument. [#79006](https://github.com/ClickHouse/ClickHouse/pull/79006) ([arf42](https://github.com/arf42)).
* Hash functions now support NULLs inside arrays, tuples, and maps. (issues [#48365](https://github.com/ClickHouse/ClickHouse/issues/48365) and [#48623](https://github.com/ClickHouse/ClickHouse/issues/48623)). [#79008](https://github.com/ClickHouse/ClickHouse/pull/79008) ([Michael Kolupaev](https://github.com/al13n321)).
* Support for a refresh in readonly MergeTree tables. [#79033](https://github.com/ClickHouse/ClickHouse/pull/79033) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update cctz to 2025a. [#79043](https://github.com/ClickHouse/ClickHouse/pull/79043) ([Raúl Marín](https://github.com/Algunenano)).
* It's better for usability. [#79066](https://github.com/ClickHouse/ClickHouse/pull/79066) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Enabled the query condition cache by default. [#79080](https://github.com/ClickHouse/ClickHouse/pull/79080) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make tabs undo-able in the Web UI. This closes [#71284](https://github.com/ClickHouse/ClickHouse/issues/71284). [#79084](https://github.com/ClickHouse/ClickHouse/pull/79084) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove settings during `recoverLostReplica` same as it was done in: https://github.com/ClickHouse/ClickHouse/pull/78637. [#79113](https://github.com/ClickHouse/ClickHouse/pull/79113) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Add ProfileEvents ParquetReadRowGroups and ParquetPrunedRowGroups to profile parquet index prune ### Documentation entry for user-facing changes. [#79180](https://github.com/ClickHouse/ClickHouse/pull/79180) ([flynn](https://github.com/ucasfl)).
* Support altering database on cluster. [#79242](https://github.com/ClickHouse/ClickHouse/pull/79242) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Explicitly skip missed runs of statistics collection for QueryMetricLog, otherwise the log will take a long time to catch up with the current time. [#79257](https://github.com/ClickHouse/ClickHouse/pull/79257) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Added an ability to apply lightweight deletes on the fly (with settings `lightweight_deletes_sync = 0`, `apply_mutations_on_fly = 1`. [#79281](https://github.com/ClickHouse/ClickHouse/pull/79281) ([Anton Popov](https://github.com/CurtizJ)).
* Optimized `ALTER ... DELETE` mutations for parts in which all rows should be deleted. Now, in such cases an empty part is created instead of original without executing a mutation. [#79307](https://github.com/ClickHouse/ClickHouse/pull/79307) ([Anton Popov](https://github.com/CurtizJ)).
* Some small optimizations to CHColumnToArrowColumn. [#79308](https://github.com/ClickHouse/ClickHouse/pull/79308) ([Bharat Nallan](https://github.com/bharatnc)).
* The setting `allow_archive_path_syntax` was marked as experimental by mistake. Add a test to prevent having experimental settings enabled by default. [#79320](https://github.com/ClickHouse/ClickHouse/pull/79320) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Made page cache settings adjustable on a per-query level. This is needed for faster experimentation and for the possibility of fine-tuning for high-throughput and low-latency queries. [#79337](https://github.com/ClickHouse/ClickHouse/pull/79337) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Do not print number tips in pretty formats for numbers that look like most of the 64-bit hashes. This closes [#79334](https://github.com/ClickHouse/ClickHouse/issues/79334). [#79338](https://github.com/ClickHouse/ClickHouse/pull/79338) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* If data in the pretty format is displayed in the terminal, and a subsequent block has the same column widths, it can continue from the previous block, glue it to the previous block by moving the cursor up. This closes [#79333](https://github.com/ClickHouse/ClickHouse/issues/79333). The feature is controlled by the new setting, `output_format_pretty_glue_chunks`. [#79339](https://github.com/ClickHouse/ClickHouse/pull/79339) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Colors of graphs on the advanced dashboards will be calculated from the hash of the corresponding query. This makes it easier to remember and locate a graph while scrolling the dashboard. [#79341](https://github.com/ClickHouse/ClickHouse/pull/79341) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add asynchronous metric, `FilesystemCacheCapacity` - total capacity in the `cache` virtual filesystem. This is useful for global infrastructure monitoring. [#79348](https://github.com/ClickHouse/ClickHouse/pull/79348) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Optimize access to system.parts (read columns/indexes size only when requested). [#79352](https://github.com/ClickHouse/ClickHouse/pull/79352) ([Azat Khuzhin](https://github.com/azat)).
* Select important fields for query `'SHOW CLUSTER <name>'` instead of all fields. [#79368](https://github.com/ClickHouse/ClickHouse/pull/79368) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Allow to specify storage settings for `DatabaseCatalog`. [#79407](https://github.com/ClickHouse/ClickHouse/pull/79407) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Support local storage in delta kernel. [#79416](https://github.com/ClickHouse/ClickHouse/pull/79416) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add a query level setting to enable delta-kernel-rs: `allow_experimental_delta_kernel_rs`. [#79418](https://github.com/ClickHouse/ClickHouse/pull/79418) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix possible endless loop when listing blobs from Azure/S3 blob storage. [#79425](https://github.com/ClickHouse/ClickHouse/pull/79425) ([Alexander Gololobov](https://github.com/davenger)).
* Add filesystem cache setting `max_size_ratio_to_total_space`. [#79460](https://github.com/ClickHouse/ClickHouse/pull/79460) ([Kseniia Sumarokova](https://github.com/kssenii)).
* For `clickhouse-benchmark` reconfigure `reconnect` option to take 0, 1 or N as values for reconnecting accordingly. [#79465](https://github.com/ClickHouse/ClickHouse/pull/79465) ([Sachin Kumar Singh](https://github.com/sachinkumarsingh092)).
* Add setting input_format_max_block_size_bytes to limit blocks created in input formats in bytes. It can help to avoid high memory usage during data import when rows contains large values. [#79495](https://github.com/ClickHouse/ClickHouse/pull/79495) ([Pavel Kruglov](https://github.com/Avogar)).
* Enhance sparseGrams speed and memory usage. [#79517](https://github.com/ClickHouse/ClickHouse/pull/79517) ([scanhex12](https://github.com/scanhex12)).
* Avoid extra copying of the block during insertion into Compact part when possible. [#79536](https://github.com/ClickHouse/ClickHouse/pull/79536) ([Pavel Kruglov](https://github.com/Avogar)).
* Enable `DeltaLake` storage delta-kernel implementation by default. [#79541](https://github.com/ClickHouse/ClickHouse/pull/79541) ([Kseniia Sumarokova](https://github.com/kssenii)).
* If reading from an URL involves multiple redirects, setting `enable_url_encoding` is correctly applied across all redirects in the chain. [#79563](https://github.com/ClickHouse/ClickHouse/pull/79563) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Allow ALTER TABLE ... MOVE|REPLACE PARTITION for tables on different plain_rewritable disks. [#79566](https://github.com/ClickHouse/ClickHouse/pull/79566) ([Julia Kartseva](https://github.com/jkartseva)).
* Support scalar correlated subqueries in the WHERE clause. Closes [#6697](https://github.com/ClickHouse/ClickHouse/issues/6697). [#79600](https://github.com/ClickHouse/ClickHouse/pull/79600) ([Dmitry Novik](https://github.com/novikd)).
* The vector similarity index is now also used if the reference vector is of type `Array(BFloat16)`. [#79745](https://github.com/ClickHouse/ClickHouse/pull/79745) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Add last_error_message, last_error_trace and query_id to the system.error_log table. Related ticket [#75816](https://github.com/ClickHouse/ClickHouse/issues/75816). [#79836](https://github.com/ClickHouse/ClickHouse/pull/79836) ([Andrei Tinikov](https://github.com/Dolso)).
* Enable sending crash reports by default. This can be turned off in the server's configuration file. [#79838](https://github.com/ClickHouse/ClickHouse/pull/79838) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* System table `system.functions` now shows in which ClickHouse version functions were first introduced. [#79839](https://github.com/ClickHouse/ClickHouse/pull/79839) ([Robert Schulze](https://github.com/rschu1ze)).
* Added `access_control_improvements.enable_user_name_access_type` setting. This setting allows enabling/disabling of precise grants for users/roles, introduced in https://github.com/ClickHouse/ClickHouse/pull/72246. You may want to turn this setting off in case you have a cluster with the replicas older than 25.1. [#79842](https://github.com/ClickHouse/ClickHouse/pull/79842) ([pufit](https://github.com/pufit)).
* Proper implementation of `ASTSelectWithUnionQuery::clone()` method now takes into account `is_normalized` field as well. This might help with [#77569](https://github.com/ClickHouse/ClickHouse/issues/77569). [#79909](https://github.com/ClickHouse/ClickHouse/pull/79909) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Support correlated subqueries in the projection list in simple cases. [#79925](https://github.com/ClickHouse/ClickHouse/pull/79925) ([Dmitry Novik](https://github.com/novikd)).
* Fix the inconsistent formatting of certain queries with the EXCEPT operator. If the left-hand side of the EXCEPT operator ends with `*`, the formatted query loses parentheses and is then parsed as a `*` with the `EXCEPT` modifier. These queries are found by the fuzzer and are unlikely to be found in practice. This closes [#79950](https://github.com/ClickHouse/ClickHouse/issues/79950). [#79952](https://github.com/ClickHouse/ClickHouse/pull/79952) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Small improvement in JSON type parsing by using cache of variants deserialization order. [#79984](https://github.com/ClickHouse/ClickHouse/pull/79984) ([Pavel Kruglov](https://github.com/Avogar)).
* Add setting `s3_slow_all_threads_after_network_error`. [#80035](https://github.com/ClickHouse/ClickHouse/pull/80035) ([Vitaly Baranov](https://github.com/vitlibar)).
* The logging level about the selected parts to merge was wrong (Information). Closes [#80061](https://github.com/ClickHouse/ClickHouse/issues/80061). [#80062](https://github.com/ClickHouse/ClickHouse/pull/80062) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Setting `enble_url_encoding` default value is now set to `False`. [#80088](https://github.com/ClickHouse/ClickHouse/pull/80088) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Vector search using the vector similarity index is now beta (from previously experimental). [#80164](https://github.com/ClickHouse/ClickHouse/pull/80164) ([Robert Schulze](https://github.com/rschu1ze)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#80351](https://github.com/ClickHouse/ClickHouse/issues/80351): Analyzer: Fix column projection name after column type promotion in join. Closes [#63345](https://github.com/ClickHouse/ClickHouse/issues/63345). [#63519](https://github.com/ClickHouse/ClickHouse/pull/63519) ([Dmitry Novik](https://github.com/novikd)).
* A materialized view can start too late, e.g. after the Kafka table that streams to it. [#72123](https://github.com/ClickHouse/ClickHouse/pull/72123) ([Ilya Golshtein](https://github.com/ilejn)).
* Fixed rare crashes while reading from `MergeTree` table after multiple asynchronous (with `alter_sync = 0`) `RENAME COLUMN` and `ADD COLUMN` queries. [#76346](https://github.com/ClickHouse/ClickHouse/pull/76346) ([Anton Popov](https://github.com/CurtizJ)).
* Fix `SELECT` query rewriting during `VIEW` creation with enabled analyzer. closes [#75956](https://github.com/ClickHouse/ClickHouse/issues/75956). [#76356](https://github.com/ClickHouse/ClickHouse/pull/76356) ([Dmitry Novik](https://github.com/novikd)).
* Fix applying `async_insert` from server (via `apply_settings_from_server`) (previously leads to `Unknown packet 11 from server` errors on the client). [#77578](https://github.com/ClickHouse/ClickHouse/pull/77578) ([Azat Khuzhin](https://github.com/azat)).
* Fixed refreshable materialized view in Replicated database not working on newly added replicas. [#77774](https://github.com/ClickHouse/ClickHouse/pull/77774) ([Michael Kolupaev](https://github.com/al13n321)).
* Fixed refreshable materialized views breaking backups. [#77893](https://github.com/ClickHouse/ClickHouse/pull/77893) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix old firing logical error for `transform`. [#78247](https://github.com/ClickHouse/ClickHouse/pull/78247) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix some cases where secondary index was not applied with analyzer. Fixes [#65607](https://github.com/ClickHouse/ClickHouse/issues/65607) , fixes [#69373](https://github.com/ClickHouse/ClickHouse/issues/69373). [#78485](https://github.com/ClickHouse/ClickHouse/pull/78485) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix dumping profile events (`NetworkSendElapsedMicroseconds`/`NetworkSendBytes`) for HTTP protocol with compression enabled (the error should not be more then the buffer size, usually around 1MiB). [#78516](https://github.com/ClickHouse/ClickHouse/pull/78516) ([Azat Khuzhin](https://github.com/azat)).
* ```sql CREATE TABLE t0 ( key Int32, value Int32 ) ENGINE=MergeTree() PRIMARY KEY key PARTITION BY key % 2;. [#78593](https://github.com/ClickHouse/ClickHouse/pull/78593) ([Vlad](https://github.com/codeworse)).
* Fix analyzer producing LOGICAL_ERROR when JOIN ... USING involves ALIAS column - should produce appropriate error. [#78618](https://github.com/ClickHouse/ClickHouse/pull/78618) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Fix analyzer: CREATE VIEW ... ON CLUSTER fails if SELECT contains positional arguments. [#78663](https://github.com/ClickHouse/ClickHouse/pull/78663) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Fix `Block structure mismatch` error in case of `INSERT SELECT` into table a function with schema inference if `SELECT` has scalar subqueries. [#78677](https://github.com/ClickHouse/ClickHouse/pull/78677) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Fix analyzer: with prefer_global_in_and_join=1 for Distributed table in SELECT query `in` function should be replaced by `globalIn`. [#78749](https://github.com/ClickHouse/ClickHouse/pull/78749) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Fixed several types of `SELECT` queries that read from tables with `MongoDB` engine or `mongodb` table function: queries with implicit conversion of const value in `WHERE` clause (e.g. `WHERE datetime = '2025-03-10 00:00:00'`) ; queries with `LIMIT` and `GROUP BY`. Previously, they could return the wrong result. [#78777](https://github.com/ClickHouse/ClickHouse/pull/78777) ([Anton Popov](https://github.com/CurtizJ)).
* Fix conversion between different JSON types. Not it's performed by simple cast through convertion to/from String. It's less effective but 100% accurate. [#78807](https://github.com/ClickHouse/ClickHouse/pull/78807) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix logical error during convertion of Dynamic type to Interval. [#78813](https://github.com/ClickHouse/ClickHouse/pull/78813) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix column rollback on JSON parsing error. [#78836](https://github.com/ClickHouse/ClickHouse/pull/78836) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix 'bad cast' error when join using constant alias column. [#78848](https://github.com/ClickHouse/ClickHouse/pull/78848) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Don't allow prewhere in materialized view on columns with different types in view and target table. [#78889](https://github.com/ClickHouse/ClickHouse/pull/78889) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix logical error during parsing of bad binary data of Variant column. [#78982](https://github.com/ClickHouse/ClickHouse/pull/78982) ([Pavel Kruglov](https://github.com/Avogar)).
* Throw an exception when the parquet batch size is set to 0. Previously when output_format_parquet_batch_size = 0 ClickHouse would hang. Now this behavior is fixed. [#78991](https://github.com/ClickHouse/ClickHouse/pull/78991) ([daryawessely](https://github.com/daryawessely)).
* Fix deserialization of variant discriminators with basic format in compact parts. It was introduced in https://github.com/ClickHouse/ClickHouse/pull/55518. [#79000](https://github.com/ClickHouse/ClickHouse/pull/79000) ([Pavel Kruglov](https://github.com/Avogar)).
* Dictionaries of type `complex_key_ssd_cache` now reject zero or negative `block_size` and `write_buffer_size` parameters (issue [#78314](https://github.com/ClickHouse/ClickHouse/issues/78314)). [#79028](https://github.com/ClickHouse/ClickHouse/pull/79028) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Avoid using Field for non-aggregated columns in SummingMergeTree. It could lead to unexpected errors with Dynamic/Variant types used in SummingMergeTree. [#79051](https://github.com/ClickHouse/ClickHouse/pull/79051) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix read from Materialized View with Distributed destination table and different header in analyzer. [#79059](https://github.com/ClickHouse/ClickHouse/pull/79059) ([Pavel Kruglov](https://github.com/Avogar)).
* Fixes a bug where `arrayUnion()` returned extra (incorrect) values on tables that had batch inserts. Fixes [#75057](https://github.com/ClickHouse/ClickHouse/issues/75057). [#79079](https://github.com/ClickHouse/ClickHouse/pull/79079) ([Peter Nguyen](https://github.com/petern48)).
* Fix segfault in `OpenSSLInitializer`. Closes [#79092](https://github.com/ClickHouse/ClickHouse/issues/79092). [#79097](https://github.com/ClickHouse/ClickHouse/pull/79097) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Always set prefix for S3 ListObject. [#79114](https://github.com/ClickHouse/ClickHouse/pull/79114) ([Azat Khuzhin](https://github.com/azat)).
* Fixes a bug where arrayUnion() returned extra (incorrect) values on tables that had batch inserts. Fixes [#79157](https://github.com/ClickHouse/ClickHouse/issues/79157). [#79158](https://github.com/ClickHouse/ClickHouse/pull/79158) ([Peter Nguyen](https://github.com/petern48)).
* Fix logical error after filter pushdown. [#79164](https://github.com/ClickHouse/ClickHouse/pull/79164) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Backported in [#80468](https://github.com/ClickHouse/ClickHouse/issues/80468): Try to use IColumn instead of Field in SingleValueDataGeneric. It fixes the incorrect return values for some aggregate functions like `argMax` for types `Dynamic/Variant/JSON`. [#79166](https://github.com/ClickHouse/ClickHouse/pull/79166) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix DeltaLake table engine with delta-kernel implementation being used with http based endpoints, fix NOSIGN. Closes [#78124](https://github.com/ClickHouse/ClickHouse/issues/78124). [#79203](https://github.com/ClickHouse/ClickHouse/pull/79203) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Keeper fix: Avoid triggering watches on failed multi requests. [#79247](https://github.com/ClickHouse/ClickHouse/pull/79247) ([Antonio Andelic](https://github.com/antonio2368)).
* Forbid Dynamic and JSON types in IN. With current implementation of `IN` it can lead to incorrect results. Proper support of this types in `IN` is complicated and can be done in future. [#79282](https://github.com/ClickHouse/ClickHouse/pull/79282) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix check for duplicate paths in JSON type parsing. [#79317](https://github.com/ClickHouse/ClickHouse/pull/79317) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix SecureStreamSocket connection issues. [#79383](https://github.com/ClickHouse/ClickHouse/pull/79383) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix loading of plain_rewritable disks containing data. [#79439](https://github.com/ClickHouse/ClickHouse/pull/79439) ([Julia Kartseva](https://github.com/jkartseva)).
* Fix crash in dynamic subcolumns discovery in Wide parts in MergeTree. [#79466](https://github.com/ClickHouse/ClickHouse/pull/79466) ([Pavel Kruglov](https://github.com/Avogar)).
* Verify the table name's length only for initial create queries. Do not verify this for secondary creates to avoid backward compatibility issues. [#79488](https://github.com/ClickHouse/ClickHouse/pull/79488) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Fixed error `Block structure mismatch` in several cases with tables with sparse columns. [#79491](https://github.com/ClickHouse/ClickHouse/pull/79491) ([Anton Popov](https://github.com/CurtizJ)).
* Fix 2 cases of "Logical Error: Can't set alias of * of Asterisk on alias". [#79505](https://github.com/ClickHouse/ClickHouse/pull/79505) ([Raúl Marín](https://github.com/Algunenano)).
* Fix using incorrect paths when renaming an Atomic database. [#79569](https://github.com/ClickHouse/ClickHouse/pull/79569) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fix order by JSON column with other columns. [#79591](https://github.com/ClickHouse/ClickHouse/pull/79591) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix result duplication when reading from remote with both `use_hedged_requests` and `allow_experimental_parallel_reading_from_replicas` disabled. [#79599](https://github.com/ClickHouse/ClickHouse/pull/79599) ([Eduard Karacharov](https://github.com/korowa)).
* Fix crash in delta-kernel implementation when using unity catalog. [#79677](https://github.com/ClickHouse/ClickHouse/pull/79677) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Resolve macros for autodiscovery clusters. [#79696](https://github.com/ClickHouse/ClickHouse/pull/79696) ([Anton Ivashkin](https://github.com/ianton-ru)).
* Handle incorrectly configured page_cache_limits suitably. [#79805](https://github.com/ClickHouse/ClickHouse/pull/79805) ([Bharat Nallan](https://github.com/bharatnc)).
* Fixes the result of SQL function `formatDateTime` if a variable-size formatter (e.g. `%W` aka. weekday `Monday` `Tuesday`, etc.) is followed by a compound formatter (a formatter that prints multiple components at once, e.g. `%D` aka. the American date `05/04/25`). [#79835](https://github.com/ClickHouse/ClickHouse/pull/79835) ([Robert Schulze](https://github.com/rschu1ze)).
* IcebergS3 supports count optimization, but IcebergS3Cluster does not. As a result, the count() result returned in cluster mode may be a multiple of the number of replicas. [#79844](https://github.com/ClickHouse/ClickHouse/pull/79844) ([wxybear](https://github.com/wxybear)).
* Backported in [#80533](https://github.com/ClickHouse/ClickHouse/issues/80533): Fix the sorting order of the NaNs with a negative sign bit. [#79847](https://github.com/ClickHouse/ClickHouse/pull/79847) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Fixes AMBIGUOUS_COLUMN_NAME error with lazy materialization when no columns are used for query execution until projection. Example, SELECT * FROM t ORDER BY rand() LIMIT 5. [#79926](https://github.com/ClickHouse/ClickHouse/pull/79926) ([Igor Nikonov](https://github.com/devcrafter)).
* Hide password for query `CREATE DATABASE datalake ENGINE = DataLakeCatalog(\'http://catalog:8181\', \'admin\', \'password\')`. [#79941](https://github.com/ClickHouse/ClickHouse/pull/79941) ([Han Fei](https://github.com/hanfei1991)).
* Allow to specify an alias in JOIN USING. Specify this alias in case the column was renamed (e.g., because of ARRAY JOIN). Fixes [#73707](https://github.com/ClickHouse/ClickHouse/issues/73707). [#79942](https://github.com/ClickHouse/ClickHouse/pull/79942) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#80372](https://github.com/ClickHouse/ClickHouse/issues/80372): Skip indexes with lambda expressions could not be applied. Fix the case when high-level functions in the index definition exactly match the one in the query. [#80025](https://github.com/ClickHouse/ClickHouse/pull/80025) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Allow materialized views with UNIONs to work correctly on new replicas. [#80037](https://github.com/ClickHouse/ClickHouse/pull/80037) ([Samay Sharma](https://github.com/samay-sharma)).
* Format specifier `%e` in SQL function `parseDateTime` now recognizes single-digit days (e.g. `3`), whereas it previously required space padding (e.g. ` 3`). This makes its behavior compatible with MySQL. To retain the previous behaviour, set setting `parsedatetime_e_requires_space_padding = 1`. (issue [#78243](https://github.com/ClickHouse/ClickHouse/issues/78243)). [#80057](https://github.com/ClickHouse/ClickHouse/pull/80057) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix warnings `Cannot find 'kernel' in '[...]/memory.stat'` in ClickHouse's log (issue [#77410](https://github.com/ClickHouse/ClickHouse/issues/77410)). [#80129](https://github.com/ClickHouse/ClickHouse/pull/80129) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#80458](https://github.com/ClickHouse/ClickHouse/issues/80458): Fix logical error in Arrow format with LowCardinality(FixedString). [#80156](https://github.com/ClickHouse/ClickHouse/pull/80156) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#80341](https://github.com/ClickHouse/ClickHouse/issues/80341): Fix reading subcolumns from Merge engine. [#80158](https://github.com/ClickHouse/ClickHouse/pull/80158) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#80325](https://github.com/ClickHouse/ClickHouse/issues/80325): Fix incorrect count optimization for string prefix filters like LIKE 'ab_c%' when using implicit projections. This fixes [#80250](https://github.com/ClickHouse/ClickHouse/issues/80250). [#80261](https://github.com/ClickHouse/ClickHouse/pull/80261) ([Amos Bird](https://github.com/amosbird)).
* Backported in [#80508](https://github.com/ClickHouse/ClickHouse/issues/80508): Fix improper serialization of nested numeric fields as strings in MongoDB documents. Remove maximum depth limit for documents from MongoDB. [#80289](https://github.com/ClickHouse/ClickHouse/pull/80289) ([Kirill Nikiforov](https://github.com/allmazz)).
* Backported in [#80580](https://github.com/ClickHouse/ClickHouse/issues/80580): Perform less strict metadata checks for RMT in the Replicated database. Closes [#80296](https://github.com/ClickHouse/ClickHouse/issues/80296). [#80298](https://github.com/ClickHouse/ClickHouse/pull/80298) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#80404](https://github.com/ClickHouse/ClickHouse/issues/80404): Fix text representation of DateTime and DateTime64 for PostgreSQL storage. [#80301](https://github.com/ClickHouse/ClickHouse/pull/80301) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Backported in [#80558](https://github.com/ClickHouse/ClickHouse/issues/80558): Fixed refreshable materialized view DROP getting stuck if the view was paused using SYSTEM STOP REPLICATED VIEW. [#80543](https://github.com/ClickHouse/ClickHouse/pull/80543) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#80673](https://github.com/ClickHouse/ClickHouse/issues/80673): Fix 'Cannot find column' with constant tuple in distributed query. [#80596](https://github.com/ClickHouse/ClickHouse/pull/80596) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).

#### Build/Testing/Packaging Improvement
* Make it possible to reuse built chcache binary instead of always rebuilding it. [#78851](https://github.com/ClickHouse/ClickHouse/pull/78851) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Add NATS pause waiting. [#78987](https://github.com/ClickHouse/ClickHouse/pull/78987) ([Dmitry Novikov](https://github.com/dmitry-sles-novikov)).
* FIx for incorrectly publishing ARM build as amd64compat. [#79122](https://github.com/ClickHouse/ClickHouse/pull/79122) ([Alexander Gololobov](https://github.com/davenger)).
* Use generated ahead of time assembly for OpenSSL. [#79386](https://github.com/ClickHouse/ClickHouse/pull/79386) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fixes to allow building with `clang20`. [#79588](https://github.com/ClickHouse/ClickHouse/pull/79588) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### NO CL CATEGORY

* Backported in [#80586](https://github.com/ClickHouse/ClickHouse/issues/80586):. [#80229](https://github.com/ClickHouse/ClickHouse/pull/80229) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#80307](https://github.com/ClickHouse/ClickHouse/issues/80307):. [#80303](https://github.com/ClickHouse/ClickHouse/pull/80303) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Revert "Implement comparison for values of JSON data type""'. [#78890](https://github.com/ClickHouse/ClickHouse/pull/78890) ([Pavel Kruglov](https://github.com/Avogar)).
* NO CL ENTRY:  'Revert "Fix taking full part if part contains less than 'limit' rows"'. [#79005](https://github.com/ClickHouse/ClickHouse/pull/79005) ([Nikita Taranov](https://github.com/nickitat)).
* NO CL ENTRY:  'Revert "CI: Fix head_repo inserted into ci db from forks"'. [#79086](https://github.com/ClickHouse/ClickHouse/pull/79086) ([Max Kainov](https://github.com/maxknv)).
* NO CL ENTRY:  'Revert "Revert "CI: Fix head_repo inserted into ci db from forks""'. [#79087](https://github.com/ClickHouse/ClickHouse/pull/79087) ([Max Kainov](https://github.com/maxknv)).
* NO CL ENTRY:  'Revert "Use FixedString for PostgreSQL's types that have a fixed length"'. [#79108](https://github.com/ClickHouse/ClickHouse/pull/79108) ([Pablo Marcos](https://github.com/pamarcos)).
* NO CL ENTRY:  'Revert "CI: Improve subtask output in CI report"'. [#79205](https://github.com/ClickHouse/ClickHouse/pull/79205) ([Max Kainov](https://github.com/maxknv)).
* NO CL ENTRY:  'Revert "Revert "CI: Improve subtask output in CI report""'. [#79243](https://github.com/ClickHouse/ClickHouse/pull/79243) ([Max Kainov](https://github.com/maxknv)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Limit tests even more. [#75040](https://github.com/ClickHouse/ClickHouse/pull/75040) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Tests: add test job with enabled async inserts. [#75379](https://github.com/ClickHouse/ClickHouse/pull/75379) ([Nikita Fomichev](https://github.com/fm4v)).
* Refactoring pushing to views. [#77309](https://github.com/ClickHouse/ClickHouse/pull/77309) ([Sema Checherinda](https://github.com/CheSema)).
* Add 03362_join_on_filterpushdown. [#77434](https://github.com/ClickHouse/ClickHouse/pull/77434) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Add iteration limit in QueryFuzzer. [#77453](https://github.com/ClickHouse/ClickHouse/pull/77453) ([Michael Kolupaev](https://github.com/al13n321)).
* Zero sized buffer leads to problems. This closes: [#77752](https://github.com/ClickHouse/ClickHouse/issues/77752). [#77771](https://github.com/ClickHouse/ClickHouse/pull/77771) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Check stack size in FunctionComparison to avoid stack overflow crash. [#78208](https://github.com/ClickHouse/ClickHouse/pull/78208) ([Julia Kartseva](https://github.com/jkartseva)).
* Update README.md. [#78346](https://github.com/ClickHouse/ClickHouse/pull/78346) ([Zoe Steinkamp](https://github.com/zoesteinkamp)).
* Replace Poco::Crypto with own implementation. [#78591](https://github.com/ClickHouse/ClickHouse/pull/78591) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Split kafka tests (1). [#78624](https://github.com/ClickHouse/ClickHouse/pull/78624) ([Ilya Golshtein](https://github.com/ilejn)).
* Lower `max_bytes_to_merge_at_min_space_in_pool` to `max_bytes_to_merge_at_max_space_in_pool`. [#78652](https://github.com/ClickHouse/ClickHouse/pull/78652) ([Mikhail Artemenko](https://github.com/Michicosun)).
* chcache: Rust caching support. [#78691](https://github.com/ClickHouse/ClickHouse/pull/78691) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix race during SELECT from `system.workloads`. [#78743](https://github.com/ClickHouse/ClickHouse/pull/78743) ([Sergei Trifonov](https://github.com/serxa)).
* Pinned the commit of a `create-pull-request` GitHub action. [#78748](https://github.com/ClickHouse/ClickHouse/pull/78748) ([San Tran](https://github.com/santrancisco)).
* Fix assert in S3Queue. [#78792](https://github.com/ClickHouse/ClickHouse/pull/78792) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix: lazy materialization in distributed queries. [#78815](https://github.com/ClickHouse/ClickHouse/pull/78815) ([Igor Nikonov](https://github.com/devcrafter)).
* Make parquet version selection less confusing. [#78818](https://github.com/ClickHouse/ClickHouse/pull/78818) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix use-of-uninitialized-value in `CompressedReadBufferBase::addDiagnostics()`. [#78838](https://github.com/ClickHouse/ClickHouse/pull/78838) ([Sergei Trifonov](https://github.com/serxa)).
* Fix `Array(Bool)` to `Array(FixedString)` conversion. [#78863](https://github.com/ClickHouse/ClickHouse/pull/78863) ([Nikita Taranov](https://github.com/nickitat)).
* Fix 00157_cache_dictionary Timeout. [#78864](https://github.com/ClickHouse/ClickHouse/pull/78864) ([Shichao Jin](https://github.com/jsc0218)).
* Fix 77452. [#78904](https://github.com/ClickHouse/ClickHouse/pull/78904) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Next BuzzHouse update. [#78910](https://github.com/ClickHouse/ClickHouse/pull/78910) ([Pedro Ferreira](https://github.com/PedroTadim)).
* update arrow submodule for table reader fixes. [#78920](https://github.com/ClickHouse/ClickHouse/pull/78920) ([Bharat Nallan](https://github.com/bharatnc)).
* Prohibit deprecated OpenSSL API. [#78924](https://github.com/ClickHouse/ClickHouse/pull/78924) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Throw proper exception for unsupported writes for datalakes. [#78960](https://github.com/ClickHouse/ClickHouse/pull/78960) ([alesapin](https://github.com/alesapin)).
* fix typo. [#78968](https://github.com/ClickHouse/ClickHouse/pull/78968) ([YiJustin](https://github.com/YiJustin401)).
* tests test_async_insert_adaptive_busy_timeout/test.py::test_change_queries_frequency and test_async_insert_adaptive_busy_timeout/test.py::test_compare_sequential_inserts_durations_for_adaptive_and_fixed_async_timeouts are flaky. [#78980](https://github.com/ClickHouse/ClickHouse/pull/78980) ([Daniil Ivanik](https://github.com/divanik)).
* Now if source table for system.metric_log view is dropped, view itself will return 0 rows. [#78985](https://github.com/ClickHouse/ClickHouse/pull/78985) ([alesapin](https://github.com/alesapin)).
* CI: Special labels to reduce CI scope. [#78997](https://github.com/ClickHouse/ClickHouse/pull/78997) ([Max Kainov](https://github.com/maxknv)).
* CI: Enable profiling in perf tests. [#79002](https://github.com/ClickHouse/ClickHouse/pull/79002) ([Max Kainov](https://github.com/maxknv)).
* tests: avoid data-race in bash in 01161_all_system_tables. [#79013](https://github.com/ClickHouse/ClickHouse/pull/79013) ([Azat Khuzhin](https://github.com/azat)).
* Introspection of .sh tests (via BASH_XTRACEFD). [#79015](https://github.com/ClickHouse/ClickHouse/pull/79015) ([Azat Khuzhin](https://github.com/azat)).
* ci: fix "Digest does not match" for Replicated database in stress tests. [#79016](https://github.com/ClickHouse/ClickHouse/pull/79016) ([Azat Khuzhin](https://github.com/azat)).
* ci: run only 10% (5 times) of test runs for long tests. [#79019](https://github.com/ClickHouse/ClickHouse/pull/79019) ([Azat Khuzhin](https://github.com/azat)).
* Update version after release. [#79020](https://github.com/ClickHouse/ClickHouse/pull/79020) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* CI: Fix version update on new release branch create. [#79029](https://github.com/ClickHouse/ClickHouse/pull/79029) ([Max Kainov](https://github.com/maxknv)).
* Fix `ReservoirSampler` self-merging. [#79031](https://github.com/ClickHouse/ClickHouse/pull/79031) ([Nikita Taranov](https://github.com/nickitat)).
* Fix compatiblity value for max_merge_delayed_streams_for_parallel_write (MT). [#79034](https://github.com/ClickHouse/ClickHouse/pull/79034) ([Azat Khuzhin](https://github.com/azat)).
* Minor: Do not add empty blocks to join while using ConcurrentHashJoin. [#79035](https://github.com/ClickHouse/ClickHouse/pull/79035) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix history values for max_postpone_time_for_failed_replicated_ settings. [#79036](https://github.com/ClickHouse/ClickHouse/pull/79036) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Place 25.4 setting changes under 25.4. [#79037](https://github.com/ClickHouse/ClickHouse/pull/79037) ([Raúl Marín](https://github.com/Algunenano)).
* trace-visualizer: add runtime/share in tooltips and status messages. [#79040](https://github.com/ClickHouse/ClickHouse/pull/79040) ([Sergei Trifonov](https://github.com/serxa)).
* Delete flaky test 02421_type_json_empty_parts with old Object type. [#79041](https://github.com/ClickHouse/ClickHouse/pull/79041) ([Pavel Kruglov](https://github.com/Avogar)).
* trace-visualizer: load data from clickhouse server. [#79042](https://github.com/ClickHouse/ClickHouse/pull/79042) ([Sergei Trifonov](https://github.com/serxa)).
* remove experimental mark of share set join. [#79044](https://github.com/ClickHouse/ClickHouse/pull/79044) ([Han Fei](https://github.com/hanfei1991)).
* Fix storage of insertion table in client context. [#79046](https://github.com/ClickHouse/ClickHouse/pull/79046) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Add RabbitMQ monitor to debug test_storage_rabbitmq. [#79050](https://github.com/ClickHouse/ClickHouse/pull/79050) ([Pablo Marcos](https://github.com/pamarcos)).
* Fix listing local objects. [#79053](https://github.com/ClickHouse/ClickHouse/pull/79053) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix flaky test test_storage_s3::test_parallel_reading_with_memory_limit. [#79054](https://github.com/ClickHouse/ClickHouse/pull/79054) ([Shankar Iyer](https://github.com/shankar-iyer)).
* CI: Fix head_repo inserted into ci db from forks. [#79055](https://github.com/ClickHouse/ClickHouse/pull/79055) ([Max Kainov](https://github.com/maxknv)).
* Fix the destruction order of data members of `AggregatingSortedAlgorithm` and `SummingSortedAlgorithm`. [#79056](https://github.com/ClickHouse/ClickHouse/pull/79056) ([Nikita Taranov](https://github.com/nickitat)).
* CI: Automatically skip jobs not affected by the change. [#79057](https://github.com/ClickHouse/ClickHouse/pull/79057) ([Max Kainov](https://github.com/maxknv)).
* Fix test test_backup_restore_on_cluster/test_concurrency.py::test_concurrent_backups_on_same_node. [#79060](https://github.com/ClickHouse/ClickHouse/pull/79060) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix test test_backup_restore_on_cluster/test_cancel_backup.py::test_long_disconnection_stops_backup. [#79061](https://github.com/ClickHouse/ClickHouse/pull/79061) ([Vitaly Baranov](https://github.com/vitlibar)).
* Closes [#72439](https://github.com/ClickHouse/ClickHouse/issues/72439). [#79083](https://github.com/ClickHouse/ClickHouse/pull/79083) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Add debug logs. [#79089](https://github.com/ClickHouse/ClickHouse/pull/79089) ([Max Kainov](https://github.com/maxknv)).
* Grant full permissions to test_partial_acl_delete/subnode before deleting. [#79104](https://github.com/ClickHouse/ClickHouse/pull/79104) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Update delta-kernel-rs to latest main. [#79115](https://github.com/ClickHouse/ClickHouse/pull/79115) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix flaky test 03364_estimate_compression_ratio. [#79116](https://github.com/ClickHouse/ClickHouse/pull/79116) ([Pavel Kruglov](https://github.com/Avogar)).
* Add ci labels to run all integration/functional tests only. [#79117](https://github.com/ClickHouse/ClickHouse/pull/79117) ([Kseniia Sumarokova](https://github.com/kssenii)).
* backport [#28892](https://github.com/ClickHouse/ClickHouse/issues/28892) to open source repo. [#79119](https://github.com/ClickHouse/ClickHouse/pull/79119) ([Han Fei](https://github.com/hanfei1991)).
* The `alwaysUnknownOrTrue` is implemented by each child class and some of them were using the same implementation (the code was duplicated). [#79124](https://github.com/ClickHouse/ClickHouse/pull/79124) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Lint OpenSSL initialization. [#79132](https://github.com/ClickHouse/ClickHouse/pull/79132) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Remove guard pages for threads and async_socket_for_remote/use_hedge_requests. Change the allocation method in `FiberStack` from `mmap` to `aligned_alloc`. Since this splits VMAs and under heavy load vm.max_map_count can be reached. [#79147](https://github.com/ClickHouse/ClickHouse/pull/79147) ([Sema Checherinda](https://github.com/CheSema)).
* Minor refactoring near `MergeTree` sinks. [#79160](https://github.com/ClickHouse/ClickHouse/pull/79160) ([Anton Popov](https://github.com/CurtizJ)).
* Follow-up to [#79024](https://github.com/ClickHouse/ClickHouse/issues/79024). [#79165](https://github.com/ClickHouse/ClickHouse/pull/79165) ([Robert Schulze](https://github.com/rschu1ze)).
* Add/remove meetups to/from README.md. [#79167](https://github.com/ClickHouse/ClickHouse/pull/79167) ([Zoe Steinkamp](https://github.com/zoesteinkamp)).
* CI: Add build digest into ci data. [#79168](https://github.com/ClickHouse/ClickHouse/pull/79168) ([Max Kainov](https://github.com/maxknv)).
* CI: fix docs_job failing on markdown-linter. [#79170](https://github.com/ClickHouse/ClickHouse/pull/79170) ([Shaun Struwig](https://github.com/Blargian)).
* CI: Improve subtask output in CI report. [#79176](https://github.com/ClickHouse/ClickHouse/pull/79176) ([Max Kainov](https://github.com/maxknv)).
* Fix znode_exists flakiness in test_refreshable_mv_in_replicated_db. [#79178](https://github.com/ClickHouse/ClickHouse/pull/79178) ([Michael Kolupaev](https://github.com/al13n321)).
* Force full storage for GIN tests. [#79201](https://github.com/ClickHouse/ClickHouse/pull/79201) ([Robert Schulze](https://github.com/rschu1ze)).
* Increase number of messages to avoid flakiness. [#79202](https://github.com/ClickHouse/ClickHouse/pull/79202) ([Pablo Marcos](https://github.com/pamarcos)).
* Adds a log file for external http server. [#79212](https://github.com/ClickHouse/ClickHouse/pull/79212) ([Max Vostrikov](https://github.com/max-vostrikov)).
* Fix flaky 02908_many_requests_to_system_replicas. [#79213](https://github.com/ClickHouse/ClickHouse/pull/79213) ([Alexander Gololobov](https://github.com/davenger)).
* Speed up 10x test_storage_rabbitmq::test_failed_connection. [#79217](https://github.com/ClickHouse/ClickHouse/pull/79217) ([Pablo Marcos](https://github.com/pamarcos)).
* fix build on osx with command line tool 16.3. [#79220](https://github.com/ClickHouse/ClickHouse/pull/79220) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Clarify `low_priority_query_wait_time_ms` purpose. [#79225](https://github.com/ClickHouse/ClickHouse/pull/79225) ([Nikita Taranov](https://github.com/nickitat)).
* Add retry logic to test_backup_restore_new::test_system_backups. [#79226](https://github.com/ClickHouse/ClickHouse/pull/79226) ([Samay Sharma](https://github.com/samay-sharma)).
* Fix compilation with clang-20. [#79227](https://github.com/ClickHouse/ClickHouse/pull/79227) ([Nikita Taranov](https://github.com/nickitat)).
* metrics on failing merges. [#79228](https://github.com/ClickHouse/ClickHouse/pull/79228) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* build: use POST_BUILD over separate targets for creating clickhouse symlinks. [#79230](https://github.com/ClickHouse/ClickHouse/pull/79230) ([Azat Khuzhin](https://github.com/azat)).
* Simplify projection lwd logic a bit. [#79234](https://github.com/ClickHouse/ClickHouse/pull/79234) ([Shichao Jin](https://github.com/jsc0218)).
* There was a tricky usage scenario for clickhouse-local: running it with the `--path` of clickhouse-server to read persistent log tables from the `system` database. In the unreleased version 25.4, it was loading only ephemeral system tables in the system database. [#79235](https://github.com/ClickHouse/ClickHouse/pull/79235) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* better warning message for skipped startup scripts. [#79236](https://github.com/ClickHouse/ClickHouse/pull/79236) ([Bharat Nallan](https://github.com/bharatnc)).
* Small improvement for transposed_metric_log. [#79246](https://github.com/ClickHouse/ClickHouse/pull/79246) ([alesapin](https://github.com/alesapin)).
* CI: Fix log export in clickbench. [#79248](https://github.com/ClickHouse/ClickHouse/pull/79248) ([Max Kainov](https://github.com/maxknv)).
* Fix build on NixOS. [#79286](https://github.com/ClickHouse/ClickHouse/pull/79286) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Increase number of messages to avoid flakiness. [#79287](https://github.com/ClickHouse/ClickHouse/pull/79287) ([Pablo Marcos](https://github.com/pamarcos)).
* Switch contrib/zstd to a fork with huf_decompress_amd64.S fix. [#79288](https://github.com/ClickHouse/ClickHouse/pull/79288) ([Michael Kolupaev](https://github.com/al13n321)).
* Skip `test_storage_rabbitmq::test_failed_connection` for now. [#79291](https://github.com/ClickHouse/ClickHouse/pull/79291) ([Pablo Marcos](https://github.com/pamarcos)).
* Add test for fixed detached view issue. [#79295](https://github.com/ClickHouse/ClickHouse/pull/79295) ([Pedro Ferreira](https://github.com/PedroTadim)).
* CI: improve subtask output in CI report. [#79296](https://github.com/ClickHouse/ClickHouse/pull/79296) ([Shaun Struwig](https://github.com/Blargian)).
* Disable two broken rabbitmq tests until fixed. [#79301](https://github.com/ClickHouse/ClickHouse/pull/79301) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Stateless tests: mark blacklisted tests as failed when they succeed. [#79303](https://github.com/ClickHouse/ClickHouse/pull/79303) ([Nikita Fomichev](https://github.com/fm4v)).
* Query to system database can hang if system database metadata located in keeper. [#79304](https://github.com/ClickHouse/ClickHouse/pull/79304) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Add a test for [#35307](https://github.com/ClickHouse/ClickHouse/issues/35307). [#79306](https://github.com/ClickHouse/ClickHouse/pull/79306) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#61275](https://github.com/ClickHouse/ClickHouse/issues/61275). [#79316](https://github.com/ClickHouse/ClickHouse/pull/79316) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Less logs. [#79322](https://github.com/ClickHouse/ClickHouse/pull/79322) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix flaky 01780_column_sparse_pk (with parallel replicas). [#79328](https://github.com/ClickHouse/ClickHouse/pull/79328) ([Igor Nikonov](https://github.com/devcrafter)).
* Encapsulate one field in `MergeTreePartInfo`. [#79331](https://github.com/ClickHouse/ClickHouse/pull/79331) ([Anton Popov](https://github.com/CurtizJ)).
* Remove `ArrayCache`. [#79336](https://github.com/ClickHouse/ClickHouse/pull/79336) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* `clickhouse-benchmark` will display percentage based on the max iterations if specified. [#79346](https://github.com/ClickHouse/ClickHouse/pull/79346) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Better introspection for index analysis performance. [#79347](https://github.com/ClickHouse/ClickHouse/pull/79347) ([Nikita Taranov](https://github.com/nickitat)).
* Remove `io_uring` from tests randomization. [#79349](https://github.com/ClickHouse/ClickHouse/pull/79349) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* tests: fix 02441_alter_delete_and_drop_column flakiness (filter out GET_PART). [#79357](https://github.com/ClickHouse/ClickHouse/pull/79357) ([Azat Khuzhin](https://github.com/azat)).
* tests: disable 03352_concurrent_rename_alter for PR. [#79358](https://github.com/ClickHouse/ClickHouse/pull/79358) ([Azat Khuzhin](https://github.com/azat)).
* tests: attempt to fix hangs of postgres container (leads to tests timeouts). [#79360](https://github.com/ClickHouse/ClickHouse/pull/79360) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix 03393_max_merge_delayed_streams_for_parallel_write flakiness (disable for MSan). [#79362](https://github.com/ClickHouse/ClickHouse/pull/79362) ([Azat Khuzhin](https://github.com/azat)).
* More fair max_processed_files_before_commit in S3Queue/AzureQueue. [#79363](https://github.com/ClickHouse/ClickHouse/pull/79363) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix test_storage_s3_queue/test_0.py::test_streaming_to_many_views flakiness. [#79364](https://github.com/ClickHouse/ClickHouse/pull/79364) ([Azat Khuzhin](https://github.com/azat)).
* Fix ci-integration-test/ci-function-test tags. [#79365](https://github.com/ClickHouse/ClickHouse/pull/79365) ([Azat Khuzhin](https://github.com/azat)).
* Bump usearch to v2.17.7. [#79371](https://github.com/ClickHouse/ClickHouse/pull/79371) ([Robert Schulze](https://github.com/rschu1ze)).
* cctools: use default prefix for gdb to fix debug symbols lookup. [#79372](https://github.com/ClickHouse/ClickHouse/pull/79372) ([Azat Khuzhin](https://github.com/azat)).
* Implement Settings Aliases without nested calls (fixes clang 20 build). [#79376](https://github.com/ClickHouse/ClickHouse/pull/79376) ([Azat Khuzhin](https://github.com/azat)).
* More tests for PR INSERT SELECT. [#79380](https://github.com/ClickHouse/ClickHouse/pull/79380) ([Igor Nikonov](https://github.com/devcrafter)).
* CI: Add tqdm module to style-test docker image. [#79395](https://github.com/ClickHouse/ClickHouse/pull/79395) ([Max Kainov](https://github.com/maxknv)).
* A fix for unreleased change. [#79396](https://github.com/ClickHouse/ClickHouse/pull/79396) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Add more packages into style-test image. [#79397](https://github.com/ClickHouse/ClickHouse/pull/79397) ([Max Kainov](https://github.com/maxknv)).
* Address the code review comments from @KochetovNicolai. [#79399](https://github.com/ClickHouse/ClickHouse/pull/79399) ([Dmitry Novik](https://github.com/novikd)).
* Lazy Materialization with parallel replicas. [#79401](https://github.com/ClickHouse/ClickHouse/pull/79401) ([Igor Nikonov](https://github.com/devcrafter)).
* Sync private. [#79404](https://github.com/ClickHouse/ClickHouse/pull/79404) ([Raúl Marín](https://github.com/Algunenano)).
* make fix-02443_detach_attach_partition.sh less flaky. [#79405](https://github.com/ClickHouse/ClickHouse/pull/79405) ([Han Fei](https://github.com/hanfei1991)).
* CI: Create release workflow (patch release) fix. [#79406](https://github.com/ClickHouse/ClickHouse/pull/79406) ([Max Kainov](https://github.com/maxknv)).
* CI: CreateRelease workflow: fix github helper with cache. [#79409](https://github.com/ClickHouse/ClickHouse/pull/79409) ([Max Kainov](https://github.com/maxknv)).
* log exceptions in thread pool worker. [#79410](https://github.com/ClickHouse/ClickHouse/pull/79410) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Update version_date.tsv and changelog after v25.3.3.42-lts. [#79415](https://github.com/ClickHouse/ClickHouse/pull/79415) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* CI: CreateRelease workflow changelog script fix. [#79421](https://github.com/ClickHouse/ClickHouse/pull/79421) ([Max Kainov](https://github.com/maxknv)).
* Cleanup some cmake warnings. [#79427](https://github.com/ClickHouse/ClickHouse/pull/79427) ([Raúl Marín](https://github.com/Algunenano)).
* Adjust settings history after backports to 25.4. [#79430](https://github.com/ClickHouse/ClickHouse/pull/79430) ([Raúl Marín](https://github.com/Algunenano)).
* CI: run docs check generated documentation using branch build. [#79431](https://github.com/ClickHouse/ClickHouse/pull/79431) ([Shaun Struwig](https://github.com/Blargian)).
* Update version_date.tsv and changelog after v25.4.1.2934-stable. [#79436](https://github.com/ClickHouse/ClickHouse/pull/79436) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Add system.parts table visualizer. [#79437](https://github.com/ClickHouse/ClickHouse/pull/79437) ([Sergei Trifonov](https://github.com/serxa)).
* Make userspace page cache resizing look at MemoryTracker::amount. [#79443](https://github.com/ClickHouse/ClickHouse/pull/79443) ([Michael Kolupaev](https://github.com/al13n321)).
* Remove LTS "label" from 24.4 version in changelog. [#79444](https://github.com/ClickHouse/ClickHouse/pull/79444) ([Vitaly Orlov](https://github.com/orloffv)).
* Fix test_storage_rabbitmq/test_failed_connection.py. [#79450](https://github.com/ClickHouse/ClickHouse/pull/79450) ([Pablo Marcos](https://github.com/pamarcos)).
* Enable the XRay flavor only on Debug builds. [#79455](https://github.com/ClickHouse/ClickHouse/pull/79455) ([Pablo Marcos](https://github.com/pamarcos)).
* Next update. [#79456](https://github.com/ClickHouse/ClickHouse/pull/79456) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Remove trailing whitespaces during formating SELECT query in PROJECTION. [#79467](https://github.com/ClickHouse/ClickHouse/pull/79467) ([Azat Khuzhin](https://github.com/azat)).
* refine setting doc of use_iceberg_metadata_files_cache. [#79468](https://github.com/ClickHouse/ClickHouse/pull/79468) ([Han Fei](https://github.com/hanfei1991)).
* Fix crash in MySQL authentication in unreleased version. [#79492](https://github.com/ClickHouse/ClickHouse/pull/79492) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* CI: Move arm_binary and arm_coverage to regular builds group. [#79503](https://github.com/ClickHouse/ClickHouse/pull/79503) ([Max Kainov](https://github.com/maxknv)).
* Update quick_sync.py. [#79532](https://github.com/ClickHouse/ClickHouse/pull/79532) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix a typo in threadstack::getsize. [#79533](https://github.com/ClickHouse/ClickHouse/pull/79533) ([Sema Checherinda](https://github.com/CheSema)).
* Destroy pipeline before gathering profile event and writing query_log in order to log into query_log some event updates inside processors destructors. [#79540](https://github.com/ClickHouse/ClickHouse/pull/79540) ([Sema Checherinda](https://github.com/CheSema)).
* tests: enable debugging via BASH_XTRACEFD only if bash is new enough. [#79544](https://github.com/ClickHouse/ClickHouse/pull/79544) ([Azat Khuzhin](https://github.com/azat)).
* tests: use local variables in *.lib to avoid overlaps with parent scope. [#79545](https://github.com/ClickHouse/ClickHouse/pull/79545) ([Azat Khuzhin](https://github.com/azat)).
* tests: print last lines in debug log (those are most useful for debugging). [#79546](https://github.com/ClickHouse/ClickHouse/pull/79546) ([Azat Khuzhin](https://github.com/azat)).
* Sync some files. [#79549](https://github.com/ClickHouse/ClickHouse/pull/79549) ([Raúl Marín](https://github.com/Algunenano)).
* Just another attempt to make test_storage_rabbitmq less flaky. [#79550](https://github.com/ClickHouse/ClickHouse/pull/79550) ([Pablo Marcos](https://github.com/pamarcos)).
* Make test_check_replicated_does_not_block_shutdown less flaky and faster. [#79552](https://github.com/ClickHouse/ClickHouse/pull/79552) ([Raúl Marín](https://github.com/Algunenano)).
* Fix transposed metric log test. [#79555](https://github.com/ClickHouse/ClickHouse/pull/79555) ([alesapin](https://github.com/alesapin)).
* Add task stealing for async tasks in PipelineExecutor. [#79556](https://github.com/ClickHouse/ClickHouse/pull/79556) ([Sergei Trifonov](https://github.com/serxa)).
* Fix typos ``` IcebegerVersionHintUsed -> IcebergVersionHintUsed IcebergPartitionPrunnedFiles -> IcebergPartitionPrunedFiles IcebergMinMaxIndexPrunnedFiles -> IcebergMinMaxIndexPrunedFiles ```. [#79558](https://github.com/ClickHouse/ClickHouse/pull/79558) ([Alsu Giliazova](https://github.com/alsugiliazova)).
* tests: do not run 02536_system_sync_file_cache in parallel. [#79559](https://github.com/ClickHouse/ClickHouse/pull/79559) ([Azat Khuzhin](https://github.com/azat)).
* fix data race in poco::JSON::stringify. [#79574](https://github.com/ClickHouse/ClickHouse/pull/79574) ([Han Fei](https://github.com/hanfei1991)).
* cctools: do not rely on gdb location for debug symbols. [#79575](https://github.com/ClickHouse/ClickHouse/pull/79575) ([Azat Khuzhin](https://github.com/azat)).
* Forbid incorrect use-case for `CaseWithExpression`. [#79593](https://github.com/ClickHouse/ClickHouse/pull/79593) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Avoid cache calculation for deduplication when deduplication is off. [#79596](https://github.com/ClickHouse/ClickHouse/pull/79596) ([Sema Checherinda](https://github.com/CheSema)).
* tests: randomize hedged requests usage. [#79602](https://github.com/ClickHouse/ClickHouse/pull/79602) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix 03396_s3_do_not_retry_dns_errors flakiness. [#79608](https://github.com/ClickHouse/ClickHouse/pull/79608) ([Azat Khuzhin](https://github.com/azat)).
* tests: extended coverage for hedged requests and async socket. [#79628](https://github.com/ClickHouse/ClickHouse/pull/79628) ([Eduard Karacharov](https://github.com/korowa)).
* CI: Remove deprecated CI job filter for docs only update. [#79631](https://github.com/ClickHouse/ClickHouse/pull/79631) ([Max Kainov](https://github.com/maxknv)).
* tests: use `table_disk=1` over explicit UUIDs for attaching datasets. [#79632](https://github.com/ClickHouse/ClickHouse/pull/79632) ([Azat Khuzhin](https://github.com/azat)).
* Fix `chcache` with `clang20`. [#79654](https://github.com/ClickHouse/ClickHouse/pull/79654) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Update rust vendor. [#79664](https://github.com/ClickHouse/ClickHouse/pull/79664) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Make [#76185](https://github.com/ClickHouse/ClickHouse/issues/76185) backportable. [#79665](https://github.com/ClickHouse/ClickHouse/pull/79665) ([Nikita Taranov](https://github.com/nickitat)).
* A few small fixes to ClickHouse benchmark. [#79669](https://github.com/ClickHouse/ClickHouse/pull/79669) ([Bharat Nallan](https://github.com/bharatnc)).
* refine the exception message when keeper reaches soft memory limit. [#79670](https://github.com/ClickHouse/ClickHouse/pull/79670) ([Han Fei](https://github.com/hanfei1991)).
* CI: Ignore non utf-8 errors. [#79673](https://github.com/ClickHouse/ClickHouse/pull/79673) ([Max Kainov](https://github.com/maxknv)).
* Split kafka tests (1). [#79700](https://github.com/ClickHouse/ClickHouse/pull/79700) ([Ilya Golshtein](https://github.com/ilejn)).
* CI: Enable build profiling. [#79709](https://github.com/ClickHouse/ClickHouse/pull/79709) ([Max Kainov](https://github.com/maxknv)).
* This closes [#79717](https://github.com/ClickHouse/ClickHouse/issues/79717). [#79723](https://github.com/ClickHouse/ClickHouse/pull/79723) ([Amos Bird](https://github.com/amosbird)).
* Fix build of MySQL tests. [#79726](https://github.com/ClickHouse/ClickHouse/pull/79726) ([Nikita Taranov](https://github.com/nickitat)).
* CI: Compress praktika result for faster report response. [#79742](https://github.com/ClickHouse/ClickHouse/pull/79742) ([Max Kainov](https://github.com/maxknv)).
* Update version_date.tsv and changelog after v25.4.2.31-stable. [#79755](https://github.com/ClickHouse/ClickHouse/pull/79755) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* fix flaky test 00932_geohash_support. [#79772](https://github.com/ClickHouse/ClickHouse/pull/79772) ([Bharat Nallan](https://github.com/bharatnc)).
* fix flaky test 03442_alter_delete_empty_part_rmt. [#79799](https://github.com/ClickHouse/ClickHouse/pull/79799) ([Bharat Nallan](https://github.com/bharatnc)).
* Replacing _PROJECT_SOURCE_DIR_ with a unified _ClickHouse_SOURCE_DIR_ variable. As in other files CMakeLists.txt a unified variable _ClickHouse_SOURCE_DIR_ is used from the contrib folder, so you need to change it here as well. [#79807](https://github.com/ClickHouse/ClickHouse/pull/79807) ([Kyamran](https://github.com/nibblerenush)).
* Fix `02354_vector_search_reference_vector_types` for parallel replicas. [#79813](https://github.com/ClickHouse/ClickHouse/pull/79813) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Add a test for [#58987](https://github.com/ClickHouse/ClickHouse/issues/58987). [#79821](https://github.com/ClickHouse/ClickHouse/pull/79821) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#58016](https://github.com/ClickHouse/ClickHouse/issues/58016). [#79823](https://github.com/ClickHouse/ClickHouse/pull/79823) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#50277](https://github.com/ClickHouse/ClickHouse/issues/50277). [#79825](https://github.com/ClickHouse/ClickHouse/pull/79825) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#54916](https://github.com/ClickHouse/ClickHouse/issues/54916). [#79826](https://github.com/ClickHouse/ClickHouse/pull/79826) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#54915](https://github.com/ClickHouse/ClickHouse/issues/54915). [#79827](https://github.com/ClickHouse/ClickHouse/pull/79827) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#54562](https://github.com/ClickHouse/ClickHouse/issues/54562). [#79828](https://github.com/ClickHouse/ClickHouse/pull/79828) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#60018](https://github.com/ClickHouse/ClickHouse/issues/60018). [#79829](https://github.com/ClickHouse/ClickHouse/pull/79829) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#57432](https://github.com/ClickHouse/ClickHouse/issues/57432). [#79830](https://github.com/ClickHouse/ClickHouse/pull/79830) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#53776](https://github.com/ClickHouse/ClickHouse/issues/53776). [#79831](https://github.com/ClickHouse/ClickHouse/pull/79831) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#65690](https://github.com/ClickHouse/ClickHouse/issues/65690). [#79840](https://github.com/ClickHouse/ClickHouse/pull/79840) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#62816](https://github.com/ClickHouse/ClickHouse/issues/62816). [#79841](https://github.com/ClickHouse/ClickHouse/pull/79841) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* try to fix flaky test test_database_glue. [#79843](https://github.com/ClickHouse/ClickHouse/pull/79843) ([Bharat Nallan](https://github.com/bharatnc)).
* Add `bind_host` example to config. [#79846](https://github.com/ClickHouse/ClickHouse/pull/79846) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* The reports are missing both `fatal.log` and stack traces in the raw logs. This PR fixes it. [#79848](https://github.com/ClickHouse/ClickHouse/pull/79848) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Fix build on clang-20. [#79851](https://github.com/ClickHouse/ClickHouse/pull/79851) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* use python instead of sed in test script. [#79852](https://github.com/ClickHouse/ClickHouse/pull/79852) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Some cleanups around inverted index. [#79853](https://github.com/ClickHouse/ClickHouse/pull/79853) ([Robert Schulze](https://github.com/rschu1ze)).
* fix flaky test test_covered_by_broken_exists. [#79865](https://github.com/ClickHouse/ClickHouse/pull/79865) ([Bharat Nallan](https://github.com/bharatnc)).
* Tiny vector search cleanups. [#79870](https://github.com/ClickHouse/ClickHouse/pull/79870) ([Robert Schulze](https://github.com/rschu1ze)).
* Add azat to the trusted list. [#79884](https://github.com/ClickHouse/ClickHouse/pull/79884) ([Azat Khuzhin](https://github.com/azat)).
* fix flaky test_database_glue (followup). [#79889](https://github.com/ClickHouse/ClickHouse/pull/79889) ([Bharat Nallan](https://github.com/bharatnc)).
* update trusted contributors. [#79893](https://github.com/ClickHouse/ClickHouse/pull/79893) ([Bharat Nallan](https://github.com/bharatnc)).
* This reverts https://github.com/ClickHouse/ClickHouse/pull/77309. [#79898](https://github.com/ClickHouse/ClickHouse/pull/79898) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* fix flaky test_database_hms. [#79906](https://github.com/ClickHouse/ClickHouse/pull/79906) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix a mistake in [#79339](https://github.com/ClickHouse/ClickHouse/issues/79339). [#79908](https://github.com/ClickHouse/ClickHouse/pull/79908) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Fix failure of `02415_all_new_functions_must_have_version_information`. [#79935](https://github.com/ClickHouse/ClickHouse/pull/79935) ([Robert Schulze](https://github.com/rschu1ze)).
* remove some useless code and sync some code for snapshot. [#79936](https://github.com/ClickHouse/ClickHouse/pull/79936) ([Han Fei](https://github.com/hanfei1991)).
* Fix flaky test_refreshable_mv/test.py::test_adding_replica. [#79940](https://github.com/ClickHouse/ClickHouse/pull/79940) ([Michael Kolupaev](https://github.com/al13n321)).
* fix flaky test_cgroup_limit. [#79948](https://github.com/ClickHouse/ClickHouse/pull/79948) ([Bharat Nallan](https://github.com/bharatnc)).
* Disable connections and queries drop by default. [#79964](https://github.com/ClickHouse/ClickHouse/pull/79964) ([Raúl Marín](https://github.com/Algunenano)).
* chcache: fix rebuilding Rust projects on sequential CMake runs. [#79965](https://github.com/ClickHouse/ClickHouse/pull/79965) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#80512](https://github.com/ClickHouse/ClickHouse/issues/80512): TODO: enable it by default in one of the next releases. [#79967](https://github.com/ClickHouse/ClickHouse/pull/79967) ([Pavel Kruglov](https://github.com/Avogar)).
* Reduce locking in `HashTablesStatistics`. [#79976](https://github.com/ClickHouse/ClickHouse/pull/79976) ([Nikita Taranov](https://github.com/nickitat)).
* Add tool for query latency analyzing. [#79978](https://github.com/ClickHouse/ClickHouse/pull/79978) ([Sergei Trifonov](https://github.com/serxa)).
* tests: disable warnings for client tests with expect. [#79979](https://github.com/ClickHouse/ClickHouse/pull/79979) ([Azat Khuzhin](https://github.com/azat)).
* Sync parser files. [#79983](https://github.com/ClickHouse/ClickHouse/pull/79983) ([Raúl Marín](https://github.com/Algunenano)).
* Stateless tests: parallel replicas skip flaky test 02317_distinct_in_order_optimization. [#79986](https://github.com/ClickHouse/ClickHouse/pull/79986) ([Nikita Fomichev](https://github.com/fm4v)).
* This closes: [#79989](https://github.com/ClickHouse/ClickHouse/issues/79989). [#79990](https://github.com/ClickHouse/ClickHouse/pull/79990) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* tests: fix 01945_show_debug_warning. [#79994](https://github.com/ClickHouse/ClickHouse/pull/79994) ([Azat Khuzhin](https://github.com/azat)).
* few more test cases for splitByChar. [#79995](https://github.com/ClickHouse/ClickHouse/pull/79995) ([Bharat Nallan](https://github.com/bharatnc)).
* Replace outdated env vars in MinIO config. [#80008](https://github.com/ClickHouse/ClickHouse/pull/80008) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Update README.md for Tokyo meetup on June 5 under Upcoming meetups. [#80015](https://github.com/ClickHouse/ClickHouse/pull/80015) ([Cheryl Tuquib](https://github.com/chetuquib)).
* Add explicit index_granularity to test 03355_join_to_in_optimization. [#80016](https://github.com/ClickHouse/ClickHouse/pull/80016) ([Shankar Iyer](https://github.com/shankar-iyer)).
* `enable_user_name_access_type` must not affect `DEFINER` access type. [#80026](https://github.com/ClickHouse/ClickHouse/pull/80026) ([pufit](https://github.com/pufit)).
* Try to make test_check_replicated_does_not_block_shutdown less flaky. [#80028](https://github.com/ClickHouse/ClickHouse/pull/80028) ([Raúl Marín](https://github.com/Algunenano)).
* Try to fix BugFix validation. [#80029](https://github.com/ClickHouse/ClickHouse/pull/80029) ([Raúl Marín](https://github.com/Algunenano)).
* Remove outdated code. [#80036](https://github.com/ClickHouse/ClickHouse/pull/80036) ([Anton Popov](https://github.com/CurtizJ)).
* Update version_date.tsv and changelog after v25.4.3.22-stable. [#80040](https://github.com/ClickHouse/ClickHouse/pull/80040) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Improve geo parquet. [#80050](https://github.com/ClickHouse/ClickHouse/pull/80050) ([scanhex12](https://github.com/scanhex12)).
* Fix test `02155_h3_to_center_child`. [#80064](https://github.com/ClickHouse/ClickHouse/pull/80064) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Fix OS error in perf job script. [#80089](https://github.com/ClickHouse/ClickHouse/pull/80089) ([Max Kainov](https://github.com/maxknv)).
* CI: SQLTest: Fix report file location. [#80090](https://github.com/ClickHouse/ClickHouse/pull/80090) ([Max Kainov](https://github.com/maxknv)).
* CI: Fix praktika docker clean up. [#80091](https://github.com/ClickHouse/ClickHouse/pull/80091) ([Max Kainov](https://github.com/maxknv)).
* Query condition cache: reduce logging verbosity. [#80093](https://github.com/ClickHouse/ClickHouse/pull/80093) ([Robert Schulze](https://github.com/rschu1ze)).
* add no-msan/asan/tsan tag for test 01396_inactive_replica_cleanup_nodes_zookeeper. [#80100](https://github.com/ClickHouse/ClickHouse/pull/80100) ([Han Fei](https://github.com/hanfei1991)).
* Disallow {marks_compress/primary_key}_compress_block_size = 0. [#80102](https://github.com/ClickHouse/ClickHouse/pull/80102) ([Robert Schulze](https://github.com/rschu1ze)).
* Stateless tests: fix flaky tests with async insert enabled. [#80104](https://github.com/ClickHouse/ClickHouse/pull/80104) ([Nikita Fomichev](https://github.com/fm4v)).
* Improve bitmap function error messages. [#80106](https://github.com/ClickHouse/ClickHouse/pull/80106) ([Raúl Marín](https://github.com/Algunenano)).
* CI: Safari: Switch report compression to supported gzip. [#80119](https://github.com/ClickHouse/ClickHouse/pull/80119) ([Max Kainov](https://github.com/maxknv)).
* Fix ubsan issue in quantileBFloat16. [#80137](https://github.com/ClickHouse/ClickHouse/pull/80137) ([Robert Schulze](https://github.com/rschu1ze)).
* Disable atexit hook for OpenSSL. [#80138](https://github.com/ClickHouse/ClickHouse/pull/80138) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Prevent setting max_block_size to 0. [#80140](https://github.com/ClickHouse/ClickHouse/pull/80140) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Fix UBSan failure on non-aligned PODArray null pointer. [#80145](https://github.com/ClickHouse/ClickHouse/pull/80145) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Remove noexcept for removeifneeded. [#80154](https://github.com/ClickHouse/ClickHouse/pull/80154) ([Sema Checherinda](https://github.com/CheSema)).
* Add test for the cast logical error in version earlier than 25.5. [#80163](https://github.com/ClickHouse/ClickHouse/pull/80163) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Disable CPU overload checks for all tests. [#80166](https://github.com/ClickHouse/ClickHouse/pull/80166) ([Alexander Gololobov](https://github.com/davenger)).
* Organize Iceberg field name's literals better. [#80170](https://github.com/ClickHouse/ClickHouse/pull/80170) ([Han Fei](https://github.com/hanfei1991)).
* Revert PR 77401 "Use s3 native copy only if source and destination credentials are same". [#80172](https://github.com/ClickHouse/ClickHouse/pull/80172) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix possible dtor of nullptr in GraphiteRollupSortedAlgorithm dtor. [#80178](https://github.com/ClickHouse/ClickHouse/pull/80178) ([Elmi Ahmadov](https://github.com/ahmadov)).
* CI: praktika to support choice type in workflow input. [#80180](https://github.com/ClickHouse/ClickHouse/pull/80180) ([Max Kainov](https://github.com/maxknv)).
* Fix 01318_long_unsuccessful_mutation_zookeeper test flakiness. [#80190](https://github.com/ClickHouse/ClickHouse/pull/80190) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Disable CPU overload check in server settings by default. [#80211](https://github.com/ClickHouse/ClickHouse/pull/80211) ([Alexander Gololobov](https://github.com/davenger)).
* Sync private. [#80212](https://github.com/ClickHouse/ClickHouse/pull/80212) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Do not throw `LOGICAL_ERROR` if entry node was deleted. It can be deleted by concurrent cleanup thread running on another replica. [#80214](https://github.com/ClickHouse/ClickHouse/pull/80214) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Update README.md. [#80217](https://github.com/ClickHouse/ClickHouse/pull/80217) ([Tyler Hannan](https://github.com/tylerhannan)).
* Fix examples linking. [#80223](https://github.com/ClickHouse/ClickHouse/pull/80223) ([Raúl Marín](https://github.com/Algunenano)).
* Pass dictionary name to DictionarySource. [#80225](https://github.com/ClickHouse/ClickHouse/pull/80225) ([Alexander Tokmakov](https://github.com/tavplubix)).
* test_remove_stale_moving_parts ignore non-existent directory during wait, wait longer. [#80227](https://github.com/ClickHouse/ClickHouse/pull/80227) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Backported in [#80539](https://github.com/ClickHouse/ClickHouse/issues/80539): Disable OpenSSL init and cleanup for AWS SDK. [#80231](https://github.com/ClickHouse/ClickHouse/pull/80231) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Update version_date.tsv and changelog after v25.4.4.25-stable. [#80248](https://github.com/ClickHouse/ClickHouse/pull/80248) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Backported in [#80537](https://github.com/ClickHouse/ClickHouse/issues/80537): Explicit OpenSSL cleanup. [#80332](https://github.com/ClickHouse/ClickHouse/pull/80332) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#80524](https://github.com/ClickHouse/ClickHouse/issues/80524): Fixing creating live and window view creation with populating, it is broken after pr 79596. [#80471](https://github.com/ClickHouse/ClickHouse/pull/80471) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#80568](https://github.com/ClickHouse/ClickHouse/issues/80568): Rename some new experimental settings. [#80511](https://github.com/ClickHouse/ClickHouse/pull/80511) ([Alexander Gololobov](https://github.com/davenger)).
* Backported in [#80636](https://github.com/ClickHouse/ClickHouse/issues/80636): Fix data race on vptr signallistener::run. [#80514](https://github.com/ClickHouse/ClickHouse/pull/80514) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#80610](https://github.com/ClickHouse/ClickHouse/issues/80610): For new settings meaning time or delays use Milliseconds type. [#80541](https://github.com/ClickHouse/ClickHouse/pull/80541) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Backported in [#80664](https://github.com/ClickHouse/ClickHouse/issues/80664): better name for geotoh3_lon_lat_input_order. [#80544](https://github.com/ClickHouse/ClickHouse/pull/80544) ([Bharat Nallan](https://github.com/bharatnc)).

