---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.4.7.66-stable (767e6c72db2) FIXME as compared to v25.4.6.67-stable (407b1e14129)

#### Performance Improvement
* Backported in [#81854](https://github.com/ClickHouse/ClickHouse/issues/81854): Avoid unnecessary update and reduce lock contention in QueryConditionCache. [#80247](https://github.com/ClickHouse/ClickHouse/pull/80247) ([Jiebin Sun](https://github.com/jiebinn)).
* Backported in [#81746](https://github.com/ClickHouse/ClickHouse/issues/81746): Fixed performance regression in memory tracking. [#81694](https://github.com/ClickHouse/ClickHouse/pull/81694) ([Michael Kolupaev](https://github.com/al13n321)).

#### Improvement
* Backported in [#81442](https://github.com/ClickHouse/ClickHouse/issues/81442): Add container prefix to data paths reported in system.tables for plain disks in Azure blob storage, making reporting consistent with S3 and GCP. [#79241](https://github.com/ClickHouse/ClickHouse/pull/79241) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#81220](https://github.com/ClickHouse/ClickHouse/issues/81220): Fix a crash: if an exception is thrown in an attempt to remove a temporary file (they are used for spilling temporary data on disk) in the destructor, the program can terminate. [#80776](https://github.com/ClickHouse/ClickHouse/pull/80776) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#81536](https://github.com/ClickHouse/ClickHouse/issues/81536): Upgrade libxml2 to 2.14.3. [#81187](https://github.com/ClickHouse/ClickHouse/pull/81187) ([larryluogit](https://github.com/larryluogit)).
* Backported in [#81409](https://github.com/ClickHouse/ClickHouse/issues/81409): In filesystem with journal `mkdir` is written to the journal of filesystem which is persisted to disk. In case of slow disk this can take long time. Definitely make sense to move out from reserve lock scope. [#81371](https://github.com/ClickHouse/ClickHouse/pull/81371) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#81486](https://github.com/ClickHouse/ClickHouse/issues/81486): Use `krb5` 1.21.3-final. [#81453](https://github.com/ClickHouse/ClickHouse/pull/81453) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#81478](https://github.com/ClickHouse/ClickHouse/issues/81478): Use `orc` 2.1.2. [#81455](https://github.com/ClickHouse/ClickHouse/pull/81455) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#81666](https://github.com/ClickHouse/ClickHouse/issues/81666): Postpone reading of Iceberg manifest files until first reading query. [#81619](https://github.com/ClickHouse/ClickHouse/pull/81619) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#81930](https://github.com/ClickHouse/ClickHouse/issues/81930): Try fix logical error in filesystem cache: "Having zero bytes but range is not finished". [#81868](https://github.com/ClickHouse/ClickHouse/pull/81868) ([Kseniia Sumarokova](https://github.com/kssenii)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#81446](https://github.com/ClickHouse/ClickHouse/issues/81446): Fix CTE usage in pushed-down predicates when `allow_push_predicate_ast_for_distributed_subqueries` is enabled. Fixes [#75647](https://github.com/ClickHouse/ClickHouse/issues/75647). Fixes [#79672](https://github.com/ClickHouse/ClickHouse/issues/79672). [#77316](https://github.com/ClickHouse/ClickHouse/pull/77316) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#79487](https://github.com/ClickHouse/ClickHouse/issues/79487): Fix old firing logical error for `transform`. [#78247](https://github.com/ClickHouse/ClickHouse/pull/78247) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#81243](https://github.com/ClickHouse/ClickHouse/issues/81243): Forbid Dynamic and JSON types in IN. With current implementation of `IN` it can lead to incorrect results. Proper support of this types in `IN` is complicated and can be done in future. [#79282](https://github.com/ClickHouse/ClickHouse/pull/79282) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81426](https://github.com/ClickHouse/ClickHouse/issues/81426): Fix logical errors about a column's unknown origin scope produced while checking if this column is correlated. Fixes [#78183](https://github.com/ClickHouse/ClickHouse/issues/78183). Fixes [#79451](https://github.com/ClickHouse/ClickHouse/issues/79451). [#79727](https://github.com/ClickHouse/ClickHouse/pull/79727) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#81622](https://github.com/ClickHouse/ClickHouse/issues/81622): Disabling hive partitioning for datalakes Partially addresses https://github.com/issues/assigned?issue=ClickHouse%7CClickHouse%7C79937. [#80005](https://github.com/ClickHouse/ClickHouse/pull/80005) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#80838](https://github.com/ClickHouse/ClickHouse/issues/80838): Fix possible logical errors and crashes in projections with subcolumns. [#80333](https://github.com/ClickHouse/ClickHouse/pull/80333) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81289](https://github.com/ClickHouse/ClickHouse/issues/81289): Fix incorrect result during reading column that exists in subset of tables in Merge engine. [#80643](https://github.com/ClickHouse/ClickHouse/pull/80643) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81341](https://github.com/ClickHouse/ClickHouse/issues/81341): Fixed clickhouse-local crashing when outputting const tuples or maps in Parquet format. [#81249](https://github.com/ClickHouse/ClickHouse/pull/81249) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#81366](https://github.com/ClickHouse/ClickHouse/issues/81366): Fix some corner case in query that joins empty tables and uses window functions. The bug leads to exploding number of parallel streams which leads to OOMs. [#81299](https://github.com/ClickHouse/ClickHouse/pull/81299) ([Alexander Gololobov](https://github.com/davenger)).
* Backported in [#81543](https://github.com/ClickHouse/ClickHouse/issues/81543): Fix region error in delta-kernel. Fixes [#79914](https://github.com/ClickHouse/ClickHouse/issues/79914). [#81353](https://github.com/ClickHouse/ClickHouse/pull/81353) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#81503](https://github.com/ClickHouse/ClickHouse/issues/81503): Don't store content of several manifest files in memory. [#81470](https://github.com/ClickHouse/ClickHouse/pull/81470) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#81726](https://github.com/ClickHouse/ClickHouse/issues/81726): Query settings `use_iceberg_partition_pruning` will not take effect for iceberg storage, because it uses global context rather than query context. it's not critical because its default value is true. this pr can fix it. [#81673](https://github.com/ClickHouse/ClickHouse/pull/81673) ([Han Fei](https://github.com/hanfei1991)).
* Backported in [#81846](https://github.com/ClickHouse/ClickHouse/issues/81846): Fix crash in `ConcurrentHashJoin` with empty `USING ()` and old analyzer enabled. [#81754](https://github.com/ClickHouse/ClickHouse/pull/81754) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#81906](https://github.com/ClickHouse/ClickHouse/issues/81906): Keeper fix: block commits of new logs if there is invalid entry in the logs. Previously, if leader applied some logs incorrectly, it would continue to commit new logs, even though the follower would detect digest mismatch and abort. [#81780](https://github.com/ClickHouse/ClickHouse/pull/81780) ([Antonio Andelic](https://github.com/antonio2368)).

#### NO CL CATEGORY

* Backported in [#81606](https://github.com/ClickHouse/ClickHouse/issues/81606):. [#81372](https://github.com/ClickHouse/ClickHouse/pull/81372) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#81460](https://github.com/ClickHouse/ClickHouse/issues/81460): Query condition cache: reduce logging verbosity. [#80093](https://github.com/ClickHouse/ClickHouse/pull/80093) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#81653](https://github.com/ClickHouse/ClickHouse/issues/81653): Slightly better logging in StorageKeeperMap::dropTable. [#80662](https://github.com/ClickHouse/ClickHouse/pull/80662) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#81321](https://github.com/ClickHouse/ClickHouse/issues/81321): Disable collecting job stack traces by default. [#80978](https://github.com/ClickHouse/ClickHouse/pull/80978) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#81830](https://github.com/ClickHouse/ClickHouse/issues/81830): Make NATS connection retries less noisy in the logs. [#81587](https://github.com/ClickHouse/ClickHouse/pull/81587) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81731](https://github.com/ClickHouse/ClickHouse/issues/81731): Fix CVE-2023-0286 / CVE-2023-5678. [#81672](https://github.com/ClickHouse/ClickHouse/pull/81672) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#81773](https://github.com/ClickHouse/ClickHouse/issues/81773): Fix: `appendRemovalTIDToVersionMetadata` for covered_parts in `MergeTreeTransaction::addNewPartAndRemoveCovered `so that there is a removal_id in the transaction metadata file even when it is removed without a transaction. Hence, when restarting, it can load the outdated parts successfully without triggering: ``` Logical error: \'Data part 202410_1_42_8 is Outdated and has creation TID (94, 40, 3ce64a6c-c10e-4c02-8891-47977f2b6a1a) and CSN 95, but does not have removal tid. It\'s a bug or a result of manual intervention.\'. ```. [#81734](https://github.com/ClickHouse/ClickHouse/pull/81734) ([Tuan Pham Anh](https://github.com/tuanpach)).

