---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.4.10.45-stable (e9923e54d62) FIXME as compared to v25.4.9.14-stable (5ca9638860e)

#### Performance Improvement
* Backported in [#83339](https://github.com/ClickHouse/ClickHouse/issues/83339): Try to speedup QueryTreeHash a bit. [#82617](https://github.com/ClickHouse/ClickHouse/pull/82617) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).

#### Improvement
* Backported in [#83013](https://github.com/ClickHouse/ClickHouse/issues/83013): Keeper improvement: move changelog files between disk in a background thread. Previously, moving changelog to a different disk would block Keeper globally until the move is finished. This lead to performance degradation if moving is a long operation (e.g. to S3 disk). [#82485](https://github.com/ClickHouse/ClickHouse/pull/82485) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#83203](https://github.com/ClickHouse/ClickHouse/issues/83203): `SYSTEM RESTART REPLICA` may fail due to ZooKeeper connection issues. To avoid forgetting about this table, we now retry until the table is created. [#82616](https://github.com/ClickHouse/ClickHouse/pull/82616) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#83180](https://github.com/ClickHouse/ClickHouse/issues/83180): Consolidate unknown settings warnings in clickhouse client and log them as a summary. [#83042](https://github.com/ClickHouse/ClickHouse/pull/83042) ([Bharat Nallan](https://github.com/bharatnc)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#83315](https://github.com/ClickHouse/ClickHouse/issues/83315): Fix "Context has expired" for Iceberg. [#82146](https://github.com/ClickHouse/ClickHouse/pull/82146) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#83255](https://github.com/ClickHouse/ClickHouse/issues/83255): Fix disabling boundary alignment for cached buffer in external table engines. It was broken in https://github.com/ClickHouse/ClickHouse/pull/81868. [#82493](https://github.com/ClickHouse/ClickHouse/pull/82493) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#82911](https://github.com/ClickHouse/ClickHouse/issues/82911): In AzureBlobStorage, for native copy we compare authentication methods, during which if we get an exception, updated the code to fallback to read and copy (i.e. non native copy). [#82693](https://github.com/ClickHouse/ClickHouse/pull/82693) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Backported in [#83110](https://github.com/ClickHouse/ClickHouse/issues/83110): Fix exception safety in union/intersect/except_default_mode rewrite. Closes [#82664](https://github.com/ClickHouse/ClickHouse/issues/82664). [#82820](https://github.com/ClickHouse/ClickHouse/pull/82820) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#83328](https://github.com/ClickHouse/ClickHouse/issues/83328): Fix data races in Iceberg. [#82841](https://github.com/ClickHouse/ClickHouse/pull/82841) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#83287](https://github.com/ClickHouse/ClickHouse/issues/83287): Set salt for auth data when parsing from AST with type SCRAM_SHA256_PASSWORD. [#82888](https://github.com/ClickHouse/ClickHouse/pull/82888) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Backported in [#83025](https://github.com/ClickHouse/ClickHouse/issues/83025): Fix filter modification for queries with a JOIN expression with a table with storage `Merge`. Fixes [#82092](https://github.com/ClickHouse/ClickHouse/issues/82092). [#82950](https://github.com/ClickHouse/ClickHouse/pull/82950) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#83309](https://github.com/ClickHouse/ClickHouse/issues/83309): Fix LOGICAL_ERROR in QueryMetricLog: Mutex cannot be NULL. [#82979](https://github.com/ClickHouse/ClickHouse/pull/82979) ([Pablo Marcos](https://github.com/pamarcos)).
* Backported in [#83238](https://github.com/ClickHouse/ClickHouse/issues/83238): Fix performance degradation with the enabled analyzer when secondary queries always read all columns from the VIEWs. Fixes [#81718](https://github.com/ClickHouse/ClickHouse/issues/81718). [#83036](https://github.com/ClickHouse/ClickHouse/pull/83036) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#83428](https://github.com/ClickHouse/ClickHouse/issues/83428): Fix misleading error message when restoring a backup on a read-only disk. [#83051](https://github.com/ClickHouse/ClickHouse/pull/83051) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#83197](https://github.com/ClickHouse/ClickHouse/issues/83197): Do not check for cyclic dependencies on create table with no dependencies. It fixes performance degradation of the use cases with creation of thousands of tables that was introduced in https://github.com/ClickHouse/ClickHouse/pull/65405. [#83077](https://github.com/ClickHouse/ClickHouse/pull/83077) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#83403](https://github.com/ClickHouse/ClickHouse/issues/83403): Fix `no_sign_request` for S3 client. It can be used to explicitly avoid signing S3 requests. It can also be defined for specific endpoints using endpoint-based settings. [#83379](https://github.com/ClickHouse/ClickHouse/pull/83379) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#83465](https://github.com/ClickHouse/ClickHouse/issues/83465): Fix `TOO_DEEP_SUBQUERIES` exception when CTE definition references another table expression with the same name. [#83413](https://github.com/ClickHouse/ClickHouse/pull/83413) ([Dmitry Novik](https://github.com/novikd)).

#### Build/Testing/Packaging Improvement
* Backported in [#83535](https://github.com/ClickHouse/ClickHouse/issues/83535): Use `expat` 2.7.1 inside Poco. [#82661](https://github.com/ClickHouse/ClickHouse/pull/82661) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#83250](https://github.com/ClickHouse/ClickHouse/issues/83250): Cache metadata json string in iceberg metadata. [#81429](https://github.com/ClickHouse/ClickHouse/pull/81429) ([Han Fei](https://github.com/hanfei1991)).
* Backported in [#82756](https://github.com/ClickHouse/ClickHouse/issues/82756): Add a setting to preserve old behaviour of dateTrunc function. [#82530](https://github.com/ClickHouse/ClickHouse/pull/82530) ([Pavel Kruglov](https://github.com/Avogar)).

