---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.4.1.2934-stable (589918f385f) FIXME as compared to v25.4.1.1-new (6849013e378)

#### Backward Incompatible Change
* Check all columns in a materialized view match the target table if `allow_materialized_view_with_bad_select` is `false`. [#74481](https://github.com/ClickHouse/ClickHouse/pull/74481) ([Christoph Wurm](https://github.com/cwurm)).
* Fixes cases where `dateTrunc` is used with negative date/datetime arguments. [#77622](https://github.com/ClickHouse/ClickHouse/pull/77622) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* The legacy MongoDB integration has been removed. Server setting `use_legacy_mongodb_integration` became obsolete and now does nothing. [#77895](https://github.com/ClickHouse/ClickHouse/pull/77895) ([Robert Schulze](https://github.com/rschu1ze)).
* Enhance SummingMergeTree validation to skip aggregation for columns used in partition or sort keys. [#78022](https://github.com/ClickHouse/ClickHouse/pull/78022) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).

#### New Feature
* Backported in [#79232](https://github.com/ClickHouse/ClickHouse/issues/79232): Add a new option to MergeTree SETTINGS which specifies a default compression codec in case the CREATE query does not explicitly define one for the given columns. This closes [#42005](https://github.com/ClickHouse/ClickHouse/issues/42005). [#66394](https://github.com/ClickHouse/ClickHouse/pull/66394) ([gvoelfin](https://github.com/gvoelfin)).
* Serialize query plan for Distributed queries. A new setting `serialize_query_plan` is added. When enabled, queries from `Distributed` table will use a serialized query plan for remote query execution. This introduces a new packet type to TCP protocol, `<process_query_plan_packet>true</process_query_plan_packet>` should be added to the server config to allow processing this packet. [#69652](https://github.com/ClickHouse/ClickHouse/pull/69652) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Add setting to query Iceberg tables as of a specific timestamp. [#71072](https://github.com/ClickHouse/ClickHouse/pull/71072) ([Brett Hoerner](https://github.com/bretthoerner)).
* Support low cardinality decimal data types, fix [#72256](https://github.com/ClickHouse/ClickHouse/issues/72256). [#72833](https://github.com/ClickHouse/ClickHouse/pull/72833) ([zhanglistar](https://github.com/zhanglistar)).
* Support DeltaLake table engine for AzureBlobStorage. Fixes [#68043](https://github.com/ClickHouse/ClickHouse/issues/68043). [#74541](https://github.com/ClickHouse/ClickHouse/pull/74541) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Add bind_host setting to set the source IP address for clickhouse client connections. [#74741](https://github.com/ClickHouse/ClickHouse/pull/74741) ([Todd Yocum](https://github.com/toddyocum)).
* Introduce parametrized_view_parameters in system.tables. Closes https://github.com/clickhouse/clickhouse/issues/66756. [#75112](https://github.com/ClickHouse/ClickHouse/pull/75112) ([NamNguyenHoai](https://github.com/NamHoaiNguyen)).
* Allow altering a database comment. Closes [#73351](https://github.com/ClickHouse/ClickHouse/issues/73351) ### Documentation entry for user-facing changes. [#75622](https://github.com/ClickHouse/ClickHouse/pull/75622) ([NamNguyenHoai](https://github.com/NamHoaiNguyen)).
* Backported in [#79361](https://github.com/ClickHouse/ClickHouse/issues/79361): Support correlated subqueries as an argument of `EXISTS` expression in the WHERE clause. Closes [#72459](https://github.com/ClickHouse/ClickHouse/issues/72459). [#76078](https://github.com/ClickHouse/ClickHouse/pull/76078) ([Dmitry Novik](https://github.com/novikd)).
* Scram SHA256 & update postgres wire auth. [#76839](https://github.com/ClickHouse/ClickHouse/pull/76839) ([scanhex12](https://github.com/scanhex12)).
* Support `IcebergMetadataFilesCache`, which will store manifest files/list and metadata.json in one cache. [#77156](https://github.com/ClickHouse/ClickHouse/pull/77156) ([Han Fei](https://github.com/hanfei1991)).
* Add functions `arrayLevenshteinDistance`, `arrayLevenshteinDistanceWeighted`, and `arraySimilarity`. [#77187](https://github.com/ClickHouse/ClickHouse/pull/77187) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Allows a user to query the state of an Iceberg table as it existed at a previous point in time. [#77439](https://github.com/ClickHouse/ClickHouse/pull/77439) ([Daniil Ivanik](https://github.com/divanik)).
* Added CPU slot scheduling for workloads, see https://clickhouse.com/docs/operations/workload-scheduling#cpu_scheduling for details. [#77595](https://github.com/ClickHouse/ClickHouse/pull/77595) ([Sergei Trifonov](https://github.com/serxa)).
* The hasAll() function can now take advantage of the tokenbf_v1, ngrambf_v1 full-text skipping indices. [#77662](https://github.com/ClickHouse/ClickHouse/pull/77662) ([UnamedRus](https://github.com/UnamedRus)).
* `JSON` data type is production-ready. See https://jsonbench.com/. `Dynamic` and `Varaint` data types are production ready. [#77785](https://github.com/ClickHouse/ClickHouse/pull/77785) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Added an in-memory cache for deserialized vector similarity indexes. This should make repeated approximate nearest neighbor (ANN) search queries faster. The size of the new cache is controlled by server settings `vector_similarity_index_cache_size` and `vector_similarity_index_cache_max_entries`. This feature supersedes the skipping index cache feature of earlier releases. [#77905](https://github.com/ClickHouse/ClickHouse/pull/77905) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Backported in [#79343](https://github.com/ClickHouse/ClickHouse/issues/79343): TBD. [#78041](https://github.com/ClickHouse/ClickHouse/pull/78041) ([Igor Nikonov](https://github.com/devcrafter)).
* Functions sparseGrams and sparseGramsHashes with UTF8 versions added. Author: [scanhex12](https://github.com/scanhex12). [#78176](https://github.com/ClickHouse/ClickHouse/pull/78176) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Introduce `toInterval` function. This function accepts 2 arguments (value and unit), and converts the value to a specific `Interval` type. [#78723](https://github.com/ClickHouse/ClickHouse/pull/78723) ([Andrew Davis](https://github.com/pulpdrew)).

#### Performance Improvement
* Optimize performance with lazy projection to avoid reading unused columns. [#55518](https://github.com/ClickHouse/ClickHouse/pull/55518) ([Xiaozhe Yu](https://github.com/wudidapaopao)).
* Support async io prefetch for `NativeORCBlockInputFormat`, which improves overall performance by hiding remote io latency. Speedup ratio could reach 1.47x in my test case. [#70534](https://github.com/ClickHouse/ClickHouse/pull/70534) ([李扬](https://github.com/taiyang-li)).
* Preallocate memory used by async inserts to improve performance. [#74945](https://github.com/ClickHouse/ClickHouse/pull/74945) ([Ilya Golshtein](https://github.com/ilejn)).
* Trivial opt on wrapInNullable to avoid unnecessary null map allocation. [#76489](https://github.com/ClickHouse/ClickHouse/pull/76489) ([李扬](https://github.com/taiyang-li)).
* Optimize arraySort. [#76850](https://github.com/ClickHouse/ClickHouse/pull/76850) ([李扬](https://github.com/taiyang-li)).
* Speed-up building JOIN result by de-virtualizing calls to `col->insertFrom()`. [#77350](https://github.com/ClickHouse/ClickHouse/pull/77350) ([Alexander Gololobov](https://github.com/davenger)).
* Merge marks of the same part and write them to the query condition cache at one time to reduce the consumption of locks. [#77377](https://github.com/ClickHouse/ClickHouse/pull/77377) ([zhongyuankai](https://github.com/zhongyuankai)).
* Optimize s3Cluster performance for queries with one bracket expansion. [#77686](https://github.com/ClickHouse/ClickHouse/pull/77686) ([Tomáš Hromada](https://github.com/gyfis)).
* Optimize order by single nullable or low-cardinality columns. [#77789](https://github.com/ClickHouse/ClickHouse/pull/77789) ([李扬](https://github.com/taiyang-li)).
* Disable `filesystem_cache_prefer_bigger_buffer_size` when the cache is used passively, such as for merges. [#77898](https://github.com/ClickHouse/ClickHouse/pull/77898) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Implement trivial count optimization for Iceberg. Now queries with `count()` and without any filters should be faster. Closes [#77639](https://github.com/ClickHouse/ClickHouse/issues/77639). [#78090](https://github.com/ClickHouse/ClickHouse/pull/78090) ([alesapin](https://github.com/alesapin)).
* Support Iceberg data pruning based on lower_bound and uppert_bound values for columns. Fixes [#77638](https://github.com/ClickHouse/ClickHouse/issues/77638). [#78242](https://github.com/ClickHouse/ClickHouse/pull/78242) ([alesapin](https://github.com/alesapin)).
* Optimize memory usage for NativeReader. [#78442](https://github.com/ClickHouse/ClickHouse/pull/78442) ([Azat Khuzhin](https://github.com/azat)).
* Trivial optimization: do not rewrite count(if()) to countIf if CAST is required. Close [#78564](https://github.com/ClickHouse/ClickHouse/issues/78564). [#78565](https://github.com/ClickHouse/ClickHouse/pull/78565) ([李扬](https://github.com/taiyang-li)).
* Backported in [#79163](https://github.com/ClickHouse/ClickHouse/issues/79163): Now we use number of replicas to determine task size for reading with parallel replicas enabled. This provides better work distribution between replicas when the amount of data to read is not really big. [#78695](https://github.com/ClickHouse/ClickHouse/pull/78695) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#79190](https://github.com/ClickHouse/ClickHouse/issues/79190): Merge equality conditions from filter query plan step into JOIN condition if possible to allow using them as hash table keys. [#78877](https://github.com/ClickHouse/ClickHouse/pull/78877) ([Dmitry Novik](https://github.com/novikd)).

#### Improvement
* Decrease the amount of Keeper requests by eliminating the use of single `get` requests, which could have caused a significant load on Keeper with the increased number of replicas, in places where `multiRead` is available. [#56862](https://github.com/ClickHouse/ClickHouse/pull/56862) ([Nikolay Degterinsky](https://github.com/evillique)).
* Reject queries when the server is overloaded. The decision is made based on the ratio of wait time (`OSCPUWaitMicroseconds`) to busy time (`OSCPUVirtualTimeMicroseconds`). The query is dropped with some probability, when this ratio is between `min_os_cpu_wait_time_ratio_to_throw` and `max_os_cpu_wait_time_ratio_to_throw` (those are query level settings). [#63206](https://github.com/ClickHouse/ClickHouse/pull/63206) ([Alexey Katsman](https://github.com/alexkats)).
* Refreshes of refreshable materialized views now appear in `system.query_log`. [#71333](https://github.com/ClickHouse/ClickHouse/pull/71333) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#79175](https://github.com/ClickHouse/ClickHouse/issues/79175): `clickhouse-local` will retain its databases after restart if you specify the `--path` command line argument. This closes [#50647](https://github.com/ClickHouse/ClickHouse/issues/50647). This closes [#49947](https://github.com/ClickHouse/ClickHouse/issues/49947). [#71722](https://github.com/ClickHouse/ClickHouse/pull/71722) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Enabled a backoff logic for all types of replicated tasks. It will provide the ability to reduce CPU usage, memory usage, and log file sizes. Added new settings `max_postpone_time_for_failed_replicated_fetches_ms`, `max_postpone_time_for_failed_replicated_merges_ms` and `max_postpone_time_for_failed_replicated_tasks_ms` which are similar to `max_postpone_time_for_failed_mutations_ms`. [#74576](https://github.com/ClickHouse/ClickHouse/pull/74576) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Use dynamic sharding for JOIN if the JOIN key is a prefix of PK for both parts. This optimization is enabled with `query_plan_join_shard_by_pk_ranges` setting (disabled by default). [#74733](https://github.com/ClickHouse/ClickHouse/pull/74733) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Enabled SSH protocol back. Fixed some critical vulnerabilities so that it is no longer possible to use custom pager or specify `server-logs-file`. Disabled the ability to pass client options through the environment variables by default (it is still possible via `ssh-server.enable_client_options_passing` in config.xml). Supported progress table, query cancellation, completion, profile events progress, stdin and `send_logs_level` option. This closes: [#74340](https://github.com/ClickHouse/ClickHouse/issues/74340). [#74989](https://github.com/ClickHouse/ClickHouse/pull/74989) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Support for a refresh in readonly MergeTree tables. [#76467](https://github.com/ClickHouse/ClickHouse/pull/76467) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add query_id to system.errors. Related ticket [#75815](https://github.com/ClickHouse/ClickHouse/issues/75815). [#76581](https://github.com/ClickHouse/ClickHouse/pull/76581) ([Vladimir Baikov](https://github.com/bkvvldmr)).
* Support JSON type and subcolumns reading from View. [#76903](https://github.com/ClickHouse/ClickHouse/pull/76903) ([Pavel Kruglov](https://github.com/Avogar)).
* Adding Support for Converting UInt128 to IPv6. This allows the `bitAnd` operation and arithmatics for IPv6 and conversion back to IPv6. Closes [#76752](https://github.com/ClickHouse/ClickHouse/issues/76752). This allows the result from `bitAnd` operation on IPv6 to be converted back to IPv6, as well. See: https://github.com/ClickHouse/ClickHouse/pull/57707. [#76928](https://github.com/ClickHouse/ClickHouse/pull/76928) ([Muzammil Abdul Rehman](https://github.com/muzammilar)).
* Don't parse special Bool values in text formats inside Variant type by default. It can be enabled using setting `allow_special_bool_values_inside_variant`. [#76974](https://github.com/ClickHouse/ClickHouse/pull/76974) ([Pavel Kruglov](https://github.com/Avogar)).
* Support configurable per task waiting time of low priority query in session level and in server level. [#77013](https://github.com/ClickHouse/ClickHouse/pull/77013) ([VicoWu](https://github.com/VicoWu)).
* Use FixedString for PostgreSQL's CHARACTER, CHAR and BPCHAR. [#77304](https://github.com/ClickHouse/ClickHouse/pull/77304) ([Pablo Marcos](https://github.com/pamarcos)).
* Support using a remote disk for databases to store metadata files. [#77365](https://github.com/ClickHouse/ClickHouse/pull/77365) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Implement comparison for values of JSON data type. Now JSON objects can be compared similarly to Maps. [#77397](https://github.com/ClickHouse/ClickHouse/pull/77397) ([Pavel Kruglov](https://github.com/Avogar)).
* Support ALTER TABLE ... ATTACH|DETACH|MOVE|REPLACE PARTITION for the plain_rewritable disk. [#77406](https://github.com/ClickHouse/ClickHouse/pull/77406) ([Julia Kartseva](https://github.com/jkartseva)).
* Support query parameters inside `additional_table_filters` setting. After the change, the following query would succeed:. [#77680](https://github.com/ClickHouse/ClickHouse/pull/77680) ([wxybear](https://github.com/wxybear)).
* Better permission support by system.kafka_consumers Internal librdkafka errors are presented as exceptions. [#77700](https://github.com/ClickHouse/ClickHouse/pull/77700) ([Ilya Golshtein](https://github.com/ilejn)).
* User-defined functions (UDFs) can now be marked as deterministic via a new tag in their XML definition. Also, the query cache now checks if UDFs called within a query are deterministic. If this is the case, it caches the query result. (Issue [#59988](https://github.com/ClickHouse/ClickHouse/issues/59988)). [#77769](https://github.com/ClickHouse/ClickHouse/pull/77769) ([Jimmy Aguilar Mena](https://github.com/Ergus)).
* Added Buffer table engine parameters validation. [#77840](https://github.com/ClickHouse/ClickHouse/pull/77840) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Add config `enable_hdfs_pread` to enable or disable hdfs pread. [#77885](https://github.com/ClickHouse/ClickHouse/pull/77885) ([kevinyhzou](https://github.com/KevinyhZou)).
* Add profile events for number of zookeeper 'multi' read and write requests. [#77888](https://github.com/ClickHouse/ClickHouse/pull/77888) ([JackyWoo](https://github.com/JackyWoo)).
* Allow creating and inserting into temp table when disable_insertion_and_mutation is on. [#77901](https://github.com/ClickHouse/ClickHouse/pull/77901) ([Xu Jia](https://github.com/XuJia0210)).
* Decrease max_insert_delayed_streams_for_parallel_write (to 100). [#77919](https://github.com/ClickHouse/ClickHouse/pull/77919) ([Azat Khuzhin](https://github.com/azat)).
* Add ability to configure number of columns that merges can flush in parallel using `max_merge_delayed_streams_for_parallel_write` (this should reduce memory usage for vertical merges to S3 about 25x times). [#77922](https://github.com/ClickHouse/ClickHouse/pull/77922) ([Azat Khuzhin](https://github.com/azat)).
* Fix year parsing in joda syntax like 'yyy'. [#77973](https://github.com/ClickHouse/ClickHouse/pull/77973) ([李扬](https://github.com/taiyang-li)).
* Attaching parts of MergeTree tables will be performed in their block order, which is important for special merging algorithms, such as ReplacingMergeTree. This closes [#71009](https://github.com/ClickHouse/ClickHouse/issues/71009). [#77976](https://github.com/ClickHouse/ClickHouse/pull/77976) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Query masking rules are now able to throw a LOGICAL_ERROR in case if the match happened. This will help to check if pre-defined password is leaking anywhere in logs. [#78094](https://github.com/ClickHouse/ClickHouse/pull/78094) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Added column `index_length_column` to `information_schema.tables` for better compatibility with MySQL. [#78119](https://github.com/ClickHouse/ClickHouse/pull/78119) ([Paweł Zakrzewski](https://github.com/KrzaQ)).
* Introduce two new metrics: `TotalMergeFailures` and `NonAbortedMergeFailures`. These metrics are needed to detect the cases where too many merges fail within a short period. [#78150](https://github.com/ClickHouse/ClickHouse/pull/78150) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Fix incorrect S3 uri parsing when key is not specified on path style. [#78185](https://github.com/ClickHouse/ClickHouse/pull/78185) ([Arthur Passos](https://github.com/arthurpassos)).
* Fix incorrect values of `BlockActiveTime`, `BlockDiscardTime`, `BlockWriteTime`, `BlockQueueTime`, and `BlockReadTime` asynchronous metrics (before the change 1 second was incorrectly reported as 0.001). [#78211](https://github.com/ClickHouse/ClickHouse/pull/78211) ([filimonov](https://github.com/filimonov)).
* Respect `loading_retries` limit for errors during push to materialized view for StorageS3(Azure)Queue. Before that such errors were retried indefinitely. [#78313](https://github.com/ClickHouse/ClickHouse/pull/78313) ([Kseniia Sumarokova](https://github.com/kssenii)).
* In StorageDeltaLake with delta-kernel-rs implementation, fix performance and progress bar. [#78368](https://github.com/ClickHouse/ClickHouse/pull/78368) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Vector similarity index could over-allocate main memory by up to 2x. This fix reworks the memory allocation strategy, reducing the memory consumption and improving the effectiveness of the vector similarity index cache. (issue [#78056](https://github.com/ClickHouse/ClickHouse/issues/78056)). [#78394](https://github.com/ClickHouse/ClickHouse/pull/78394) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Introduce a setting `schema_type` for `system.metric_log` table with schema type. There are three allowed schemas: `wide` -- current schema, each metric/event in a separate column (most effective for reads of separate columns), `transposed` -- similar to `system.asynchronous_metric_log`, metrics/events are stored as rows, and the most interesting `transposed_with_wide_view` -- create underlying table with `transposed` schema, but also introduce a view with `wide` schema which translates queries to underlying table. In `transposed_with_wide_view` subsecond resolution for view is not supported, `event_time_microseconds` is just an alias for backward compatibility. [#78412](https://github.com/ClickHouse/ClickHouse/pull/78412) ([alesapin](https://github.com/alesapin)).
* Support `include`, `from_env`, `from_zk` for runtime disks. Closes [#78177](https://github.com/ClickHouse/ClickHouse/issues/78177). [#78470](https://github.com/ClickHouse/ClickHouse/pull/78470) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add several convenient ways to resolve root metadata.json file in an iceberg table function and engine. Closes [#78455](https://github.com/ClickHouse/ClickHouse/issues/78455). [#78475](https://github.com/ClickHouse/ClickHouse/pull/78475) ([Daniil Ivanik](https://github.com/divanik)).
* Support partition pruning in delta lake. [#78486](https://github.com/ClickHouse/ClickHouse/pull/78486) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Support password based auth in SSH protocol in ClickHouse. [#78586](https://github.com/ClickHouse/ClickHouse/pull/78586) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Add a dynamic warning to the `system.warnings` table for long running mutations. [#78658](https://github.com/ClickHouse/ClickHouse/pull/78658) ([Bharat Nallan](https://github.com/bharatnc)).
* Backported in [#79298](https://github.com/ClickHouse/ClickHouse/issues/79298): Added field `condition` to system table `system.query_condition_cache`. It stores the plaintext condition whose hash is used as a key in the query condition cache. [#78671](https://github.com/ClickHouse/ClickHouse/pull/78671) ([Robert Schulze](https://github.com/rschu1ze)).
* Drop connections if the CPU is massively overloaded. The decision is made based on the ratio of wait time (`OSCPUWaitMicroseconds`) to busy time (`OSCPUVirtualTimeMicroseconds`). The query is dropped with some probability, when this ratio is between `min_os_cpu_wait_time_ratio_to_drop_connection` and `max_os_cpu_wait_time_ratio_to_drop_connection`. [#78778](https://github.com/ClickHouse/ClickHouse/pull/78778) ([Alexey Katsman](https://github.com/alexkats)).
* Backported in [#79156](https://github.com/ClickHouse/ClickHouse/issues/79156): Add table settings for SASL configuration and credentials to the `Kafka` table engine. This allows configuring SASL-based authentication to Kafka and Kafka-compatible systems directly in the CREATE TABLE statement rather than having to use configuration files or named collections. [#78810](https://github.com/ClickHouse/ClickHouse/pull/78810) ([Christoph Wurm](https://github.com/cwurm)).
* Allow empty value on hive partitioning. [#78816](https://github.com/ClickHouse/ClickHouse/pull/78816) ([Arthur Passos](https://github.com/arthurpassos)).
* Fix `IN` clause type coercion for `BFloat16` (i.e. `SELECT toBFloat16(1) IN [1, 2, 3];` now returns `1`). Closes [#78754](https://github.com/ClickHouse/ClickHouse/issues/78754). [#78839](https://github.com/ClickHouse/ClickHouse/pull/78839) ([Raufs Dunamalijevs](https://github.com/rienath)).
* Do not check parts on other disks for MergeTree if disk= is set. [#78855](https://github.com/ClickHouse/ClickHouse/pull/78855) ([Azat Khuzhin](https://github.com/azat)).
* Make data types in `used_data_type_families` in `system.query_log` canonical. [#78972](https://github.com/ClickHouse/ClickHouse/pull/78972) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#79063](https://github.com/ClickHouse/ClickHouse/issues/79063): Support for a refresh in readonly MergeTree tables. [#79033](https://github.com/ClickHouse/ClickHouse/pull/79033) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#79239](https://github.com/ClickHouse/ClickHouse/issues/79239): Enabled the query condition cache by default. [#79080](https://github.com/ClickHouse/ClickHouse/pull/79080) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#79139](https://github.com/ClickHouse/ClickHouse/issues/79139): Remove settings during `recoverLostReplica` same as it was done in: https://github.com/ClickHouse/ClickHouse/pull/78637. [#79113](https://github.com/ClickHouse/ClickHouse/pull/79113) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Backported in [#79260](https://github.com/ClickHouse/ClickHouse/issues/79260): Support altering database on cluster. [#79242](https://github.com/ClickHouse/ClickHouse/pull/79242) ([Tuan Pham Anh](https://github.com/tuanpach)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Fix incorrect projection analysis when `count(nullable)` is used in aggregate projections. This fixes [#74495](https://github.com/ClickHouse/ClickHouse/issues/74495) . This PR also adds some logs around projection analysis to clarify why a projection is used or why not. [#74498](https://github.com/ClickHouse/ClickHouse/pull/74498) ([Amos Bird](https://github.com/amosbird)).
* Fix "Part <...> does not contain in snapshot of previous virtual parts. (PART_IS_TEMPORARILY_LOCKED)" during DETACH PART. [#76039](https://github.com/ClickHouse/ClickHouse/pull/76039) ([Aleksei Filatov](https://github.com/aalexfvk)).
* Fix not working skip indexes with expression with literals in analyzer and remove trivial casts during indexes analysis. [#77229](https://github.com/ClickHouse/ClickHouse/pull/77229) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix a bug when `close_session` query parameter didn't have any effect leading to named sessions being closed only after `session_timeout`. [#77336](https://github.com/ClickHouse/ClickHouse/pull/77336) ([Alexey Katsman](https://github.com/alexkats)).
* Fixed receiving messages from nats server without attached mv. [#77392](https://github.com/ClickHouse/ClickHouse/pull/77392) ([Dmitry Novikov](https://github.com/dmitry-sles-novikov)).
* Fix logical error while reading from empty `FileLog` via `merge` table function, close [#75575](https://github.com/ClickHouse/ClickHouse/issues/75575). [#77441](https://github.com/ClickHouse/ClickHouse/pull/77441) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Use default format settings in Dynamic serialization from shared variant. [#77572](https://github.com/ClickHouse/ClickHouse/pull/77572) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix checking if the table data path exists on the local disk. [#77608](https://github.com/ClickHouse/ClickHouse/pull/77608) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fix sending constant values to remote for some types. [#77634](https://github.com/ClickHouse/ClickHouse/pull/77634) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix crash because of expired context in StorageS3(Azure)Queue. [#77720](https://github.com/ClickHouse/ClickHouse/pull/77720) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Hide credentials in RabbitMQ, Nats, Redis, AzureQueue table engines. [#77755](https://github.com/ClickHouse/ClickHouse/pull/77755) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix undefined behaviour on NaN comparison in ArgMin/ArgMax. [#77756](https://github.com/ClickHouse/ClickHouse/pull/77756) ([Raúl Marín](https://github.com/Algunenano)).
* Regularly check if merges and mutations were cancelled even in case when the operation doesn't produce any blocks to write. [#77766](https://github.com/ClickHouse/ClickHouse/pull/77766) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Backported in [#79280](https://github.com/ClickHouse/ClickHouse/issues/79280): Fixed refreshable materialized view in Replicated database not working on newly added replicas. [#77774](https://github.com/ClickHouse/ClickHouse/pull/77774) ([Michael Kolupaev](https://github.com/al13n321)).
* Reverted. [#77843](https://github.com/ClickHouse/ClickHouse/pull/77843) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fix possible crash when `NOT_FOUND_COLUMN_IN_BLOCK` error occurs. [#77854](https://github.com/ClickHouse/ClickHouse/pull/77854) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fix crash that happens in the `StorageSystemObjectStorageQueueSettings` while filling data. [#77878](https://github.com/ClickHouse/ClickHouse/pull/77878) ([Bharat Nallan](https://github.com/bharatnc)).
* Disable fuzzy search for history in SSH server (since it requires skim). [#78002](https://github.com/ClickHouse/ClickHouse/pull/78002) ([Azat Khuzhin](https://github.com/azat)).
* Fixes a bug that a vector search query on a non-indexed column was returning incorrect results if there was another vector column in the table with a defined vector similarity index. (Issue [#77978](https://github.com/ClickHouse/ClickHouse/issues/77978)). [#78069](https://github.com/ClickHouse/ClickHouse/pull/78069) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Fix "The requested output format {} is binary... Do you want to output it anyway? [y/N]" prompt. [#78095](https://github.com/ClickHouse/ClickHouse/pull/78095) ([Azat Khuzhin](https://github.com/azat)).
* Fix of a bug in case of `toStartOfInterval` with zero origin argument. [#78096](https://github.com/ClickHouse/ClickHouse/pull/78096) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Disallow specifying an empty `session_id` query parameter for HTTP interface. [#78098](https://github.com/ClickHouse/ClickHouse/pull/78098) ([Alexey Katsman](https://github.com/alexkats)).
* Fix metadata override in Database Replicated which could have happened due to a RENAME query executed right after an ALTER query. [#78107](https://github.com/ClickHouse/ClickHouse/pull/78107) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix crash in NATS engine. [#78108](https://github.com/ClickHouse/ClickHouse/pull/78108) ([Dmitry Novikov](https://github.com/dmitry-sles-novikov)).
* Do not try to create history_file in embedded client for SSH. [#78112](https://github.com/ClickHouse/ClickHouse/pull/78112) ([Azat Khuzhin](https://github.com/azat)).
* Fix system.detached_tables displaying incorrect information after RENAME DATABASE or DROP TABLE queries. [#78126](https://github.com/ClickHouse/ClickHouse/pull/78126) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix for checks for too many tables with Database Replicated after https://github.com/ClickHouse/ClickHouse/pull/77274. Also, perform the check before creating the storage to avoid creating unaccounted nodes in ZooKeeper in the case of RMT or KeeperMap. [#78127](https://github.com/ClickHouse/ClickHouse/pull/78127) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix possible crash due to concurrent S3Queue metadata initialization. [#78131](https://github.com/ClickHouse/ClickHouse/pull/78131) ([Azat Khuzhin](https://github.com/azat)).
* `groupArray*` functions now produce BAD_ARGUMENTS error for Int-typed 0 value of max_size argument, like it's already done for UInt one, instead of trying to execute with it. [#78140](https://github.com/ClickHouse/ClickHouse/pull/78140) ([Eduard Karacharov](https://github.com/korowa)).
* Prevent crash on recoverLostReplica if the local table is removed before it's detached. [#78173](https://github.com/ClickHouse/ClickHouse/pull/78173) ([Raúl Marín](https://github.com/Algunenano)).
* Fix "alterable" column in system.s3_queue_settings returning always `false`. [#78187](https://github.com/ClickHouse/ClickHouse/pull/78187) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Mask azure access signature to be not visible to user or in logs. [#78189](https://github.com/ClickHouse/ClickHouse/pull/78189) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix prefetch of substreams with prefixes in Wide parts. [#78205](https://github.com/ClickHouse/ClickHouse/pull/78205) ([Pavel Kruglov](https://github.com/Avogar)).
* Fixed crashes / incorrect result for `mapFromArrays` in case of LowCardinality(Nullable) type of keys array. [#78240](https://github.com/ClickHouse/ClickHouse/pull/78240) ([Eduard Karacharov](https://github.com/korowa)).
* Fix delta-kernel auth options. [#78255](https://github.com/ClickHouse/ClickHouse/pull/78255) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Not schedule RefreshMV task if a replica's `disable_insertion_and_mutation` is true. A task is some insertion, it will failed if `disable_insertion_and_mutation` is true. [#78277](https://github.com/ClickHouse/ClickHouse/pull/78277) ([Xu Jia](https://github.com/XuJia0210)).
* Validate access to underlying tables for the Merge engine. [#78339](https://github.com/ClickHouse/ClickHouse/pull/78339) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* FINAL modifier can be lost for `Distributed` engine table. [#78428](https://github.com/ClickHouse/ClickHouse/pull/78428) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Bitmapmin return uint32_max when the bitmap is empty(uint64_max when input type >= 8bits), which matches the behavior of empty roaring_bitmap's minimum(). [#78444](https://github.com/ClickHouse/ClickHouse/pull/78444) ([wxybear](https://github.com/wxybear)).
* Revert "Apply preserve_most attribute at some places in code" since it may lead to crashes. [#78449](https://github.com/ClickHouse/ClickHouse/pull/78449) ([Azat Khuzhin](https://github.com/azat)).
* Use insertion columns for INFILE schema inference. [#78490](https://github.com/ClickHouse/ClickHouse/pull/78490) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Disable parallelize query processing right after reading FROM when `distributed_aggregation_memory_efficient` enabled, it may lead to logical error. Closes [#76934](https://github.com/ClickHouse/ClickHouse/issues/76934). [#78500](https://github.com/ClickHouse/ClickHouse/pull/78500) ([flynn](https://github.com/ucasfl)).
* Set at least one stream for reading in case there are zero planned streams after applying `max_streams_to_max_threads_ratio` setting. [#78505](https://github.com/ClickHouse/ClickHouse/pull/78505) ([Eduard Karacharov](https://github.com/korowa)).
* In storage S3Queue fix logical error "Cannot unregister: table uuid is not registered". Closes [#78285](https://github.com/ClickHouse/ClickHouse/issues/78285). [#78541](https://github.com/ClickHouse/ClickHouse/pull/78541) ([Kseniia Sumarokova](https://github.com/kssenii)).
* ClickHouse is now able to figure out its cgroup v2 on systems with both cgroups v1 and v2 enabled. [#78566](https://github.com/ClickHouse/ClickHouse/pull/78566) ([Grigory Korolev](https://github.com/gkorolev)).
* ObjectStorage cluster table functions failed when used with table level-settings. [#78587](https://github.com/ClickHouse/ClickHouse/pull/78587) ([Daniil Ivanik](https://github.com/divanik)).
* Better checks for transactions is not supported by ReplicatedMergeTree on INSERTs. [#78633](https://github.com/ClickHouse/ClickHouse/pull/78633) ([Azat Khuzhin](https://github.com/azat)).
* Apply query settings during attach. [#78637](https://github.com/ClickHouse/ClickHouse/pull/78637) ([Raúl Marín](https://github.com/Algunenano)).
* Fix crash when invalid path was specified in `iceberg_metadata_file_path`. [#78688](https://github.com/ClickHouse/ClickHouse/pull/78688) ([alesapin](https://github.com/alesapin)).
* In DeltaLake table engine with delta-kernel implementation fix case when read schema is different from table schema and there are partition columns at the same time leading to not found column error. [#78690](https://github.com/ClickHouse/ClickHouse/pull/78690) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix a problem when after scheduling to close a named session (but before timeout expiration), creation of a new named session with the same name led to it being closed at a time point when the first session was scheduled to close. [#78698](https://github.com/ClickHouse/ClickHouse/pull/78698) ([Alexey Katsman](https://github.com/alexkats)).
* Backported in [#79077](https://github.com/ClickHouse/ClickHouse/issues/79077): Fixed several types of `SELECT` queries that read from tables with `MongoDB` engine or `mongodb` table function: queries with implicit conversion of const value in `WHERE` clause (e.g. `WHERE datetime = '2025-03-10 00:00:00'`) ; queries with `LIMIT` and `GROUP BY`. Previously, they could return the wrong result. [#78777](https://github.com/ClickHouse/ClickHouse/pull/78777) ([Anton Popov](https://github.com/CurtizJ)).
* Don't block table shutdown while running CHECK TABLE. [#78782](https://github.com/ClickHouse/ClickHouse/pull/78782) ([Raúl Marín](https://github.com/Algunenano)).
* Keeper fix: fix ephemeral count in all cases. [#78799](https://github.com/ClickHouse/ClickHouse/pull/78799) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix bad cast in `StorageDistributed` when using table functions other than `view()`. Closes [#78464](https://github.com/ClickHouse/ClickHouse/issues/78464). [#78828](https://github.com/ClickHouse/ClickHouse/pull/78828) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix formatting for `tupleElement(*, 1)`. Closes [#78639](https://github.com/ClickHouse/ClickHouse/issues/78639). [#78832](https://github.com/ClickHouse/ClickHouse/pull/78832) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Dictionaries of type `ssd_cache` now reject zero or negative `block_size` and `write_buffer_size` parameters (issue [#78314](https://github.com/ClickHouse/ClickHouse/issues/78314)). [#78854](https://github.com/ClickHouse/ClickHouse/pull/78854) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Fix crash in REFRESHABLE MV in case of ALTER after incorrect shutdown. [#78858](https://github.com/ClickHouse/ClickHouse/pull/78858) ([Azat Khuzhin](https://github.com/azat)).
* Fix parsing of bad DateTime values in CSV format. [#78919](https://github.com/ClickHouse/ClickHouse/pull/78919) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#79274](https://github.com/ClickHouse/ClickHouse/issues/79274): Keeper fix: Avoid triggering watches on failed multi requests. [#79247](https://github.com/ClickHouse/ClickHouse/pull/79247) ([Antonio Andelic](https://github.com/antonio2368)).

#### Build/Testing/Packaging Improvement
* Respect CPU target features in rust and enable LTO in all crates. [#78590](https://github.com/ClickHouse/ClickHouse/pull/78590) ([Raúl Marín](https://github.com/Algunenano)).
* Bump `minizip-ng` to `4.0.9`. [#78917](https://github.com/ClickHouse/ClickHouse/pull/78917) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### BugFix

* Fix reading iceberg table failed when min-max value is NULL. Closes [#78740](https://github.com/ClickHouse/ClickHouse/issues/78740). ### Documentation entry for user-facing changes. [#78764](https://github.com/ClickHouse/ClickHouse/pull/78764) ([flynn](https://github.com/ucasfl)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Revert "Non-constant `CASE` support""'. [#77759](https://github.com/ClickHouse/ClickHouse/pull/77759) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* NO CL ENTRY:  'Revert "feat: additional_table_filter support query parameters"'. [#77881](https://github.com/ClickHouse/ClickHouse/pull/77881) ([Bharat Nallan](https://github.com/bharatnc)).
* NO CL ENTRY:  'Revert "Support low cardinality decimal data types"'. [#78079](https://github.com/ClickHouse/ClickHouse/pull/78079) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "Revert "Fix THERE_IS_NO_COLUMN for parallel replicas with constant table ALIAS""'. [#78097](https://github.com/ClickHouse/ClickHouse/pull/78097) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* NO CL ENTRY:  'Revert "Select and load the correct vector index based on search column"'. [#78101](https://github.com/ClickHouse/ClickHouse/pull/78101) ([Igor Nikonov](https://github.com/devcrafter)).
* NO CL ENTRY:  'Revert "Implement comparison for values of JSON data type"'. [#78580](https://github.com/ClickHouse/ClickHouse/pull/78580) ([Pedro Ferreira](https://github.com/PedroTadim)).
* NO CL ENTRY:  'Revert "Support for refresh in readonly MergeTree tables"'. [#79018](https://github.com/ClickHouse/ClickHouse/pull/79018) ([Alexander Tokmakov](https://github.com/tavplubix)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Weekly update of docker-library repos for images and docs. [#74605](https://github.com/ClickHouse/ClickHouse/pull/74605) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add Database Prefix in Kafka Table Logs for Improved Accuracy. [#76720](https://github.com/ClickHouse/ClickHouse/pull/76720) ([VicoWu](https://github.com/VicoWu)).
* Fix race in DatabaseReplicated between stopReplication and startupDatabaseAsync. [#76847](https://github.com/ClickHouse/ClickHouse/pull/76847) ([Michael Kolupaev](https://github.com/al13n321)).
* tests: fix 03270_object_to_json_alter_wide_merge_tree flakiness for object storages. [#77033](https://github.com/ClickHouse/ClickHouse/pull/77033) ([Sema Checherinda](https://github.com/CheSema)).
* Set remote_filesystem_read_method to threadpool. [#77368](https://github.com/ClickHouse/ClickHouse/pull/77368) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Minor CR follow-up from [#76661](https://github.com/ClickHouse/ClickHouse/issues/76661). [#77444](https://github.com/ClickHouse/ClickHouse/pull/77444) ([Tariq Almawash](https://github.com/talmawash)).
* Follow up to [#77423](https://github.com/ClickHouse/ClickHouse/issues/77423). [#77446](https://github.com/ClickHouse/ClickHouse/pull/77446) ([Dmitry Novik](https://github.com/novikd)).
* s3queue: allow to alter buckets setting in case it is <=1. [#77448](https://github.com/ClickHouse/ClickHouse/pull/77448) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Separate test of compact and wide parts, so can detect errors in fast test, instead of populating to other tests. [#77525](https://github.com/ClickHouse/ClickHouse/pull/77525) ([Shichao Jin](https://github.com/jsc0218)).
* 2nd version of converting join to in subquery if output column is tied to the left table, need an extra step at first, so disabled by default until the step is added later. [#77607](https://github.com/ClickHouse/ClickHouse/pull/77607) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fix msan reported issue about destruction order in cppkafka. [#77624](https://github.com/ClickHouse/ClickHouse/pull/77624) ([filimonov](https://github.com/filimonov)).
* CI: Quick Sync. [#77632](https://github.com/ClickHouse/ClickHouse/pull/77632) ([Max Kainov](https://github.com/maxknv)).
* Try fix s3queue tests. [#77646](https://github.com/ClickHouse/ClickHouse/pull/77646) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Do not retry S3 requests in case of host not found. [#77678](https://github.com/ClickHouse/ClickHouse/pull/77678) ([Azat Khuzhin](https://github.com/azat)).
* Fix Rust offline build. [#77695](https://github.com/ClickHouse/ClickHouse/pull/77695) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* CI: Fast test refactored. [#77696](https://github.com/ClickHouse/ClickHouse/pull/77696) ([Max Kainov](https://github.com/maxknv)).
* CI: Sqlancer job refactored. [#77714](https://github.com/ClickHouse/ClickHouse/pull/77714) ([Max Kainov](https://github.com/maxknv)).
* Update 00111_shard_external_sort_distributed. [#77727](https://github.com/ClickHouse/ClickHouse/pull/77727) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Remove some cmake leftovers and unnest some includes. [#77739](https://github.com/ClickHouse/ClickHouse/pull/77739) ([Raúl Marín](https://github.com/Algunenano)).
* Fix another instance of "Can't set alias of columns". [#77748](https://github.com/ClickHouse/ClickHouse/pull/77748) ([Raúl Marín](https://github.com/Algunenano)).
* Fix typos. [#77790](https://github.com/ClickHouse/ClickHouse/pull/77790) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update version after release. [#77793](https://github.com/ClickHouse/ClickHouse/pull/77793) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Remove obsolete cache for Hive. [#77795](https://github.com/ClickHouse/ClickHouse/pull/77795) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add new setting blocks. [#77796](https://github.com/ClickHouse/ClickHouse/pull/77796) ([Raúl Marín](https://github.com/Algunenano)).
* CI: Fix backport script to not assign robots. [#77799](https://github.com/ClickHouse/ClickHouse/pull/77799) ([Max Kainov](https://github.com/maxknv)).
* Fix AST fuzzer. [#77800](https://github.com/ClickHouse/ClickHouse/pull/77800) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Changelog for 25.3. [#77802](https://github.com/ClickHouse/ClickHouse/pull/77802) ([Raúl Marín](https://github.com/Algunenano)).
* Update 02995_new_settings_history baseline. [#77806](https://github.com/ClickHouse/ClickHouse/pull/77806) ([Raúl Marín](https://github.com/Algunenano)).
* Mark query condition cache as refreshable. [#77809](https://github.com/ClickHouse/ClickHouse/pull/77809) ([Robert Schulze](https://github.com/rschu1ze)).
* Reverting changes made in https://github.com/ClickHouse/ClickHouse/pull/75226 on behalf of https://github.com/ClickHouse/ClickHouse/pull/77546. [#77810](https://github.com/ClickHouse/ClickHouse/pull/77810) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* We removed stateful tests, and these files remain as tech debt. [#77811](https://github.com/ClickHouse/ClickHouse/pull/77811) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make `nats_max_reconnect` obsolete. [#77829](https://github.com/ClickHouse/ClickHouse/pull/77829) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Less frequent logs from CgroupsReader. [#77831](https://github.com/ClickHouse/ClickHouse/pull/77831) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Some tweaks for 25.3 settings. [#77839](https://github.com/ClickHouse/ClickHouse/pull/77839) ([Raúl Marín](https://github.com/Algunenano)).
* tests: add listen_try to make it work without IPv6. [#77841](https://github.com/ClickHouse/ClickHouse/pull/77841) ([Azat Khuzhin](https://github.com/azat)).
* Mark system.warnings settings as refreshable. [#77845](https://github.com/ClickHouse/ClickHouse/pull/77845) ([Bharat Nallan](https://github.com/bharatnc)).
* Add `<query_condition_cache_size>` to config.xml. [#77846](https://github.com/ClickHouse/ClickHouse/pull/77846) ([Robert Schulze](https://github.com/rschu1ze)).
* CMake: Rid ourselves of some build-time spam. [#77847](https://github.com/ClickHouse/ClickHouse/pull/77847) ([Robert Schulze](https://github.com/rschu1ze)).
* Ensure mongo-c-driver does not modify the build tree. [#77855](https://github.com/ClickHouse/ClickHouse/pull/77855) ([Raúl Marín](https://github.com/Algunenano)).
* Print CgroupsReader warnings only once. [#77862](https://github.com/ClickHouse/ClickHouse/pull/77862) ([Michael Kolupaev](https://github.com/al13n321)).
* Remove some includes. [#77865](https://github.com/ClickHouse/ClickHouse/pull/77865) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test. [#77882](https://github.com/ClickHouse/ClickHouse/pull/77882) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Sharded userspace page cache. [#77883](https://github.com/ClickHouse/ClickHouse/pull/77883) ([Michael Kolupaev](https://github.com/al13n321)).
* Remove useless and operations in `MergeTreeIndexFullText.cpp`. [#77886](https://github.com/ClickHouse/ClickHouse/pull/77886) ([cjw](https://github.com/byte-sourcerer)).
* CI: Fix exception in backport script. [#77891](https://github.com/ClickHouse/ClickHouse/pull/77891) ([Max Kainov](https://github.com/maxknv)).
* Revert [#77584](https://github.com/ClickHouse/ClickHouse/issues/77584). [#77897](https://github.com/ClickHouse/ClickHouse/pull/77897) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* CI: Align create release workflow with praktika. [#77912](https://github.com/ClickHouse/ClickHouse/pull/77912) ([Max Kainov](https://github.com/maxknv)).
* CI: Fix backport created check. [#77913](https://github.com/ClickHouse/ClickHouse/pull/77913) ([Max Kainov](https://github.com/maxknv)).
* Refactor operations with Avro files in Iceberg-related code. [#77916](https://github.com/ClickHouse/ClickHouse/pull/77916) ([alesapin](https://github.com/alesapin)).
* Next Buzzhouse update. [#77918](https://github.com/ClickHouse/ClickHouse/pull/77918) ([Pedro Ferreira](https://github.com/PedroTadim)).
* CI: Build job refactored. [#77920](https://github.com/ClickHouse/ClickHouse/pull/77920) ([Max Kainov](https://github.com/maxknv)).
* Speed up ConstraintsDescription compilation. [#77926](https://github.com/ClickHouse/ClickHouse/pull/77926) ([Raúl Marín](https://github.com/Algunenano)).
* Adjust a few old tests to flush individual logs. [#77936](https://github.com/ClickHouse/ClickHouse/pull/77936) ([Raúl Marín](https://github.com/Algunenano)).
* Minor follow-up for [#77905](https://github.com/ClickHouse/ClickHouse/issues/77905). [#77938](https://github.com/ClickHouse/ClickHouse/pull/77938) ([Robert Schulze](https://github.com/rschu1ze)).
* Update CHANGELOG.md. [#77986](https://github.com/ClickHouse/ClickHouse/pull/77986) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Query condition cache: Fix race in debug build + add comment about error handling. [#77988](https://github.com/ClickHouse/ClickHouse/pull/77988) ([Robert Schulze](https://github.com/rschu1ze)).
* Update CHANGELOG.md. [#77989](https://github.com/ClickHouse/ClickHouse/pull/77989) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Support for non-constant THEN argument in `CASE`. [#77995](https://github.com/ClickHouse/ClickHouse/pull/77995) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Update CHANGELOG.md. [#77997](https://github.com/ClickHouse/ClickHouse/pull/77997) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Update CHANGELOG.md. [#78000](https://github.com/ClickHouse/ClickHouse/pull/78000) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* tests: fix test_backup_restore_s3 flakiness. [#78001](https://github.com/ClickHouse/ClickHouse/pull/78001) ([Azat Khuzhin](https://github.com/azat)).
* Reset cursor blinking on client termination. [#78004](https://github.com/ClickHouse/ClickHouse/pull/78004) ([Azat Khuzhin](https://github.com/azat)).
* Add aws-cpp-sdk-glue to sparse-checkout. [#78007](https://github.com/ClickHouse/ClickHouse/pull/78007) ([Pablo Marcos](https://github.com/pamarcos)).
* Fix table header highlighting for SSH server. [#78011](https://github.com/ClickHouse/ClickHouse/pull/78011) ([Azat Khuzhin](https://github.com/azat)).
* Optimize incremental compilation in case of MarkRange.h changes. [#78013](https://github.com/ClickHouse/ClickHouse/pull/78013) ([Azat Khuzhin](https://github.com/azat)).
* Fix cloning of ASTQueryParameter. [#78016](https://github.com/ClickHouse/ClickHouse/pull/78016) ([Azat Khuzhin](https://github.com/azat)).
* Refactor some code in Iceberg Storage. [#78021](https://github.com/ClickHouse/ClickHouse/pull/78021) ([Han Fei](https://github.com/hanfei1991)).
* Update version_date.tsv and changelog after v25.3.1.2703-lts. [#78031](https://github.com/ClickHouse/ClickHouse/pull/78031) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* tests: disable 01304_direct_io_long under TSan. [#78042](https://github.com/ClickHouse/ClickHouse/pull/78042) ([Azat Khuzhin](https://github.com/azat)).
* Update README.md. [#78051](https://github.com/ClickHouse/ClickHouse/pull/78051) ([Tyler Hannan](https://github.com/tylerhannan)).
* Use proper error code over LOGICAL_ERROR for unsupported GLOBAL JOIN kind (fixes AST fuzzer). [#78052](https://github.com/ClickHouse/ClickHouse/pull/78052) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix 03293_tty_binary_confirmation flakiness. [#78054](https://github.com/ClickHouse/ClickHouse/pull/78054) ([Azat Khuzhin](https://github.com/azat)).
* Better expect tests. [#78064](https://github.com/ClickHouse/ClickHouse/pull/78064) ([Azat Khuzhin](https://github.com/azat)).
* ci: do not fail stateless job if scraping system.*_log failed. [#78066](https://github.com/ClickHouse/ClickHouse/pull/78066) ([Azat Khuzhin](https://github.com/azat)).
* CI: Updates for Quick sync. [#78067](https://github.com/ClickHouse/ClickHouse/pull/78067) ([Max Kainov](https://github.com/maxknv)).
* tests: fix 01825_type_json_schema_race_long flakiness (test for deprecated Object JSON). [#78081](https://github.com/ClickHouse/ClickHouse/pull/78081) ([Azat Khuzhin](https://github.com/azat)).
* Include table name in METADATA_MISMATCH exceptions. [#78082](https://github.com/ClickHouse/ClickHouse/pull/78082) ([Kseniia Sumarokova](https://github.com/kssenii)).
* CI: Add S3 Usage meters to praktika. [#78089](https://github.com/ClickHouse/ClickHouse/pull/78089) ([Max Kainov](https://github.com/maxknv)).
* tests: remove --print-time option for clickhouse-test (always print them). [#78091](https://github.com/ClickHouse/ClickHouse/pull/78091) ([Azat Khuzhin](https://github.com/azat)).
* Revert "Revert "Select and load the correct vector index based on search column"". [#78117](https://github.com/ClickHouse/ClickHouse/pull/78117) ([Robert Schulze](https://github.com/rschu1ze)).
* Vector similarity index: Fix random crashes during oversubscription. [#78118](https://github.com/ClickHouse/ClickHouse/pull/78118) ([Robert Schulze](https://github.com/rschu1ze)).
* tests: disable 02125_many_mutations* for Replicated database (too slow). [#78123](https://github.com/ClickHouse/ClickHouse/pull/78123) ([Azat Khuzhin](https://github.com/azat)).
* Better detection of dirty files in the source directory after build. [#78125](https://github.com/ClickHouse/ClickHouse/pull/78125) ([Raúl Marín](https://github.com/Algunenano)).
* Update 02354_vector_search_choose_correct_index. [#78167](https://github.com/ClickHouse/ClickHouse/pull/78167) ([Igor Nikonov](https://github.com/devcrafter)).
* Fix using reference on local variable. [#78174](https://github.com/ClickHouse/ClickHouse/pull/78174) ([Anton Ivashkin](https://github.com/ianton-ru)).
* Fix crash from sanitizer report on atexit handlers. [#78178](https://github.com/ClickHouse/ClickHouse/pull/78178) ([Azat Khuzhin](https://github.com/azat)).
* Better exception messages. [#78184](https://github.com/ClickHouse/ClickHouse/pull/78184) ([Raúl Marín](https://github.com/Algunenano)).
* Fix rabbitmq test by starting RabbitMQ from scratch every test. [#78186](https://github.com/ClickHouse/ClickHouse/pull/78186) ([Pablo Marcos](https://github.com/pamarcos)).
* Critical bugfix should not skip bugfix validation. [#78209](https://github.com/ClickHouse/ClickHouse/pull/78209) ([Raúl Marín](https://github.com/Algunenano)).
* Update VENDOR.md. [#78212](https://github.com/ClickHouse/ClickHouse/pull/78212) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix SCRAM_SHA256_PASSWORD enum position. [#78216](https://github.com/ClickHouse/ClickHouse/pull/78216) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Isolate test_recover_digest_mismatch. [#78245](https://github.com/ClickHouse/ClickHouse/pull/78245) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Update a test. [#78246](https://github.com/ClickHouse/ClickHouse/pull/78246) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix 03355_join_to_in_optimization. [#78254](https://github.com/ClickHouse/ClickHouse/pull/78254) ([Raúl Marín](https://github.com/Algunenano)).
* Log invalid HTTP version string. [#78264](https://github.com/ClickHouse/ClickHouse/pull/78264) ([Christoph Wurm](https://github.com/cwurm)).
* ci: fix hangs during sending system.*_log to ci-logs. [#78266](https://github.com/ClickHouse/ClickHouse/pull/78266) ([Azat Khuzhin](https://github.com/azat)).
* update 03393_join_bug_77848.sql. [#78274](https://github.com/ClickHouse/ClickHouse/pull/78274) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Buzzhouse update. [#78284](https://github.com/ClickHouse/ClickHouse/pull/78284) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Remove old and unused cmake code. [#78288](https://github.com/ClickHouse/ClickHouse/pull/78288) ([Raúl Marín](https://github.com/Algunenano)).
* CI: Minor updates for quick sync. [#78296](https://github.com/ClickHouse/ClickHouse/pull/78296) ([Max Kainov](https://github.com/maxknv)).
* CI: Add server error log into FastTest artifacts. [#78300](https://github.com/ClickHouse/ClickHouse/pull/78300) ([Max Kainov](https://github.com/maxknv)).
* Add test to ensure no container-overflow happens in ASAN. [#78317](https://github.com/ClickHouse/ClickHouse/pull/78317) ([Pablo Marcos](https://github.com/pamarcos)).
* backport same setting changes to open source repo. [#78334](https://github.com/ClickHouse/ClickHouse/pull/78334) ([Han Fei](https://github.com/hanfei1991)).
* Fix assert `Unexpected state. Back: [5242880, 10485759], result range: [0, 12582911], limit: 0. (s3 storage)`. [#78340](https://github.com/ClickHouse/ClickHouse/pull/78340) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Legacy layout fixes for plain_rewritable disk. [#78351](https://github.com/ClickHouse/ClickHouse/pull/78351) ([Julia Kartseva](https://github.com/jkartseva)).
* CI: Fix workflow custom data storage and retrieval. [#78356](https://github.com/ClickHouse/ClickHouse/pull/78356) ([Max Kainov](https://github.com/maxknv)).
* Update version_date.tsv and changelog after v25.3.2.39-lts. [#78359](https://github.com/ClickHouse/ClickHouse/pull/78359) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Follow up https://github.com/ClickHouse/ClickHouse/pull/76839, this PR is to support scram sha256 in native clickhouse client. [#78372](https://github.com/ClickHouse/ClickHouse/pull/78372) ([scanhex12](https://github.com/scanhex12)).
* fix the description of logger_name column of system.text_log. [#78390](https://github.com/ClickHouse/ClickHouse/pull/78390) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* CI: Fix gh_auth in praktika. [#78393](https://github.com/ClickHouse/ClickHouse/pull/78393) ([Max Kainov](https://github.com/maxknv)).
* Add test for wide vs compact parts for vector search. [#78395](https://github.com/ClickHouse/ClickHouse/pull/78395) ([Robert Schulze](https://github.com/rschu1ze)).
* CI: Fix for migration to pyjwt auth. [#78396](https://github.com/ClickHouse/ClickHouse/pull/78396) ([Max Kainov](https://github.com/maxknv)).
* Https://github.com/clickhouse/clickhouse/issues/69074 is fixed on the current master. add a test for it. [#78399](https://github.com/ClickHouse/ClickHouse/pull/78399) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Fixes `applyCompatibilitySetting`. Prior to this patch, all settings with a type not equal to Bool were marked as changed because the type of setting changes in the settings history was not equal to the type of settings in the settings declaration. [#78402](https://github.com/ClickHouse/ClickHouse/pull/78402) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Refactor test_reload_client_certificate to make it more stable. [#78411](https://github.com/ClickHouse/ClickHouse/pull/78411) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Follow up this PR [#77365](https://github.com/ClickHouse/ClickHouse/pull/77365), with_remote_database_disk is disabled in some tests to reduce diversion between the public and private repo. [#78416](https://github.com/ClickHouse/ClickHouse/pull/78416) ([Tuan Pham Anh](https://github.com/tuanpach)).
* CI: Fix docs PR criteria. [#78418](https://github.com/ClickHouse/ClickHouse/pull/78418) ([Max Kainov](https://github.com/maxknv)).
* ci: bump aspell (it does not know some words that even I know). [#78421](https://github.com/ClickHouse/ClickHouse/pull/78421) ([Azat Khuzhin](https://github.com/azat)).
* CI: Fix for setting clickhouse version in workflow data. [#78422](https://github.com/ClickHouse/ClickHouse/pull/78422) ([Max Kainov](https://github.com/maxknv)).
* Better guard pages with MADV_GUARD_INSTALL/MADV_GUARD_REMOVE (linux 6.13+). [#78423](https://github.com/ClickHouse/ClickHouse/pull/78423) ([Azat Khuzhin](https://github.com/azat)).
* CI: Fix performance comparison for master branch. [#78424](https://github.com/ClickHouse/ClickHouse/pull/78424) ([Max Kainov](https://github.com/maxknv)).
* Vector search: Specify expected cardinality in vector index parameters. [#78425](https://github.com/ClickHouse/ClickHouse/pull/78425) ([Robert Schulze](https://github.com/rschu1ze)).
* CI: Unit tests refactored. [#78426](https://github.com/ClickHouse/ClickHouse/pull/78426) ([Max Kainov](https://github.com/maxknv)).
* CI: Clickbench and Sqllogic jobs refactored. [#78431](https://github.com/ClickHouse/ClickHouse/pull/78431) ([Max Kainov](https://github.com/maxknv)).
* tests: fix flaky 00111_shard_external_sort_distributed. [#78440](https://github.com/ClickHouse/ClickHouse/pull/78440) ([Eduard Karacharov](https://github.com/korowa)).
* tests: fix 03312_system_errors_last_error flakiness. [#78443](https://github.com/ClickHouse/ClickHouse/pull/78443) ([Azat Khuzhin](https://github.com/azat)).
* CI: Switch asan unit tests back to amd. [#78445](https://github.com/ClickHouse/ClickHouse/pull/78445) ([Max Kainov](https://github.com/maxknv)).
* Introduced in https://github.com/ClickHouse/ClickHouse/pull/77926. [#78451](https://github.com/ClickHouse/ClickHouse/pull/78451) ([Nikolay Degterinsky](https://github.com/evillique)).
* CI: Clang-tidy-cache setup fix. [#78457](https://github.com/ClickHouse/ClickHouse/pull/78457) ([Max Kainov](https://github.com/maxknv)).
* CI: Fast tests: add server logs. [#78458](https://github.com/ClickHouse/ClickHouse/pull/78458) ([Max Kainov](https://github.com/maxknv)).
* CI: Fix build job failure in the merge queue. [#78459](https://github.com/ClickHouse/ClickHouse/pull/78459) ([Max Kainov](https://github.com/maxknv)).
* Fix possible recursive static var initialization (in debug build) due to big allocations check. [#78460](https://github.com/ClickHouse/ClickHouse/pull/78460) ([Azat Khuzhin](https://github.com/azat)).
* Improvement for system.filesystem_cache. [#78463](https://github.com/ClickHouse/ClickHouse/pull/78463) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Update clang-tidy-cache and show its stats. [#78466](https://github.com/ClickHouse/ClickHouse/pull/78466) ([Pablo Marcos](https://github.com/pamarcos)).
* CI: Set ThinLTO explicitly in the build script. [#78467](https://github.com/ClickHouse/ClickHouse/pull/78467) ([Max Kainov](https://github.com/maxknv)).
* Try to fix flaky tests in master. [#78469](https://github.com/ClickHouse/ClickHouse/pull/78469) ([Robert Schulze](https://github.com/rschu1ze)).
* ci: fix cache for clang-tidy. [#78471](https://github.com/ClickHouse/ClickHouse/pull/78471) ([Azat Khuzhin](https://github.com/azat)).
* tests: explicit number of threads for S3Queue tests. [#78476](https://github.com/ClickHouse/ClickHouse/pull/78476) ([Azat Khuzhin](https://github.com/azat)).
* Minor refactoring near `MergeTree` reader. [#78483](https://github.com/ClickHouse/ClickHouse/pull/78483) ([Anton Popov](https://github.com/CurtizJ)).
* CI: Fast test to upload stripped binary. [#78488](https://github.com/ClickHouse/ClickHouse/pull/78488) ([Max Kainov](https://github.com/maxknv)).
* ci: fix sccache statistics for fuzzers. [#78489](https://github.com/ClickHouse/ClickHouse/pull/78489) ([Azat Khuzhin](https://github.com/azat)).
* CI: Migration to arm. [#78492](https://github.com/ClickHouse/ClickHouse/pull/78492) ([Max Kainov](https://github.com/maxknv)).
* It is useful as github html page does not open as a website in browser. [#78501](https://github.com/ClickHouse/ClickHouse/pull/78501) ([Ilya Yatsishin](https://github.com/qoega)).
* CI: Perf tests fixes. [#78507](https://github.com/ClickHouse/ClickHouse/pull/78507) ([Max Kainov](https://github.com/maxknv)).
* Use upstream corrosion. [#78508](https://github.com/ClickHouse/ClickHouse/pull/78508) ([Raúl Marín](https://github.com/Algunenano)).
* Move MongoDB instance initialization to a class. [#78510](https://github.com/ClickHouse/ClickHouse/pull/78510) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix test_reload_while_loading, increase timeout from 1 to 10s, ensure that the instance receives the query triggering the dict loading. [#78511](https://github.com/ClickHouse/ClickHouse/pull/78511) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Correctly stop prewarming of mark cache and primary index cache. [#78514](https://github.com/ClickHouse/ClickHouse/pull/78514) ([Anton Popov](https://github.com/CurtizJ)).
* Minor refactoring near `AlterConversions`. [#78515](https://github.com/ClickHouse/ClickHouse/pull/78515) ([Anton Popov](https://github.com/CurtizJ)).
* Modernize OpenSSL usage in `SSLCertificateSubjects.cpp`. [#78517](https://github.com/ClickHouse/ClickHouse/pull/78517) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Modernize OpenSSL usage in helpers. [#78518](https://github.com/ClickHouse/ClickHouse/pull/78518) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Modernize OpenSSL usage in hash functions. [#78520](https://github.com/ClickHouse/ClickHouse/pull/78520) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* `system.query_condition_cache`: Prettier prettyprinting for matching marks. [#78524](https://github.com/ClickHouse/ClickHouse/pull/78524) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix `explain distributed=1` always uses `to_stage == Complete`. [#78525](https://github.com/ClickHouse/ClickHouse/pull/78525) ([Nikita Taranov](https://github.com/nickitat)).
* Some fixes around autogenerated headers. [#78537](https://github.com/ClickHouse/ClickHouse/pull/78537) ([Raúl Marín](https://github.com/Algunenano)).
* CI: Support writing data to CIDB from specified job's subtask. [#78551](https://github.com/ClickHouse/ClickHouse/pull/78551) ([Max Kainov](https://github.com/maxknv)).
* tests: fix 00988_parallel_parts_removal flakiness. [#78557](https://github.com/ClickHouse/ClickHouse/pull/78557) ([Azat Khuzhin](https://github.com/azat)).
* Add a test for [#52065](https://github.com/ClickHouse/ClickHouse/issues/52065). [#78563](https://github.com/ClickHouse/ClickHouse/pull/78563) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Fix toolchain for darwin arm build. [#78584](https://github.com/ClickHouse/ClickHouse/pull/78584) ([Max Kainov](https://github.com/maxknv)).
* CI: Upload self-extracting binary for installation with curl. [#78589](https://github.com/ClickHouse/ClickHouse/pull/78589) ([Max Kainov](https://github.com/maxknv)).
* Remove some dead code from Poco. [#78592](https://github.com/ClickHouse/ClickHouse/pull/78592) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* ci: increase timeout for clickhouse stop (due to slow gdb). [#78598](https://github.com/ClickHouse/ClickHouse/pull/78598) ([Azat Khuzhin](https://github.com/azat)).
* minor fix to ObjectStorage exception. [#78616](https://github.com/ClickHouse/ClickHouse/pull/78616) ([Bharat Nallan](https://github.com/bharatnc)).
* bump liburing: 2.5 -> 2.9. [#78620](https://github.com/ClickHouse/ClickHouse/pull/78620) ([Pradeep Chhetri](https://github.com/chhetripradeep)).
* Disable with_remote_database_disk in test_distributed_ddl and test_zookeeper_config. [#78621](https://github.com/ClickHouse/ClickHouse/pull/78621) ([Tuan Pham Anh](https://github.com/tuanpach)).
* CI: Refactor docs check job. [#78630](https://github.com/ClickHouse/ClickHouse/pull/78630) ([Max Kainov](https://github.com/maxknv)).
* ci: add symbolizer to clickhouse/integration-tests-runner. [#78631](https://github.com/ClickHouse/ClickHouse/pull/78631) ([Azat Khuzhin](https://github.com/azat)).
* Sync with private. [#78635](https://github.com/ClickHouse/ClickHouse/pull/78635) ([Raúl Marín](https://github.com/Algunenano)).
* Fix schedule session close. [#78636](https://github.com/ClickHouse/ClickHouse/pull/78636) ([Alexey Katsman](https://github.com/alexkats)).
* Stop the log pipeline before creating the Message structure. [#78651](https://github.com/ClickHouse/ClickHouse/pull/78651) ([Mikhail Artemenko](https://github.com/Michicosun)).
* We do not count tables from the `system` database when we check the limit of tables, so we should also not check the limits for tables in `system` database. [#78653](https://github.com/ClickHouse/ClickHouse/pull/78653) ([Nikolay Degterinsky](https://github.com/evillique)).
* CI: Refresh PR context from API. [#78654](https://github.com/ClickHouse/ClickHouse/pull/78654) ([Max Kainov](https://github.com/maxknv)).
* CI: Refactor Nightly workflows. [#78657](https://github.com/ClickHouse/ClickHouse/pull/78657) ([Max Kainov](https://github.com/maxknv)).
* CI: Improve job summary in report. [#78659](https://github.com/ClickHouse/ClickHouse/pull/78659) ([Max Kainov](https://github.com/maxknv)).
* CI: Follow-up fixes for dockers build on master. [#78661](https://github.com/ClickHouse/ClickHouse/pull/78661) ([Max Kainov](https://github.com/maxknv)).
* CI: Support artifacts compressing. [#78662](https://github.com/ClickHouse/ClickHouse/pull/78662) ([Max Kainov](https://github.com/maxknv)).
* cctools: update gdb to 16.2 (6x faster backtraces on CI) and fix Apple TAPI/cctools port. [#78667](https://github.com/ClickHouse/ClickHouse/pull/78667) ([Azat Khuzhin](https://github.com/azat)).
* build: optimize strip by using -o over extra cp. [#78668](https://github.com/ClickHouse/ClickHouse/pull/78668) ([Azat Khuzhin](https://github.com/azat)).
* Fix some deterministic settings, aliases, and dictionary settings. - Added missing CLUSTER clause to SYSTEM statements. [#78669](https://github.com/ClickHouse/ClickHouse/pull/78669) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Fix for failing docs check. [#78673](https://github.com/ClickHouse/ClickHouse/pull/78673) ([Shaun Struwig](https://github.com/Blargian)).
* Add a bunch of forward declarations in headers. [#78675](https://github.com/ClickHouse/ClickHouse/pull/78675) ([Raúl Marín](https://github.com/Algunenano)).
* Sync private. [#78678](https://github.com/ClickHouse/ClickHouse/pull/78678) ([Raúl Marín](https://github.com/Algunenano)).
* Fix wrong arguments order for TableFunctionFactory::execute() for loop. [#78707](https://github.com/ClickHouse/ClickHouse/pull/78707) ([Azat Khuzhin](https://github.com/azat)).
* ci: upload performance tests results to ci-db. [#78708](https://github.com/ClickHouse/ClickHouse/pull/78708) ([Azat Khuzhin](https://github.com/azat)).
* ci: fix bug-fix check (due to new settings added to tests configurations in 25.4). [#78709](https://github.com/ClickHouse/ClickHouse/pull/78709) ([Azat Khuzhin](https://github.com/azat)).
* Optimize system.tables for *_mutations access. [#78720](https://github.com/ClickHouse/ClickHouse/pull/78720) ([Azat Khuzhin](https://github.com/azat)).
* Just checking bug fix script. Will revert the category to not for changelog before merge. [#78721](https://github.com/ClickHouse/ClickHouse/pull/78721) ([Azat Khuzhin](https://github.com/azat)).
* ci: disable async_insert for sending system.*_log to ci-logs cluster and increase stop timeout. [#78722](https://github.com/ClickHouse/ClickHouse/pull/78722) ([Azat Khuzhin](https://github.com/azat)).
* Ignore non existing include_from files with --try for clickhouse-extract-from-config. [#78725](https://github.com/ClickHouse/ClickHouse/pull/78725) ([Azat Khuzhin](https://github.com/azat)).
* More consistent error handling of OpenSSL calls. [#78727](https://github.com/ClickHouse/ClickHouse/pull/78727) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix flaky 03261_minmax_indices_by_default. [#78736](https://github.com/ClickHouse/ClickHouse/pull/78736) ([Eduard Karacharov](https://github.com/korowa)).
* Fix Digest does not match (from Replicated database) on CI. [#78741](https://github.com/ClickHouse/ClickHouse/pull/78741) ([Azat Khuzhin](https://github.com/azat)).
* fix flaky test `test_storage_s3_queue/test_4.py`. [#78744](https://github.com/ClickHouse/ClickHouse/pull/78744) ([Bharat Nallan](https://github.com/bharatnc)).
* Further modernization of OpenSSL calls. [#78745](https://github.com/ClickHouse/ClickHouse/pull/78745) ([Robert Schulze](https://github.com/rschu1ze)).
* Bump usearch to 2.17.5. [#78766](https://github.com/ClickHouse/ClickHouse/pull/78766) ([Robert Schulze](https://github.com/rschu1ze)).
* Fixes for test_storage_rabbitmq::test_failed_connection.py. [#78773](https://github.com/ClickHouse/ClickHouse/pull/78773) ([Pablo Marcos](https://github.com/pamarcos)).
* Small refactoring around data lakes. [#78775](https://github.com/ClickHouse/ClickHouse/pull/78775) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add a job url into the cherry-pick and backport PRs. [#78776](https://github.com/ClickHouse/ClickHouse/pull/78776) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Prevent `test_replicated_database/test.py::test_create_replicated_table` from being flaky. [#78779](https://github.com/ClickHouse/ClickHouse/pull/78779) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Docs check: update Dockerfile. [#78783](https://github.com/ClickHouse/ClickHouse/pull/78783) ([Shaun Struwig](https://github.com/Blargian)).
* Add tests for recent JSON issues. [#78793](https://github.com/ClickHouse/ClickHouse/pull/78793) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Fix race when writing Keeper response. [#78794](https://github.com/ClickHouse/ClickHouse/pull/78794) ([Antonio Andelic](https://github.com/antonio2368)).
* Improve OpenSSL error handling. [#78808](https://github.com/ClickHouse/ClickHouse/pull/78808) ([Robert Schulze](https://github.com/rschu1ze)).
* CI: Report widget with job duration statistics. [#78809](https://github.com/ClickHouse/ClickHouse/pull/78809) ([Max Kainov](https://github.com/maxknv)).
* Add `no-distributed-cache` tag to `03008_s3_plain_rewritable_alter_partition.sh`. [#78811](https://github.com/ClickHouse/ClickHouse/pull/78811) ([Julia Kartseva](https://github.com/jkartseva)).
* Trying to stabilize `test_no_backoff_after_killing_mutation`. [#78814](https://github.com/ClickHouse/ClickHouse/pull/78814) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Backported in [#79094](https://github.com/ClickHouse/ClickHouse/issues/79094): Fix: lazy materialization in distributed queries. [#78815](https://github.com/ClickHouse/ClickHouse/pull/78815) ([Igor Nikonov](https://github.com/devcrafter)).
* tests: better Exception in stdout detection. [#78817](https://github.com/ClickHouse/ClickHouse/pull/78817) ([Azat Khuzhin](https://github.com/azat)).
* Bring back [#76914](https://github.com/ClickHouse/ClickHouse/issues/76914). [#78819](https://github.com/ClickHouse/ClickHouse/pull/78819) ([Nikita Taranov](https://github.com/nickitat)).
* try to fix flaky test `test_backup_restore_s3`. [#78821](https://github.com/ClickHouse/ClickHouse/pull/78821) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix `test_s3_plain_rewritable` flakiness. [#78825](https://github.com/ClickHouse/ClickHouse/pull/78825) ([Julia Kartseva](https://github.com/jkartseva)).
* Rework tests for query condition cache. [#78834](https://github.com/ClickHouse/ClickHouse/pull/78834) ([Robert Schulze](https://github.com/rschu1ze)).
* BuzzHouse: Clean remote feature. [#78837](https://github.com/ClickHouse/ClickHouse/pull/78837) ([Pedro Ferreira](https://github.com/PedroTadim)).
* CI: Feature docs check needs exception for autogenerated documentation. [#78843](https://github.com/ClickHouse/ClickHouse/pull/78843) ([Shaun Struwig](https://github.com/Blargian)).
* Integration README update. [#78849](https://github.com/ClickHouse/ClickHouse/pull/78849) ([Samay Sharma](https://github.com/samay-sharma)).
* More rust build improvements. [#78857](https://github.com/ClickHouse/ClickHouse/pull/78857) ([Raúl Marín](https://github.com/Algunenano)).
* Use display_name from server config for prompt over SSH protocol. [#78872](https://github.com/ClickHouse/ClickHouse/pull/78872) ([Azat Khuzhin](https://github.com/azat)).
* Fix race when shutting down queue metadata. [#78876](https://github.com/ClickHouse/ClickHouse/pull/78876) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix table attach in stress test. [#78881](https://github.com/ClickHouse/ClickHouse/pull/78881) ([Antonio Andelic](https://github.com/antonio2368)).
* CI: Nightly job for collecting CI statistics. [#78882](https://github.com/ClickHouse/ClickHouse/pull/78882) ([Max Kainov](https://github.com/maxknv)).
* Fix test  `02944_dynamically_change_filesystem_cache_size.sh`. [#78884](https://github.com/ClickHouse/ClickHouse/pull/78884) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fix flaky `03229_query_condition_cache_profile_events`. [#78886](https://github.com/ClickHouse/ClickHouse/pull/78886) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix `test_rabbitmq_restore_failed_connection_without_losses_1`. [#78887](https://github.com/ClickHouse/ClickHouse/pull/78887) ([Pablo Marcos](https://github.com/pamarcos)).
* Fix tests `02240_filesystem_cache_bypass_cache_threshold`, `02240_filesystem_query_cache`. [#78888](https://github.com/ClickHouse/ClickHouse/pull/78888) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Remove clang_tidy_cache from repo. [#78905](https://github.com/ClickHouse/ClickHouse/pull/78905) ([Azat Khuzhin](https://github.com/azat)).
* CI: Fast tests sccache fix. [#78906](https://github.com/ClickHouse/ClickHouse/pull/78906) ([Max Kainov](https://github.com/maxknv)).
* Fix several small issues with transposed metric log. In case of schema type `transposed_with_wide_view` `system.transposed_metric_log` ignores explicitly specified `ORDER BY` (because predefined one is optimal for view). Now clickhouse will create "wide" view for each `system.transposed_metric_log`. [#78932](https://github.com/ClickHouse/ClickHouse/pull/78932) ([alesapin](https://github.com/alesapin)).
* CI: Clean up hook in docker server build job. [#78961](https://github.com/ClickHouse/ClickHouse/pull/78961) ([Max Kainov](https://github.com/maxknv)).
* Fix Keeper test_snapshot_on_exit. [#78965](https://github.com/ClickHouse/ClickHouse/pull/78965) ([Antonio Andelic](https://github.com/antonio2368)).
* Another fix for `test_rabbitmq_restore_failed_connection_without_losses_1`. [#78970](https://github.com/ClickHouse/ClickHouse/pull/78970) ([Pablo Marcos](https://github.com/pamarcos)).
* Fix 03229_query_condition_cache_profile_events with parallel replicas. [#78971](https://github.com/ClickHouse/ClickHouse/pull/78971) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#79049](https://github.com/ClickHouse/ClickHouse/issues/79049): Now if source table for system.metric_log view is dropped, view itself will return 0 rows. [#78985](https://github.com/ClickHouse/ClickHouse/pull/78985) ([alesapin](https://github.com/alesapin)).
* Fix bugfix validation for max_cpu_load config. [#78988](https://github.com/ClickHouse/ClickHouse/pull/78988) ([Alexey Katsman](https://github.com/alexkats)).
* Update trace-visualizer README.md. [#78993](https://github.com/ClickHouse/ClickHouse/pull/78993) ([Nikita Taranov](https://github.com/nickitat)).
* CI: Use ARM runner for docs check. [#78998](https://github.com/ClickHouse/ClickHouse/pull/78998) ([Shaun Struwig](https://github.com/Blargian)).
* tests: fix flaky test_cleanup_after_start. [#79003](https://github.com/ClickHouse/ClickHouse/pull/79003) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#79129](https://github.com/ClickHouse/ClickHouse/issues/79129): Fix compatiblity value for max_merge_delayed_streams_for_parallel_write (MT). [#79034](https://github.com/ClickHouse/ClickHouse/pull/79034) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#79384](https://github.com/ClickHouse/ClickHouse/issues/79384): Fix history values for max_postpone_time_for_failed_replicated_ settings. [#79036](https://github.com/ClickHouse/ClickHouse/pull/79036) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#79140](https://github.com/ClickHouse/ClickHouse/issues/79140): Place 25.4 setting changes under 25.4. [#79037](https://github.com/ClickHouse/ClickHouse/pull/79037) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#79069](https://github.com/ClickHouse/ClickHouse/issues/79069): remove experimental mark of share set join. [#79044](https://github.com/ClickHouse/ClickHouse/pull/79044) ([Han Fei](https://github.com/hanfei1991)).
* Backported in [#79154](https://github.com/ClickHouse/ClickHouse/issues/79154): CI: Automatically skip jobs not affected by the change. [#79057](https://github.com/ClickHouse/ClickHouse/pull/79057) ([Max Kainov](https://github.com/maxknv)).
* Backported in [#79315](https://github.com/ClickHouse/ClickHouse/issues/79315): Remove guard pages for threads and async_socket_for_remote/use_hedge_requests. Change the allocation method in `FiberStack` from `mmap` to `aligned_alloc`. Since this splits VMAs and under heavy load vm.max_map_count can be reached. [#79147](https://github.com/ClickHouse/ClickHouse/pull/79147) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#79172](https://github.com/ClickHouse/ClickHouse/issues/79172): CI: Add build digest into ci data. [#79168](https://github.com/ClickHouse/ClickHouse/pull/79168) ([Max Kainov](https://github.com/maxknv)).
* Backported in [#79238](https://github.com/ClickHouse/ClickHouse/issues/79238): Clarify `low_priority_query_wait_time_ms` purpose. [#79225](https://github.com/ClickHouse/ClickHouse/pull/79225) ([Nikita Taranov](https://github.com/nickitat)).

