---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.3.7.194-lts (36637934778) FIXME as compared to v25.3.6.56-lts (39f0a39e4bb)

#### Improvement
* Backported in [#84500](https://github.com/ClickHouse/ClickHouse/issues/84500): Two mini improvements in Web UI: - correctly handle queries without output, such as `CREATE`, `INSERT` (until recently, these queries resulted in an infinite spinner); - when double clicking on a table, scroll to the top. [#81131](https://github.com/ClickHouse/ClickHouse/pull/81131) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#84031](https://github.com/ClickHouse/ClickHouse/issues/84031): Use information from cgroup (if applicable, i.e. `memory_worker_use_cgroup` and cgroups are available) to adjust memory tracker (`memory_worker_correct_memory_tracker`). [#83981](https://github.com/ClickHouse/ClickHouse/pull/83981) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#84593](https://github.com/ClickHouse/ClickHouse/issues/84593): S3Queue ordered mode fix: quit earlier if shutdown was called. [#84463](https://github.com/ClickHouse/ClickHouse/pull/84463) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#85017](https://github.com/ClickHouse/ClickHouse/issues/85017): Add 4LW in Keeper, `lgrq`, for toggling request logging of received requests. [#84719](https://github.com/ClickHouse/ClickHouse/pull/84719) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#84866](https://github.com/ClickHouse/ClickHouse/issues/84866): Reduce contention on storage lock in Keeper. [#84732](https://github.com/ClickHouse/ClickHouse/pull/84732) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85014](https://github.com/ClickHouse/ClickHouse/issues/85014): Limit Keeper log entry cache size by number of entries using `keeper_server.coordination_settings.latest_logs_cache_entry_count_threshold` and `keeper_server.coordination_settings.commit_logs_cache_entry_count_threshold`. [#84877](https://github.com/ClickHouse/ClickHouse/pull/84877) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85731](https://github.com/ClickHouse/ClickHouse/issues/85731): Added show_data_lake_catalogs_in_system_tables flag to manage adding data lake tables in system.tables resolves [#85384](https://github.com/ClickHouse/ClickHouse/issues/85384). [#85411](https://github.com/ClickHouse/ClickHouse/pull/85411) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Backported in [#86823](https://github.com/ClickHouse/ClickHouse/issues/86823): Improve performance of RemoveRecursive request in Keeper. [#86789](https://github.com/ClickHouse/ClickHouse/pull/86789) ([Antonio Andelic](https://github.com/antonio2368)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#86905](https://github.com/ClickHouse/ClickHouse/issues/86905): Disable parallelize query processing right after reading FROM when `distributed_aggregation_memory_efficient` enabled, it may lead to logical error. Closes [#76934](https://github.com/ClickHouse/ClickHouse/issues/76934). [#78500](https://github.com/ClickHouse/ClickHouse/pull/78500) ([flynn](https://github.com/ucasfl)).
* Backported in [#80368](https://github.com/ClickHouse/ClickHouse/issues/80368): Skip indexes with lambda expressions could not be applied. Fix the case when high-level functions in the index definition exactly match the one in the query. [#80025](https://github.com/ClickHouse/ClickHouse/pull/80025) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#80980](https://github.com/ClickHouse/ClickHouse/issues/80980): Perform less strict metadata checks for RMT in the Replicated database. Closes [#80296](https://github.com/ClickHouse/ClickHouse/issues/80296). [#80298](https://github.com/ClickHouse/ClickHouse/pull/80298) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#88310](https://github.com/ClickHouse/ClickHouse/issues/88310): Fix `NOT_FOUND_COLUMN_IN_BLOCK` error caused by filter-push-down optimization of the logical JOIN sep in case `ON` expression is not a trivial equality. Fixes [#79647](https://github.com/ClickHouse/ClickHouse/issues/79647) Fixes [#77848](https://github.com/ClickHouse/ClickHouse/issues/77848). [#80360](https://github.com/ClickHouse/ClickHouse/pull/80360) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#84389](https://github.com/ClickHouse/ClickHouse/issues/84389): Fix rollback of Dynamic column on parsing failure. [#82169](https://github.com/ClickHouse/ClickHouse/pull/82169) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#83235](https://github.com/ClickHouse/ClickHouse/issues/83235): Fix performance degradation with the enabled analyzer when secondary queries always read all columns from the VIEWs. Fixes [#81718](https://github.com/ClickHouse/ClickHouse/issues/81718). [#83036](https://github.com/ClickHouse/ClickHouse/pull/83036) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#83195](https://github.com/ClickHouse/ClickHouse/issues/83195): Do not check for cyclic dependencies on create table with no dependencies. It fixes performance degradation of the use cases with creation of thousands of tables that was introduced in https://github.com/ClickHouse/ClickHouse/pull/65405. [#83077](https://github.com/ClickHouse/ClickHouse/pull/83077) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#83138](https://github.com/ClickHouse/ClickHouse/issues/83138): Do not use unrelated parts of a shared dictionary in the `lowCardinalityKeys` function. [#83118](https://github.com/ClickHouse/ClickHouse/pull/83118) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#83469](https://github.com/ClickHouse/ClickHouse/issues/83469): Fix possible crash in Variant type in UNION. [#83295](https://github.com/ClickHouse/ClickHouse/pull/83295) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#83760](https://github.com/ClickHouse/ClickHouse/issues/83760): Keeper fix: update total watch count correctly when ephemeral nodes are deleted on session close. [#83583](https://github.com/ClickHouse/ClickHouse/pull/83583) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#83739](https://github.com/ClickHouse/ClickHouse/issues/83739): Fix endless loop in estimateCompressionRatio() with block_size_bytes=0. [#83704](https://github.com/ClickHouse/ClickHouse/pull/83704) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#84135](https://github.com/ClickHouse/ClickHouse/issues/84135): Mask Avro schema registry authentication details to be not visible to user or in logs. [#83713](https://github.com/ClickHouse/ClickHouse/pull/83713) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* Backported in [#83953](https://github.com/ClickHouse/ClickHouse/issues/83953): Fix the issue where, if a MergeTree table is created with `add_minmax_index_for_numeric_columns=1` or `add_minmax_index_for_string_columns=1`, the index is later materialized during an ALTER operation, and it prevents the Replicated database from initializing correctly on a new replica. [#83751](https://github.com/ClickHouse/ClickHouse/pull/83751) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#85753](https://github.com/ClickHouse/ClickHouse/issues/85753): Fixed parquet writer outputting incorrect statistics (min/max) for Decimal types. [#83754](https://github.com/ClickHouse/ClickHouse/pull/83754) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#83871](https://github.com/ClickHouse/ClickHouse/issues/83871): Introduce backward compatibility setting to allow new analyzer to reference outer alias in WITH clause in the case of name clashes. Fixes [#82700](https://github.com/ClickHouse/ClickHouse/issues/82700). [#83797](https://github.com/ClickHouse/ClickHouse/pull/83797) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#84217](https://github.com/ClickHouse/ClickHouse/issues/84217): Allow referencing any table in `view(...)` argument of `remote` table function with enabled analyzer. Fixes [#78717](https://github.com/ClickHouse/ClickHouse/issues/78717). Fixes [#79377](https://github.com/ClickHouse/ClickHouse/issues/79377). [#83844](https://github.com/ClickHouse/ClickHouse/pull/83844) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#85790](https://github.com/ClickHouse/ClickHouse/issues/85790): Fix writing JSON paths with NULL values in RowBinary format. [#83923](https://github.com/ClickHouse/ClickHouse/pull/83923) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#84556](https://github.com/ClickHouse/ClickHouse/issues/84556): Fix deadlock caused by background cancellation checker thread. [#84203](https://github.com/ClickHouse/ClickHouse/pull/84203) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#84487](https://github.com/ClickHouse/ClickHouse/issues/84487): Fixed incorrect construction of empty tuples in the `array()` function. This fixes [#84202](https://github.com/ClickHouse/ClickHouse/issues/84202). [#84297](https://github.com/ClickHouse/ClickHouse/pull/84297) ([Amos Bird](https://github.com/amosbird)).
* Backported in [#84447](https://github.com/ClickHouse/ClickHouse/issues/84447): Make `zoutofmemory` hardware error, otherwise it will throw logical error. see https://github.com/clickhouse/clickhouse-core-incidents/issues/877. [#84420](https://github.com/ClickHouse/ClickHouse/pull/84420) ([Han Fei](https://github.com/hanfei1991)).
* Backported in [#86052](https://github.com/ClickHouse/ClickHouse/issues/86052): Fixed server crash when a user created with `no_password` attempts to login after the server setting `allow_no_password` was changed to 0. [#84426](https://github.com/ClickHouse/ClickHouse/pull/84426) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Backported in [#84648](https://github.com/ClickHouse/ClickHouse/issues/84648): Fix out-of-order writes to Keeper changelog. Previously, we could have in-flight writes to changelog, but rollback could cause concurrent change of the destination file. This would lead to inconsistent logs, and possible data loss. [#84434](https://github.com/ClickHouse/ClickHouse/pull/84434) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85308](https://github.com/ClickHouse/ClickHouse/issues/85308): Now if all TTL are removed from table MergeTree will do nothing related to TTL. [#84441](https://github.com/ClickHouse/ClickHouse/pull/84441) ([alesapin](https://github.com/alesapin)).
* Backported in [#85300](https://github.com/ClickHouse/ClickHouse/issues/85300): Fix ALTER MODIFY ORDER BY not validating TTL columns in sorting keys. TTL columns are now properly rejected when used in ORDER BY clauses during ALTER operations, preventing potential table corruption. [#84536](https://github.com/ClickHouse/ClickHouse/pull/84536) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Backported in [#84723](https://github.com/ClickHouse/ClickHouse/issues/84723): Lock 'mutex' when getting zookeeper from 'view' in RefreshTask. [#84699](https://github.com/ClickHouse/ClickHouse/pull/84699) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Backported in [#86608](https://github.com/ClickHouse/ClickHouse/issues/86608): Shutdown tables properly when recovering database replica. Improper shutdown would lead to LOGICAL_ERROR for some table engines during database replica recovery. [#84744](https://github.com/ClickHouse/ClickHouse/pull/84744) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#84989](https://github.com/ClickHouse/ClickHouse/issues/84989): Fix total watches count returned by Keeper. [#84890](https://github.com/ClickHouse/ClickHouse/pull/84890) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85152](https://github.com/ClickHouse/ClickHouse/issues/85152): Fixed double-free in `AzureIteratorAsync`. [#85064](https://github.com/ClickHouse/ClickHouse/pull/85064) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#85230](https://github.com/ClickHouse/ClickHouse/issues/85230): Fix `Not-ready Set` for `IN (subquery)` inside `additional_table_filters expression` setting. [#85210](https://github.com/ClickHouse/ClickHouse/pull/85210) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#85258](https://github.com/ClickHouse/ClickHouse/issues/85258): Get rid of unnecessary `getStatus()` calls during SYSTEM DROP REPLICA queries. Fixes the case when a table is dropped in the background, and the `Shutdown for storage is called` exception is thrown. [#85220](https://github.com/ClickHouse/ClickHouse/pull/85220) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#85498](https://github.com/ClickHouse/ClickHouse/issues/85498): Added missing table name length checks in CREATE OR REPLACE and RENAME queries. [#85326](https://github.com/ClickHouse/ClickHouse/pull/85326) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#85520](https://github.com/ClickHouse/ClickHouse/issues/85520): Fix backup of parts with broken projections. [#85362](https://github.com/ClickHouse/ClickHouse/pull/85362) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85613](https://github.com/ClickHouse/ClickHouse/issues/85613): Queries with parallel replicas which uses reading reverse in order optimization can produce incorrect result. [#85406](https://github.com/ClickHouse/ClickHouse/pull/85406) ([Igor Nikonov](https://github.com/devcrafter)).
* Backported in [#85693](https://github.com/ClickHouse/ClickHouse/issues/85693): Fix possible UB (crashes) in case of MEMORY_LIMIT_EXCEEDED during String deserialization. [#85440](https://github.com/ClickHouse/ClickHouse/pull/85440) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#85820](https://github.com/ClickHouse/ClickHouse/issues/85820): Fix incorrect metrics KafkaAssignedPartitions and KafkaConsumersWithAssignment. [#85494](https://github.com/ClickHouse/ClickHouse/pull/85494) ([Ilya Golshtein](https://github.com/ilejn)).
* Backported in [#85910](https://github.com/ClickHouse/ClickHouse/issues/85910): Fix secrets masking in icebergS3Cluster and icebergAzureCluster table functions. [#85658](https://github.com/ClickHouse/ClickHouse/pull/85658) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Backported in [#86106](https://github.com/ClickHouse/ClickHouse/issues/86106): Using `distributed_depth` as an indicator of *Cluster function was incorrect and may lead to data duplication; use `client_info.collaborate_with_initiator` instead. [#85734](https://github.com/ClickHouse/ClickHouse/pull/85734) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#85856](https://github.com/ClickHouse/ClickHouse/issues/85856): Fix possible inconsistency for dictionaries with update_field on MEMORY_LIMIT_EXCEEDED errors. [#85807](https://github.com/ClickHouse/ClickHouse/pull/85807) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#86263](https://github.com/ClickHouse/ClickHouse/issues/86263): Fix logical error on attempt to `CREATE ... AS (SELECT * FROM s3Cluster(...))` with `DatabaseReplicated`. [#85904](https://github.com/ClickHouse/ClickHouse/pull/85904) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#86951](https://github.com/ClickHouse/ClickHouse/issues/86951): Fix alter update of a column with a subcolumn used in other column materialized expression. Previously materialized column with subcolumn in its expression was not updated properly. [#85985](https://github.com/ClickHouse/ClickHouse/pull/85985) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86689](https://github.com/ClickHouse/ClickHouse/issues/86689): Forbid altering columns whose subcolumns are used in PK or partition expression. [#86005](https://github.com/ClickHouse/ClickHouse/pull/86005) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86193](https://github.com/ClickHouse/ClickHouse/issues/86193): Fix using wrong default values for path with Enum hint inside JSON. [#86065](https://github.com/ClickHouse/ClickHouse/pull/86065) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86342](https://github.com/ClickHouse/ClickHouse/issues/86342): Fix crash during ALTER UPDATE Nullable(JSON). [#86281](https://github.com/ClickHouse/ClickHouse/pull/86281) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86943](https://github.com/ClickHouse/ClickHouse/issues/86943): Fix cast from LowCardinality(Nullable(T)) to Dynamic. [#86365](https://github.com/ClickHouse/ClickHouse/pull/86365) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#86618](https://github.com/ClickHouse/ClickHouse/issues/86618): Ignore exceptions during flushing log on shutdown and make shutdown more safe (to avoid SIGSEGV). [#86546](https://github.com/ClickHouse/ClickHouse/pull/86546) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#86889](https://github.com/ClickHouse/ClickHouse/issues/86889): Fix missing chunk header when send_chunk_header is enabled and UDF is invoked via HTTP protocol. [#86606](https://github.com/ClickHouse/ClickHouse/pull/86606) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#87055](https://github.com/ClickHouse/ClickHouse/issues/87055): Fix writing NULL into JSON shared data in RowBinary input format and add some additional validations in ColumnObject. [#86812](https://github.com/ClickHouse/ClickHouse/pull/86812) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#87313](https://github.com/ClickHouse/ClickHouse/issues/87313): Fix TimeSeries engine table breaking creation of new replica in Replicated Database. [#86845](https://github.com/ClickHouse/ClickHouse/pull/86845) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#86857](https://github.com/ClickHouse/ClickHouse/issues/86857): Fix querying `system.distributed_ddl_queue` in cases where tasks are missing certain Keeper nodes. [#86848](https://github.com/ClickHouse/ClickHouse/pull/86848) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#87066](https://github.com/ClickHouse/ClickHouse/issues/87066): Correctly cast output of PREWHERE after splitting it into multiple steps. [#87040](https://github.com/ClickHouse/ClickHouse/pull/87040) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#87418](https://github.com/ClickHouse/ClickHouse/issues/87418): EmbeddedRocksDB: Path must be inside user_files. [#87109](https://github.com/ClickHouse/ClickHouse/pull/87109) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#87309](https://github.com/ClickHouse/ClickHouse/issues/87309): Fix KeeperMap tables created before 25.1, leaving data in ZooKeeper after the DROP query. [#87112](https://github.com/ClickHouse/ClickHouse/pull/87112) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#87635](https://github.com/ClickHouse/ClickHouse/issues/87635): Fixed incorrect accounting of temporary data deallocations in `max_temporary_data_on_disk_size` limit tracking, close [#87118](https://github.com/ClickHouse/ClickHouse/issues/87118). [#87140](https://github.com/ClickHouse/ClickHouse/pull/87140) ([JIaQi](https://github.com/JiaQiTang98)).
* Backported in [#87819](https://github.com/ClickHouse/ClickHouse/issues/87819): The function checkHeaders is now properly validating the provided headers and reject forbidden headers. Original author: Michael Anastasakis (@michael-anastasakis). [#87172](https://github.com/ClickHouse/ClickHouse/pull/87172) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#87473](https://github.com/ClickHouse/ClickHouse/issues/87473): Make pathStartsWith only match paths under the prefix. [#87181](https://github.com/ClickHouse/ClickHouse/pull/87181) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#87471](https://github.com/ClickHouse/ClickHouse/issues/87471): Ignore only not found errors for `s3_plain_rewritable` (which may lead to all sort of troubles). [#87426](https://github.com/ClickHouse/ClickHouse/pull/87426) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#88005](https://github.com/ClickHouse/ClickHouse/issues/88005): Fixes access validation on select and insert for Buffer tables. [#87545](https://github.com/ClickHouse/ClickHouse/pull/87545) ([pufit](https://github.com/pufit)).
* Backported in [#87767](https://github.com/ClickHouse/ClickHouse/issues/87767): Fixed a bug that might lead to overriding global server settings with SELECT settings of a View or Materialized View, if this view was dropped asynchronously and the server was restarted before finishing background cleanup. [#87603](https://github.com/ClickHouse/ClickHouse/pull/87603) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#88487](https://github.com/ClickHouse/ClickHouse/issues/88487): Fix for incorrect granules/partitions elimination for datetime-based keys, when using `session_timezone` setting in queries. [#87987](https://github.com/ClickHouse/ClickHouse/pull/87987) ([Eduard Karacharov](https://github.com/korowa)).
* Backported in [#88197](https://github.com/ClickHouse/ClickHouse/issues/88197): Fix possible uncaught exception while reading `system.tables` with invalid tables in external databases (`PostgreSQL`/`SQLite`/...) attached. [#88105](https://github.com/ClickHouse/ClickHouse/pull/88105) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#88282](https://github.com/ClickHouse/ClickHouse/issues/88282): Fixed propagation of `is_shared` flag in `ColumnLowCardinality`. It may lead to a wrong group-by result if a new value is inserted in a column after hash values are already pre-calculated and cached in the `ReverseIndex`. [#88213](https://github.com/ClickHouse/ClickHouse/pull/88213) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#88359](https://github.com/ClickHouse/ClickHouse/issues/88359): Avoid trying to initialize DataLake databases while accessing `system.projections` and `system.data_skipping_indices`. [#88330](https://github.com/ClickHouse/ClickHouse/pull/88330) ([Azat Khuzhin](https://github.com/azat)).

#### Build/Testing/Packaging Improvement
* Backported in [#88108](https://github.com/ClickHouse/ClickHouse/issues/88108): Use `postgres` 18.0. [#87647](https://github.com/ClickHouse/ClickHouse/pull/87647) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Backport [#83713](https://github.com/ClickHouse/ClickHouse/issues/83713) to 25.3: Hide avro schema registry auth in logs"'. [#84195](https://github.com/ClickHouse/ClickHouse/pull/84195) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* NO CL ENTRY:  'Revert "Revert "Backport [#83713](https://github.com/ClickHouse/ClickHouse/issues/83713) to 25.3: Hide avro schema registry auth in logs""'. [#84212](https://github.com/ClickHouse/ClickHouse/pull/84212) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* NO CL ENTRY:  'Fix output_format_parquet_date_as_uint16 backport to 25.3'. [#87864](https://github.com/ClickHouse/ClickHouse/pull/87864) ([Michael Kolupaev](https://github.com/al13n321)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#87747](https://github.com/ClickHouse/ClickHouse/issues/87747): Fix RMV tryEnqueueReplicatedDDL shutdown crash again. [#78873](https://github.com/ClickHouse/ClickHouse/pull/78873) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#83809](https://github.com/ClickHouse/ClickHouse/issues/83809): hold the temporary part lock when executeReplaceRange. [#83095](https://github.com/ClickHouse/ClickHouse/pull/83095) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#84061](https://github.com/ClickHouse/ClickHouse/issues/84061): `sccache` supports explicit server start. We should start it before the `ninja` build stage. [#83600](https://github.com/ClickHouse/ClickHouse/pull/83600) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Backported in [#83860](https://github.com/ClickHouse/ClickHouse/issues/83860): Allow concurrent tables creation when `max_database_replicated_create_table_thread_pool_size` setting is 0 (automatic pool size). [#83834](https://github.com/ClickHouse/ClickHouse/pull/83834) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Backported in [#84791](https://github.com/ClickHouse/ClickHouse/issues/84791): Previously, `FilterTransform` could stop reading if the expression for any chunk returned a constant `false`. This can lead to a bug, because constant columns are allowed to appear during the execution, and most function default implementations will preserve constants as well. [#83855](https://github.com/ClickHouse/ClickHouse/pull/83855) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#85589](https://github.com/ClickHouse/ClickHouse/issues/85589): Fix parquet writer outputting incorrect row indices in offset index. [#83876](https://github.com/ClickHouse/ClickHouse/pull/83876) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#84359](https://github.com/ClickHouse/ClickHouse/issues/84359): Fix test_storage_rabbitmq timeouts. [#84234](https://github.com/ClickHouse/ClickHouse/pull/84234) ([Pablo Marcos](https://github.com/pamarcos)).
* Backported in [#85278](https://github.com/ClickHouse/ClickHouse/issues/85278): Avoid some copies in Keeper. [#85131](https://github.com/ClickHouse/ClickHouse/pull/85131) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#85830](https://github.com/ClickHouse/ClickHouse/issues/85830): Add compatibility setting to write Date as UInt16 to parquet files. [#85510](https://github.com/ClickHouse/ClickHouse/pull/85510) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#86678](https://github.com/ClickHouse/ClickHouse/issues/86678): Check feature flag when adding RemoveRecursive request to Multi. [#86554](https://github.com/ClickHouse/ClickHouse/pull/86554) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#87495](https://github.com/ClickHouse/ClickHouse/issues/87495): EmbeddedRocksDB: Go back to using data/ path by default. [#87463](https://github.com/ClickHouse/ClickHouse/pull/87463) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#87855](https://github.com/ClickHouse/ClickHouse/issues/87855): Don't crash if a vector similarity index cannot be saved to / loaded from persistence. [#87803](https://github.com/ClickHouse/ClickHouse/pull/87803) ([Azat Khuzhin](https://github.com/azat)).

