---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.3.4.190-lts (93636ae3130) FIXME as compared to v25.3.3.42-lts (c4bfe68b052)

#### Performance Improvement
* Backported in [#79660](https://github.com/ClickHouse/ClickHouse/issues/79660): Introduced threshold (regulated by setting `parallel_hash_join_threshold`) to fall back to the `hash` algorithm when the size of the right table is below the threshold. [#76185](https://github.com/ClickHouse/ClickHouse/pull/76185) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#79922](https://github.com/ClickHouse/ClickHouse/issues/79922): Prevent `LogSeriesLimiter` from doing cleanup on every construction, avoiding lock contention and performance regressions in high-concurrency scenarios. [#79864](https://github.com/ClickHouse/ClickHouse/pull/79864) ([filimonov](https://github.com/filimonov)).
* Backported in [#81857](https://github.com/ClickHouse/ClickHouse/issues/81857): Avoid unnecessary update and reduce lock contention in QueryConditionCache. [#80247](https://github.com/ClickHouse/ClickHouse/pull/80247) ([Jiebin Sun](https://github.com/jiebinn)).
* Backported in [#81757](https://github.com/ClickHouse/ClickHouse/issues/81757): Fixed performance regression in memory tracking. [#81694](https://github.com/ClickHouse/ClickHouse/pull/81694) ([Michael Kolupaev](https://github.com/al13n321)).

#### Improvement
* Backported in [#79902](https://github.com/ClickHouse/ClickHouse/issues/79902): Added `access_control_improvements.enable_user_name_access_type` setting. This setting allows enabling/disabling of precise grants for users/roles, introduced in https://github.com/ClickHouse/ClickHouse/pull/72246. You may want to turn this setting off in case you have a cluster with the replicas older than 25.1. [#79842](https://github.com/ClickHouse/ClickHouse/pull/79842) ([pufit](https://github.com/pufit)).
* Backported in [#79932](https://github.com/ClickHouse/ClickHouse/issues/79932): Proper implementation of `ASTSelectWithUnionQuery::clone()` method now takes into account `is_normalized` field as well. This might help with [#77569](https://github.com/ClickHouse/ClickHouse/issues/77569). [#79909](https://github.com/ClickHouse/ClickHouse/pull/79909) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Backported in [#81379](https://github.com/ClickHouse/ClickHouse/issues/81379): Update `c-ares` to `v1.34.5`. [#81159](https://github.com/ClickHouse/ClickHouse/pull/81159) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#81377](https://github.com/ClickHouse/ClickHouse/issues/81377): Upgrade curl to 8.14 to address CVE-2025-5025 and CVE-2025-4947. [#81171](https://github.com/ClickHouse/ClickHouse/pull/81171) ([larryluogit](https://github.com/larryluogit)).
* Backported in [#81226](https://github.com/ClickHouse/ClickHouse/issues/81226): Upgrade libarchive to 3.7.9 to address: CVE-2024-20696 CVE-2025-25724 CVE-2024-48958 CVE-2024-57970 CVE-2025-1632 CVE-2024-48957 CVE-2024-48615. [#81174](https://github.com/ClickHouse/ClickHouse/pull/81174) ([larryluogit](https://github.com/larryluogit)).
* Backported in [#81534](https://github.com/ClickHouse/ClickHouse/issues/81534): Upgrade libxml2 to 2.14.3. [#81187](https://github.com/ClickHouse/ClickHouse/pull/81187) ([larryluogit](https://github.com/larryluogit)).
* Backported in [#81313](https://github.com/ClickHouse/ClickHouse/issues/81313): MemoryResidentWithoutPageCache provides the amount of physical memory used by the server process, excluding userspace page cache, in bytes. This provides a more accurate view of actual memory usage when userspace page cache is utilized. When userspace page cache is disabled, this value equals MemoryResident. [#81233](https://github.com/ClickHouse/ClickHouse/pull/81233) ([Jayme Bird](https://github.com/jaymebrd)).
* Backported in [#81407](https://github.com/ClickHouse/ClickHouse/issues/81407): In filesystem with journal `mkdir` is written to the journal of filesystem which is persisted to disk. In case of slow disk this can take long time. Definitely make sense to move out from reserve lock scope. [#81371](https://github.com/ClickHouse/ClickHouse/pull/81371) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#81617](https://github.com/ClickHouse/ClickHouse/issues/81617): Use `postgres` 16.9. [#81437](https://github.com/ClickHouse/ClickHouse/pull/81437) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#81491](https://github.com/ClickHouse/ClickHouse/issues/81491): Use `openssl` 3.2.4. [#81438](https://github.com/ClickHouse/ClickHouse/pull/81438) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#81688](https://github.com/ClickHouse/ClickHouse/issues/81688): Use `abseil-cpp` 2025-01-27. [#81440](https://github.com/ClickHouse/ClickHouse/pull/81440) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#81721](https://github.com/ClickHouse/ClickHouse/issues/81721): Use `mongo-c-driver` 1.30.4. [#81449](https://github.com/ClickHouse/ClickHouse/pull/81449) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#81484](https://github.com/ClickHouse/ClickHouse/issues/81484): Use `krb5` 1.21.3-final. [#81453](https://github.com/ClickHouse/ClickHouse/pull/81453) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Backported in [#81799](https://github.com/ClickHouse/ClickHouse/issues/81799): Add profile event `PageCacheReadBytes`. [#81742](https://github.com/ClickHouse/ClickHouse/pull/81742) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#81928](https://github.com/ClickHouse/ClickHouse/issues/81928): Try fix logical error in filesystem cache: "Having zero bytes but range is not finished". [#81868](https://github.com/ClickHouse/ClickHouse/pull/81868) ([Kseniia Sumarokova](https://github.com/kssenii)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#80474](https://github.com/ClickHouse/ClickHouse/issues/80474): Analyzer: Fix column projection name after column type promotion in join. Closes [#63345](https://github.com/ClickHouse/ClickHouse/issues/63345). [#63519](https://github.com/ClickHouse/ClickHouse/pull/63519) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#81724](https://github.com/ClickHouse/ClickHouse/issues/81724): Fix CTE usage in pushed-down predicates when `allow_push_predicate_ast_for_distributed_subqueries` is enabled. Fixes [#75647](https://github.com/ClickHouse/ClickHouse/issues/75647). Fixes [#79672](https://github.com/ClickHouse/ClickHouse/issues/79672). [#77316](https://github.com/ClickHouse/ClickHouse/pull/77316) ([Dmitry Novik](https://github.com/novikd)).
* Backported in [#80698](https://github.com/ClickHouse/ClickHouse/issues/80698): Fix sending constant values to remote for some types. [#77634](https://github.com/ClickHouse/ClickHouse/pull/77634) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#79784](https://github.com/ClickHouse/ClickHouse/issues/79784): Fixed refreshable materialized views breaking backups. [#77893](https://github.com/ClickHouse/ClickHouse/pull/77893) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#79485](https://github.com/ClickHouse/ClickHouse/issues/79485): Fix old firing logical error for `transform`. [#78247](https://github.com/ClickHouse/ClickHouse/pull/78247) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Backported in [#79211](https://github.com/ClickHouse/ClickHouse/issues/79211): Fix delta-kernel auth options. [#78255](https://github.com/ClickHouse/ClickHouse/pull/78255) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#79796](https://github.com/ClickHouse/ClickHouse/issues/79796): In storage S3Queue fix logical error "Cannot unregister: table uuid is not registered". Closes [#78285](https://github.com/ClickHouse/ClickHouse/issues/78285). [#78541](https://github.com/ClickHouse/ClickHouse/pull/78541) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#79500](https://github.com/ClickHouse/ClickHouse/issues/79500): ```sql CREATE TABLE t0 ( key Int32, value Int32 ) ENGINE=MergeTree() PRIMARY KEY key PARTITION BY key % 2;. [#78593](https://github.com/ClickHouse/ClickHouse/pull/78593) ([Vlad](https://github.com/codeworse)).
* Backported in [#78916](https://github.com/ClickHouse/ClickHouse/issues/78916): Keeper fix: fix ephemeral count in all cases. [#78799](https://github.com/ClickHouse/ClickHouse/pull/78799) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#79433](https://github.com/ClickHouse/ClickHouse/issues/79433): Fixes a bug where arrayUnion() returned extra (incorrect) values on tables that had batch inserts. Fixes [#79157](https://github.com/ClickHouse/ClickHouse/issues/79157). [#79158](https://github.com/ClickHouse/ClickHouse/pull/79158) ([Peter Nguyen](https://github.com/petern48)).
* Backported in [#80464](https://github.com/ClickHouse/ClickHouse/issues/80464): Try to use IColumn instead of Field in SingleValueDataGeneric. It fixes the incorrect return values for some aggregate functions like `argMax` for types `Dynamic/Variant/JSON`. [#79166](https://github.com/ClickHouse/ClickHouse/pull/79166) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81241](https://github.com/ClickHouse/ClickHouse/issues/81241): Forbid Dynamic and JSON types in IN. With current implementation of `IN` it can lead to incorrect results. Proper support of this types in `IN` is complicated and can be done in future. [#79282](https://github.com/ClickHouse/ClickHouse/pull/79282) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#79605](https://github.com/ClickHouse/ClickHouse/issues/79605): Fix loading of plain_rewritable disks containing data. [#79439](https://github.com/ClickHouse/ClickHouse/pull/79439) ([Julia Kartseva](https://github.com/jkartseva)).
* Backported in [#79739](https://github.com/ClickHouse/ClickHouse/issues/79739): Fix crash in dynamic subcolumns discovery in Wide parts in MergeTree. [#79466](https://github.com/ClickHouse/ClickHouse/pull/79466) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#79754](https://github.com/ClickHouse/ClickHouse/issues/79754): Verify the table name's length only for initial create queries. Do not verify this for secondary creates to avoid backward compatibility issues. [#79488](https://github.com/ClickHouse/ClickHouse/pull/79488) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Backported in [#79523](https://github.com/ClickHouse/ClickHouse/issues/79523): Fixed error `Block structure mismatch` in several cases with tables with sparse columns. [#79491](https://github.com/ClickHouse/ClickHouse/pull/79491) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#79614](https://github.com/ClickHouse/ClickHouse/issues/79614): Fix result duplication when reading from remote with both `use_hedged_requests` and `allow_experimental_parallel_reading_from_replicas` disabled. [#79599](https://github.com/ClickHouse/ClickHouse/pull/79599) ([Eduard Karacharov](https://github.com/korowa)).
* Backported in [#80047](https://github.com/ClickHouse/ClickHouse/issues/80047): Fixes the result of SQL function `formatDateTime` if a variable-size formatter (e.g. `%W` aka. weekday `Monday` `Tuesday`, etc.) is followed by a compound formatter (a formatter that prints multiple components at once, e.g. `%D` aka. the American date `05/04/25`). [#79835](https://github.com/ClickHouse/ClickHouse/pull/79835) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#80529](https://github.com/ClickHouse/ClickHouse/issues/80529): Fix the sorting order of the NaNs with a negative sign bit. [#79847](https://github.com/ClickHouse/ClickHouse/pull/79847) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Backported in [#81621](https://github.com/ClickHouse/ClickHouse/issues/81621): Disabling hive partitioning for datalakes Partially addresses https://github.com/issues/assigned?issue=ClickHouse%7CClickHouse%7C79937. [#80005](https://github.com/ClickHouse/ClickHouse/pull/80005) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#80076](https://github.com/ClickHouse/ClickHouse/issues/80076): Allow materialized views with UNIONs to work correctly on new replicas. [#80037](https://github.com/ClickHouse/ClickHouse/pull/80037) ([Samay Sharma](https://github.com/samay-sharma)).
* Backported in [#80193](https://github.com/ClickHouse/ClickHouse/issues/80193): Fix warnings `Cannot find 'kernel' in '[...]/memory.stat'` in ClickHouse's log (issue [#77410](https://github.com/ClickHouse/ClickHouse/issues/77410)). [#80129](https://github.com/ClickHouse/ClickHouse/pull/80129) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#80454](https://github.com/ClickHouse/ClickHouse/issues/80454): Fix logical error in Arrow format with LowCardinality(FixedString). [#80156](https://github.com/ClickHouse/ClickHouse/pull/80156) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#80628](https://github.com/ClickHouse/ClickHouse/issues/80628): Fix reading subcolumns from Merge engine. [#80158](https://github.com/ClickHouse/ClickHouse/pull/80158) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#80321](https://github.com/ClickHouse/ClickHouse/issues/80321): Fix incorrect count optimization for string prefix filters like LIKE 'ab_c%' when using implicit projections. This fixes [#80250](https://github.com/ClickHouse/ClickHouse/issues/80250). [#80261](https://github.com/ClickHouse/ClickHouse/pull/80261) ([Amos Bird](https://github.com/amosbird)).
* Backported in [#80400](https://github.com/ClickHouse/ClickHouse/issues/80400): Fix text representation of DateTime and DateTime64 for PostgreSQL storage. [#80301](https://github.com/ClickHouse/ClickHouse/pull/80301) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Backported in [#80974](https://github.com/ClickHouse/ClickHouse/issues/80974): Disable filter-push-down for the predicate with a non-deterministic function in case the query plan step changes the number of rows. Fixes [#40273](https://github.com/ClickHouse/ClickHouse/issues/40273). [#80329](https://github.com/ClickHouse/ClickHouse/pull/80329) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#80837](https://github.com/ClickHouse/ClickHouse/issues/80837): Fix possible logical errors and crashes in projections with subcolumns. [#80333](https://github.com/ClickHouse/ClickHouse/pull/80333) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#80560](https://github.com/ClickHouse/ClickHouse/issues/80560): Fixed refreshable materialized view DROP getting stuck if the view was paused using SYSTEM STOP REPLICATED VIEW. [#80543](https://github.com/ClickHouse/ClickHouse/pull/80543) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#80892](https://github.com/ClickHouse/ClickHouse/issues/80892): Fix 'Cannot find column' with constant tuple in distributed query. [#80596](https://github.com/ClickHouse/ClickHouse/pull/80596) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Backported in [#81287](https://github.com/ClickHouse/ClickHouse/issues/81287): Fix incorrect result during reading column that exists in subset of tables in Merge engine. [#80643](https://github.com/ClickHouse/ClickHouse/pull/80643) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#80751](https://github.com/ClickHouse/ClickHouse/issues/80751): Fix possible crash in case of dictionary registration failed (when `CREATE DICTIONARY` failed with `CANNOT_SCHEDULE_TASK` it is possible to leave dangling pointer in the dictionary registry, which later lead to crash). [#80714](https://github.com/ClickHouse/ClickHouse/pull/80714) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#81139](https://github.com/ClickHouse/ClickHouse/issues/81139): Fix wrong result type of comparison functions with Tuple(Dynamic) and String that led to logical error. [#80728](https://github.com/ClickHouse/ClickHouse/pull/80728) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#82183](https://github.com/ClickHouse/ClickHouse/issues/82183): Fix logical error during materialize projection when column type was changed to Nullable. [#80741](https://github.com/ClickHouse/ClickHouse/pull/80741) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#80897](https://github.com/ClickHouse/ClickHouse/issues/80897): Fix `THERE_IS_NO_COLUMN` error for distributed queries with `IN cte`. Fixes [#75032](https://github.com/ClickHouse/ClickHouse/issues/75032). [#80757](https://github.com/ClickHouse/ClickHouse/pull/80757) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#80968](https://github.com/ClickHouse/ClickHouse/issues/80968): Fix excessive number of files (leads to excessive memory usage) for external ORDER BY. [#80777](https://github.com/ClickHouse/ClickHouse/pull/80777) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#81112](https://github.com/ClickHouse/ClickHouse/issues/81112): Fix crash in Kafka due to get_member_id() was creating std::string from NULL (it was likely an issue only in case of connection to broker had been failed). [#80793](https://github.com/ClickHouse/ClickHouse/pull/80793) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#80908](https://github.com/ClickHouse/ClickHouse/issues/80908): Properly wait consumers before shutting down Kafka engine (active consumers after shutdown can trigger various debug assertions and also may read data from brokers in background after table has been dropped/detached). [#80795](https://github.com/ClickHouse/ClickHouse/pull/80795) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#81057](https://github.com/ClickHouse/ClickHouse/issues/81057): Fix wrong partitioning with nullable partition key. [#80913](https://github.com/ClickHouse/ClickHouse/pull/80913) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Backported in [#81946](https://github.com/ClickHouse/ClickHouse/issues/81946): Fix `Table does not exist` error for distributed queries with pushed-down predicate (`allow_push_predicate_ast_for_distributed_subqueries=1`) when the source table does not exist on the initialtor. Fixes [#77281](https://github.com/ClickHouse/ClickHouse/issues/77281). [#80915](https://github.com/ClickHouse/ClickHouse/pull/80915) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#81095](https://github.com/ClickHouse/ClickHouse/issues/81095): Fix the logical error in the nested functions with named windows. [#80926](https://github.com/ClickHouse/ClickHouse/pull/80926) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Backported in [#80999](https://github.com/ClickHouse/ClickHouse/issues/80999): Fix extremes for nullable and floating-point columns. [#80970](https://github.com/ClickHouse/ClickHouse/pull/80970) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Backported in [#81013](https://github.com/ClickHouse/ClickHouse/issues/81013): Fix possible crash while querying from system.tables (likely the case under memory pressure). [#80976](https://github.com/ClickHouse/ClickHouse/pull/80976) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#81006](https://github.com/ClickHouse/ClickHouse/issues/81006): Fix atomic rename with truncate for files which compression is inferred from their file extension. [#80979](https://github.com/ClickHouse/ClickHouse/pull/80979) ([Pablo Marcos](https://github.com/pamarcos)).
* Backported in [#81276](https://github.com/ClickHouse/ClickHouse/issues/81276): Fix parsing of DateTime64 from integers in JSONExtract and JSON type parsing. [#81050](https://github.com/ClickHouse/ClickHouse/pull/81050) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81151](https://github.com/ClickHouse/ClickHouse/issues/81151): Reflect date_time_input_format setting in schema inference cache. [#81052](https://github.com/ClickHouse/ClickHouse/pull/81052) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#81203](https://github.com/ClickHouse/ClickHouse/issues/81203): Fixed `Too large size ... passed to allocator` errors or possible crashes on inserts via http protocol with text formats (`JSON`, `Values`, ...) and omitted `Enum` fields. [#81145](https://github.com/ClickHouse/ClickHouse/pull/81145) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#82012](https://github.com/ClickHouse/ClickHouse/issues/82012): Fix `Unknown table expression identifier` for `distributed_product_mode_local=local` with cross-replication. [#81162](https://github.com/ClickHouse/ClickHouse/pull/81162) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#81339](https://github.com/ClickHouse/ClickHouse/issues/81339): Fixed clickhouse-local crashing when outputting const tuples or maps in Parquet format. [#81249](https://github.com/ClickHouse/ClickHouse/pull/81249) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#81364](https://github.com/ClickHouse/ClickHouse/issues/81364): Fix some corner case in query that joins empty tables and uses window functions. The bug leads to exploding number of parallel streams which leads to OOMs. [#81299](https://github.com/ClickHouse/ClickHouse/pull/81299) ([Alexander Gololobov](https://github.com/davenger)).
* Backported in [#81542](https://github.com/ClickHouse/ClickHouse/issues/81542): Fix region error in delta-kernel. Fixes [#79914](https://github.com/ClickHouse/ClickHouse/issues/79914). [#81353](https://github.com/ClickHouse/ClickHouse/pull/81353) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#82173](https://github.com/ClickHouse/ClickHouse/issues/82173): Don't validate experimental/suspicious types in default/materialize expression execution during reading from existing table. [#81618](https://github.com/ClickHouse/ClickHouse/pull/81618) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#82122](https://github.com/ClickHouse/ClickHouse/issues/82122): Fix "Context has expired" during merges when dict used in TTL expression. [#81690](https://github.com/ClickHouse/ClickHouse/pull/81690) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#81844](https://github.com/ClickHouse/ClickHouse/issues/81844): Fix crash in `ConcurrentHashJoin` with empty `USING ()` and old analyzer enabled. [#81754](https://github.com/ClickHouse/ClickHouse/pull/81754) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#81905](https://github.com/ClickHouse/ClickHouse/issues/81905): Keeper fix: block commits of new logs if there is invalid entry in the logs. Previously, if leader applied some logs incorrectly, it would continue to commit new logs, even though the follower would detect digest mismatch and abort. [#81780](https://github.com/ClickHouse/ClickHouse/pull/81780) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#82322](https://github.com/ClickHouse/ClickHouse/issues/82322): In previous versions, the server returned excessive content for requests to `/js`. This closes [#61890](https://github.com/ClickHouse/ClickHouse/issues/61890). [#81895](https://github.com/ClickHouse/ClickHouse/pull/81895) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Build/Testing/Packaging Improvement
* Backported in [#81626](https://github.com/ClickHouse/ClickHouse/issues/81626): Bump `minizip-ng` to `4.0.9`. [#78917](https://github.com/ClickHouse/ClickHouse/pull/78917) ([Konstantin Bogdanov](https://github.com/thevar1able)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#79751](https://github.com/ClickHouse/ClickHouse/issues/79751): Improvement for system.filesystem_cache. [#78463](https://github.com/ClickHouse/ClickHouse/pull/78463) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#79810](https://github.com/ClickHouse/ClickHouse/issues/79810): Better introspection for index analysis performance. [#79347](https://github.com/ClickHouse/ClickHouse/pull/79347) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#79621](https://github.com/ClickHouse/ClickHouse/issues/79621): Avoid cache calculation for deduplication when deduplication is off. [#79596](https://github.com/ClickHouse/ClickHouse/pull/79596) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#79692](https://github.com/ClickHouse/ClickHouse/issues/79692): Make [#76185](https://github.com/ClickHouse/ClickHouse/issues/76185) backportable. [#79665](https://github.com/ClickHouse/ClickHouse/pull/79665) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#79707](https://github.com/ClickHouse/ClickHouse/issues/79707): refine the exception message when keeper reaches soft memory limit. [#79670](https://github.com/ClickHouse/ClickHouse/pull/79670) ([Han Fei](https://github.com/hanfei1991)).
* Backported in [#80271](https://github.com/ClickHouse/ClickHouse/issues/80271): Fix flaky test_refreshable_mv/test.py::test_adding_replica. [#79940](https://github.com/ClickHouse/ClickHouse/pull/79940) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#81125](https://github.com/ClickHouse/ClickHouse/issues/81125): Fix Data Lake tests concurrent run. [#80386](https://github.com/ClickHouse/ClickHouse/pull/80386) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#80520](https://github.com/ClickHouse/ClickHouse/issues/80520): Fixing creating live and window view creation with populating, it is broken after pr 79596. [#80471](https://github.com/ClickHouse/ClickHouse/pull/80471) ([Sema Checherinda](https://github.com/CheSema)).
* Backported in [#81120](https://github.com/ClickHouse/ClickHouse/issues/81120): tests: temporary disable 03522_storage_kafka_shutdown_smoke to suppress data-race in cJSON. [#80949](https://github.com/ClickHouse/ClickHouse/pull/80949) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#81730](https://github.com/ClickHouse/ClickHouse/issues/81730): Fix CVE-2023-0286 / CVE-2023-5678. [#81672](https://github.com/ClickHouse/ClickHouse/pull/81672) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#81771](https://github.com/ClickHouse/ClickHouse/issues/81771): Fix: `appendRemovalTIDToVersionMetadata` for covered_parts in `MergeTreeTransaction::addNewPartAndRemoveCovered `so that there is a removal_id in the transaction metadata file even when it is removed without a transaction. Hence, when restarting, it can load the outdated parts successfully without triggering: ``` Logical error: \'Data part 202410_1_42_8 is Outdated and has creation TID (94, 40, 3ce64a6c-c10e-4c02-8891-47977f2b6a1a) and CSN 95, but does not have removal tid. It\'s a bug or a result of manual intervention.\'. ```. [#81734](https://github.com/ClickHouse/ClickHouse/pull/81734) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Backported in [#81764](https://github.com/ClickHouse/ClickHouse/issues/81764): Fix abseil build. [#81750](https://github.com/ClickHouse/ClickHouse/pull/81750) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Backported in [#82210](https://github.com/ClickHouse/ClickHouse/issues/82210): Follow up to [#81868](https://github.com/ClickHouse/ClickHouse/issues/81868). [#82163](https://github.com/ClickHouse/ClickHouse/pull/82163) ([Kseniia Sumarokova](https://github.com/kssenii)).

