---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.10.2.65-stable (4ff630944f8) FIXME as compared to v25.10.1.3832-stable (f95c1af632a)

#### Backward Incompatible Change
* Backported in [#89358](https://github.com/ClickHouse/ClickHouse/issues/89358): `PlainRewritable` disks store their file system tree in memory. If another disk changes the object storage structure, the in-memory structure will not be updated, which will lead to invalid file system operations and possible no such key errors. [#89038](https://github.com/ClickHouse/ClickHouse/pull/89038) ([Mikhail Artemenko](https://github.com/Michicosun)).

#### Performance Improvement
* Backported in [#89506](https://github.com/ClickHouse/ClickHouse/issues/89506): Queries can now benefit from optimize_read_in_order and query_plan_optimize_lazy_materialization simultaneously. Resolves [#88767](https://github.com/ClickHouse/ClickHouse/issues/88767). [#88866](https://github.com/ClickHouse/ClickHouse/pull/88866) ([Manuel](https://github.com/raimannma)).

#### Improvement
* Backported in [#89650](https://github.com/ClickHouse/ClickHouse/issues/89650): Add cache for bcrypt authentication. [#87115](https://github.com/ClickHouse/ClickHouse/pull/87115) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#89425](https://github.com/ClickHouse/ClickHouse/issues/89425): Subqueries which take part inside IN expressions when querying Iceberg table will be precomputed in the right way before partition pruning analysis. [#89177](https://github.com/ClickHouse/ClickHouse/pull/89177) ([Daniil Ivanik](https://github.com/divanik)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#89578](https://github.com/ClickHouse/ClickHouse/issues/89578): Fix reading mixed array of Floats and Bools in JSON. Previously inserting such data led to an exception. [#88008](https://github.com/ClickHouse/ClickHouse/pull/88008) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#89508](https://github.com/ClickHouse/ClickHouse/issues/89508): Fix logical error in cross join reordering when query_plan_optimize_join_order_limit > 1, Close [#89409](https://github.com/ClickHouse/ClickHouse/issues/89409). [#88286](https://github.com/ClickHouse/ClickHouse/pull/88286) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#89673](https://github.com/ClickHouse/ClickHouse/issues/89673): Fix [#88426](https://github.com/ClickHouse/ClickHouse/issues/88426) 1. Disallow explicit column definitions in Alias and columns are automatically load from the target table. This ensures that the alias always matches the target table's schema. 2. Proxy more methods from the IStorage. [#88552](https://github.com/ClickHouse/ClickHouse/pull/88552) ([Kai Zhu](https://github.com/nauu)).
* Backported in [#89446](https://github.com/ClickHouse/ClickHouse/issues/89446): Fix possible "Context has expired" with new analyzer with subqueries. [#88694](https://github.com/ClickHouse/ClickHouse/pull/88694) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#89466](https://github.com/ClickHouse/ClickHouse/issues/89466): Fix propagation of size restrictions by settings max_table_size_to_drop and max_partition_size_to_drop on DROP of inner tables. [#88812](https://github.com/ClickHouse/ClickHouse/pull/88812) ([Nikolay Degterinsky](https://github.com/evillique)).
* Backported in [#89716](https://github.com/ClickHouse/ClickHouse/issues/89716): Fix icebergS3Cluster protocol. Started supporting schema evolution, positional and equality deletes in iceberg cluster function. Resolves [#88287](https://github.com/ClickHouse/ClickHouse/issues/88287). [#88919](https://github.com/ClickHouse/ClickHouse/pull/88919) ([Yang Jiang](https://github.com/Ted-Jiang)).
* Backported in [#89438](https://github.com/ClickHouse/ClickHouse/issues/89438): Fix LOGICAL_ERROR in L2DistanceTransposed(vec1, vec2, p) where the optimization for partial QBit reading incorrectly removed Nullable from the return type when p was LowCardinality(Nullable(T)). Resolves [#88362](https://github.com/ClickHouse/ClickHouse/issues/88362). [#89397](https://github.com/ClickHouse/ClickHouse/pull/89397) ([Raufs Dunamalijevs](https://github.com/rienath)).
* Backported in [#89449](https://github.com/ClickHouse/ClickHouse/issues/89449): Fix loading tables with incorrect sparse serialization for tuple itself (that is written by older ClickHouse versions). [#89405](https://github.com/ClickHouse/ClickHouse/pull/89405) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#89487](https://github.com/ClickHouse/ClickHouse/issues/89487): Fixed incorrect merge handling of TTL-emptied parts with non-empty projections when using `deduplicate_merge_projection_mode='ignore'`. Resolves [#89430](https://github.com/ClickHouse/ClickHouse/issues/89430). [#89458](https://github.com/ClickHouse/ClickHouse/pull/89458) ([Amos Bird](https://github.com/amosbird)).
* Backported in [#89570](https://github.com/ClickHouse/ClickHouse/issues/89570): Fix reading of changelogs during Keeper startup in cases a changelog was not renamed properly during rotation. [#89496](https://github.com/ClickHouse/ClickHouse/pull/89496) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#89633](https://github.com/ClickHouse/ClickHouse/issues/89633): Fix incorrect JOIN results when using OR conditions with unique right table keys. Resolves [#89391](https://github.com/ClickHouse/ClickHouse/issues/89391). [#89512](https://github.com/ClickHouse/ClickHouse/pull/89512) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#89595](https://github.com/ClickHouse/ClickHouse/issues/89595): Fix possible "Context has expired" with analyzer and PK IN (subquery) (v2). Fixes [#89433](https://github.com/ClickHouse/ClickHouse/issues/89433). [#89527](https://github.com/ClickHouse/ClickHouse/pull/89527) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#89688](https://github.com/ClickHouse/ClickHouse/issues/89688): Fix a crash in case if a state of an aggregate function contains a serialized value of a column of LowCardinality(String). [#89550](https://github.com/ClickHouse/ClickHouse/pull/89550) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#89678](https://github.com/ClickHouse/ClickHouse/issues/89678): Add runtime filters only for supported join algorithms i.e. hash joins. A filter can only be built when join algorithm first fully reads the right side and then reads the left side, but FullSortingMergeJoin for example reads both sides simultaneously. Fixes [#89220](https://github.com/ClickHouse/ClickHouse/issues/89220). [#89652](https://github.com/ClickHouse/ClickHouse/pull/89652) ([Alexander Gololobov](https://github.com/davenger)).
* Backported in [#89699](https://github.com/ClickHouse/ClickHouse/issues/89699): Fix logical error/crash with join runtime filter in some cases. Fixes [#89062](https://github.com/ClickHouse/ClickHouse/issues/89062). [#89666](https://github.com/ClickHouse/ClickHouse/pull/89666) ([Alexander Gololobov](https://github.com/davenger)).

#### NO CL CATEGORY

* Backported in [#89626](https://github.com/ClickHouse/ClickHouse/issues/89626):. [#89581](https://github.com/ClickHouse/ClickHouse/pull/89581) ([Vladimir Cherkasov](https://github.com/vdimir)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#89522](https://github.com/ClickHouse/ClickHouse/issues/89522): Fix potential heap-use-after-free in projections analysis after [#72102](https://github.com/ClickHouse/ClickHouse/issues/72102). [#89139](https://github.com/ClickHouse/ClickHouse/pull/89139) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#89252](https://github.com/ClickHouse/ClickHouse/issues/89252): Fix settings changes history. [#89224](https://github.com/ClickHouse/ClickHouse/pull/89224) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#89355](https://github.com/ClickHouse/ClickHouse/issues/89355): Better docs for some merge tree settings. [#89330](https://github.com/ClickHouse/ClickHouse/pull/89330) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#89393](https://github.com/ClickHouse/ClickHouse/issues/89393): ci: skip debug-symbol tests when debug symbols are missing. [#89364](https://github.com/ClickHouse/ClickHouse/pull/89364) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#89418](https://github.com/ClickHouse/ClickHouse/issues/89418): Revert "Do not perform PrimaryKeyExpand step if skip index is already part of primary key". [#89395](https://github.com/ClickHouse/ClickHouse/pull/89395) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Fix settings changes. [#89529](https://github.com/ClickHouse/ClickHouse/pull/89529) ([Pavel Kruglov](https://github.com/Avogar)).
* Ci add stateless tests to 25.10. [#89648](https://github.com/ClickHouse/ClickHouse/pull/89648) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#89786](https://github.com/ClickHouse/ClickHouse/issues/89786): Speed up test_refreshable_mv_skip_old_temp_table_ddls. [#89692](https://github.com/ClickHouse/ClickHouse/pull/89692) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Backported in [#89732](https://github.com/ClickHouse/ClickHouse/issues/89732): CI: Fix functional tests local run with praktika. [#89724](https://github.com/ClickHouse/ClickHouse/pull/89724) ([Max Kainov](https://github.com/maxknv)).
* Backported in [#89745](https://github.com/ClickHouse/ClickHouse/issues/89745): CI: Support --count in functional tests with praktika. [#89735](https://github.com/ClickHouse/ClickHouse/pull/89735) ([Max Kainov](https://github.com/maxknv)).

