---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.10.1.3832-stable (f95c1af632a) FIXME as compared to v25.10.1.1-new (5b1dfb14925)

#### Backward Incompatible Change
* Changed default `schema_inference_make_columns_nullable` setting to respect column `Nullable`-ness information from Parquet/ORC/Arrow metadata, instead of making everything Nullable. No change for text formats. [#71499](https://github.com/ClickHouse/ClickHouse/pull/71499) ([Michael Kolupaev](https://github.com/al13n321)).
* This PR makes the query result cache ignore the `log_comment` setting, so that changing only the `log_comment` on a query no longer forces a cache miss. There is a small chance users intentionally segmented their cache by varying `log_comment`. This change alters that behavior and is therefore backward incompatible. Please use setting `query_cache_tag` for this purpose. [#79878](https://github.com/ClickHouse/ClickHouse/pull/79878) ([filimonov](https://github.com/filimonov)).
* In previous versions, queries with table functions named the same way as the implementation functions for operators were formatted inconsistently. Closes [#81601](https://github.com/ClickHouse/ClickHouse/issues/81601). Closes [#81977](https://github.com/ClickHouse/ClickHouse/issues/81977). Closes [#82834](https://github.com/ClickHouse/ClickHouse/issues/82834). Closes [#82835](https://github.com/ClickHouse/ClickHouse/issues/82835). EXPLAIN SYNTAX queries will not format operators - the new behavior better reflects the purpose of explaining syntax. `clickhouse-format`, `formatQuery`, and similar will not format functions as operators if the query contained them in a functional form. [#82825](https://github.com/ClickHouse/ClickHouse/pull/82825) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Forbid using Dynamic type in JOIN keys. It could lead to unexpected results when Dynamic type is compared to a non-Dynamic type. It's better to cast Dynamic column to the required type. [#86358](https://github.com/ClickHouse/ClickHouse/pull/86358) ([Pavel Kruglov](https://github.com/Avogar)).
* Storage_metadata_write_full_object_key server option is turned on by default, it can't be set off now. this is backward compatible change. i used the label for attention. this change is forward compatible only with 25.x releases. that means that you could downgrade only on any 25.x release in case you have to rollback the new release. [#87335](https://github.com/ClickHouse/ClickHouse/pull/87335) ([Sema Checherinda](https://github.com/CheSema)).
* Decrease replicated_deduplication_window_seconds from 1 week down to one hour in order to store less znode on zookeeper when insertion rate is low. [#87414](https://github.com/ClickHouse/ClickHouse/pull/87414) ([Sema Checherinda](https://github.com/CheSema)).
* Rename setting `query_plan_use_new_logical_join_step` to `query_plan_use_logical_join_step`. [#87679](https://github.com/ClickHouse/ClickHouse/pull/87679) ([Vladimir Cherkasov](https://github.com/vdimir)).
* The new syntax allows tokenizer parameter to be more expressive. [#87997](https://github.com/ClickHouse/ClickHouse/pull/87997) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Renamed functions `searchAny` and `searchAll` to `hasAnyTokens` and `hasAllTokens` for better consistency with existing function `hasToken`. [#88109](https://github.com/ClickHouse/ClickHouse/pull/88109) ([Robert Schulze](https://github.com/rschu1ze)).
* Remove `cache_hits_threshold` from filesystem cache. This feature was added by an external contributor before we had SLRU cache policy, and now that we have it - it does not make sense to support both. [#88344](https://github.com/ClickHouse/ClickHouse/pull/88344) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Two slight changes to how `min_free_disk_ratio_to_perform_insert` and `min_free_disk_bytes_to_perform_insert` settings work: - use unreserved instead of available bytes to determine if an insert should be rejected. This is probably not crucial if the reservations for background merges and mutations are small compared to the configured thresholds, but it seems more correct. - Don't apply these settings to system tables. The reasoning for this is that we still want tables like `query_log` to be updated. This helps a lot with debugging. Data written to system tables is usually small compared to actual data, so they should be able to continue for much longer with a reasonable `min_free_disk_ratio_to_perform_insert` threshold. [#88468](https://github.com/ClickHouse/ClickHouse/pull/88468) ([c-end](https://github.com/c-end)).
* Enable async mode for Keeper's internal replication. Keeper will preserve the same behavior as before with possible performance improvements. If you are updating from a version older than 23.9, you need to either update first to 23.9+ and than to 25.10+. You can also set `keeper_server.coordination_settings.async_replication` to 0 before update and enable it after update is done. [#88515](https://github.com/ClickHouse/ClickHouse/pull/88515) ([Antonio Andelic](https://github.com/antonio2368)).

#### New Feature
* Add `naiveBayesClassifier` function to classify text using Naive Bayes based on ngrams. [#78700](https://github.com/ClickHouse/ClickHouse/pull/78700) ([Nihal Z. Miaji](https://github.com/nihalzp)).
* Sparse_gram bloom filter index. [#79985](https://github.com/ClickHouse/ClickHouse/pull/79985) ([scanhex12](https://github.com/scanhex12)).
* Access ClickHouse Cloud instances using Cloud credentials with `--login`. [#82753](https://github.com/ClickHouse/ClickHouse/pull/82753) ([Krishna Mannem](https://github.com/kcmannem)).
* New `conv` function for converting numbers between bases, currently supports bases from `2-36`. [#83058](https://github.com/ClickHouse/ClickHouse/pull/83058) ([hp](https://github.com/hp77-creator)).
* Added `LIMIT BY ALL` syntax support. Similar to `GROUP BY ALL` and `ORDER BY ALL`, `LIMIT BY ALL` automatically expands to use all non-aggregate expressions from the SELECT clause as LIMIT BY keys. For example, `SELECT id, name, count(*) FROM table GROUP BY id LIMIT 1 BY ALL` is equivalent to `SELECT id, name, count(*) FROM table GROUP BY id LIMIT 1 BY id, name`. This feature simplifies queries when you want to limit by all selected non-aggregate columns without explicitly listing them. Closes [#59152](https://github.com/ClickHouse/ClickHouse/issues/59152). [#84079](https://github.com/ClickHouse/ClickHouse/pull/84079) ([Surya Kant Ranjan](https://github.com/iit2009046)).
* Add support for querying Apache Paimon in ClickHouse. This integration would enable ClickHouse users to directly interact with Paimon's data lake storage. [#84423](https://github.com/ClickHouse/ClickHouse/pull/84423) ([JIaQi](https://github.com/JiaQiTang98)).
* Added `studentTTestOneSample` aggregate function. [#85436](https://github.com/ClickHouse/ClickHouse/pull/85436) ([Dylan](https://github.com/DylanBlakemore)).
* Aggregate function `quantilePrometheusHistogram`, which accepts the upper bounds and cumulative values of histogram buckets as arguments, and performs a linear interpolation between the upper and lower bounds of the bucket in which the quantile position is found. Behaves similarly to the PromQL `histogram_quantile()` function on classic histograms. [#86294](https://github.com/ClickHouse/ClickHouse/pull/86294) ([Stephen Chi](https://github.com/stephchi0)).
* Added an ability to automatically create statistics on all suitable columns in `MergeTree` tables. Added table-level setting `auto_statistics_types` which stores comma-separated types of statistics to create (e.g. `auto_statistics_types = 'minmax, uniq, countmin'`). [#87241](https://github.com/ClickHouse/ClickHouse/pull/87241) ([Anton Popov](https://github.com/CurtizJ)).
* System table for delta lake metadata files. [#87263](https://github.com/ClickHouse/ClickHouse/pull/87263) ([scanhex12](https://github.com/scanhex12)).
* Add SYSTEM RECONNECT ZOOKEEPER command to force zookeeper disconnect and reconnect (https://github.com/ClickHouse/ClickHouse/issues/87317). [#87318](https://github.com/ClickHouse/ClickHouse/pull/87318) ([Pradeep Chhetri](https://github.com/chhetripradeep)).
* Limit the number of named collections through setting `max_named_collection_num_to_warn` and `max_named_collection_num_to_throw`. Add new metric `NamedCollection` and error `TOO_MANY_NAMED_COLLECTIONS`. [#87343](https://github.com/ClickHouse/ClickHouse/pull/87343) ([Pablo Marcos](https://github.com/pamarcos)).
* Added optimized case-insensitive variants of `startsWith` and `endsWith` functions: `startsWithCaseInsensitive`, `endsWithCaseInsensitive`, `startsWithCaseInsensitiveUTF8`, and `endsWithCaseInsensitiveUTF8`. [#87374](https://github.com/ClickHouse/ClickHouse/pull/87374) ([Guang Zhao](https://github.com/zheguang)).
* Adds a way to provide WORKLOAD and RESOURCE definitions in SQL using the server configuration "resources_and_workloads" section. [#87430](https://github.com/ClickHouse/ClickHouse/pull/87430) ([Sergei Trifonov](https://github.com/serxa)).
* The `Alias` engine creates a proxy to another table. All read and write operations are forwarded to the target table, while the alias itself stores no data and only maintains a reference to the target table. [#87965](https://github.com/ClickHouse/ClickHouse/pull/87965) ([Kai Zhu](https://github.com/nauu)).
* Add `--semicolons_inline` option to format queries so that semicolons are placed on the last line instead of on a new line. [#88018](https://github.com/ClickHouse/ClickHouse/pull/88018) ([Jan Rada](https://github.com/ZelvaMan)).
* Add a new table setting `min_level_for_wide_part` that allows specifying the minimum level for a part to be created as a wide part. [#88179](https://github.com/ClickHouse/ClickHouse/pull/88179) ([Christoph Wurm](https://github.com/cwurm)).
* Add support for negative `LIMIT` and negative `OFFSET`. Closes [#28913](https://github.com/ClickHouse/ClickHouse/issues/28913). [#88411](https://github.com/ClickHouse/ClickHouse/pull/88411) ([Nihal Z. Miaji](https://github.com/nihalzp)).
* Add recursive variants of `cp`-`cpr` and `mv`-`mvr` commands in Keeper client. [#88570](https://github.com/ClickHouse/ClickHouse/pull/88570) ([Mikhail Artemenko](https://github.com/Michicosun)).

#### Experimental Feature
* Functions `searchAll` and `searchAny` now work on top of columns without text columns. In those cases, they use the default tokenizer. [#87722](https://github.com/ClickHouse/ClickHouse/pull/87722) ([Jimmy Aguilar Mena](https://github.com/Ergus)).
* Implement `QBit` data type that stores vectors in bit-sliced format and `L2DistanceTransposed` function that allows approximate vector search where precision-speed trade-off is controlled by a parameter. [#87922](https://github.com/ClickHouse/ClickHouse/pull/87922) ([Raufs Dunamalijevs](https://github.com/rienath)).

#### Performance Improvement
* Improved query performance by refactoring the order and integration of Query Condition Cache (QCC) with index analysis. QCC filtering is now applied before primary key and skip index analysis, reducing unnecessary index computation. Index analysis has been extended to support multiple range filters, and its filtering results are now stored back into the QCC. This significantly speeds up queries where index analysis dominates execution time—especially those relying on skip indexes (e.g. vector or inverted indexes). [#82380](https://github.com/ClickHouse/ClickHouse/pull/82380) ([Amos Bird](https://github.com/amosbird)).
* Add optional `.size` subcolumn serialization for top-level String columns in MergeTree tables to improve compression and enable efficient subcolumn access. Introduce new MergeTree settings for serialization version control and expression optimization for empty strings. [#82850](https://github.com/ClickHouse/ClickHouse/pull/82850) ([Amos Bird](https://github.com/amosbird)).
* A bunch of micro-optimizations to speed up small queries. [#83096](https://github.com/ClickHouse/ClickHouse/pull/83096) ([Raúl Marín](https://github.com/Algunenano)).
* Compress logs and profile events in the native protocol. On clusters with 100+ replicas, uncompressed profile events take 1..10 MB/sec, and the progress bar is sluggish on slow Internet connections. This closes [#82533](https://github.com/ClickHouse/ClickHouse/issues/82533). [#83586](https://github.com/ClickHouse/ClickHouse/pull/83586) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Improve the performance of case sensitive string search (operations such as filtering, e.g. `WHERE URL LIKE '%google%'`) by using the [StringZilla](https://github.com/ashvardanian/StringZilla) library, using SIMD CPU instructions when available. [#84161](https://github.com/ClickHouse/ClickHouse/pull/84161) ([Raúl Marín](https://github.com/Algunenano)).
* Reduce memory allocation and memory copy when select from an aggregating merge tree table with FINAL when the table has columns with type `SimpleAggregateFunction(anyLast)`. [#84428](https://github.com/ClickHouse/ClickHouse/pull/84428) ([Duc Canh Le](https://github.com/canhld94)).
* Provides a logic regarding pushing down the disjunction JOIN predicates. Example: in TPC-H Q7 for a condition on 2 tables n1 and n2 like `(n1.n_name = 'FRANCE' AND n2.n_name = 'GERMANY') OR (n1.n_name = 'GERMANY' AND n2.n_name = 'FRANCE')` we extract separate partial filters for each table `n1.n_name = 'FRANCE' OR n1.n_name = 'GERMANY'` for n1 and `n2.n_name = 'GERMANY' OR n2.n_name = 'FRANCE'` for n2. [#84735](https://github.com/ClickHouse/ClickHouse/pull/84735) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Improves performance of `LIKE` with prefix or suffix by using the new default setting `optimize_rewrite_like_perfect_affix`. [#85920](https://github.com/ClickHouse/ClickHouse/pull/85920) ([Guang Zhao](https://github.com/zheguang)).
* Fix performance degradation caused by large serialized key while grouping by multiple string/number columns. Close https://github.com/ClickHouse/ClickHouse/pull/83884#issuecomment-3187972297 cc @mkmkme . It is a follow-up of https://github.com/ClickHouse/ClickHouse/pull/83884. [#85924](https://github.com/ClickHouse/ClickHouse/pull/85924) ([李扬](https://github.com/taiyang-li)).
* Improvements to DB::SharedMutex. [#87491](https://github.com/ClickHouse/ClickHouse/pull/87491) ([Raúl Marín](https://github.com/Algunenano)).
* Improved performance of building text index for documents that contain mostly non-frequent tokens. [#87546](https://github.com/ClickHouse/ClickHouse/pull/87546) ([Anton Popov](https://github.com/CurtizJ)).
* Speed up the common case of Field destructor. [#87631](https://github.com/ClickHouse/ClickHouse/pull/87631) ([Raúl Marín](https://github.com/Algunenano)).
* Skip runtime hash table statistics recalculation during join optimization. Added new profile events `JoinOptimizeMicroseconds` and `QueryPlanOptimizeMicroseconds`. [#87683](https://github.com/ClickHouse/ClickHouse/pull/87683) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Enable saving marks in cache and avoid direct IO for the MergeTreeLazy reader. [#87989](https://github.com/ClickHouse/ClickHouse/pull/87989) ([Nikita Taranov](https://github.com/nickitat)).
* SELECT query with `FINAL` clause on.a `ReplacingMergeTree` table with the `is_deleted` column now executes faster because of improved parallelization from 2 existing optimizations : 1) `do_not_merge_across_partitions_select_final` optimization for partitions of the table that have only a single `part` 2) Split other selected ranges of the table into `intersecting / non-intersecting` and only intersecting ranges have to pass through FINAL merging transform. [#88090](https://github.com/ClickHouse/ClickHouse/pull/88090) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Reduce the impact of not using fail points. [#88196](https://github.com/ClickHouse/ClickHouse/pull/88196) ([Raúl Marín](https://github.com/Algunenano)).
* Avoid full scan for `system.tables` with filter by `uuid` (Can be useful if you have only UUID from logs or zookeeper path). [#88379](https://github.com/ClickHouse/ClickHouse/pull/88379) ([Azat Khuzhin](https://github.com/azat)).
* Improved performance of functions `tokens`, `hasAllTokens`, `hasAnyTokens`. [#88416](https://github.com/ClickHouse/ClickHouse/pull/88416) ([Anton Popov](https://github.com/CurtizJ)).
* Read in order for Iceberg. [#88454](https://github.com/ClickHouse/ClickHouse/pull/88454) ([scanhex12](https://github.com/scanhex12)).
* Inline `AddedColumns::appendFromBlock` for slightly better join performance in some cases. [#88455](https://github.com/ClickHouse/ClickHouse/pull/88455) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#89182](https://github.com/ClickHouse/ClickHouse/issues/89182): Implement lazy columns replication in JOIN and ARRAY JOIN. Avoid converting special columns representation like Sparse and Replicated to full columns in some output formats. This avoids unnecessary data copy in memory. [#88752](https://github.com/ClickHouse/ClickHouse/pull/88752) ([Pavel Kruglov](https://github.com/Avogar)).

#### Improvement
* Allow configuring server-level throttling when the configuration is overridden in Keeper. Closes [#73964](https://github.com/ClickHouse/ClickHouse/issues/73964). [#74066](https://github.com/ClickHouse/ClickHouse/pull/74066) ([JIaQi](https://github.com/JiaQiTang98)).
* `mannWhitneyUTest` no longer throws an exception when both samples contain only identical values. Now returns a valid result, consistent with SciPy. This closes: [#79814](https://github.com/ClickHouse/ClickHouse/issues/79814). [#80009](https://github.com/ClickHouse/ClickHouse/pull/80009) ([DeanNeaht](https://github.com/DeanNeaht)).
* Rewrite disk object storage transaction removes previous remote blobs if metadata transaction is committed. [#81787](https://github.com/ClickHouse/ClickHouse/pull/81787) ([Sema Checherinda](https://github.com/CheSema)).
* Fixed optimization pass for redundant equal expression when LowCardinality of the resulting type differs before and after optimization. [#82651](https://github.com/ClickHouse/ClickHouse/pull/82651) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* When HTTP clients set the header `X-ClickHouse-100-Continue: defer` in addition to `Expect: 100-continue`, ClickHouse doesn't send send a `100 Continue` response to the client until after quota validation passes, preventing waste of network bandwidth from transmitting request bodies that will be thrown away anyways. This is relevant for INSERT queries where the query can be sent in the URL query string and the data is sent in the request body. Aborting a request without sending the full body prevents connection reuse with HTTP/1.1, but the additional latency introduced by opening new connections is usually insignificant compared to total INSERT duration with large amounts of data. [#84304](https://github.com/ClickHouse/ClickHouse/pull/84304) ([c-end](https://github.com/c-end)).
* Client autocompletion is faster and more consistent by using `system.completions` rather than issuing multiple system-table queries. [#84694](https://github.com/ClickHouse/ClickHouse/pull/84694) ([|2ustam](https://github.com/RuS2m)).
* Speed up some JOIN queries by building a bloom filter from the right subtree at runtime and pass this filter to the scan in the left subtree. This can be beneficial for queries like `SELECT avg(o_totalprice) FROM orders, customer, nation WHERE c_custkey = o_custkey AND c_nationkey=n_nationkey AND n_name = 'FRANCE'`. [#84772](https://github.com/ClickHouse/ClickHouse/pull/84772) ([Alexander Gololobov](https://github.com/davenger)).
* Mask S3 credentials in logs when using DATABASE ENGINE = Backup with S3 storage. [#85336](https://github.com/ClickHouse/ClickHouse/pull/85336) ([Kenny Sun](https://github.com/hwabis)).
* Backported in [#88990](https://github.com/ClickHouse/ClickHouse/issues/88990): Make query plan optimizations visible to the correlated subquery input subplan by postponing it's materialization. Part of [#79890](https://github.com/ClickHouse/ClickHouse/issues/79890). [#85455](https://github.com/ClickHouse/ClickHouse/pull/85455) ([Dmitry Novik](https://github.com/novikd)).
* Rename InterpreterSystemQuery::dropReplicaImpl to InterpreterSystemQuery::dropStorageReplica - In InterpreterSystemQuery::dropDatabaseReplica: - When dropping with database or drop the whole replica: it also drops replica for each table of the database - If 'WITH TABLES' is provided, drop replica for each storage - Otherwise, the logic is unchanged, only call DatabaseReplicated::dropReplica on the databases - When dropping a database replica with the keeper path: - If 'WITH TABLES' is provided: - Restore the database as Atomic - Restore RMT tables from statement in Keeper - Drop the database (restored tables are also dropped) - Otherwise, only call DatabaseReplicated::dropReplica on the provided keeper path. [#85637](https://github.com/ClickHouse/ClickHouse/pull/85637) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fix inconsistent formatting of TTL when it contains a `materialize` function. Closes [#82828](https://github.com/ClickHouse/ClickHouse/issues/82828). [#85749](https://github.com/ClickHouse/ClickHouse/pull/85749) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Iceberg table state is not stored in a storage object anymore. This should make Iceberg in ClickHouse usable with concurrent queries. [#86062](https://github.com/ClickHouse/ClickHouse/pull/86062) ([Daniil Ivanik](https://github.com/divanik)).
* Make bucket lock in S3Queue ordered mode a persistent mode, similar to processing nodes in case `use_persistent_processing_nodes = 1`. Add keeper fault injection in tests. [#86628](https://github.com/ClickHouse/ClickHouse/pull/86628) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Support hints for format names. Closes [#86761](https://github.com/ClickHouse/ClickHouse/issues/86761). [#87092](https://github.com/ClickHouse/ClickHouse/pull/87092) ([flynn](https://github.com/ucasfl)).
* Remote replicas skip index analysis when there are no projections. [#87096](https://github.com/ClickHouse/ClickHouse/pull/87096) ([zoomxi](https://github.com/zoomxi)).
* Allow disabling utf8 encoding for ytsaurus table. [#87150](https://github.com/ClickHouse/ClickHouse/pull/87150) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Add new `dictionary_block_frontcoding_compression` text index parameter to control the dictionary compression. By default, it is enabled to use the `front-coding` compression. [#87175](https://github.com/ClickHouse/ClickHouse/pull/87175) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Disable `s3_slow_all_threads_after_retryable_error` by default. [#87198](https://github.com/ClickHouse/ClickHouse/pull/87198) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Rename table function `arrowflight` to `arrowFlight`. [#87249](https://github.com/ClickHouse/ClickHouse/pull/87249) ([Vitaly Baranov](https://github.com/vitlibar)).
* Updated `clickhouse-benchmark` to accept using `-` if in place of `_` in its cli flags. [#87251](https://github.com/ClickHouse/ClickHouse/pull/87251) ([Ahmed Gouda](https://github.com/0xgouda)).
* Added session setting to exclude list of skip indexes from materialization on inserts (`exclude_materialize_skip_indexes_on_insert`). Added merge tree table setting to exclude list of skip indexes from materialization during merge (`exclude_materialize_skip_indexes_on_merge`). [#87252](https://github.com/ClickHouse/ClickHouse/pull/87252) ([George Larionov](https://github.com/george-larionov)).
* Make flushing to `system.crash_log` in signal handling synchronous. [#87253](https://github.com/ClickHouse/ClickHouse/pull/87253) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Added a setting `inject_random_order_for_select_without_order_by` which injects `ORDER BY rand()` into top-level `SELECT` queries without `ORDER BY` clause. [#87261](https://github.com/ClickHouse/ClickHouse/pull/87261) ([Rui Zhang](https://github.com/zhangruiddn)).
* Improve joinGet error message so that it properly states that the number of `join_keys` is not the same as the number of `right_table_keys`. [#87279](https://github.com/ClickHouse/ClickHouse/pull/87279) ([Isak Ellmer](https://github.com/spinojara)).
* Squash data from all threads before inserting to materialized views depending on the settings `min_insert_block_size_rows_for_materialized_views` and `min_insert_block_size_bytes_for_materialized_views`. Previously, if `parallel_view_processing` was enabled, each thread inserting to a specific materailized view would squash insert independently which could lead to higher number of generated parts. [#87280](https://github.com/ClickHouse/ClickHouse/pull/87280) ([Antonio Andelic](https://github.com/antonio2368)).
* This patch adds the ability to check an arbitrary Keeper node's stat during the write tx. This can help with ABA problem detection. [#87282](https://github.com/ClickHouse/ClickHouse/pull/87282) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Redirect heavy ytsaurus requests to heavy proxies. [#87342](https://github.com/ClickHouse/ClickHouse/pull/87342) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* This patch fixes rollbacks of unlink/rename/removeRecursive/removeDirectory/etc operations and also hardlink counts in any possible workloads for metadata from disk transactions, and simplifies the interfaces to make them more generic so that they can be reused in other meta stores. [#87358](https://github.com/ClickHouse/ClickHouse/pull/87358) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Added `keeper_server.tcp_nodelay` configuration parameter that allows disabling `TCP_NODELAY` for Keeper. [#87363](https://github.com/ClickHouse/ClickHouse/pull/87363) (Copilot).
* Support `--connection` in `clickhouse-benchmarks`. It is the same as supported by `clickhouse-client`, you can specify predefined connections in client `config.xml`/`config.yaml` under `connections_credentials` path, to avoid explicitly specifying user/password via command line arguments. Add support for `--accept-invalid-certificate` into `clickhouse-benchmark`. [#87370](https://github.com/ClickHouse/ClickHouse/pull/87370) ([Azat Khuzhin](https://github.com/azat)).
* Now setting `max_insert_threads` will take effect on Iceberg tables. [#87407](https://github.com/ClickHouse/ClickHouse/pull/87407) ([alesapin](https://github.com/alesapin)).
* Add histogram and dimensional metrics to `PrometheusMetricsWriter`. This way, the `PrometheusRequestHandler` handler will have all the essential metrics and can be used for reliable and low-overhead metric collection in the cloud. [#87521](https://github.com/ClickHouse/ClickHouse/pull/87521) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Function `hasToken` now returns zero matches for the empty token (whereas this previously threw an exception). [#87564](https://github.com/ClickHouse/ClickHouse/pull/87564) ([Jimmy Aguilar Mena](https://github.com/Ergus)).
* Add text index support for `Array` and `Map` (`mapKeys` and `mapValues`) values. The supported functions are `mapContainsKey` and `has`. [#87602](https://github.com/ClickHouse/ClickHouse/pull/87602) ([Elmi Ahmadov](https://github.com/ahmadov)).
* Add a new `ZooKeeperSessionExpired` metric which indicates the number of expired global ZooKeeper sessions. [#87613](https://github.com/ClickHouse/ClickHouse/pull/87613) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Use S3 storage client with backup-specific settings (for example, backup_slow_all_threads_after_retryable_s3_error) for server-side (native) copy to a backup destination. Make s3_slow_all_threads_after_retryable_error obsolete. [#87660](https://github.com/ClickHouse/ClickHouse/pull/87660) ([Julia Kartseva](https://github.com/jkartseva)).
* Fix incorrect handling of settings `max_joined_block_size_rows` and `max_joined_block_size_bytes` during query plan serialization with experimental `make_distributed_plan`. [#87675](https://github.com/ClickHouse/ClickHouse/pull/87675) ([Vladimir Cherkasov](https://github.com/vdimir)).
* The setting `enable_http_compression` is now the default. This means that if a client accepts HTTP compression, the server will use it. However, this change has certain downsides. The client can request a heavy compression method, such as `bzip2`, which is unreasonable, and it will increase the resource consumption of the server (but this will be visible only when large results are transferred). The client can request `gzip`, which is not that bad, but suboptimal compared to `zstd`. Closes [#71591](https://github.com/ClickHouse/ClickHouse/issues/71591). [#87703](https://github.com/ClickHouse/ClickHouse/pull/87703) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Added a new setting `keeper_hosts` that exposes the list of [Zoo]Keeper hosts ClickHouse can connect to. [#87718](https://github.com/ClickHouse/ClickHouse/pull/87718) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Add `ALTER TABLE REWRITE PARTS` - rewrites the table parts from scratch, by using all new settings (since some, like `use_const_adaptive_granularity`, will be applied only for new parts). [#87774](https://github.com/ClickHouse/ClickHouse/pull/87774) ([Azat Khuzhin](https://github.com/azat)).
* Add `from` and `to` values to the system dashboards to facilitate historical investigations. [#87823](https://github.com/ClickHouse/ClickHouse/pull/87823) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Add more information for performance tracking in Iceberg SELECTs. [#87903](https://github.com/ClickHouse/ClickHouse/pull/87903) ([Daniil Ivanik](https://github.com/divanik)).
* Add new `joined_block_split_single_row` setting to reduce memory usage in hash joins with many matches per key. This allows hash join results to be chunked even within matches for a single left table row, which is particularly useful when one row from the left table matches thousands or millions of rows from the right table. Previously, all matches had to be materialized at once in memory. This reduces peak memory usage but may increase CPU usage. [#87913](https://github.com/ClickHouse/ClickHouse/pull/87913) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Filesystem cache improvement: reuse cache priority iterator among threads concurrently reserving space in cache. [#87914](https://github.com/ClickHouse/ClickHouse/pull/87914) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add ability to limit requests for `Keeper` (`max_request_size` setting, same as `jute.maxbuffer` for `ZooKeeper`, default **OFF** for backward compatibility, will be set in the next releases). [#87952](https://github.com/ClickHouse/ClickHouse/pull/87952) ([Azat Khuzhin](https://github.com/azat)).
* Fix `clickhouse-benchmark` to not include stacktraces in error messages by default. [#87954](https://github.com/ClickHouse/ClickHouse/pull/87954) ([Ahmed Gouda](https://github.com/0xgouda)).
* Avoid utilizing thread pool asynchonous marks loading (`load_marks_asynchronously=1`) when marks are in cache (since the pool can be under pressure and queries will pay penalty for this even if the marks already in cache). [#87967](https://github.com/ClickHouse/ClickHouse/pull/87967) ([Azat Khuzhin](https://github.com/azat)).
* Ytsaurus: allow create table/table functions/dictionaries with subset of columns. [#87982](https://github.com/ClickHouse/ClickHouse/pull/87982) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* From now `system.zookeeper_connection_log` is enabled by default and it can be used to get information about Keeper sessions. [#88011](https://github.com/ClickHouse/ClickHouse/pull/88011) ([János Benjamin Antal](https://github.com/antaljanosbenjamin)).
* To expose the `KeeperRequestRejectedDueToSoftMemoryLimitCount` keeper profile event, we must add it to `KeeperConstants.cpp`. [#88030](https://github.com/ClickHouse/ClickHouse/pull/88030) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Make TCP and HTTP behavior consistent when there duplicated external tables are passed. HTTP allows a temporary table to be passed several times. [#88032](https://github.com/ClickHouse/ClickHouse/pull/88032) ([Sema Checherinda](https://github.com/CheSema)).
* Remove custom MemoryPools for reading Arrow/ORC/Parquet. This component seems unneeded after https://github.com/ClickHouse/ClickHouse/pull/84082 because now we track all the allocations regardless. [#88035](https://github.com/ClickHouse/ClickHouse/pull/88035) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Allow to create `Replicated` database without arguments. [#88044](https://github.com/ClickHouse/ClickHouse/pull/88044) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Add support to connect to tls port of clickhouse-keeper, kept flag names same as in the clickhouse-client. [#88065](https://github.com/ClickHouse/ClickHouse/pull/88065) ([Pradeep Chhetri](https://github.com/chhetripradeep)).
* Added a new profile event to track the number of times that a background merge was rejected due to exceeding memory limits. [#88084](https://github.com/ClickHouse/ClickHouse/pull/88084) ([Grant Holly](https://github.com/grantholly-clickhouse)).
* Added optional `start_value` parameter to `generateSerialID` function to specify custom starting values for new series. [#88085](https://github.com/ClickHouse/ClickHouse/pull/88085) ([Manuel](https://github.com/raimannma)).
* Enables the analyzer for CREATE/ALTER TABLE column default expression validation. [#88087](https://github.com/ClickHouse/ClickHouse/pull/88087) ([Max Justus Spransy](https://github.com/maxjustus)).
* Internal query planning improvement: use JoinStepLogical for `CROSS JOIN`. [#88151](https://github.com/ClickHouse/ClickHouse/pull/88151) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Full support of operator IS NOT DISTINCT FROM (<=>). [#88155](https://github.com/ClickHouse/ClickHouse/pull/88155) ([simonmichal](https://github.com/simonmichal)).
* Added alias for hasAnyTokens (hasAnyToken) and hasAllTokens (hasAllToken) functions. [#88162](https://github.com/ClickHouse/ClickHouse/pull/88162) ([George Larionov](https://github.com/george-larionov)).
* Enable global sampling profiler by default: collect stacktraces of all threads every 10 seconds of CPU and real time. [#88209](https://github.com/ClickHouse/ClickHouse/pull/88209) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fixed support for `EXCHANGE TABLES` operations on tables with the `Alias` engine. The engine now stores the target table as database and table names instead of a constant storage id, allowing it to correctly resolve the target after table exchanges. [#88233](https://github.com/ClickHouse/ClickHouse/pull/88233) ([Kai Zhu](https://github.com/nauu)).
* Add setting `temporary_files_buffer_size` to control size of the buffer for temporary files writers. * Optimize memory consumption of `scatter` operation (used, for example in grace hash join) for `LowCardinality` columns. [#88237](https://github.com/ClickHouse/ClickHouse/pull/88237) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Added support of direct reading from text indexes with parallel replicas. Improved performance of reading text indexes from object storage. [#88262](https://github.com/ClickHouse/ClickHouse/pull/88262) ([Anton Popov](https://github.com/CurtizJ)).
* Now the function `generateSerialID` supports a non-constant argument with the series name. Closes [#83750](https://github.com/ClickHouse/ClickHouse/issues/83750). [#88270](https://github.com/ClickHouse/ClickHouse/pull/88270) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Datalakes catalogs database for distributed processing. [#88273](https://github.com/ClickHouse/ClickHouse/pull/88273) ([scanhex12](https://github.com/scanhex12)).
* Update azure sdk to include 'Content-Length' fix that is seen with copy and create container functionalities. [#88278](https://github.com/ClickHouse/ClickHouse/pull/88278) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Make function lag case insensitive for compatibility with MySQL. [#88322](https://github.com/ClickHouse/ClickHouse/pull/88322) ([Lonny Kapelushnik](https://github.com/lonnylot)).
* Backported in [#89246](https://github.com/ClickHouse/ClickHouse/issues/89246): If a skip index used in a FINAL query is on a column that is part of the primary key, the additional step to check for primary key intersection in other parts is unnecessary and now not performed. Resolves [#85897](https://github.com/ClickHouse/ClickHouse/issues/85897). [#88368](https://github.com/ClickHouse/ClickHouse/pull/88368) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Allow `clickhouse-local` to start from the `clickhouse-server` directory. In previous versions, it produced an error `Cannot parse UUID: .` Now you can start clickhouse-local and manipulate the server's databases without starting the server. [#88383](https://github.com/ClickHouse/ClickHouse/pull/88383) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add config `keeper_server.coordination_settings.check_node_acl_on_remove`. If enabled, before each delete of a node, ACLs of both the node itself and parent node will be verified. Otherwise, only the ACL of the parent node will be verified. [#88513](https://github.com/ClickHouse/ClickHouse/pull/88513) ([Antonio Andelic](https://github.com/antonio2368)).
* `JSON` columns are now pretty printed when using `Vertical` format. Closes [#81794](https://github.com/ClickHouse/ClickHouse/issues/81794). [#88524](https://github.com/ClickHouse/ClickHouse/pull/88524) ([Frank Rosner](https://github.com/FRosner)).
* Store `clickhouse-client` files (e.g. query history) in places described by [XDG Base Directories](https://specifications.freedesktop.org/basedir-spec/latest/index.html) specification instead of root of home directory. `~/.clickhouse-client-history` will still be used if it is already present. [#88538](https://github.com/ClickHouse/ClickHouse/pull/88538) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fixes memory leak due to `GLOBAL IN` (https://github.com/ClickHouse/ClickHouse/issues/88615). [#88617](https://github.com/ClickHouse/ClickHouse/pull/88617) ([pranavmehta94](https://github.com/pranavmehta94)).
* Added overload to hasAny/hasAllTokens to accept a string input. [#88679](https://github.com/ClickHouse/ClickHouse/pull/88679) ([George Larionov](https://github.com/george-larionov)).
* After this patch, heuristic `to_remove_small_parts_at_right` will be executed before the calculation of the merge range score. Before that, the merge selector was choosing the wide merge, and after that, it filtered its suffix. Fixes: [#85374](https://github.com/ClickHouse/ClickHouse/issues/85374). [#88736](https://github.com/ClickHouse/ClickHouse/pull/88736) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Add a step to postinstall script for `clickhouse-keeper` which enables starting on boot. [#88746](https://github.com/ClickHouse/ClickHouse/pull/88746) ([YenchangChan](https://github.com/YenchangChan)).
* Check credentials in the Web UI only on pasting, rather than on every key press. This avoids a problem with misconfigured LDAP servers. This closes [#85777](https://github.com/ClickHouse/ClickHouse/issues/85777). [#88769](https://github.com/ClickHouse/ClickHouse/pull/88769) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Limit exception message length when a constraint is violated. In previous versions, you could get a very long exception message when a very long string was inserted, and it ended up being written in the query_log. Closes [#87032](https://github.com/ClickHouse/ClickHouse/issues/87032). [#88801](https://github.com/ClickHouse/ClickHouse/pull/88801) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Fixed GeoParquet causing client protocol errors. [#84020](https://github.com/ClickHouse/ClickHouse/pull/84020) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix resolving host-dependent functions like shardNum() in subqueries on initiator node. [#84409](https://github.com/ClickHouse/ClickHouse/pull/84409) ([Eduard Karacharov](https://github.com/korowa)).
* Fixed incorrect handling of pre-epoch dates with fractional seconds in various date time related functions, such as `parseDateTime64BestEffort`, `change{Year,Month,Day}` and `makeDateTime64`. Previously the subsecond part was substracted from seconds instead of adding them. For example `parseDateTime64BestEffort('1969-01-01 00:00:00.468')` was returning `1968-12-31 23:59:59.532` instead of `1969-01-01 00:00:00.468`. [#85396](https://github.com/ClickHouse/ClickHouse/pull/85396) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Fix ALTER COLUMN IF EXISTS commands failing when column state changes within the same ALTER statement. Commands like DROP COLUMN IF EXISTS, MODIFY COLUMN IF EXISTS, COMMENT COLUMN IF EXISTS, and RENAME COLUMN IF EXISTS now properly handle cases where a column is deleted by a previous command in the same statement. [#86046](https://github.com/ClickHouse/ClickHouse/pull/86046) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Fix inferring Date/DateTime/DateTime64 on dates that are out of supported range. [#86184](https://github.com/ClickHouse/ClickHouse/pull/86184) ([Pavel Kruglov](https://github.com/Avogar)).
* Fixes a crash where some valid user-submitted data to an `AggregateFunction(quantileDD)` column could cause merges to recurse infinitely. [#86560](https://github.com/ClickHouse/ClickHouse/pull/86560) ([Raphaël Thériault](https://github.com/raphael-theriault-swi)).
* Support JSON/Dynamic types in table created as `cluster` table function. [#86821](https://github.com/ClickHouse/ClickHouse/pull/86821) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix result of function calculated in CTE being non-deterministic in the query. [#86967](https://github.com/ClickHouse/ClickHouse/pull/86967) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Fix LOGICAL_ERROR in EXPLAIN with pointInPolygon on primary key columns. [#86971](https://github.com/ClickHouse/ClickHouse/pull/86971) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix data lake tables with a percent-encoded sequence in the name. Closes [#86626](https://github.com/ClickHouse/ClickHouse/issues/86626). [#87020](https://github.com/ClickHouse/ClickHouse/pull/87020) ([Anton Ivashkin](https://github.com/ianton-ru)).
* Fix incorrect `IS NULL` behavior on nullable columns in `OUTER JOIN` with `optimize_functions_to_subcolumns`, close [#78625](https://github.com/ClickHouse/ClickHouse/issues/78625). [#87058](https://github.com/ClickHouse/ClickHouse/pull/87058) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Fixed incorrect accounting of temporary data deallocations in `max_temporary_data_on_disk_size` limit tracking, close [#87118](https://github.com/ClickHouse/ClickHouse/issues/87118). [#87140](https://github.com/ClickHouse/ClickHouse/pull/87140) ([JIaQi](https://github.com/JiaQiTang98)).
* The function checkHeaders is now properly validating the provided headers and reject forbidden headers. Original author: Michael Anastasakis (@michael-anastasakis). [#87172](https://github.com/ClickHouse/ClickHouse/pull/87172) ([Raúl Marín](https://github.com/Algunenano)).
* Makes the same behaviour of `toDate` and `toDate32` for all numeric types. Fixes Date32 underflow check during cast from int16. [#87176](https://github.com/ClickHouse/ClickHouse/pull/87176) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Fix logical error with parallel replicas for queries with multiple JOINs, with RIGHT JOIN after LEFT/INNER JOIN in particular. [#87178](https://github.com/ClickHouse/ClickHouse/pull/87178) ([Igor Nikonov](https://github.com/devcrafter)).
* Respect setting `input_format_try_infer_variants` in schema inference cache. [#87180](https://github.com/ClickHouse/ClickHouse/pull/87180) ([Pavel Kruglov](https://github.com/Avogar)).
* Make pathStartsWith only match paths under the prefix. [#87181](https://github.com/ClickHouse/ClickHouse/pull/87181) ([Raúl Marín](https://github.com/Algunenano)).
* Fixed logical errors in `_row_number` virtual column and iceberg positioned deletes. [#87220](https://github.com/ClickHouse/ClickHouse/pull/87220) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix "Too large size passed to allocator" `LOGICAL_ERROR` in `JOIN` due to mixed const and non-const blocks. [#87231](https://github.com/ClickHouse/ClickHouse/pull/87231) ([Azat Khuzhin](https://github.com/azat)).
* Fixed lightweight updates with subqueries that read from another `MergeTree` tables. [#87285](https://github.com/ClickHouse/ClickHouse/pull/87285) ([Anton Popov](https://github.com/CurtizJ)).
* Fixed move-to-prewhere optimization, which did not work in the presence of row policy. Continuation of [#85118](https://github.com/ClickHouse/ClickHouse/issues/85118). Closes [#69777](https://github.com/ClickHouse/ClickHouse/issues/69777). Closes [#83748](https://github.com/ClickHouse/ClickHouse/issues/83748). [#87303](https://github.com/ClickHouse/ClickHouse/pull/87303) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Fixed applying patches to columns with default expression that are missing in data parts. [#87347](https://github.com/ClickHouse/ClickHouse/pull/87347) ([Anton Popov](https://github.com/CurtizJ)).
* Fixed segmentation fault when using duplicate partition field names in MergeTree tables. [#87365](https://github.com/ClickHouse/ClickHouse/pull/87365) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Fix EmbeddedRocksDB upgrade. [#87392](https://github.com/ClickHouse/ClickHouse/pull/87392) ([Raúl Marín](https://github.com/Algunenano)).
* Fixed direct reading from the text index on object storage. [#87399](https://github.com/ClickHouse/ClickHouse/pull/87399) ([Anton Popov](https://github.com/CurtizJ)).
* Prevent privilege with non-existent engine to be created. [#87419](https://github.com/ClickHouse/ClickHouse/pull/87419) ([Jitendra](https://github.com/jitendra1411)).
* Ignore only not found errors for `s3_plain_rewritable` (which may lead to all sort of troubles). [#87426](https://github.com/ClickHouse/ClickHouse/pull/87426) ([Azat Khuzhin](https://github.com/azat)).
* Fix dictionaries with YTSaurus source and *range_hashed layouts. [#87490](https://github.com/ClickHouse/ClickHouse/pull/87490) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Fix creating an array of empty tuples. [#87520](https://github.com/ClickHouse/ClickHouse/pull/87520) ([Pavel Kruglov](https://github.com/Avogar)).
* Check for illegal columns during temporary table creation. [#87524](https://github.com/ClickHouse/ClickHouse/pull/87524) ([Pavel Kruglov](https://github.com/Avogar)).
* Never put hive partition columns in the format header. Fixes [#87515](https://github.com/ClickHouse/ClickHouse/issues/87515). [#87528](https://github.com/ClickHouse/ClickHouse/pull/87528) ([Arthur Passos](https://github.com/arthurpassos)).
* Fix preparing reading from format in DeltaLake when text format is used. [#87529](https://github.com/ClickHouse/ClickHouse/pull/87529) ([Pavel Kruglov](https://github.com/Avogar)).
* Fixes access validation on select and insert for Buffer tables. [#87545](https://github.com/ClickHouse/ClickHouse/pull/87545) ([pufit](https://github.com/pufit)).
* Disallow creating data skipping index for S3 table. [#87554](https://github.com/ClickHouse/ClickHouse/pull/87554) ([Bharat Nallan](https://github.com/bharatnc)).
* Avoid leaking of tracked memory for async logging (can have a significant drift, for 10 hours, ~100GiB) and text_log (almost same drift is possible). [#87584](https://github.com/ClickHouse/ClickHouse/pull/87584) ([Azat Khuzhin](https://github.com/azat)).
* Fixed a bug that might lead to overriding global server settings with SELECT settings of a View or Materialized View, if this view was dropped asynchronously and the server was restarted before finishing background cleanup. [#87603](https://github.com/ClickHouse/ClickHouse/pull/87603) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Exclude userspace page cache bytes (if possible) when computing memory overload warning. [#87610](https://github.com/ClickHouse/ClickHouse/pull/87610) ([Bharat Nallan](https://github.com/bharatnc)).
* Fix a bug when incorrect type order during CSV deserialization led to the `LOGICAL_ERROR`. [#87622](https://github.com/ClickHouse/ClickHouse/pull/87622) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Fix incorrect handling of `command_read_timeout` for executable dictionaries. [#87627](https://github.com/ClickHouse/ClickHouse/pull/87627) ([Azat Khuzhin](https://github.com/azat)).
* Fixed incorrect SELECT * REPLACE behavior in WHERE clause with new analyzer when filtering on replaced columns. [#87630](https://github.com/ClickHouse/ClickHouse/pull/87630) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Fixed two-level aggregation when using `Merge` over `Distributed`. [#87687](https://github.com/ClickHouse/ClickHouse/pull/87687) ([c-end](https://github.com/c-end)).
* Fix the generation of the output block in the HashJoin algorithm when the right row list is not used. Fixes [#87401](https://github.com/ClickHouse/ClickHouse/issues/87401). [#87699](https://github.com/ClickHouse/ClickHouse/pull/87699) ([Dmitry Novik](https://github.com/novikd)).
* Parallel replicas read mode could be chosen incorrectly if there are no data to read after applying index analysis. Closes [#87653](https://github.com/ClickHouse/ClickHouse/issues/87653). [#87700](https://github.com/ClickHouse/ClickHouse/pull/87700) ([zoomxi](https://github.com/zoomxi)).
* Fix handling of `timestamp` / `timestamptz` columns in Glue. [#87733](https://github.com/ClickHouse/ClickHouse/pull/87733) ([Andrey Zvonov](https://github.com/zvonand)).
* This closes [#86587](https://github.com/ClickHouse/ClickHouse/issues/86587). [#87761](https://github.com/ClickHouse/ClickHouse/pull/87761) ([scanhex12](https://github.com/scanhex12)).
* Fix writing boolean values in PostgreSQL interface. [#87762](https://github.com/ClickHouse/ClickHouse/pull/87762) ([Artem Yurov](https://github.com/ArtemYurov)).
* Fix unknown table error in insert select query with CTE, [#85368](https://github.com/ClickHouse/ClickHouse/issues/85368). [#87789](https://github.com/ClickHouse/ClickHouse/pull/87789) ([Guang Zhao](https://github.com/zheguang)).
* Fix reading null map subcolumn from Variants that cannot be inside Nullable. [#87798](https://github.com/ClickHouse/ClickHouse/pull/87798) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix handling error when failing to drop the database completely on the cluster on the secondary node. [#87802](https://github.com/ClickHouse/ClickHouse/pull/87802) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fix several skip indices bugs. [#87817](https://github.com/ClickHouse/ClickHouse/pull/87817) ([Raúl Marín](https://github.com/Algunenano)).
* In AzureBlobStorage, updated to try native copy first and go to read & write on 'Unauthroized' error (In AzureBlobStorage, if storage accounts are different for source & destination we get 'Unauthorized' error). And fix applying "use_native_copy" when endpoint is defined in configuration. [#87826](https://github.com/ClickHouse/ClickHouse/pull/87826) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* ClickHouse crashes if ArrowStream file has non-unique dictionary. [#87863](https://github.com/ClickHouse/ClickHouse/pull/87863) ([Ilya Golshtein](https://github.com/ilejn)).
* Fix fatal using approx_top_k and finalizeAggregation. [#87892](https://github.com/ClickHouse/ClickHouse/pull/87892) ([Jitendra](https://github.com/jitendra1411)).
* Fix merge with projections when the last block is empty. [#87928](https://github.com/ClickHouse/ClickHouse/pull/87928) ([Raúl Marín](https://github.com/Algunenano)).
* Don't remove injective functions from GROUP BY if arguments types are not allowed in GROUP BY. [#87958](https://github.com/ClickHouse/ClickHouse/pull/87958) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix for incorrect granules/partitions elimination for datetime-based keys, when using `session_timezone` setting in queries. [#87987](https://github.com/ClickHouse/ClickHouse/pull/87987) ([Eduard Karacharov](https://github.com/korowa)).
* Returns affected rows count after query in PostgreSQL Interface. [#87990](https://github.com/ClickHouse/ClickHouse/pull/87990) ([Artem Yurov](https://github.com/ArtemYurov)).
* Restrics using of filter pushdown for PASTE JOIN because it can cause incorrect results. [#88078](https://github.com/ClickHouse/ClickHouse/pull/88078) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* Applies URI normalization before evaluation for the grants check introduced by https://github.com/ClickHouse/ClickHouse/pull/84503. [#88089](https://github.com/ClickHouse/ClickHouse/pull/88089) ([pufit](https://github.com/pufit)).
* Fix logical error when ARRAY JOIN COLUMNS() matches no columns in new analyzer. [#88091](https://github.com/ClickHouse/ClickHouse/pull/88091) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Fix "High ClickHouse memory usage" warning (exclude page cache). [#88092](https://github.com/ClickHouse/ClickHouse/pull/88092) ([Azat Khuzhin](https://github.com/azat)).
* Fixed possible data corruption in `MergeTree` tables with set column `TTL`. [#88095](https://github.com/ClickHouse/ClickHouse/pull/88095) ([Anton Popov](https://github.com/CurtizJ)).
* Fix possible uncaught exception while reading `system.tables` with invalid tables in external databases (`PostgreSQL`/`SQLite`/...) attached. [#88105](https://github.com/ClickHouse/ClickHouse/pull/88105) ([Azat Khuzhin](https://github.com/azat)).
* Fixed crash in `mortonEncode` and `hilbertEncode` functions when called with empty tuple argument. [#88110](https://github.com/ClickHouse/ClickHouse/pull/88110) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Now `ON CLUSTER` queries will take less time in case of inactive replicas in cluster. [#88153](https://github.com/ClickHouse/ClickHouse/pull/88153) ([alesapin](https://github.com/alesapin)).
* Now DDL worker cleanup outdated hosts from replicas set. It will reduce amount of stored metadata in ZooKeeper. [#88154](https://github.com/ClickHouse/ClickHouse/pull/88154) ([alesapin](https://github.com/alesapin)).
* Fix running ClickHouse w/o cgroups (accidentally cgroups became a requirement for asynchronous metrics). [#88164](https://github.com/ClickHouse/ClickHouse/pull/88164) ([Azat Khuzhin](https://github.com/azat)).
* Do proper undo of the move directory operation in case of error. We need to rewrite all `prefix.path` objects changed during the execution, not only the root one. [#88198](https://github.com/ClickHouse/ClickHouse/pull/88198) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Backported in [#89213](https://github.com/ClickHouse/ClickHouse/issues/89213): Using shared_ptr for QueryState in TCPHandler to detect if the state is invalid in setProgressCallback, setFileProgressCallback and setBlockMarshallingCallback. [#88201](https://github.com/ClickHouse/ClickHouse/pull/88201) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fixed propagation of `is_shared` flag in `ColumnLowCardinality`. It may lead to a wrong group-by result if a new value is inserted in a column after hash values are already pre-calculated and cached in the `ReverseIndex`. [#88213](https://github.com/ClickHouse/ClickHouse/pull/88213) ([Nikita Taranov](https://github.com/nickitat)).
* Fixes a workload setting `max_cpu_share`. Now it can be used without `max_cpus` workload setting being set. [#88217](https://github.com/ClickHouse/ClickHouse/pull/88217) ([Neerav](https://github.com/neeravsalaria)).
* Fix bug that very heavy mutations with subqueries could stuck in prepare stage. Now it's possible to stop these mutations with `SYSTEM STOP MERGES`. [#88241](https://github.com/ClickHouse/ClickHouse/pull/88241) ([alesapin](https://github.com/alesapin)).
* Now correlated subqueries will work with object storages. [#88290](https://github.com/ClickHouse/ClickHouse/pull/88290) ([alesapin](https://github.com/alesapin)).
* Avoid trying to initialize DataLake databases while accessing `system.projections` and `system.data_skipping_indices`. [#88330](https://github.com/ClickHouse/ClickHouse/pull/88330) ([Azat Khuzhin](https://github.com/azat)).
* Now datalakes catalogs will be shown in system introspection tables only if `show_data_lake_catalogs_in_system_tables` explicitly enabled. [#88341](https://github.com/ClickHouse/ClickHouse/pull/88341) ([alesapin](https://github.com/alesapin)).
* Fixed DatabaseReplicated to respect `interserver_http_host` configuration. [#88378](https://github.com/ClickHouse/ClickHouse/pull/88378) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Positional arguments are now explicitly disabled in the context of defining Projections, as they are not sensible in this internal query stage. This fixes [#48604](https://github.com/ClickHouse/ClickHouse/issues/48604). [#88380](https://github.com/ClickHouse/ClickHouse/pull/88380) ([Amos Bird](https://github.com/amosbird)).
* Fix quadratic complexity in the `countMatches` function. Closes [#88400](https://github.com/ClickHouse/ClickHouse/issues/88400). [#88401](https://github.com/ClickHouse/ClickHouse/pull/88401) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Make `ALTER COLUMN ... COMMENT` commands for KeeperMap tables replicated so they are committed to Replicated database metadata and propagated across all replicas. Closes [#88077](https://github.com/ClickHouse/ClickHouse/issues/88077). [#88408](https://github.com/ClickHouse/ClickHouse/pull/88408) ([Eduard Karacharov](https://github.com/korowa)).
* Fix a case of false cyclic dependency with Materialized Views in Database Replicated, which prevented new replicas from being added to the database. [#88423](https://github.com/ClickHouse/ClickHouse/pull/88423) ([Nikolay Degterinsky](https://github.com/evillique)).
* Fix aggregation of sparse columns when `group_by_overflow_mode` is set to `any`. [#88440](https://github.com/ClickHouse/ClickHouse/pull/88440) ([Eduard Karacharov](https://github.com/korowa)).
* Fix "column not found" error when using `query_plan_use_logical_join_step=0` with multiple FULL JOIN USING clauses. Closes [#88103](https://github.com/ClickHouse/ClickHouse/issues/88103). [#88473](https://github.com/ClickHouse/ClickHouse/pull/88473) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Big clusters with node numbers > 10 have a high probability of failing the restore with error `[941] 67c45db4-4df4-4879-87c5-25b8d1e0d414 <Trace>: RestoreCoordinationOnCluster The version of node /clickhouse/backups/restore-7c551a77-bd76-404c-bad0-3213618ac58e/stage/num_hosts changed (attempt #9), will try again`. The `num_hosts` node is overwritten by many hosts at the same time. The fix makes the setting to control attempts dynamic. Closes [#87721](https://github.com/ClickHouse/ClickHouse/issues/87721). [#88484](https://github.com/ClickHouse/ClickHouse/pull/88484) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* This PR just for making compatibility to 23.8 and before, The compatibility issue was introduced by this PR: https://github.com/ClickHouse/ClickHouse/pull/54240 This SQL will fail with `enable_analyzer=0`(before 23.8, it's ok) ``` select * from t1 s final join ( select * from t2 final ) r final on s.key = r.key join ( select * from t3 final ) c final on s.key = c.key ``` Because `JoinToSubqueryTransformVisitor` will rewrite this SQL to ``` SELECT `_--s.key` AS `s.key`, `_--s.value` AS `s.value`, `_--r.key` AS `r.key`, `_--r.value` AS `r.value`, `_--c.key` AS `c.key`, `_--c.value` AS `c.value` FROM ( SELECT value AS `_--s.value`, key AS `_--s.key`, r.value AS `_--r.value`, r.key AS `_--r.key` FROM t1 AS s FINAL ALL INNER JOIN ( SELECT key, value FROM t2 FINAL ) AS r FINAL ON `_--s.key` = `_--r.key` ) AS `--.s` ALL INNER JOIN ( SELECT value AS `_--c.value`, key AS `_--c.key` FROM ( SELECT key, value FROM t3 FINAL ) AS c FINAL ) AS `--.t` ON `_--s.key` = `_--c.key` ``` We want to rewrite this SQL to(just move the last FINAL) ``` SELECT `_--s.key` AS `s.key`, `_--s.value` AS `s.value`, `_--r.key` AS `r.key`, `_--r.value` AS `r.value`, `_--c.key` AS `c.key`, `_--c.value` AS `c.value` FROM ( SELECT value AS `_--s.value`, key AS `_--s.key`, r.value AS `_--r.value`, r.key AS `_--r.key` FROM t1 AS s FINAL ALL INNER JOIN ( SELECT key, value FROM t2 FINAL ) AS r FINAL ON `_--s.key` = `_--r.key` ) AS `--.s` ALL INNER JOIN ( SELECT value AS `_--c.value`, key AS `_--c.key` FROM ( SELECT key, value FROM t3 FINAL ) AS c ) AS `--.t` FINAL ON `_--s.key` = `_--c.key` ```. [#88491](https://github.com/ClickHouse/ClickHouse/pull/88491) ([JIaQi](https://github.com/JiaQiTang98)).
* Fix UBSAN integer overflow in `accurateCast` error message when converting large values to DateTime. [#88520](https://github.com/ClickHouse/ClickHouse/pull/88520) ([xiaohuanlin](https://github.com/xiaohuanlin)).
* Fix coalescing merge tree for tuple types. This closes [#88469](https://github.com/ClickHouse/ClickHouse/issues/88469). [#88526](https://github.com/ClickHouse/ClickHouse/pull/88526) ([scanhex12](https://github.com/scanhex12)).
* Forbid deletes for `iceberg_format_version=1`. This closes [#88444](https://github.com/ClickHouse/ClickHouse/issues/88444). [#88532](https://github.com/ClickHouse/ClickHouse/pull/88532) ([scanhex12](https://github.com/scanhex12)).
* This patch fixes the move operation of `plain-rewritable` disks for folders of arbitrary depth. [#88586](https://github.com/ClickHouse/ClickHouse/pull/88586) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Fix SQL SECURITY DEFINER with *cluster functions. [#88588](https://github.com/ClickHouse/ClickHouse/pull/88588) ([Julian Maicher](https://github.com/jmaicher)).
* Fix potential crash caused by concurrent mutation of underlying const PREWHERE columns. [#88605](https://github.com/ClickHouse/ClickHouse/pull/88605) ([Azat Khuzhin](https://github.com/azat)).
* Fixed reading from the text index and enabled query condition cache (with enabled settings `use_skip_indexes_on_data_read` and `use_query_condition_cache`). [#88660](https://github.com/ClickHouse/ClickHouse/pull/88660) ([Anton Popov](https://github.com/CurtizJ)).
* A `Poco::TimeoutException` exception thrown from `Poco::Net::HTTPChunkedStreamBuf::readFromDevice` leads to a crash with SIGABRT. [#88668](https://github.com/ClickHouse/ClickHouse/pull/88668) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Backported in [#88910](https://github.com/ClickHouse/ClickHouse/issues/88910): After recovering, a Replicated database replica might get stuck for a long time printing messages like `Failed to marked query-0004647339 as finished (finished=No node, synced=No node)`, it's fixed. [#88671](https://github.com/ClickHouse/ClickHouse/pull/88671) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Fix appending to `system.zookeeper_connection_log` in case ClickHouse connects for the first time after config reload. [#88728](https://github.com/ClickHouse/ClickHouse/pull/88728) ([Antonio Andelic](https://github.com/antonio2368)).
* Fixed a bug where converting DateTime64 to Date with `date_time_overflow_behavior = 'saturate'` could lead to incorrect results for out-of-range values when working with time zones. [#88737](https://github.com/ClickHouse/ClickHouse/pull/88737) ([Manuel](https://github.com/raimannma)).
* Nth attempt to fix "having zero bytes error" with s3 table engine with enabled cache. [#88740](https://github.com/ClickHouse/ClickHouse/pull/88740) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Fixes access validation on select for `loop` table function. [#88802](https://github.com/ClickHouse/ClickHouse/pull/88802) ([pufit](https://github.com/pufit)).
* Catch exceptions when async logging fails to prevent program aborts. [#88814](https://github.com/ClickHouse/ClickHouse/pull/88814) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#89060](https://github.com/ClickHouse/ClickHouse/issues/89060): Fix `top_k` to respect the threshold parameter when called with a single argument. Closes [#88757](https://github.com/ClickHouse/ClickHouse/issues/88757). [#88867](https://github.com/ClickHouse/ClickHouse/pull/88867) ([Manuel](https://github.com/raimannma)).
* Backported in [#88944](https://github.com/ClickHouse/ClickHouse/issues/88944): Fix bug in the function `reverseUTF8`. In previous versions, it mistakenly reversed the bytes of UTF-8 code points of length 4. This closes [#88913](https://github.com/ClickHouse/ClickHouse/issues/88913). [#88914](https://github.com/ClickHouse/ClickHouse/pull/88914) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#88980](https://github.com/ClickHouse/ClickHouse/issues/88980): Do not check access `SET DEFINER <current_user>:definer` when creating a view with SQL SECURITY DEFINER. [#88968](https://github.com/ClickHouse/ClickHouse/pull/88968) ([pufit](https://github.com/pufit)).
* Backported in [#89058](https://github.com/ClickHouse/ClickHouse/issues/89058): Fixed `LOGICAL_ERROR` in `L2DistanceTransposed(vec1, vec2, p)` where the optimisation for partial `QBit` reading incorrectly removed `Nullable` from the return type when `p` was `Nullable`. [#88974](https://github.com/ClickHouse/ClickHouse/pull/88974) ([Raufs Dunamalijevs](https://github.com/rienath)).
* Backported in [#89167](https://github.com/ClickHouse/ClickHouse/issues/89167): Fix crash in unknown catalog type. Resolves [#88819](https://github.com/ClickHouse/ClickHouse/issues/88819). [#88987](https://github.com/ClickHouse/ClickHouse/pull/88987) ([scanhex12](https://github.com/scanhex12)).
* Backported in [#89085](https://github.com/ClickHouse/ClickHouse/issues/89085): This closes [#88081](https://github.com/ClickHouse/ClickHouse/issues/88081). [#88988](https://github.com/ClickHouse/ClickHouse/pull/88988) ([scanhex12](https://github.com/scanhex12)).
* Backported in [#89028](https://github.com/ClickHouse/ClickHouse/issues/89028): Fixed performance degradation in analysis of skipping indexes. [#89004](https://github.com/ClickHouse/ClickHouse/pull/89004) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#89295](https://github.com/ClickHouse/ClickHouse/issues/89295): Fix ACCESS_ENTITY_NOT_FOUND error when trying to execute clusterAllReplicas from a user with a non-existing role. Resolves [#87670](https://github.com/ClickHouse/ClickHouse/issues/87670). [#89068](https://github.com/ClickHouse/ClickHouse/pull/89068) ([pufit](https://github.com/pufit)).
* Backported in [#89326](https://github.com/ClickHouse/ClickHouse/issues/89326): Fix calculation of buffer size needed for base32/base58 encoding and decoding operations. [#89133](https://github.com/ClickHouse/ClickHouse/pull/89133) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#89349](https://github.com/ClickHouse/ClickHouse/issues/89349): Avoid possible data-races due to mutable exceptions while parsing Parquet. Fixes [#88385](https://github.com/ClickHouse/ClickHouse/issues/88385). [#89174](https://github.com/ClickHouse/ClickHouse/pull/89174) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#89268](https://github.com/ClickHouse/ClickHouse/issues/89268): Refreshable materialized view: fixed rare server crash if source table was fully dropped during a refresh. [#89203](https://github.com/ClickHouse/ClickHouse/pull/89203) ([Michael Kolupaev](https://github.com/al13n321)).

#### Build/Testing/Packaging Improvement
* Add more perf cases to test full text search index. [#87577](https://github.com/ClickHouse/ClickHouse/pull/87577) ([Nikita Fomichev](https://github.com/fm4v)).
* Use `postgres` 18.0. [#87647](https://github.com/ClickHouse/ClickHouse/pull/87647) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Enable ICU for FreeBSD. [#87891](https://github.com/ClickHouse/ClickHouse/pull/87891) ([Raúl Marín](https://github.com/Algunenano)).
* Use sse4.2 when we dispatch to sse4.2 and not sse4. [#88029](https://github.com/ClickHouse/ClickHouse/pull/88029) ([Raúl Marín](https://github.com/Algunenano)).
* Don't require `NO_ARMV81_OR_HIGHER` flag if `Speculative Store Bypass Safe` is unavailable. [#88051](https://github.com/ClickHouse/ClickHouse/pull/88051) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* When ClickHouse is built with `ENABLE_LIBFIU=OFF`, failpoint-related functions become no-ops and cannot impact performance anymore. `SYSTEM ENABLE/DISABLE FAILPOINT` queries return a `SUPPORT_IS_DISABLED` error in that case. [#88184](https://github.com/ClickHouse/ClickHouse/pull/88184) ([c-end](https://github.com/c-end)).
* ``` /clickhouse/base/base/wide_integer_impl.h:358:53: error: no member named 'make_pair' in namespace 'std' 358 | wide_integer_from_tuple_like(self, std::make_pair(value.low64, value.high64)); ```. [#88498](https://github.com/ClickHouse/ClickHouse/pull/88498) ([buyval01](https://github.com/buyval01)).
* Follow-up for [#88484](https://github.com/ClickHouse/ClickHouse/issues/88484) to fix the race in the test. [#88701](https://github.com/ClickHouse/ClickHouse/pull/88701) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

#### Improvement (user-visible misbehavior in an official stable release)

* Fix requesting the structure of a dataset from the ArrowFlight server when creating a table. [#87542](https://github.com/ClickHouse/ClickHouse/pull/87542) ([Vitaly Baranov](https://github.com/vitlibar)).

#### NO CL CATEGORY

* Backported in [#88956](https://github.com/ClickHouse/ClickHouse/issues/88956):. [#88828](https://github.com/ClickHouse/ClickHouse/pull/88828) ([scanhex12](https://github.com/scanhex12)).

#### NO CL ENTRY

* NO CL ENTRY:  'Revert "Revert "CI: Fix log export configuration""'. [#87464](https://github.com/ClickHouse/ClickHouse/pull/87464) ([Max Kainov](https://github.com/maxknv)).
* NO CL ENTRY:  'Revert "Add test for issue 85976"'. [#87482](https://github.com/ClickHouse/ClickHouse/pull/87482) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'Revert "CI: add automatic PR description and change log generation using Claude code"'. [#87652](https://github.com/ClickHouse/ClickHouse/pull/87652) ([Shaun Struwig](https://github.com/Blargian)).
* NO CL ENTRY:  'Revert "Fix wrong returned type in `search_issues`"'. [#87715](https://github.com/ClickHouse/ClickHouse/pull/87715) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* NO CL ENTRY:  'Revert "changelog.py: Fix handling for PRs from Copilot user"'. [#87736](https://github.com/ClickHouse/ClickHouse/pull/87736) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* NO CL ENTRY:  'Revert "Use system.completions table for suggestions"'. [#87868](https://github.com/ClickHouse/ClickHouse/pull/87868) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* NO CL ENTRY:  'second attempt: Use system.completions table for suggestions'. [#87901](https://github.com/ClickHouse/ClickHouse/pull/87901) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* NO CL ENTRY:  'Revert "Add test 03631_huge_query_filter_analyze"'. [#88116](https://github.com/ClickHouse/ClickHouse/pull/88116) ([Azat Khuzhin](https://github.com/azat)).
* NO CL ENTRY:  'Revert "Fix fatal using approx-top-k issue 86882"'. [#88228](https://github.com/ClickHouse/ClickHouse/pull/88228) ([Raúl Marín](https://github.com/Algunenano)).
* NO CL ENTRY:  'Revert "Idp login cli support"'. [#88414](https://github.com/ClickHouse/ClickHouse/pull/88414) ([Nikita Fomichev](https://github.com/fm4v)).
* NO CL ENTRY:  'Revert "Deflake test_keeper_disks::test_logs_with_disks: deterministic waits + pure‑merge validation"'. [#88464](https://github.com/ClickHouse/ClickHouse/pull/88464) ([Antonio Andelic](https://github.com/antonio2368)).
* NO CL ENTRY:  'Revert "Harden test_ddl_worker_with_loopback_hosts against CI flakes" and add proper fix'. [#88472](https://github.com/ClickHouse/ClickHouse/pull/88472) ([alesapin](https://github.com/alesapin)).
* NO CL ENTRY:  'Revert "fix flaky test: poll for SESSION_NOT_FOUND in 03373_named_session_try_recreate_before_timeout"'. [#88475](https://github.com/ClickHouse/ClickHouse/pull/88475) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'Revert "ci: add complete database directory into artifacts for failed tests"'. [#88530](https://github.com/ClickHouse/ClickHouse/pull/88530) ([Max Kainov](https://github.com/maxknv)).
* NO CL ENTRY:  'Revert "Fix coalescing merge tree for tuple types"'. [#88645](https://github.com/ClickHouse/ClickHouse/pull/88645) ([Antonio Andelic](https://github.com/antonio2368)).
* NO CL ENTRY:  'Revert "Intern Task: Text Classification with Ngram Models"'. [#88674](https://github.com/ClickHouse/ClickHouse/pull/88674) ([Alexander Tokmakov](https://github.com/tavplubix)).
* NO CL ENTRY:  'Revert "Add sanity check to `ReverseIndex`"'. [#88684](https://github.com/ClickHouse/ClickHouse/pull/88684) ([Nikita Taranov](https://github.com/nickitat)).
* NO CL ENTRY:  'Revert "first pass - autogenerated system tables"'. [#88693](https://github.com/ClickHouse/ClickHouse/pull/88693) ([Dominic Tran](https://github.com/dhtclk)).
* NO CL ENTRY:  'Revert "Revert "first pass - autogenerated system tables""'. [#88697](https://github.com/ClickHouse/ClickHouse/pull/88697) ([Dominic Tran](https://github.com/dhtclk)).
* NO CL ENTRY:  'Revert "Add a test for [#65587](https://github.com/ClickHouse/ClickHouse/issues/65587), but it shows a bug with parallel replicas"'. [#88856](https://github.com/ClickHouse/ClickHouse/pull/88856) ([Igor Nikonov](https://github.com/devcrafter)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Do not display empty columns in CI report. [#75992](https://github.com/ClickHouse/ClickHouse/pull/75992) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Changed error code while reading from avro. [#78540](https://github.com/ClickHouse/ClickHouse/pull/78540) ([Kunal Gupta](https://github.com/iamKunalGupta)).
* Fix RMV tryEnqueueReplicatedDDL shutdown crash again. [#78873](https://github.com/ClickHouse/ClickHouse/pull/78873) ([Michael Kolupaev](https://github.com/al13n321)).
* Update libhdfs3 to support ec in pread. [#78959](https://github.com/ClickHouse/ClickHouse/pull/78959) ([M1eyu](https://github.com/M1eyu2018)).
* try remove partition_path node cache when executing forget partition. [#79530](https://github.com/ClickHouse/ClickHouse/pull/79530) ([cw5121](https://github.com/cw5121)).
* Fix path detection for shard metadata. [#82348](https://github.com/ClickHouse/ClickHouse/pull/82348) ([GEFFARD Quentin](https://github.com/qgeffard)).
* Fix suspected bug in Lz4InflatingReadBuffer. [#83880](https://github.com/ClickHouse/ClickHouse/pull/83880) ([Michael Kolupaev](https://github.com/al13n321)).
* Add test for join_using_top_level_identifier with distributed. [#83921](https://github.com/ClickHouse/ClickHouse/pull/83921) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Rewrite IN (subquery) so that it can be executed as JOIN instead of CreatingSets. [#83991](https://github.com/ClickHouse/ClickHouse/pull/83991) ([Alexander Gololobov](https://github.com/davenger)).
* Add a test for [#65587](https://github.com/ClickHouse/ClickHouse/issues/65587), but it shows a bug with parallel replicas. [#84545](https://github.com/ClickHouse/ClickHouse/pull/84545) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Ignore builds/sanitizers tags for flaky check (always run modified tests under flaky check). [#84682](https://github.com/ClickHouse/ClickHouse/pull/84682) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Added tests for fixed parallel replicas issues. [#84886](https://github.com/ClickHouse/ClickHouse/pull/84886) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Fix tests for database_disk on CI. [#84970](https://github.com/ClickHouse/ClickHouse/pull/84970) ([Azat Khuzhin](https://github.com/azat)).
* More tests are parallel (1). [#85439](https://github.com/ClickHouse/ClickHouse/pull/85439) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for compatibility for functions on a single empty string argument. [#85507](https://github.com/ClickHouse/ClickHouse/pull/85507) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* More-careful inlining in PODArray reserve/resize/insert. [#86016](https://github.com/ClickHouse/ClickHouse/pull/86016) ([Michael Kolupaev](https://github.com/al13n321)).
* tests: collect system and jemalloc metrics for test_memory_limit. [#86047](https://github.com/ClickHouse/ClickHouse/pull/86047) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix test for use_roaring_bitmap_iceberg_positional_deletes. [#86243](https://github.com/ClickHouse/ClickHouse/pull/86243) ([Azat Khuzhin](https://github.com/azat)).
* Fix incorrect table name for temporary table. [#86361](https://github.com/ClickHouse/ClickHouse/pull/86361) ([Xiaozhe Yu](https://github.com/wudidapaopao)).
* Added automatic generation and formatting of PR descriptions and changelog entries using Claude AI. PR descriptions and changelog entries can now be auto-generated from PR diffs, or users can provide their own content and have it formatted according to ClickHouse style conventions. [#86363](https://github.com/ClickHouse/ClickHouse/pull/86363) ([Shaun Struwig](https://github.com/Blargian)).
* CI: Integration Tests remove wrappers. [#86543](https://github.com/ClickHouse/ClickHouse/pull/86543) ([Max Kainov](https://github.com/maxknv)).
* Use FunctionArgumentDescriptors to check countDigits function + add t…. [#86645](https://github.com/ClickHouse/ClickHouse/pull/86645) ([Garrett Thomas](https://github.com/garrettthomaskth)).
* CI: Size build runners. [#86687](https://github.com/ClickHouse/ClickHouse/pull/86687) ([Max Kainov](https://github.com/maxknv)).
* Fix MergeTreeSetIndex::checkInRange. [#86771](https://github.com/ClickHouse/ClickHouse/pull/86771) ([Michael Kolupaev](https://github.com/al13n321)).
* add arraySort to the second arg, fix test 02008_materialize_column. [#86800](https://github.com/ClickHouse/ClickHouse/pull/86800) ([Sema Checherinda](https://github.com/CheSema)).
* Limit the size of invalid JSON printed in the error message. [#87076](https://github.com/ClickHouse/ClickHouse/pull/87076) ([Pavel Kruglov](https://github.com/Avogar)).
* Fix simple parquet reader v3 assert on bool column min/max. [#87095](https://github.com/ClickHouse/ClickHouse/pull/87095) ([Michael Kolupaev](https://github.com/al13n321)).
* Fix storage system.tables potential out of bounds access. [#87135](https://github.com/ClickHouse/ClickHouse/pull/87135) ([Maksim Kita](https://github.com/kitaisreal)).
* Avoid allocation when storing jemalloc profile name. [#87149](https://github.com/ClickHouse/ClickHouse/pull/87149) ([Antonio Andelic](https://github.com/antonio2368)).
* Slightly improve the code around updating mutations. [#87206](https://github.com/ClickHouse/ClickHouse/pull/87206) ([Konstantin Morozov](https://github.com/k-morozov)).
* Added a few log lines for a backup execution process. [#87233](https://github.com/ClickHouse/ClickHouse/pull/87233) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Better exception message in case of duplicated parts. [#87248](https://github.com/ClickHouse/ClickHouse/pull/87248) ([alesapin](https://github.com/alesapin)).
* Check read mode with all `CoordinationMode`-s. [#87254](https://github.com/ClickHouse/ClickHouse/pull/87254) ([Nikita Taranov](https://github.com/nickitat)).
* Fix 'Invalid dict indices bit width: 0' in parquet reader v3. [#87258](https://github.com/ClickHouse/ClickHouse/pull/87258) ([Michael Kolupaev](https://github.com/al13n321)).
* fix exception message in `ReadBufferFromRemoteFSGather::setReadUntilPosition`. [#87296](https://github.com/ClickHouse/ClickHouse/pull/87296) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Update text index docs. [#87307](https://github.com/ClickHouse/ClickHouse/pull/87307) ([Robert Schulze](https://github.com/rschu1ze)).
* This reduces the number of calls to `SYSTEM FLUSH LOG query_log` in our test `02765_queries_with_subqueries_profile_events`. This has been the cause of a number of flaky tests where many clients stall waiting on log flushes (https://github.com/ClickHouse/ClickHouse/issues/85101). [#87308](https://github.com/ClickHouse/ClickHouse/pull/87308) ([Grant Holly](https://github.com/grantholly-clickhouse)).
* small fixes to cmake flags around object storage. [#87314](https://github.com/ClickHouse/ClickHouse/pull/87314) ([Bharat Nallan](https://github.com/bharatnc)).
* Use official ctcache repo again after PR merged. [#87320](https://github.com/ClickHouse/ClickHouse/pull/87320) ([Pablo Marcos](https://github.com/pamarcos)).
* Remove web meta tx. [#87328](https://github.com/ClickHouse/ClickHouse/pull/87328) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Fix typo: Manaila -> Manila in README.md. [#87338](https://github.com/ClickHouse/ClickHouse/pull/87338) ([ChaiAndCode](https://github.com/SaaiAravindhRaja)).
* Update version after release. [#87344](https://github.com/ClickHouse/ClickHouse/pull/87344) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* PR: enable tests with column dependent aliases. [#87355](https://github.com/ClickHouse/ClickHouse/pull/87355) ([Igor Nikonov](https://github.com/devcrafter)).
* add missing TABLE keyword to SYSTEM DROP REPLICA error message [#87031](https://github.com/ClickHouse/ClickHouse/issues/87031). [#87356](https://github.com/ClickHouse/ClickHouse/pull/87356) ([Garrett Thomas](https://github.com/garrettthomaskth)).
* Update README.md. [#87359](https://github.com/ClickHouse/ClickHouse/pull/87359) ([Zoe Steinkamp](https://github.com/zoesteinkamp)).
* Log processors only when applicable, for SELECTs and INSERTs. [#87364](https://github.com/ClickHouse/ClickHouse/pull/87364) ([Azat Khuzhin](https://github.com/azat)).
* Rename file after the function it contains. [#87367](https://github.com/ClickHouse/ClickHouse/pull/87367) ([Robert Schulze](https://github.com/rschu1ze)).
* Enable `use_skip_indexes_on_data_read` by default. [#87368](https://github.com/ClickHouse/ClickHouse/pull/87368) ([Robert Schulze](https://github.com/rschu1ze)).
* Update CHANGELOG.md. [#87376](https://github.com/ClickHouse/ClickHouse/pull/87376) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* More data lakes testing. [#87377](https://github.com/ClickHouse/ClickHouse/pull/87377) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Change `datalake_disk_name` to `disk`. [#87388](https://github.com/ClickHouse/ClickHouse/pull/87388) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Rename settings and change defaults. [#87389](https://github.com/ClickHouse/ClickHouse/pull/87389) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add test for issue 85976. [#87391](https://github.com/ClickHouse/ClickHouse/pull/87391) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Tweak test_streaming_to_many_views log check. [#87398](https://github.com/ClickHouse/ClickHouse/pull/87398) ([Raúl Marín](https://github.com/Algunenano)).
* do not mark CI as red due to the debug message. [#87404](https://github.com/ClickHouse/ClickHouse/pull/87404) ([Sema Checherinda](https://github.com/CheSema)).
* Support creating `KeyPair` from PEM string or OpenSSL BIO. [#87440](https://github.com/ClickHouse/ClickHouse/pull/87440) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix exception handling in OpenSSLHelpers.cpp. [#87441](https://github.com/ClickHouse/ClickHouse/pull/87441) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix bool decoding in parquet reader v3. [#87442](https://github.com/ClickHouse/ClickHouse/pull/87442) ([Michael Kolupaev](https://github.com/al13n321)).
* Test text index files accurately counted in system table. [#87443](https://github.com/ClickHouse/ClickHouse/pull/87443) ([George Larionov](https://github.com/george-larionov)).
* Make parquet reader v3 preserve decimal precision information. [#87444](https://github.com/ClickHouse/ClickHouse/pull/87444) ([Michael Kolupaev](https://github.com/al13n321)).
* Change licensing exception error code. [#87445](https://github.com/ClickHouse/ClickHouse/pull/87445) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Fix settings changes test for backup_slow_all_threads_after_retryable_s3_error. [#87449](https://github.com/ClickHouse/ClickHouse/pull/87449) ([Azat Khuzhin](https://github.com/azat)).
* EmbeddedRocksDB: Go back to using data/ path by default. [#87463](https://github.com/ClickHouse/ClickHouse/pull/87463) ([Raúl Marín](https://github.com/Algunenano)).
* Fix logical error in outer join reordering. [#87484](https://github.com/ClickHouse/ClickHouse/pull/87484) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Safer IObjectStorage::tryGetObjectMetadata() (ignore only object existence error). Ignoring any errors leads to bugs - https://github.com/ClickHouse/ClickHouse/pull/87426. [#87485](https://github.com/ClickHouse/ClickHouse/pull/87485) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v25.7.7.68-stable. [#87486](https://github.com/ClickHouse/ClickHouse/pull/87486) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v25.8.5.17-lts. [#87487](https://github.com/ClickHouse/ClickHouse/pull/87487) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Revert "Query condition cache: introduce selectivity threshold". [#87498](https://github.com/ClickHouse/ClickHouse/pull/87498) ([Robert Schulze](https://github.com/rschu1ze)).
* Sync private. [#87510](https://github.com/ClickHouse/ClickHouse/pull/87510) ([Raufs Dunamalijevs](https://github.com/rienath)).
* Sync changes. [#87511](https://github.com/ClickHouse/ClickHouse/pull/87511) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Deprecate `clearDirectory`. [#87512](https://github.com/ClickHouse/ClickHouse/pull/87512) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Add guardrails for keeper disk. [#87519](https://github.com/ClickHouse/ClickHouse/pull/87519) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Fix indent for `Ranges` output in `EXPLAIN indexes=1`. [#87543](https://github.com/ClickHouse/ClickHouse/pull/87543) ([Azat Khuzhin](https://github.com/azat)).
* Add starts and endsWithCaseInsensitive test coverage. [#87556](https://github.com/ClickHouse/ClickHouse/pull/87556) ([Guang Zhao](https://github.com/zheguang)).
* Fix dependencies for google_cloud_cpp_kms. [#87561](https://github.com/ClickHouse/ClickHouse/pull/87561) ([Pablo Marcos](https://github.com/pamarcos)).
* Check for JSON/Dynamic support during CREATE only if there are such columns. [#87563](https://github.com/ClickHouse/ClickHouse/pull/87563) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v25.8.6.11-lts. [#87568](https://github.com/ClickHouse/ClickHouse/pull/87568) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Needed to support IfNoneMatch for Put/CompleteMultipartUpload requests. [#87569](https://github.com/ClickHouse/ClickHouse/pull/87569) ([alesapin](https://github.com/alesapin)).
* Better exception about reaching the memory threshold during inserts. [#87570](https://github.com/ClickHouse/ClickHouse/pull/87570) ([yanglongwei](https://github.com/ylw510)).
* Fix test_storage_delta/test.py::test_replicated_database_and_unavailable_s3. [#87579](https://github.com/ClickHouse/ClickHouse/pull/87579) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Make a separate IColumn method to take exact dynamic structure from a column. [#87582](https://github.com/ClickHouse/ClickHouse/pull/87582) ([Pavel Kruglov](https://github.com/Avogar)).
* Reapply "Use Analyzer to generate actions from default expression" and fix prewhere issue. [#87585](https://github.com/ClickHouse/ClickHouse/pull/87585) ([Pervakov Grigorii](https://github.com/GrigoryPervakov)).
* Fix usage of text index with expressions. [#87590](https://github.com/ClickHouse/ClickHouse/pull/87590) ([Anton Popov](https://github.com/CurtizJ)).
* More fixes for parquet reader v3, enable it in stateless tests. [#87600](https://github.com/ClickHouse/ClickHouse/pull/87600) ([Michael Kolupaev](https://github.com/al13n321)).
* Bump pip from 25.0.1 to 25.2 in /ci/docker/libfuzzer. [#87604](https://github.com/ClickHouse/ClickHouse/pull/87604) ([dependabot[bot]](https://github.com/apps/dependabot)).
* Update setting history for query_plan_optimize_join_order_limit. [#87612](https://github.com/ClickHouse/ClickHouse/pull/87612) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Small fixes for jemalloc profiler. [#87614](https://github.com/ClickHouse/ClickHouse/pull/87614) ([Antonio Andelic](https://github.com/antonio2368)).
* Fix filtering the flaky integration test. [#87616](https://github.com/ClickHouse/ClickHouse/pull/87616) ([Pablo Marcos](https://github.com/pamarcos)).
* Move test files to their proper locationn. [#87621](https://github.com/ClickHouse/ClickHouse/pull/87621) ([Arthur Passos](https://github.com/arthurpassos)).
* Rename the log level settings from startupLevel and shutdownLevel to startup_level and shutdown_level to match the general settings format. [#87624](https://github.com/ClickHouse/ClickHouse/pull/87624) ([Nikita Fomichev](https://github.com/fm4v)).
* Add column descriptions in system.database_replicas. [#87625](https://github.com/ClickHouse/ClickHouse/pull/87625) ([Konstantin Morozov](https://github.com/k-morozov)).
* Update version_date.tsv and changelog after v25.8.7.3-lts. [#87628](https://github.com/ClickHouse/ClickHouse/pull/87628) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* make os_thread_priority alias on os_threads_nice_value_query. [#87629](https://github.com/ClickHouse/ClickHouse/pull/87629) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* changelog.py: Fix handling for PRs from Copilot user. [#87640](https://github.com/ClickHouse/ClickHouse/pull/87640) ([Nikita Fomichev](https://github.com/fm4v)).
* PR: make n-way join tests less confusing. [#87644](https://github.com/ClickHouse/ClickHouse/pull/87644) ([Igor Nikonov](https://github.com/devcrafter)).
* Fixed descriptions in CHANGELOG.md for `Iceberg` and `DeltaLake` tables features: - Added clarification that custom disk configuration is supported via storage level setting `disk` - Corrected naming of Iceberg insertion settings to `iceberg_insert_max_rows_in_data_file` and `iceberg_insert_max_bytes_in_data_file` - Improved descriptions of Delta Lake and Iceberg file size limiting functionality. [#87645](https://github.com/ClickHouse/ClickHouse/pull/87645) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Removed tests `02023_transform_or_to_in` and `00066_sorting_distributed_many_replicas` from parallel replicas blacklist, allowing them to run in parallel mode. [#87648](https://github.com/ClickHouse/ClickHouse/pull/87648) ([Igor Nikonov](https://github.com/devcrafter)).
* ci: temporary disable database disk in integration tests to avoid flakiness. [#87657](https://github.com/ClickHouse/ClickHouse/pull/87657) ([Azat Khuzhin](https://github.com/azat)).
* More tests for parallel replicas. [#87669](https://github.com/ClickHouse/ClickHouse/pull/87669) ([zoomxi](https://github.com/zoomxi)).
* Revert "Merge pull request [#76569](https://github.com/ClickHouse/ClickHouse/issues/76569) from RinChanNOWWW/alias". [#87671](https://github.com/ClickHouse/ClickHouse/pull/87671) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add test 03631_huge_query_filter_analyze. [#87673](https://github.com/ClickHouse/ClickHouse/pull/87673) ([Vladimir Cherkasov](https://github.com/vdimir)).
* More comments around  join runtime filters. [#87678](https://github.com/ClickHouse/ClickHouse/pull/87678) ([Alexander Gololobov](https://github.com/davenger)).
* Remove unused code. [#87682](https://github.com/ClickHouse/ClickHouse/pull/87682) ([Kseniia Sumarokova](https://github.com/kssenii)).
* The type was changed recently, and it's good to shape it with upstream https://github.com/PyGithub/PyGithub/commit/938f80b1b427171e1dd6f5b425d32471bdeb9dc5#diff-cd558fc3c3c4b4ddfcbb8e34bcd6a3fa37d85cb07d510f46efa74f0b8c24fdfeR746. [#87684](https://github.com/ClickHouse/ClickHouse/pull/87684) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Exclude MD5-related tests from FIPS test run. [#87689](https://github.com/ClickHouse/ClickHouse/pull/87689) ([Konstantin Bogdanov](https://github.com/thevar1able)).
* Issue fixed by https://github.com/ClickHouse/ClickHouse/pull/80848. [#87694](https://github.com/ClickHouse/ClickHouse/pull/87694) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Better time travel testing. [#87696](https://github.com/ClickHouse/ClickHouse/pull/87696) ([Pedro Ferreira](https://github.com/PedroTadim)).
* PR: check read mode on announcement. [#87701](https://github.com/ClickHouse/ClickHouse/pull/87701) ([Igor Nikonov](https://github.com/devcrafter)).
* Add test for [#84548](https://github.com/ClickHouse/ClickHouse/issues/84548). [#87713](https://github.com/ClickHouse/ClickHouse/pull/87713) ([Pedro Ferreira](https://github.com/PedroTadim)).
* tests: fix flakiness of integration tests due to too poor logs checks. [#87719](https://github.com/ClickHouse/ClickHouse/pull/87719) ([Azat Khuzhin](https://github.com/azat)).
* changelog.py: Fix handling of Copilot user. [#87737](https://github.com/ClickHouse/ClickHouse/pull/87737) ([Nikita Fomichev](https://github.com/fm4v)).
* Update version_date.tsv and changelog after v25.9.2.1-stable. [#87738](https://github.com/ClickHouse/ClickHouse/pull/87738) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* This closes [#87332](https://github.com/ClickHouse/ClickHouse/issues/87332). [#87754](https://github.com/ClickHouse/ClickHouse/pull/87754) ([scanhex12](https://github.com/scanhex12)).
* Add more info for granule adjustment error ``` Can't adjust last granule because it has 8192 rows, but try to subtract 16384 rows ```. [#87764](https://github.com/ClickHouse/ClickHouse/pull/87764) ([Vitaly Baranov](https://github.com/vitlibar)).
* Extend trace_log with memory_context and memory_blocked_context for ClickHouse debugging. [#87765](https://github.com/ClickHouse/ClickHouse/pull/87765) ([Azat Khuzhin](https://github.com/azat)).
* `QBit`: Add cloud badge, reserve encoding `0x36`, and restructure vector docs. [#87799](https://github.com/ClickHouse/ClickHouse/pull/87799) ([Raufs Dunamalijevs](https://github.com/rienath)).
* Don't crash if a vector similarity index cannot be saved to / loaded from persistence. [#87803](https://github.com/ClickHouse/ClickHouse/pull/87803) ([Azat Khuzhin](https://github.com/azat)).
* tests: better 01848_http_insert_segfault. [#87811](https://github.com/ClickHouse/ClickHouse/pull/87811) ([Azat Khuzhin](https://github.com/azat)).
* do not mark CI as red due to the debug message, more cases. [#87833](https://github.com/ClickHouse/ClickHouse/pull/87833) ([Sema Checherinda](https://github.com/CheSema)).
* Disable `CheckStat` by default. [#87835](https://github.com/ClickHouse/ClickHouse/pull/87835) ([Mikhail Artemenko](https://github.com/Michicosun)).
* unlink METADATA_VERSION_FILE_NAME before rewrite it, fix no such key thrown. [#87838](https://github.com/ClickHouse/ClickHouse/pull/87838) ([Sema Checherinda](https://github.com/CheSema)).
* Fix 25.9.2.1 changelog. [#87847](https://github.com/ClickHouse/ClickHouse/pull/87847) ([Max Kainov](https://github.com/maxknv)).
* Remove useless MemoryTrackerBlockerInThread from SystemLogBase::add(). [#87888](https://github.com/ClickHouse/ClickHouse/pull/87888) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix flaky 03591_client_hilite_hex_highlight (increase timeout). [#87889](https://github.com/ClickHouse/ClickHouse/pull/87889) ([Azat Khuzhin](https://github.com/azat)).
* Let's simplify interfaces with using `StoredObject` directly instead of `ObjectStorageKey`. [#87893](https://github.com/ClickHouse/ClickHouse/pull/87893) ([Mikhail Artemenko](https://github.com/Michicosun)).
* This closes [#87619](https://github.com/ClickHouse/ClickHouse/issues/87619). [#87895](https://github.com/ClickHouse/ClickHouse/pull/87895) ([scanhex12](https://github.com/scanhex12)).
* Integration tests: Replace missing bitnami images. [#87897](https://github.com/ClickHouse/ClickHouse/pull/87897) ([Nikita Fomichev](https://github.com/fm4v)).
* Update version_date.tsv and changelog after v25.8.8.26-lts. [#87899](https://github.com/ClickHouse/ClickHouse/pull/87899) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* tests: fix flakiness of test_check_table_name_length due to invalid identifier generated. [#87902](https://github.com/ClickHouse/ClickHouse/pull/87902) ([Azat Khuzhin](https://github.com/azat)).
* Fix add-test for multi-extension files. [#87921](https://github.com/ClickHouse/ClickHouse/pull/87921) ([Vladimir Cherkasov](https://github.com/vdimir)).
* tests: fix flakiness of test_trace_log_memory_context. [#87924](https://github.com/ClickHouse/ClickHouse/pull/87924) ([Azat Khuzhin](https://github.com/azat)).
* tests: preserve http server log in test_external_http_authenticator. [#87925](https://github.com/ClickHouse/ClickHouse/pull/87925) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix flakiness of test_keeper_memory_soft_limit (make it less fragile). [#87951](https://github.com/ClickHouse/ClickHouse/pull/87951) ([Azat Khuzhin](https://github.com/azat)).
* Add `optimizeDirectReadFromTextIndex` information to the debug level logs for testing. [#87955](https://github.com/ClickHouse/ClickHouse/pull/87955) ([Jimmy Aguilar Mena](https://github.com/Ergus)).
* Fix parquet prewhere with non-UInt8 condition. [#87956](https://github.com/ClickHouse/ClickHouse/pull/87956) ([Michael Kolupaev](https://github.com/al13n321)).
* Cosmetics around text index. [#87959](https://github.com/ClickHouse/ClickHouse/pull/87959) ([Robert Schulze](https://github.com/rschu1ze)).
* Make test_allow_feature_tier/test.py::test_allow_feature_tier_in_mergetree_settings fail more clearly. [#87963](https://github.com/ClickHouse/ClickHouse/pull/87963) ([Raúl Marín](https://github.com/Algunenano)).
* Sync changes. [#87973](https://github.com/ClickHouse/ClickHouse/pull/87973) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Add .github/copilot-instructions.md for coding and review agent. [#87986](https://github.com/ClickHouse/ClickHouse/pull/87986) (Copilot).
* Use Set for join runtime filter when the number of elements is small. [#87991](https://github.com/ClickHouse/ClickHouse/pull/87991) ([Alexander Gololobov](https://github.com/davenger)).
* More traces for prefetched pool and marks loader. [#87992](https://github.com/ClickHouse/ClickHouse/pull/87992) ([Nikita Taranov](https://github.com/nickitat)).
* Solve direct read issue with low cardinality text columns. [#87994](https://github.com/ClickHouse/ClickHouse/pull/87994) ([Jimmy Aguilar Mena](https://github.com/Ergus)).
* Make the test test_filesystem_cache_log less flaky. [#87996](https://github.com/ClickHouse/ClickHouse/pull/87996) ([Narasimha Pakeer](https://github.com/npakeer)).
* fixing description of setting. [#88000](https://github.com/ClickHouse/ClickHouse/pull/88000) ([Grant Holly](https://github.com/grantholly-clickhouse)).
* Add logs to S3 Client. [#88001](https://github.com/ClickHouse/ClickHouse/pull/88001) ([Julia Kartseva](https://github.com/jkartseva)).
* Clean up temp files generated in `MetadataStorageFromPlainObjectStorageMoveFileOperation` when loading table metadata in `DatabaseOnDisk`. [#88006](https://github.com/ClickHouse/ClickHouse/pull/88006) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fix undefined behaviour in timeSeriesGroupArray(). [#88007](https://github.com/ClickHouse/ClickHouse/pull/88007) ([Vitaly Baranov](https://github.com/vitlibar)).
* Sync changes. [#88015](https://github.com/ClickHouse/ClickHouse/pull/88015) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Get back `PageCacheMaxBytes` metric. [#88016](https://github.com/ClickHouse/ClickHouse/pull/88016) ([Azat Khuzhin](https://github.com/azat)).
* Follow up to [#87303](https://github.com/ClickHouse/ClickHouse/issues/87303). Add a check for row policies in `ReadFromMergeTree`. [#88017](https://github.com/ClickHouse/ClickHouse/pull/88017) ([Dmitry Novik](https://github.com/novikd)).
* Remove `stack` usage from the interface and remove outdated comments. [#88019](https://github.com/ClickHouse/ClickHouse/pull/88019) ([Dmitry Novik](https://github.com/novikd)).
* More fuzz testing. [#88034](https://github.com/ClickHouse/ClickHouse/pull/88034) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Closes [#85834](https://github.com/ClickHouse/ClickHouse/issues/85834). [#88036](https://github.com/ClickHouse/ClickHouse/pull/88036) ([Dmitry Novik](https://github.com/novikd)).
* fix deadlock in Context::handleCrash. [#88040](https://github.com/ClickHouse/ClickHouse/pull/88040) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* Fix AST fuzzer failures around `network_compression_method`. [#88048](https://github.com/ClickHouse/ClickHouse/pull/88048) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix 01275_parallel_mv. [#88053](https://github.com/ClickHouse/ClickHouse/pull/88053) ([Antonio Andelic](https://github.com/antonio2368)).
* Sync changes. [#88064](https://github.com/ClickHouse/ClickHouse/pull/88064) ([Kseniia Sumarokova](https://github.com/kssenii)).
* fixing typo in error message created when inserting with cyclic materialized views. [#88086](https://github.com/ClickHouse/ClickHouse/pull/88086) ([Grant Holly](https://github.com/grantholly-clickhouse)).
* tests: fix test_failed_async_inserts flakiness in private (disable remote database disk). [#88094](https://github.com/ClickHouse/ClickHouse/pull/88094) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix flakiness of 02676_analyzer_limit_offset. [#88097](https://github.com/ClickHouse/ClickHouse/pull/88097) ([Azat Khuzhin](https://github.com/azat)).
* tests: atomically write config in test_disallow_concurrency (fixes remote database disk). [#88098](https://github.com/ClickHouse/ClickHouse/pull/88098) ([Azat Khuzhin](https://github.com/azat)).
* CI: Fix memory leaks in CI report page. [#88101](https://github.com/ClickHouse/ClickHouse/pull/88101) ([Max Kainov](https://github.com/maxknv)).
* The `test_jbod_balancer` test occasionally fails with "There are still merges on-going after 20 assignments". It's likely due to recent changes in merge strategy which may result in more merge iterations needed to fully merge parts. Since the test performs 200 inserts, increase the merge attempt limit from 20 to 200 should be enough. The test still exits early when `optimize_throw_if_noop` confirms no more merges are possible, so this doesn't affect normal test time. [#88104](https://github.com/ClickHouse/ClickHouse/pull/88104) ([Amos Bird](https://github.com/amosbird)).
* Avoid using lz4/zstd from rust crates. [#88112](https://github.com/ClickHouse/ClickHouse/pull/88112) ([Azat Khuzhin](https://github.com/azat)).
* Some cmake cleanups. [#88113](https://github.com/ClickHouse/ClickHouse/pull/88113) ([Azat Khuzhin](https://github.com/azat)).
* Fix rows_before_aggregation for aggregation in order. [#88117](https://github.com/ClickHouse/ClickHouse/pull/88117) ([Eduard Karacharov](https://github.com/korowa)).
* tests: proper atomic config generation in test_disallow_concurrency. [#88122](https://github.com/ClickHouse/ClickHouse/pull/88122) ([Azat Khuzhin](https://github.com/azat)).
* Add hackernews dataset and run parameters to vector search stress test. [#88124](https://github.com/ClickHouse/ClickHouse/pull/88124) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Update query_plan_optimize_join_order_limit in settings changes. [#88133](https://github.com/ClickHouse/ClickHouse/pull/88133) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Add debug info. [#88137](https://github.com/ClickHouse/ClickHouse/pull/88137) ([Kseniia Sumarokova](https://github.com/kssenii)).
* CI: Sort aspell dict correctly. [#88140](https://github.com/ClickHouse/ClickHouse/pull/88140) ([Robert Schulze](https://github.com/rschu1ze)).
* Fix bad error message in function `hasAny/AllTokens`. [#88152](https://github.com/ClickHouse/ClickHouse/pull/88152) ([Robert Schulze](https://github.com/rschu1ze)).
* This patch allows the exchange of `removeRecursive` from disk tx to meta tx `removeRecursive`, which can be useful for the meta blob tracker. [#88160](https://github.com/ClickHouse/ClickHouse/pull/88160) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Fix port overlapping in ytsaurus tests. [#88165](https://github.com/ClickHouse/ClickHouse/pull/88165) ([MikhailBurdukov](https://github.com/MikhailBurdukov)).
* Update version_date.tsv and changelog after v25.8.9.20-lts. [#88178](https://github.com/ClickHouse/ClickHouse/pull/88178) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v25.9.3.48-stable. [#88181](https://github.com/ClickHouse/ClickHouse/pull/88181) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Save system database and table metadata files from the remote database disk and restore them to scrape system table logs with clickhouse local. [#88183](https://github.com/ClickHouse/ClickHouse/pull/88183) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Fixed a bug that caused incorrect behavior when reading Sparse `.size` subcolumn of `String` columns from compact parts. The issue was due to missing `serialization` context in `IDataType::getSubcolumn()` and related functions. Fixes [#88167](https://github.com/ClickHouse/ClickHouse/issues/88167). Introduced in [#82850](https://github.com/ClickHouse/ClickHouse/issues/82850) which is not released yet. [#88187](https://github.com/ClickHouse/ClickHouse/pull/88187) ([Amos Bird](https://github.com/amosbird)).
* CI: Integration test runner improvements. [#88190](https://github.com/ClickHouse/ClickHouse/pull/88190) ([Max Kainov](https://github.com/maxknv)).
* Add a setting `database_replicated_drop_broken_tables` to drop unexpected tables from Replicated databases. [#88204](https://github.com/ClickHouse/ClickHouse/pull/88204) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Test text search on partially indexed table. [#88206](https://github.com/ClickHouse/ClickHouse/pull/88206) ([George Larionov](https://github.com/george-larionov)).
* Tests: Add coverage for hasAnyTokens/hasAllTokens on non-indexed FixedString. [#88210](https://github.com/ClickHouse/ClickHouse/pull/88210) ([Mohammad Lareb Zafar](https://github.com/zlareb1)).
* ci: fix restoring metadata files for clickhouse-local in case of remote database disk. [#88230](https://github.com/ClickHouse/ClickHouse/pull/88230) ([Azat Khuzhin](https://github.com/azat)).
* fix flaky test: poll for SESSION_NOT_FOUND in 03373_named_session_try_recreate_before_timeout. [#88235](https://github.com/ClickHouse/ClickHouse/pull/88235) ([Mohammad Lareb Zafar](https://github.com/zlareb1)).
* Flush distributed table in the end of the test, so DROP DATABSE will not wait for it and will not block other tests: https://pastila.nl/?0027b4c3/2513d4d65a7f7b1366d30b214fb290fa#uUO2ufEAbOKfy5aFAqRPLA==. [#88236](https://github.com/ClickHouse/ClickHouse/pull/88236) ([Alexander Tokmakov](https://github.com/tavplubix)).
* Add sanity check to `ReverseIndex`. [#88239](https://github.com/ClickHouse/ClickHouse/pull/88239) ([Nikita Taranov](https://github.com/nickitat)).
* Some problems of `plain_rewritable` disks. [#88240](https://github.com/ClickHouse/ClickHouse/pull/88240) ([Mikhail Artemenko](https://github.com/Michicosun)).
* force log `CORRUPTED_DATA` exceptions. [#88242](https://github.com/ClickHouse/ClickHouse/pull/88242) ([Miсhael Stetsyuk](https://github.com/mstetsyuk)).
* `QBit`: Narrowing optimisation and `simsimd` integration. [#88243](https://github.com/ClickHouse/ClickHouse/pull/88243) ([Raufs Dunamalijevs](https://github.com/rienath)).
* CI: Support custom option for Integration Tests job. [#88244](https://github.com/ClickHouse/ClickHouse/pull/88244) ([Max Kainov](https://github.com/maxknv)).
* Fix `CurrentMetrics::ConcurrentQueryAcquired`. [#88247](https://github.com/ClickHouse/ClickHouse/pull/88247) ([Sergei Trifonov](https://github.com/serxa)).
* Flaky test fix: Retry ZooKeeper znode creation and metric collection in test_keeper_memory_soft_limit. [#88251](https://github.com/ClickHouse/ClickHouse/pull/88251) ([Mohammad Lareb Zafar](https://github.com/zlareb1)).
* Fix test_ytsaurus_select_subset_of_columns. [#88260](https://github.com/ClickHouse/ClickHouse/pull/88260) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Add check reading spark from s3 in tests. [#88279](https://github.com/ClickHouse/ClickHouse/pull/88279) ([scanhex12](https://github.com/scanhex12)).
* Update version_date.tsv and changelog after v25.8.10.7-lts. [#88288](https://github.com/ClickHouse/ClickHouse/pull/88288) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* CI: Docker server job refactoring for praktika CI. [#88291](https://github.com/ClickHouse/ClickHouse/pull/88291) ([Max Kainov](https://github.com/maxknv)).
* Add --settings and --merge-tree-settings options to easily reproduce CI test settings locally. [#88303](https://github.com/ClickHouse/ClickHouse/pull/88303) ([Mohammad Lareb Zafar](https://github.com/zlareb1)).
* Text index: log front coded strings size per dictionary block. [#88305](https://github.com/ClickHouse/ClickHouse/pull/88305) ([Elmi Ahmadov](https://github.com/ahmadov)).
* CI: Support custom binary location in Integration tests. [#88308](https://github.com/ClickHouse/ClickHouse/pull/88308) ([Max Kainov](https://github.com/maxknv)).
* Allow 0 as keeper server id. [#88309](https://github.com/ClickHouse/ClickHouse/pull/88309) ([scanhex12](https://github.com/scanhex12)).
* CI: Integration flaky test job: fix behaviour. [#88313](https://github.com/ClickHouse/ClickHouse/pull/88313) ([Max Kainov](https://github.com/maxknv)).
* CI: Add CIDB link to failed tests in the report. [#88315](https://github.com/ClickHouse/ClickHouse/pull/88315) ([Max Kainov](https://github.com/maxknv)).
* CI: Run integration tests locally with job alias. [#88321](https://github.com/ClickHouse/ClickHouse/pull/88321) ([Max Kainov](https://github.com/maxknv)).
* fix threads count for inserts. [#88339](https://github.com/ClickHouse/ClickHouse/pull/88339) ([Sema Checherinda](https://github.com/CheSema)).
* Improved catalogs fuzz testing. [#88340](https://github.com/ClickHouse/ClickHouse/pull/88340) ([Pedro Ferreira](https://github.com/PedroTadim)).
* Harden test_ddl_worker_with_loopback_hosts against CI flakes. [#88342](https://github.com/ClickHouse/ClickHouse/pull/88342) ([Mohammad Lareb Zafar](https://github.com/zlareb1)).
* Add a test for [#43267](https://github.com/ClickHouse/ClickHouse/issues/43267). [#88369](https://github.com/ClickHouse/ClickHouse/pull/88369) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#43841](https://github.com/ClickHouse/ClickHouse/issues/43841). [#88371](https://github.com/ClickHouse/ClickHouse/pull/88371) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#52390](https://github.com/ClickHouse/ClickHouse/issues/52390). [#88372](https://github.com/ClickHouse/ClickHouse/pull/88372) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#50349](https://github.com/ClickHouse/ClickHouse/issues/50349). [#88373](https://github.com/ClickHouse/ClickHouse/pull/88373) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#49720](https://github.com/ClickHouse/ClickHouse/issues/49720). [#88374](https://github.com/ClickHouse/ClickHouse/pull/88374) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#46119](https://github.com/ClickHouse/ClickHouse/issues/46119). [#88375](https://github.com/ClickHouse/ClickHouse/pull/88375) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#58965](https://github.com/ClickHouse/ClickHouse/issues/58965). [#88376](https://github.com/ClickHouse/ClickHouse/pull/88376) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Replace IDatabase::canContain*Tables() with isExternal(). [#88381](https://github.com/ClickHouse/ClickHouse/pull/88381) ([Azat Khuzhin](https://github.com/azat)).
* tests: faster 00159_parallel_formatting tests. [#88382](https://github.com/ClickHouse/ClickHouse/pull/88382) ([Eduard Karacharov](https://github.com/korowa)).
* Add a test for [#69141](https://github.com/ClickHouse/ClickHouse/issues/69141). [#88386](https://github.com/ClickHouse/ClickHouse/pull/88386) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Add a test for [#66255](https://github.com/ClickHouse/ClickHouse/issues/66255). [#88387](https://github.com/ClickHouse/ClickHouse/pull/88387) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Cleanups a text index test. [#88392](https://github.com/ClickHouse/ClickHouse/pull/88392) ([Robert Schulze](https://github.com/rschu1ze)).
* Add `--proto-caps` option to `clickhouse-benchmark`. [#88395](https://github.com/ClickHouse/ClickHouse/pull/88395) ([Ahmed Gouda](https://github.com/0xgouda)).
* tests: fix 03403_distributed_merge_two_level_aggregation flakiness. [#88406](https://github.com/ClickHouse/ClickHouse/pull/88406) ([Azat Khuzhin](https://github.com/azat)).
* tests: avoid using global SYSTEM FLUSH LOGS. [#88407](https://github.com/ClickHouse/ClickHouse/pull/88407) ([Azat Khuzhin](https://github.com/azat)).
* Add a test for mutations serialization format. [#88409](https://github.com/ClickHouse/ClickHouse/pull/88409) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* No role hash in LDAP. [#88412](https://github.com/ClickHouse/ClickHouse/pull/88412) ([Ilya Golshtein](https://github.com/ilejn)).
* tests: fix 03644_cancel_huge_mutation_subquery flakiness. [#88415](https://github.com/ClickHouse/ClickHouse/pull/88415) ([Azat Khuzhin](https://github.com/azat)).
* Deflake test_keeper_disks::test_logs_with_disks: deterministic waits and zxid-continuity checks. [#88442](https://github.com/ClickHouse/ClickHouse/pull/88442) ([Mohammad Lareb Zafar](https://github.com/zlareb1)).
* Add `AVX-512VL` to dynamic dispatch and optimise `QBit` [un]transposition. [#88445](https://github.com/ClickHouse/ClickHouse/pull/88445) ([Raufs Dunamalijevs](https://github.com/rienath)).
* Style check: Fix executable check on Mac. [#88446](https://github.com/ClickHouse/ClickHouse/pull/88446) ([Alexei Fedotov](https://github.com/leshikus)).
* Add some debugging HTTP connection drain. [#88456](https://github.com/ClickHouse/ClickHouse/pull/88456) ([Azat Khuzhin](https://github.com/azat)).
* Improve CI libfuzzer - add multithreading, increase run time. [#88457](https://github.com/ClickHouse/ClickHouse/pull/88457) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Collect all logs from failed integration tests. [#88463](https://github.com/ClickHouse/ClickHouse/pull/88463) ([Antonio Andelic](https://github.com/antonio2368)).
* PR: fix (disable) JOINs with ARRAY/CROSS JOIN on left side. [#88465](https://github.com/ClickHouse/ClickHouse/pull/88465) ([Igor Nikonov](https://github.com/devcrafter)).
* Avoid 03176_check_timeout_in_index_analysis flakiness. [#88471](https://github.com/ClickHouse/ClickHouse/pull/88471) ([Raúl Marín](https://github.com/Algunenano)).
* reduce the cost of reading statistics. [#88485](https://github.com/ClickHouse/ClickHouse/pull/88485) ([Han Fei](https://github.com/hanfei1991)).
* ci: add complete database directory into artifacts for failed tests. [#88493](https://github.com/ClickHouse/ClickHouse/pull/88493) ([Azat Khuzhin](https://github.com/azat)).
* CI: Bugfix validation for Integration Tests fixes. [#88497](https://github.com/ClickHouse/ClickHouse/pull/88497) ([Max Kainov](https://github.com/maxknv)).
* Backported in [#89327](https://github.com/ClickHouse/ClickHouse/issues/89327): Fix explain indexes with use_skip_indexes_on_data_read + use_query_condition_cache. [#88504](https://github.com/ClickHouse/ClickHouse/pull/88504) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Small fuzzer fixes. [#88527](https://github.com/ClickHouse/ClickHouse/pull/88527) ([Pedro Ferreira](https://github.com/PedroTadim)).
* ci: fix collecting artifacts for integration tests. [#88531](https://github.com/ClickHouse/ClickHouse/pull/88531) ([Azat Khuzhin](https://github.com/azat)).
* Fix `ColumnBLOB should be converted to a regular column before usage` from `CREATE AS SELECT`. [#88544](https://github.com/ClickHouse/ClickHouse/pull/88544) ([Nikita Taranov](https://github.com/nickitat)).
* tests: better 02003_memory_limit_in_client. [#88545](https://github.com/ClickHouse/ClickHouse/pull/88545) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v25.7.8.71-stable. [#88546](https://github.com/ClickHouse/ClickHouse/pull/88546) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Update version_date.tsv and changelog after v25.6.13.41-stable. [#88547](https://github.com/ClickHouse/ClickHouse/pull/88547) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Randomize flaky tests for the case when they are launched as `--count`; show every path where the `clickhouse` binary is searched. [#88548](https://github.com/ClickHouse/ClickHouse/pull/88548) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* tests: make 02003_memory_limit_in_client more stable. [#88555](https://github.com/ClickHouse/ClickHouse/pull/88555) ([Azat Khuzhin](https://github.com/azat)).
* Update version_date.tsv and changelog after v25.5.11.15-stable. [#88559](https://github.com/ClickHouse/ClickHouse/pull/88559) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Save system metadata files from remote database disks to the local disk earlier. [#88561](https://github.com/ClickHouse/ClickHouse/pull/88561) ([Tuan Pham Anh](https://github.com/tuanpach)).
* CI: Wrap logs collection in try/catch. [#88562](https://github.com/ClickHouse/ClickHouse/pull/88562) ([Max Kainov](https://github.com/maxknv)).
* Relocate the binary before other threads are started. [#88564](https://github.com/ClickHouse/ClickHouse/pull/88564) ([Raúl Marín](https://github.com/Algunenano)).
* CI: Fix terminating a process in a docker. [#88567](https://github.com/ClickHouse/ClickHouse/pull/88567) ([Alexei Fedotov](https://github.com/leshikus)).
* test: fix flakiness of test_async_load_databases (pushing to MV reordered and lack of proper cleanup). [#88573](https://github.com/ClickHouse/ClickHouse/pull/88573) ([Azat Khuzhin](https://github.com/azat)).
* Sync ProfileEvents. [#88584](https://github.com/ClickHouse/ClickHouse/pull/88584) ([Azat Khuzhin](https://github.com/azat)).
* Introduce an option to disable all debug symbols and use it in release builds for PRs (but not master). [#88585](https://github.com/ClickHouse/ClickHouse/pull/88585) ([Raúl Marín](https://github.com/Algunenano)).
* CI: Set custom CIDB URL for reading statistics from CIDB. [#88595](https://github.com/ClickHouse/ClickHouse/pull/88595) ([Max Kainov](https://github.com/maxknv)).
* Add more tests for `plain-rewritable`. [#88596](https://github.com/ClickHouse/ClickHouse/pull/88596) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Followup for https://github.com/ClickHouse/ClickHouse/pull/87913 (not yet in release), support limit in bytes (`max_joined_block_size_bytes`) when using `joined_block_split_single_row`. [#88600](https://github.com/ClickHouse/ClickHouse/pull/88600) ([Vladimir Cherkasov](https://github.com/vdimir)).
* CI: Truncate to big PR summary comment. [#88601](https://github.com/ClickHouse/ClickHouse/pull/88601) ([Max Kainov](https://github.com/maxknv)).
* Fix crash when rewriting IN to EXISTS in some case. [#88602](https://github.com/ClickHouse/ClickHouse/pull/88602) ([Alexander Gololobov](https://github.com/davenger)).
* Update version_date.tsv and changelog after v25.3.7.194-lts. [#88603](https://github.com/ClickHouse/ClickHouse/pull/88603) ([robot-clickhouse](https://github.com/robot-clickhouse)).
* Fix LOGICAL_ERROR when ALTER TABLE REWRITE PARTS batched with other mutations. [#88608](https://github.com/ClickHouse/ClickHouse/pull/88608) ([Azat Khuzhin](https://github.com/azat)).
* Statistics: Don't throw LOGICAL_ERROR where not appropriate. [#88609](https://github.com/ClickHouse/ClickHouse/pull/88609) ([Robert Schulze](https://github.com/rschu1ze)).
* Make runner's output unbuffered. Process tests from arguments in the same logic as for CI, splitting to parallel and sequential. Save keeper and clickhouse-server configs from docker-compose in `configs.tar.gz` files. [#88611](https://github.com/ClickHouse/ClickHouse/pull/88611) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).
* Revert "Enable skip index usage during read by default". [#88638](https://github.com/ClickHouse/ClickHouse/pull/88638) ([Robert Schulze](https://github.com/rschu1ze)).
* Better logging in case of duplicated parts. [#88639](https://github.com/ClickHouse/ClickHouse/pull/88639) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix test_backup_restore_s3 flakiness. [#88646](https://github.com/ClickHouse/ClickHouse/pull/88646) ([Azat Khuzhin](https://github.com/azat)).
* tests: fix test_trace_log_memory_context flakiness. [#88663](https://github.com/ClickHouse/ClickHouse/pull/88663) ([Azat Khuzhin](https://github.com/azat)).
* Add profiling and logging on merge destruction. [#88672](https://github.com/ClickHouse/ClickHouse/pull/88672) ([Yarik Briukhovetskyi](https://github.com/yariks5s)).
* CI: cidb label to be separate from test name. [#88675](https://github.com/ClickHouse/ClickHouse/pull/88675) ([Max Kainov](https://github.com/maxknv)).
* Disable 02122_4letter_words_stress_zookeeper for Shared Catalog. [#88678](https://github.com/ClickHouse/ClickHouse/pull/88678) ([Nikolay Degterinsky](https://github.com/evillique)).
* Move RPNBuilder implementation to cpp file. [#88683](https://github.com/ClickHouse/ClickHouse/pull/88683) ([Daniil Ivanik](https://github.com/divanik)).
* Fixup after merge. [#88698](https://github.com/ClickHouse/ClickHouse/pull/88698) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI libfuzzer: increase fuzzers' run time to 60 minutes. [#88705](https://github.com/ClickHouse/ClickHouse/pull/88705) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* CI: Pytest parser fix. [#88726](https://github.com/ClickHouse/ClickHouse/pull/88726) ([Max Kainov](https://github.com/maxknv)).
* Fix tests after [#86628](https://github.com/ClickHouse/ClickHouse/issues/86628). [#88754](https://github.com/ClickHouse/ClickHouse/pull/88754) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Miscellaneous. [#88788](https://github.com/ClickHouse/ClickHouse/pull/88788) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Miscellaneous. [#88789](https://github.com/ClickHouse/ClickHouse/pull/88789) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Remove obsolete setting from tests. [#88791](https://github.com/ClickHouse/ClickHouse/pull/88791) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* CI: Add workflow to collect and track flaky test issues. [#88821](https://github.com/ClickHouse/ClickHouse/pull/88821) ([Max Kainov](https://github.com/maxknv)).
* CI: Fix Functional tests results parsing with regex pattern matching. [#88825](https://github.com/ClickHouse/ClickHouse/pull/88825) ([Max Kainov](https://github.com/maxknv)).
* get TIMEOUT back. [#88826](https://github.com/ClickHouse/ClickHouse/pull/88826) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* hasAny/AllTokens: Remove support for Array(FixedString) needles. [#88839](https://github.com/ClickHouse/ClickHouse/pull/88839) ([Robert Schulze](https://github.com/rschu1ze)).
* Fixes:. [#88841](https://github.com/ClickHouse/ClickHouse/pull/88841) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Update meetup listings in README.md. [#88854](https://github.com/ClickHouse/ClickHouse/pull/88854) ([Zoe Steinkamp](https://github.com/zoesteinkamp)).
* Update README with 25.10 community call information. [#88855](https://github.com/ClickHouse/ClickHouse/pull/88855) ([Raúl Marín](https://github.com/Algunenano)).
* Sync private changes. [#88861](https://github.com/ClickHouse/ClickHouse/pull/88861) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#89012](https://github.com/ClickHouse/ClickHouse/issues/89012): Fix spelling if setting `s3queue_keeper_fault_injection_probability`. [#88965](https://github.com/ClickHouse/ClickHouse/pull/88965) ([Nikita Fomichev](https://github.com/fm4v)).
* Backported in [#89009](https://github.com/ClickHouse/ClickHouse/issues/89009): Now, log_comment for test queries starts with f, like `f02989_replicated_merge_tree_invalid_metadata_version.sql-test_kq50vskn`, should be just the name of the test + database. This can break CI history analysis. [#88994](https://github.com/ClickHouse/ClickHouse/pull/88994) ([Mikhail Artemenko](https://github.com/Michicosun)).
* Backported in [#89160](https://github.com/ClickHouse/ClickHouse/issues/89160): Don't use metadata cache in iceberg history table. [#89003](https://github.com/ClickHouse/ClickHouse/pull/89003) ([scanhex12](https://github.com/scanhex12)).
* Backported in [#89151](https://github.com/ClickHouse/ClickHouse/issues/89151): Replace SchedulePool with a separate thread. [#89040](https://github.com/ClickHouse/ClickHouse/pull/89040) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#89078](https://github.com/ClickHouse/ClickHouse/issues/89078): Disable the new parquet reader in the CI. [#89067](https://github.com/ClickHouse/ClickHouse/pull/89067) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Backported in [#89254](https://github.com/ClickHouse/ClickHouse/issues/89254): Fix old values for some settings in SettingsChangesHistory. [#89217](https://github.com/ClickHouse/ClickHouse/pull/89217) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#89336](https://github.com/ClickHouse/ClickHouse/issues/89336): Rename default string serialization version to 'single_stream'. [#89231](https://github.com/ClickHouse/ClickHouse/pull/89231) ([Pavel Kruglov](https://github.com/Avogar)).

