---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v25.1.5.31-stable (48f17e8a805) FIXME as compared to v25.1.4.53-stable (c3f28b8bf5d)

#### Improvement
* Backported in [#76048](https://github.com/ClickHouse/ClickHouse/issues/76048): Keeper improvement: disable digest calculation when committing to in-memory storage for better performance. It can be enabled with `keeper_server.digest_enabled_on_commit` config. Digest is still calculated when preprocessing requests. [#75490](https://github.com/ClickHouse/ClickHouse/pull/75490) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#76315](https://github.com/ClickHouse/ClickHouse/issues/76315): Added a server setting `throw_on_unknown_workload` that allows to choose behavior on query with `workload` setting set to unknown value: either allow unlimited access (default) or throw a `RESOURCE_ACCESS_DENIED` error. It is useful to force all queries to use workload scheduling. [#75999](https://github.com/ClickHouse/ClickHouse/pull/75999) ([Sergei Trifonov](https://github.com/serxa)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#76341](https://github.com/ClickHouse/ClickHouse/issues/76341): Check for not supported types for some storages. [#74218](https://github.com/ClickHouse/ClickHouse/pull/74218) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#76362](https://github.com/ClickHouse/ClickHouse/issues/76362): Fix issues with expressions type aliased in the JOIN ON clause when a null-safe comparison is used. [#74970](https://github.com/ClickHouse/ClickHouse/pull/74970) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#75634](https://github.com/ClickHouse/ClickHouse/issues/75634): Fix crash due to uncaught exception in PSQL replication. [#75062](https://github.com/ClickHouse/ClickHouse/pull/75062) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#76246](https://github.com/ClickHouse/ClickHouse/issues/76246): Sasl can fail any rpc call, the fix helps to repeat the call in case if krb5 ticker is expired. [#75063](https://github.com/ClickHouse/ClickHouse/pull/75063) ([inv2004](https://github.com/inv2004)).
* Backported in [#76161](https://github.com/ClickHouse/ClickHouse/issues/76161): Rebuild projection on alter modify of its PK column. Previously it could lead to `CANNOT_READ_ALL_DATA` errors during selects after alter modify of the column used in projection PK. [#75720](https://github.com/ClickHouse/ClickHouse/pull/75720) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#76261](https://github.com/ClickHouse/ClickHouse/issues/76261): Recorded the default enablement of parallel hash as join algorithm in v24.12 in the settings change history. This means that ClickHouse will continue to join using non-parallel hash if an older compatibility level than v24.12 is configured. [#75870](https://github.com/ClickHouse/ClickHouse/pull/75870) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#76201](https://github.com/ClickHouse/ClickHouse/issues/76201): `clickhouse-library-bridge` allows opening arbitrary libraries from the filesystem, which makes it safe to run only inside an isolated environment. To prevent a vulnerability when it is run near the clickhouse-server, we will limit the paths of libraries to a location, provided in the configuration. This vulnerability was found with the [ClickHouse Bug Bounty Program](https://github.com/ClickHouse/ClickHouse/issues/38986) by **Arseniy Dugin**. [#75954](https://github.com/ClickHouse/ClickHouse/pull/75954) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#76382](https://github.com/ClickHouse/ClickHouse/issues/76382): Hopefully fix shutdown crash in ObjectStorageQueueMetadata. [#75323](https://github.com/ClickHouse/ClickHouse/pull/75323) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#76373](https://github.com/ClickHouse/ClickHouse/issues/76373): Fix normalizing function names inside ASTTTLElement. [#75757](https://github.com/ClickHouse/ClickHouse/pull/75757) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#76270](https://github.com/ClickHouse/ClickHouse/issues/76270): DisksApp: fix 'Placement info has not been loaded' and 'The IOThreadPool is not initialized'. [#75873](https://github.com/ClickHouse/ClickHouse/pull/75873) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#76283](https://github.com/ClickHouse/ClickHouse/issues/76283): Do not throw from `~Workload()`. [#76010](https://github.com/ClickHouse/ClickHouse/pull/76010) ([Sergei Trifonov](https://github.com/serxa)).
* Backported in [#76067](https://github.com/ClickHouse/ClickHouse/issues/76067): Add more test logs for decompressing. [#76023](https://github.com/ClickHouse/ClickHouse/pull/76023) ([Vitaly Baranov](https://github.com/vitlibar)).
* Fix `03274_join_algorithm_default`. [#76277](https://github.com/ClickHouse/ClickHouse/pull/76277) ([Robert Schulze](https://github.com/rschu1ze)).

