---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v24.12.6.70-stable (834cccbc6e8) FIXME as compared to v24.12.5.81-stable (abbc2854715)

#### Performance Improvement
* Backported in [#76694](https://github.com/ClickHouse/ClickHouse/issues/76694): Fixed unnecessary contention in `parallel_hash` when `max_rows_in_join = max_bytes_in_join = 0`. [#75155](https://github.com/ClickHouse/ClickHouse/pull/75155) ([Nikita Taranov](https://github.com/nickitat)).

#### Improvement
* Backported in [#76428](https://github.com/ClickHouse/ClickHouse/issues/76428): Address some clickhouse-disks usability issues addressed by users. Closes [#67136](https://github.com/ClickHouse/ClickHouse/issues/67136). [#73616](https://github.com/ClickHouse/ClickHouse/pull/73616) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#76862](https://github.com/ClickHouse/ClickHouse/issues/76862): Add ability to reload `max_remote_read_network_bandwidth_for_serve` and `max_remote_write_network_bandwidth_for_server` on fly without restart server. [#74206](https://github.com/ClickHouse/ClickHouse/pull/74206) ([Kai Zhu](https://github.com/nauu)).
* Backported in [#76451](https://github.com/ClickHouse/ClickHouse/issues/76451): Allow to parse endpoints like `localhost:1234/handle` in `postgresql` or `mysql` table functions. This fixes a regression introduced in https://github.com/ClickHouse/ClickHouse/pull/52503. [#75944](https://github.com/ClickHouse/ClickHouse/pull/75944) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).
* Backported in [#76652](https://github.com/ClickHouse/ClickHouse/issues/76652): Added a server setting `throw_on_unknown_workload` that allows to choose behavior on query with `workload` setting set to unknown value: either allow unlimited access (default) or throw a `RESOURCE_ACCESS_DENIED` error. It is useful to force all queries to use workload scheduling. [#75999](https://github.com/ClickHouse/ClickHouse/pull/75999) ([Sergei Trifonov](https://github.com/serxa)).
* Backported in [#76671](https://github.com/ClickHouse/ClickHouse/issues/76671): Use correct fallback when multipart copy to S3 fails during backup with Access Denied. Multi part copy can generate Access Denied error when backup is done between buckets that have different credentials. [#76515](https://github.com/ClickHouse/ClickHouse/pull/76515) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#77200](https://github.com/ClickHouse/ClickHouse/issues/77200): Previously database replicated might print credentials specified in a query to logs. This behaviour is fixed. This closes: [#77123](https://github.com/ClickHouse/ClickHouse/issues/77123). [#77133](https://github.com/ClickHouse/ClickHouse/pull/77133) ([Nikita Mikhaylov](https://github.com/nikitamikhaylov)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#74520](https://github.com/ClickHouse/ClickHouse/issues/74520): Skip `metadata_version.txt` in while restoring parts from a backup. [#73768](https://github.com/ClickHouse/ClickHouse/pull/73768) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#76527](https://github.com/ClickHouse/ClickHouse/issues/76527): Respect `materialized_views_ignore_errors` when a materialized view writes to a URL engine and there is a connectivity issue. [#75679](https://github.com/ClickHouse/ClickHouse/pull/75679) ([Christoph Wurm](https://github.com/cwurm)).
* Backported in [#76538](https://github.com/ClickHouse/ClickHouse/issues/76538): Fix `Block structure mismatch in QueryPipeline stream` error for some queries with `UNION ALL`. [#75715](https://github.com/ClickHouse/ClickHouse/pull/75715) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#76149](https://github.com/ClickHouse/ClickHouse/issues/76149): Propagate format settings to JSON as string formatting in Native format. [#75832](https://github.com/ClickHouse/ClickHouse/pull/75832) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#76995](https://github.com/ClickHouse/ClickHouse/issues/76995): Fix data loss when enable async insert and insert into ... from file ... with unequal block size if the first block size < async_max_size but the second block > async_max_size, the second block will not be inserted. these data is left in `squashing`. [#76343](https://github.com/ClickHouse/ClickHouse/pull/76343) ([Han Fei](https://github.com/hanfei1991)).
* Backported in [#76401](https://github.com/ClickHouse/ClickHouse/issues/76401): Fix logical error in index analysis if condition in `WHERE` has `pointInPolygon` function. [#76360](https://github.com/ClickHouse/ClickHouse/pull/76360) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#76482](https://github.com/ClickHouse/ClickHouse/issues/76482): Removed allocation from the signal handler. [#76446](https://github.com/ClickHouse/ClickHouse/pull/76446) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#76966](https://github.com/ClickHouse/ClickHouse/issues/76966): Fix THERE_IS_NO_COLUMN exception when selecting boolean literal from distributed tables. [#76656](https://github.com/ClickHouse/ClickHouse/pull/76656) ([Yakov Olkhovskiy](https://github.com/yakov-olkhovskiy)).
* Backported in [#76856](https://github.com/ClickHouse/ClickHouse/issues/76856): Flush output write buffers before finalizing them. Fix `LOGICAL_ERROR` generated during the finalization of some output format, e.g. `JSONEachRowWithProgressRowOutputFormat`. [#76726](https://github.com/ClickHouse/ClickHouse/pull/76726) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#77254](https://github.com/ClickHouse/ClickHouse/issues/77254): Fix possible crash because of bad JSON column rollback on error during async inserts. [#76908](https://github.com/ClickHouse/ClickHouse/pull/76908) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#77060](https://github.com/ClickHouse/ClickHouse/issues/77060): Fix sorting of `BFloat16` values. This closes [#75487](https://github.com/ClickHouse/ClickHouse/issues/75487). This closes [#75669](https://github.com/ClickHouse/ClickHouse/issues/75669). [#77000](https://github.com/ClickHouse/ClickHouse/pull/77000) ([Alexey Milovidov](https://github.com/alexey-milovidov)).
* Backported in [#77218](https://github.com/ClickHouse/ClickHouse/issues/77218): Bug fix json with variant subcolumn by adding check to skip ephemeral subcolumns in part consistency check. [#72187](https://github.com/ClickHouse/ClickHouse/issues/72187). [#77034](https://github.com/ClickHouse/ClickHouse/pull/77034) ([Smita Kulkarni](https://github.com/SmitaRKulkarni)).
* Backported in [#77246](https://github.com/ClickHouse/ClickHouse/issues/77246): Fix crash during Kafka table creation with exception. [#77121](https://github.com/ClickHouse/ClickHouse/pull/77121) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#77391](https://github.com/ClickHouse/ClickHouse/issues/77391): `SELECT toBFloat16(-0.0) == toBFloat16(0.0)` now correctly returns `true` (from previously `false`). This makes the behavior consistent with `Float32` and `Float64`. [#77290](https://github.com/ClickHouse/ClickHouse/pull/77290) ([Shankar Iyer](https://github.com/shankar-iyer)).
* Backported in [#77331](https://github.com/ClickHouse/ClickHouse/issues/77331): Fix comparison between tuples with nullable elements inside and strings. [#77323](https://github.com/ClickHouse/ClickHouse/pull/77323) ([Alexey Katsman](https://github.com/alexkats)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#76506](https://github.com/ClickHouse/ClickHouse/issues/76506): Add `prefetch` method to `ReadBufferFromEncryptedFile`. [#76322](https://github.com/ClickHouse/ClickHouse/pull/76322) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#76463](https://github.com/ClickHouse/ClickHouse/issues/76463): Fix `setReadUntilPosition` in `AsynchronousBoundedReadBuffer`. [#76429](https://github.com/ClickHouse/ClickHouse/pull/76429) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#76600](https://github.com/ClickHouse/ClickHouse/issues/76600): Use `MultiRead` when querying `system.distributed_ddl_queue`. [#76575](https://github.com/ClickHouse/ClickHouse/pull/76575) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#76892](https://github.com/ClickHouse/ClickHouse/issues/76892): Add log for HTTP Bad Request. [#76594](https://github.com/ClickHouse/ClickHouse/pull/76594) ([Christoph Wurm](https://github.com/cwurm)).
* Backported in [#76821](https://github.com/ClickHouse/ClickHouse/issues/76821): CI: Disable cross-compile for ARM in release and backport. [#76808](https://github.com/ClickHouse/ClickHouse/pull/76808) ([Max Kainov](https://github.com/maxknv)).
* Backported in [#76957](https://github.com/ClickHouse/ClickHouse/issues/76957): Allow empty chunks in FinishSortingTransfrom. [#76919](https://github.com/ClickHouse/ClickHouse/pull/76919) ([Nikolai Kochetov](https://github.com/KochetovNicolai)).
* Backported in [#77043](https://github.com/ClickHouse/ClickHouse/issues/77043): fix fast test 02783_parsedatetimebesteffort leap year. [#76940](https://github.com/ClickHouse/ClickHouse/pull/76940) ([Han Fei](https://github.com/hanfei1991)).
* Backported in [#77080](https://github.com/ClickHouse/ClickHouse/issues/77080): Increase log level for dictionary loading. [#77052](https://github.com/ClickHouse/ClickHouse/pull/77052) ([Michael Lex](https://github.com/mlex)).
* Backported in [#77265](https://github.com/ClickHouse/ClickHouse/issues/77265): Fix uninitialized-value `CoordinationZnode::last_success_duration` in `RefreshTask`. [#77174](https://github.com/ClickHouse/ClickHouse/pull/77174) ([Tuan Pham Anh](https://github.com/tuanpach)).

