---
sidebar_position: 1
sidebar_label: 2025
---

# 2025 Changelog

### ClickHouse release v24.12.5.81-stable (abbc2854715) FIXME as compared to v24.12.4.49-stable (2fcb11ae032)

#### Performance Improvement
* Backported in [#75534](https://github.com/ClickHouse/ClickHouse/issues/75534): Fixed calculation of size in memory for `LowCardinality` columns. [#74688](https://github.com/ClickHouse/ClickHouse/pull/74688) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#76005](https://github.com/ClickHouse/ClickHouse/issues/76005): It was discovered that concurrency control could lead to unfair CPU distribution between INSERTs and SELECTs. When all CPU slots are allocated unconditionally (w/o competition) to INSERTs with `max_threads` = 1 while SELECTs with high `max_threads` values suffer from poor performance due to using only a single thread. [#75941](https://github.com/ClickHouse/ClickHouse/pull/75941) ([Sergei Trifonov](https://github.com/serxa)).

#### Improvement
* Backported in [#75535](https://github.com/ClickHouse/ClickHouse/issues/75535): More accurate accounting for `max_joined_block_size_rows` setting for `parallel_hash` JOIN algorithm. Helps to avoid increased memory consumption compared to `hash` algorithm. [#74630](https://github.com/ClickHouse/ClickHouse/pull/74630) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#75844](https://github.com/ClickHouse/ClickHouse/issues/75844): Add check and logging for decrypting and decompressing. [#75471](https://github.com/ClickHouse/ClickHouse/pull/75471) ([Vitaly Baranov](https://github.com/vitlibar)).
* Backported in [#76046](https://github.com/ClickHouse/ClickHouse/issues/76046): Keeper improvement: disable digest calculation when committing to in-memory storage for better performance. It can be enabled with `keeper_server.digest_enabled_on_commit` config. Digest is still calculated when preprocessing requests. [#75490](https://github.com/ClickHouse/ClickHouse/pull/75490) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#75709](https://github.com/ClickHouse/ClickHouse/issues/75709): Disable sending settings from server to client (`send_settings_to_client=false`) for compatibility (This feature will be re-implemented as client setting later for better usability). [#75648](https://github.com/ClickHouse/ClickHouse/pull/75648) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#75805](https://github.com/ClickHouse/ClickHouse/issues/75805): Add a config `memory_worker_correct_memory_tracker` to enable correction of internal memory tracker with information from different source read in the background thread periodically. [#75714](https://github.com/ClickHouse/ClickHouse/pull/75714) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#76069](https://github.com/ClickHouse/ClickHouse/issues/76069): Add `MemoryTrackingUncorrected` metric showing value of internal global memory tracker which is not corrected by RSS. [#75935](https://github.com/ClickHouse/ClickHouse/pull/75935) ([Antonio Andelic](https://github.com/antonio2368)).

#### Bug Fix (user-visible misbehavior in an official stable release)
* Backported in [#75540](https://github.com/ClickHouse/ClickHouse/issues/75540): Fix the following error ``` Row 1: ────── hostname: c-test-wy-37-server-nlkyjyb-0.c-test-wy-37-server-headless.ns-test-wy-37.svc.cluster.local type: ExceptionWhileProcessing event_date: 2024-12-23 event_time: 2024-12-23 16:21:19 event_time_microseconds: 2024-12-23 16:21:19.824624 query_start_time: 2024-12-23 16:21:19 query_start_time_microseconds: 2024-12-23 16:21:19.747142 query_duration_ms: 77 read_rows: 1 read_bytes: 134 written_rows: 0 written_bytes: 0 result_rows: 0 result_bytes: 0 memory_usage: 7824 current_database: default query: CREATE DATABASE db0 formatted_query: normalized_query_hash: 7820917191074023511 -- 7.82 quintillion query_kind: Create databases: ['db0'] tables: [] columns: [] partitions: [] projections: [] views: [] exception_code: 170 exception: Code: 170. DB::Exception: Bad get: has Null, requested Int64: While executing DDLOnClusterQueryStatus. (BAD_GET) (version 25.1.1.19134 (official build)) stack_trace: 0. ./build_docker/./src/Common/Exception.cpp:107: DB::Exception::Exception(DB::Exception::MessageMasked&&, int, bool) @ 0x000000000da5e53b 1. DB::Exception::Exception(PreformattedMessage&&, int) @ 0x00000000088aca4c 2. DB::Exception::Exception<std::basic_string_view<char, std::char_traits<char>>, std::basic_string_view<char, std::char_traits<char>>>(int, FormatStringHelperImpl<std::type_identity<std::basic_string_view<char, std::char_traits<char>>>::type, std::type_identity<std::basic_string_view<char, std::char_traits<char>>>::type>, std::basic_string_view<char, std::char_traits<char>>&&, std::basic_string_view<char, std::char_traits<char>>&&) @ 0x00000000088bae8b 3. auto& DB::Field::safeGet<long>() & @ 0x0000000008a3c748 4. ./src/Core/Field.h:484: DB::ColumnVector<long>::insert(DB::Field const&) @ 0x0000000012e44c0f 5. ./build_docker/./src/Interpreters/DDLOnClusterQueryStatusSource.cpp:53: DB::DDLOnClusterQueryStatusSource::generateChunkWithUnfinishedHosts() const @ 0x0000000012a40214 6. ./build_docker/./src/Interpreters/DDLOnClusterQueryStatusSource.cpp:104: DB::DDLOnClusterQueryStatusSource::handleTimeoutExceeded() @ 0x0000000012a41640 7. ./build_docker/./src/Interpreters/DDLOnClusterQueryStatusSource.cpp:109: DB::DDLOnClusterQueryStatusSource::stopWaitingOfflineHosts() @ 0x0000000012a41be9 8. ./build_docker/./src/Interpreters/DistributedQueryStatusSource.cpp:182: DB::DistributedQueryStatusSource::generate() @ 0x0000000011feb3bf 9. ./build_docker/./src/Processors/ISource.cpp:139: DB::ISource::tryGenerate() @ 0x0000000014148f5b 10. ./build_docker/./src/Processors/ISource.cpp:108: DB::ISource::work() @ 0x0000000014148c47 11. ./build_docker/./src/Processors/Executors/ExecutionThreadContext.cpp:49: DB::ExecutionThreadContext::executeTask() @ 0x0000000014164fc7 12. ./build_docker/./src/Processors/Executors/PipelineExecutor.cpp:290: DB::PipelineExecutor::executeStepImpl(unsigned long, std::atomic<bool>*) @ 0x00000000141577e5 ```. [#73876](https://github.com/ClickHouse/ClickHouse/pull/73876) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Backported in [#75610](https://github.com/ClickHouse/ClickHouse/issues/75610): Propogate Native format settings properly for client-server communication. [#73924](https://github.com/ClickHouse/ClickHouse/pull/73924) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#75558](https://github.com/ClickHouse/ClickHouse/issues/75558): Fix crash with query `INSERT INTO SELECT` over PostgreSQL interface on macOS (issue [#72938](https://github.com/ClickHouse/ClickHouse/issues/72938)). [#74231](https://github.com/ClickHouse/ClickHouse/pull/74231) ([Artem Yurov](https://github.com/ArtemYurov)).
* Backported in [#75632](https://github.com/ClickHouse/ClickHouse/issues/75632): Fix crash due to uncaught exception in PSQL replication. [#75062](https://github.com/ClickHouse/ClickHouse/pull/75062) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#76036](https://github.com/ClickHouse/ClickHouse/issues/76036): Sasl can fail any rpc call, the fix helps to repeat the call in case if krb5 ticker is expired. [#75063](https://github.com/ClickHouse/ClickHouse/pull/75063) ([inv2004](https://github.com/inv2004)).
* Backported in [#75407](https://github.com/ClickHouse/ClickHouse/issues/75407): Fixed usage of indexes (primary and secondary) for `Array`, `Map` and `Nullable(..)` columns with enabled setting `optimize_function_to_subcolumns`. Previously, indexes for these columns could have been ignored. [#75081](https://github.com/ClickHouse/ClickHouse/pull/75081) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#76088](https://github.com/ClickHouse/ClickHouse/issues/76088): Fix nullsafe JOIN handling for LowCardinality nullable data type. Previously JOIN ON with nullsafe comparison, such as `IS NOT DISTINCT FROM`, `<=>` , `a IS NULL AND b IS NULL OR a == b` didn't work correctly with LowCardinality columns. [#75143](https://github.com/ClickHouse/ClickHouse/pull/75143) ([Vladimir Cherkasov](https://github.com/vdimir)).
* Backported in [#76393](https://github.com/ClickHouse/ClickHouse/issues/76393): Checks that we don't specify key_condition when counting total_number_of_rows for NumRowsCache. [#75164](https://github.com/ClickHouse/ClickHouse/pull/75164) ([Daniil Ivanik](https://github.com/divanik)).
* Backported in [#75570](https://github.com/ClickHouse/ClickHouse/issues/75570): Keeper fix: avoid writing to broken changelogs when rolling back logs. [#75197](https://github.com/ClickHouse/ClickHouse/pull/75197) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#75657](https://github.com/ClickHouse/ClickHouse/issues/75657): Mask azureblobstorage table engine credentials. [#75319](https://github.com/ClickHouse/ClickHouse/pull/75319) ([Garrett Thomas](https://github.com/garrettthomaskth)).
* Backported in [#75746](https://github.com/ClickHouse/ClickHouse/issues/75746): Fix crash in protobuf schema cache that can happen during output in Protobuf format and parallel query `SYSTEM DROP FORMAT SCHEMA CACHE`. [#75357](https://github.com/ClickHouse/ClickHouse/pull/75357) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#75482](https://github.com/ClickHouse/ClickHouse/issues/75482): Hide sensitive info for `icebergS3`, `icebergAzure` table functions and table engines. [#75378](https://github.com/ClickHouse/ClickHouse/pull/75378) ([Kseniia Sumarokova](https://github.com/kssenii)).
* Backported in [#76098](https://github.com/ClickHouse/ClickHouse/issues/76098): Fix possible error `Elements ... and ... of Nested data structure ... (Array columns) have different array sizes` when JSON subcolumns with Array type are used in JOIN over distributed tables. [#75512](https://github.com/ClickHouse/ClickHouse/pull/75512) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#75856](https://github.com/ClickHouse/ClickHouse/issues/75856): Fix interaction between allow_feature_tier and compatibility mergetree setting. [#75635](https://github.com/ClickHouse/ClickHouse/pull/75635) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#75894](https://github.com/ClickHouse/ClickHouse/issues/75894): Fixed rare crashes while reading from `MergeTree` table after multiple asynchronous `RENAME` queries (with `alter_sync = 0`) between columns with different types. [#75693](https://github.com/ClickHouse/ClickHouse/pull/75693) ([Anton Popov](https://github.com/CurtizJ)).
* Backported in [#76159](https://github.com/ClickHouse/ClickHouse/issues/76159): Rebuild projection on alter modify of its PK column. Previously it could lead to `CANNOT_READ_ALL_DATA` errors during selects after alter modify of the column used in projection PK. [#75720](https://github.com/ClickHouse/ClickHouse/pull/75720) ([Pavel Kruglov](https://github.com/Avogar)).
* Backported in [#75825](https://github.com/ClickHouse/ClickHouse/issues/75825): Fixed null pointer dereference in `DistinctSortedStreamTransform`. [#75734](https://github.com/ClickHouse/ClickHouse/pull/75734) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#76260](https://github.com/ClickHouse/ClickHouse/issues/76260): Recorded the default enablement of parallel hash as join algorithm in v24.12 in the settings change history. This means that ClickHouse will continue to join using non-parallel hash if an older compatibility level than v24.12 is configured. [#75870](https://github.com/ClickHouse/ClickHouse/pull/75870) ([Robert Schulze](https://github.com/rschu1ze)).
* Backported in [#76199](https://github.com/ClickHouse/ClickHouse/issues/76199): `clickhouse-library-bridge` allows opening arbitrary libraries from the filesystem, which makes it safe to run only inside an isolated environment. To prevent a vulnerability when it is run near the clickhouse-server, we will limit the paths of libraries to a location, provided in the configuration. This vulnerability was found with the [ClickHouse Bug Bounty Program](https://github.com/ClickHouse/ClickHouse/issues/38986) by **Arseniy Dugin**. [#75954](https://github.com/ClickHouse/ClickHouse/pull/75954) ([Alexey Milovidov](https://github.com/alexey-milovidov)).

#### Build/Testing/Packaging Improvement
* Backported in [#76223](https://github.com/ClickHouse/ClickHouse/issues/76223): Make all clickhouse-server related actions a function, and execute them only when launching the default binary in `entrypoint.sh`. A long-postponed improvement was suggested in [#50724](https://github.com/ClickHouse/ClickHouse/issues/50724). Added switch `--users` to `clickhouse-extract-from-config` to get values from the `users.xml`. [#75643](https://github.com/ClickHouse/ClickHouse/pull/75643) ([Mikhail f. Shiryaev](https://github.com/Felixoid)).

#### NOT FOR CHANGELOG / INSIGNIFICANT

* Backported in [#75510](https://github.com/ClickHouse/ClickHouse/issues/75510): Fix the flaky test in `test_replicated_merge_tree_s3_zero_copy/test.py::test_drop_table` by reducing the loop count and backoff period to avoid exceeding the client timeout. [#73102](https://github.com/ClickHouse/ClickHouse/pull/73102) ([Tuan Pham Anh](https://github.com/tuanpach)).
* Backported in [#75968](https://github.com/ClickHouse/ClickHouse/issues/75968): tests: fix test_keeper_disks/test.py::test_logs_with_disks flakiness. [#74197](https://github.com/ClickHouse/ClickHouse/pull/74197) ([Azat Khuzhin](https://github.com/azat)).
* Backported in [#75601](https://github.com/ClickHouse/ClickHouse/issues/75601): Fix 03312_squashing_with_low_card_mem_usage for private. [#75084](https://github.com/ClickHouse/ClickHouse/pull/75084) ([Nikita Taranov](https://github.com/nickitat)).
* Backported in [#75526](https://github.com/ClickHouse/ClickHouse/issues/75526): Don't print RSS in memory limit exceeded for query. [#75224](https://github.com/ClickHouse/ClickHouse/pull/75224) ([Antonio Andelic](https://github.com/antonio2368)).
* Backported in [#76384](https://github.com/ClickHouse/ClickHouse/issues/76384): Hopefully fix shutdown crash in ObjectStorageQueueMetadata. [#75323](https://github.com/ClickHouse/ClickHouse/pull/75323) ([Michael Kolupaev](https://github.com/al13n321)).
* [24.12] Fix src/Core/SettingsChangesHistory.cpp. [#75598](https://github.com/ClickHouse/ClickHouse/pull/75598) ([Raúl Marín](https://github.com/Algunenano)).
* Backported in [#76371](https://github.com/ClickHouse/ClickHouse/issues/76371): Fix normalizing function names inside ASTTTLElement. [#75757](https://github.com/ClickHouse/ClickHouse/pull/75757) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#76376](https://github.com/ClickHouse/ClickHouse/issues/76376): DisksApp: fix 'Placement info has not been loaded' and 'The IOThreadPool is not initialized'. [#75873](https://github.com/ClickHouse/ClickHouse/pull/75873) ([Michael Kolupaev](https://github.com/al13n321)).
* Backported in [#76281](https://github.com/ClickHouse/ClickHouse/issues/76281): Do not throw from `~Workload()`. [#76010](https://github.com/ClickHouse/ClickHouse/pull/76010) ([Sergei Trifonov](https://github.com/serxa)).
* Backported in [#76065](https://github.com/ClickHouse/ClickHouse/issues/76065): Add more test logs for decompressing. [#76023](https://github.com/ClickHouse/ClickHouse/pull/76023) ([Vitaly Baranov](https://github.com/vitlibar)).

